/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic.recovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;

public class SelectRemoteFileTierPartitionStateOutput {
    public static final short VERSION_V1 = 1;
    public static final short VERSION = 1;
    private final short version;
    private final Map<TopicIdPartition, String> selectedFTPS;
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    @JsonCreator
    public SelectRemoteFileTierPartitionStateOutput(@JsonProperty(value="version", required=true) short version, @JsonProperty(value="selected_ftps", required=true) Map<TopicIdPartition, String> selectedFTPS) {
        this.version = version;
        this.selectedFTPS = selectedFTPS;
    }

    @JsonProperty(value="version")
    public short version() {
        return this.version;
    }

    @JsonProperty(value="selected_ftps")
    public Map<TopicIdPartition, String> selectedFTPS() {
        return this.selectedFTPS;
    }

    public String toString() {
        return "SelectRemoteFileTierPartitionStateOutput(version=" + this.version + ", selectedFTPS=" + this.selectedFTPSToString() + ')';
    }

    private String selectedFTPSToString() {
        return this.selectedFTPS.entrySet().stream().map(entry -> String.format("topicPartition=%s, objectStorePath=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectRemoteFileTierPartitionStateOutput that = (SelectRemoteFileTierPartitionStateOutput)o;
        return this.version == that.version && Objects.equals(this.selectedFTPS, that.selectedFTPS);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.selectedFTPS);
    }

    public static SelectRemoteFileTierPartitionStateOutput readJsonFromFile(Path inputJsonPath) throws IOException {
        SelectRemoteFileTierPartitionStateOutput output = (SelectRemoteFileTierPartitionStateOutput)JSON_SERDE.readValue(inputJsonPath.toFile(), (TypeReference)new TypeReference<SelectRemoteFileTierPartitionStateOutput>(){});
        if (output.version() != 1) {
            throw new IOException(String.format("Invalid version in select-remote-ftps output. Expected: %s but found: %s", (short)1, output.version()));
        }
        return output;
    }

    public static SelectRemoteFileTierPartitionStateOutput readJsonFromString(String inputJson) throws IOException {
        SelectRemoteFileTierPartitionStateOutput output = (SelectRemoteFileTierPartitionStateOutput)JSON_SERDE.readValue(inputJson, (TypeReference)new TypeReference<SelectRemoteFileTierPartitionStateOutput>(){});
        if (output.version() != 1) {
            throw new IOException(String.format("Invalid version in select-remote-ftps output. Expected: %s but found: %s", (short)1, output.version()));
        }
        return output;
    }

    public void writeJsonToFile(OutputStream outputStream) throws IOException {
        JSON_SERDE.writeValue(outputStream, (Object)this);
    }

    public String jsonToString() throws IOException {
        return JSON_SERDE.writeValueAsString((Object)this);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(TopicIdPartition.class, (JsonSerializer)new JsonSerializer<TopicIdPartition>(){

            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicIdPartition.class, (JsonDeserializer)new JsonDeserializer<TopicIdPartition>(){

            public TopicIdPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return TopicIdPartition.fromString(p.getValueAsString());
            }
        });
        JSON_SERDE.registerModules(new Module[]{module, new Jdk8Module()});
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

