/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic.recovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.topic.recovery.AffectedTierTopicPartitionInfo;
import kafka.tier.topic.recovery.AffectedUserTopicPartitionInfo;
import kafka.tier.topic.recovery.ValidationSource;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopicHeadDataLossReport {
    private static final Logger log = LoggerFactory.getLogger(TierTopicHeadDataLossReport.class);
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    public static final short VERSION_V1 = 1;
    public static final short VERSION = 1;
    private final CompletionStatus completionStatus;
    private final short version;
    private final int brokerId;
    private final ValidationSource source;
    private final long startTimestampMs;
    private final long endTimestampMs;
    private final Map<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUserTopicPartitions;
    private final Map<TopicPartition, AffectedTierTopicPartitionInfo> affectedTierTopicPartitions;
    private final Set<TopicPartition> failedTierTopicPartitions;
    private final Set<TopicIdPartition> userPartitionsWithFencingFailures;
    private final List<String> errorMessages;
    private final String creationTimestamp;

    @JsonCreator
    public TierTopicHeadDataLossReport(@JsonProperty(value="completion_status", required=true) CompletionStatus completionStatus, @JsonProperty(value="version", required=true) short version, @JsonProperty(value="broker_id", required=true) int brokerId, @JsonProperty(value="source", required=true) ValidationSource source, @JsonProperty(value="start_timestamp_ms", required=true) long startTimestampMs, @JsonProperty(value="end_timestamp_ms", required=true) long endTimestampMs, @JsonProperty(value="affected_user_topic_partitions", required=true) Map<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUserTopicPartitions, @JsonProperty(value="affected_tier_topic_partitions", required=true) Map<TopicPartition, AffectedTierTopicPartitionInfo> affectedTierTopicPartitions, @JsonProperty(value="failed_tier_topic_partitions", required=true) Set<TopicPartition> failedTierTopicPartitions, @JsonProperty(value="user_partitions_with_fencing_failures", required=true) Set<TopicIdPartition> userPartitionsWithFencingFailures, @JsonProperty(value="error_messages", required=true) List<String> errorMessages, @JsonProperty(value="creation_timestamp", required=true) String creationTimestamp) {
        if (endTimestampMs < startTimestampMs) {
            throw new IllegalArgumentException(String.format("endTimestampMs:%d should be >= startTimestampMs:%d", endTimestampMs, startTimestampMs));
        }
        switch (completionStatus) {
            case SUCCESS: {
                if (!TierTopicHeadDataLossReport.hasFailures(failedTierTopicPartitions, userPartitionsWithFencingFailures, errorMessages)) break;
                throw new IllegalArgumentException(String.format("CompletionStatus:%s can't be supplied when there are errors", new Object[]{completionStatus}));
            }
            case FAILURE: {
                if (!errorMessages.isEmpty() && !failedTierTopicPartitions.isEmpty()) break;
                throw new IllegalArgumentException(String.format("CompletionStatus:%s can't be supplied without errors", new Object[]{completionStatus}));
            }
        }
        this.completionStatus = completionStatus;
        this.version = version;
        this.brokerId = brokerId;
        this.source = source;
        this.startTimestampMs = startTimestampMs;
        this.endTimestampMs = endTimestampMs;
        this.affectedUserTopicPartitions = affectedUserTopicPartitions;
        this.affectedTierTopicPartitions = affectedTierTopicPartitions;
        this.failedTierTopicPartitions = failedTierTopicPartitions;
        this.userPartitionsWithFencingFailures = userPartitionsWithFencingFailures;
        this.errorMessages = errorMessages;
        this.creationTimestamp = creationTimestamp;
    }

    public static TierTopicHeadDataLossReport createReport(CompletionStatus completionStatus, int brokerId, ValidationSource validationSource, long startTimeMs, long endTimeMs, Map<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUserTopicPartitions, Map<TopicPartition, AffectedTierTopicPartitionInfo> affectedTierTopicPartitions, Set<TopicPartition> failedTierTopicPartitions, Set<TopicIdPartition> userPartitionsWithFencingFailures, List<String> errorMessages) {
        return new TierTopicHeadDataLossReport(completionStatus, 1, brokerId, validationSource, startTimeMs, endTimeMs, affectedUserTopicPartitions, affectedTierTopicPartitions, failedTierTopicPartitions, userPartitionsWithFencingFailures, errorMessages, TierTopicHeadDataLossReport.currentTimestamp());
    }

    @JsonProperty(value="completion_status", required=true)
    public CompletionStatus completionStatus() {
        return this.completionStatus;
    }

    @JsonProperty(value="version", required=true)
    public short version() {
        return this.version;
    }

    @JsonProperty(value="broker_id", required=true)
    public int brokerId() {
        return this.brokerId;
    }

    @JsonProperty(value="source", required=true)
    public ValidationSource source() {
        return this.source;
    }

    @JsonProperty(value="start_timestamp_ms", required=true)
    public long startTimestampMs() {
        return this.startTimestampMs;
    }

    @JsonProperty(value="end_timestamp_ms", required=true)
    public long endTimestampMs() {
        return this.endTimestampMs;
    }

    @JsonProperty(value="affected_user_topic_partitions", required=true)
    public Map<TopicIdPartition, AffectedUserTopicPartitionInfo> affectedUserTopicPartitions() {
        return this.affectedUserTopicPartitions;
    }

    @JsonProperty(value="affected_tier_topic_partitions", required=true)
    public Map<TopicPartition, AffectedTierTopicPartitionInfo> affectedTierTopicPartitions() {
        return this.affectedTierTopicPartitions;
    }

    @JsonProperty(value="failed_tier_topic_partitions", required=true)
    public Set<TopicPartition> failedTierTopicPartitions() {
        return this.failedTierTopicPartitions;
    }

    @JsonProperty(value="user_partitions_with_fencing_failures", required=true)
    public Set<TopicIdPartition> userPartitionsWithFencingFailures() {
        return this.userPartitionsWithFencingFailures;
    }

    @JsonProperty(value="error_messages", required=true)
    public List<String> errorMessages() {
        return this.errorMessages;
    }

    @JsonProperty(value="creation_timestamp", required=true)
    public String creationTimestamp() {
        return this.creationTimestamp;
    }

    public long durationMs() {
        return this.endTimestampMs - this.startTimestampMs + 1L;
    }

    public int affectedUserPartitionReplicaCount() {
        return this.affectedUserTopicPartitions.size();
    }

    public int affectedUserPartitionLeaderCount() {
        return this.affectedUserTopicPartitions.values().stream().mapToInt(utpInfo -> utpInfo.isLeader() ? 1 : 0).sum();
    }

    public int affectedTierTopicPartitionCount() {
        return this.affectedTierTopicPartitions.size();
    }

    public boolean hasFailures() {
        return TierTopicHeadDataLossReport.hasFailures(this.failedTierTopicPartitions, this.userPartitionsWithFencingFailures, this.errorMessages);
    }

    private static boolean hasFailures(Set<TopicPartition> failedTierTopicPartitions, Set<TopicIdPartition> userPartitionsWithFencingFailures, List<String> errorMessages) {
        return !failedTierTopicPartitions.isEmpty() || !userPartitionsWithFencingFailures.isEmpty() || !errorMessages.isEmpty();
    }

    public boolean hasDataLoss() {
        return !this.affectedTierTopicPartitions.isEmpty() || !this.affectedUserTopicPartitions.isEmpty();
    }

    public String toString() {
        return "TierTopicHeadDataLossReport(completionStatus=" + (Object)((Object)this.completionStatus) + ", version=" + this.version + ", brokerId=" + this.brokerId + ", source=" + (Object)((Object)this.source) + ", startTimestampMs=" + this.startTimestampMs + ", endTimestampMs=" + this.endTimestampMs + ", affectedUserTopicPartitions=" + this.affectedUserTopicPartitionsToString() + ", affectedTierTopicPartitions=" + this.affectedTierTopicPartitionsToString() + ", failedTierTopicPartitions=" + this.failedTierTopicPartitions + ", userPartitionsWithFencingFailures=" + this.userPartitionsWithFencingFailures + ", errorMessages=[" + String.join((CharSequence)", ", this.errorMessages) + "], creationTimestamp=" + this.creationTimestamp + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicHeadDataLossReport that = (TierTopicHeadDataLossReport)o;
        return this.version == that.version && this.brokerId == that.brokerId && this.completionStatus == that.completionStatus && this.startTimestampMs == that.startTimestampMs && this.endTimestampMs == that.endTimestampMs && this.source == that.source && Objects.equals(this.affectedUserTopicPartitions, that.affectedUserTopicPartitions) && Objects.equals(this.affectedTierTopicPartitions, that.affectedTierTopicPartitions) && Objects.equals(this.failedTierTopicPartitions, that.failedTierTopicPartitions) && Objects.equals(this.userPartitionsWithFencingFailures, that.userPartitionsWithFencingFailures) && Objects.equals(this.errorMessages, that.errorMessages) && Objects.equals(this.creationTimestamp, that.creationTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.brokerId, this.completionStatus, this.source, this.startTimestampMs, this.endTimestampMs, this.affectedUserTopicPartitions, this.affectedTierTopicPartitions, this.failedTierTopicPartitions, this.userPartitionsWithFencingFailures, this.errorMessages, this.creationTimestamp});
    }

    public void log() {
        String reportJson;
        long durationMs = this.endTimestampMs - this.startTimestampMs + 1L;
        try {
            reportJson = TierTopicHeadDataLossReport.getJsonPrettyString(this);
        }
        catch (IOException e) {
            reportJson = "<unavailable>";
            log.error("Failed to convert data loss report to pretty JSON", (Throwable)e);
        }
        String commonErrorMsg = String.format("%s tier topic partitions are found to have data loss, %s user topic partitions are found to have data loss (ValidationSource=%s). Full report:\n%s", new Object[]{this.affectedTierTopicPartitions.size(), this.affectedUserTopicPartitions.size(), this.source, reportJson});
        String logMsg = "";
        switch (this.completionStatus) {
            case SUCCESS: {
                logMsg = "Successfully finished detecting data loss in tier topic head in " + durationMs + " ms.";
                if (this.affectedTierTopicPartitions.isEmpty() && this.affectedUserTopicPartitions.isEmpty()) {
                    log.info("{} No data loss detected. (ValidationSource={})", (Object)logMsg, (Object)this.source);
                    break;
                }
                log.error("{} {}", (Object)logMsg, (Object)commonErrorMsg);
                break;
            }
            case FAILURE: {
                logMsg = "Failed to fully detect data loss in tier topic head in " + durationMs + " ms.";
                if (this.affectedTierTopicPartitions.isEmpty() && this.affectedUserTopicPartitions.isEmpty()) {
                    log.error("{} No data loss detected in partial run (ValidationSource={}). Full report:\n{}", new Object[]{logMsg, this.source, reportJson});
                    break;
                }
                log.error("{} {}", (Object)logMsg, (Object)commonErrorMsg);
            }
        }
    }

    private String affectedTierTopicPartitionsToString() {
        return TierTopicHeadDataLossReport.mapToString(this.affectedTierTopicPartitions);
    }

    private String affectedUserTopicPartitionsToString() {
        return TierTopicHeadDataLossReport.mapToString(this.affectedUserTopicPartitions);
    }

    private static <K, V> String mapToString(Map<K, V> affectedPartitions) {
        String mapAsString = affectedPartitions.entrySet().stream().map(entry -> String.format("%s => %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        return String.format("{%s}", mapAsString);
    }

    public static String currentTimestamp() {
        return new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSzz").format(new Date());
    }

    public static void writeJsonToFile(TierTopicHeadDataLossReport info, OutputStream outputStream) throws IOException {
        JSON_SERDE.writeValue(outputStream, (Object)info);
    }

    public static String getJsonString(TierTopicHeadDataLossReport report) throws IOException {
        return JSON_SERDE.writeValueAsString((Object)report);
    }

    public static String getJsonPrettyString(TierTopicHeadDataLossReport report) throws IOException {
        return JSON_SERDE.writerWithDefaultPrettyPrinter().writeValueAsString((Object)report);
    }

    public static TierTopicHeadDataLossReport readJsonFromFile(Path inputJsonPath) throws IOException {
        return (TierTopicHeadDataLossReport)JSON_SERDE.readValue(inputJsonPath.toFile(), (TypeReference)new TypeReference<TierTopicHeadDataLossReport>(){});
    }

    public static TierTopicHeadDataLossReport readJsonFromString(String inputJson) throws IOException {
        return (TierTopicHeadDataLossReport)JSON_SERDE.readValue(inputJson, (TypeReference)new TypeReference<TierTopicHeadDataLossReport>(){});
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(TopicIdPartition.class, (JsonSerializer)new JsonSerializer<TopicIdPartition>(){

            public void serialize(TopicIdPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicIdPartition.class, (JsonDeserializer)new JsonDeserializer<TopicIdPartition>(){

            public TopicIdPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicIdPartition.fromString(p.getValueAsString());
            }
        });
        module.addSerializer(TopicPartition.class, (JsonSerializer)new JsonSerializer<TopicPartition>(){

            public void serialize(TopicPartition value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeString(value.toString());
            }
        });
        module.addDeserializer(TopicPartition.class, (JsonDeserializer)new JsonDeserializer<TopicPartition>(){

            public TopicPartition deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                return TopicPartition.fromString((String)p.getValueAsString());
            }
        });
        JSON_SERDE.registerModules(new Module[]{module, new Jdk8Module()});
        JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    public static enum CompletionStatus {
        SUCCESS,
        FAILURE;

        private static final Map<String, CompletionStatus> STR_ENUM_MAP;

        public static CompletionStatus fromStringOrThrow(String completionStatusStr) {
            CompletionStatus completionStatus = STR_ENUM_MAP.get(completionStatusStr);
            if (completionStatus == null) {
                throw new IllegalArgumentException("Invalid CompletionStatus: " + completionStatusStr);
            }
            return completionStatus;
        }

        static {
            STR_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(CompletionStatus.values()).collect(Collectors.toMap(Enum::toString, Function.identity())));
        }
    }
}

