/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import io.confluent.kafka.server.plugins.auth.BaseMultiTenantSaslSecretsStore;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.connect.util.KafkaBasedLog;

public class AuthnzMultiTenantSaslSecretsStore
extends BaseMultiTenantSaslSecretsStore {
    public AuthnzMultiTenantSaslSecretsStore(Map<String, Object> clientConfigs, Metrics metrics) {
        super(clientConfigs, metrics);
    }

    protected String getSessionUuid(Map<String, ?> config) {
        return (String)config.get("confluent.authnz.session.uuid");
    }

    protected void deleteCredential(String deletedKey) {
        LOG.info("Ignoring deleted API key {} because it is not relevant to Authnz service", (Object)deletedKey);
    }

    protected Map<String, Object> getConsumerConfig(Map<String, ?> config) {
        HashSet configNames = new HashSet(ConsumerConfig.configNames());
        configNames.remove("metric.reporters");
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(this.baseClientProperties);
        clientConfigs.keySet().retainAll(configNames);
        clientConfigs.put("client.id", String.format("%s-%s-%s", this.topicName, ConfluentConfigs.ClientType.CONSUMER, config.get("authnz.id")));
        clientConfigs.put("bootstrap.servers", this.baseClientProperties.get("bootstrap.servers"));
        return clientConfigs;
    }

    void configure(KafkaBasedLog<String, String> secretsLog, List<String> multitenantListenerNames) {
        LOG.warn("configure(KafkaBasedLog<>) called, shouldn't happen outside tests (Ignore if this is a unittest.)");
        this.topicName = "unused_var-secretsLog-passed-into-ctor";
        this.topicLoadTimeoutMs = ConfluentConfigs.CDC_TOPIC_LOAD_TIMEOUT_MS_DEFAULT;
        this.multitenantListenerNames = multitenantListenerNames;
        this.secretsLog = secretsLog;
    }

    protected void read(ConsumerRecord<String, String> record) {
        super.read(record);
    }

    protected void createSensors(Map<String, MultiTenantSaslConfigEntry> entries) {
    }
}

