/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.ldap;

import io.confluent.security.auth.provider.ldap.LdapPrincipalMapping;
import io.confluent.security.auth.utils.ConfigurableSslSocketFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(LdapConfig.class);
    private static final ConfigDef CONFIG;
    private static final String LDAP_AUTHORIZER_PREFIX = "ldap.authorizer.";
    public static final String CONFIG_PREFIX = "ldap.";
    public static final String JAVA_NAMING_SOCKET_FACTORY_PROP = "java.naming.ldap.factory.socket";
    public static final String REFRESH_INTERVAL_MS_PROP = "ldap.refresh.interval.ms";
    public static final int REFRESH_INTERVAL_MS_DEFAULT = 60000;
    public static final int PERSISTENT_REFRESH = 0;
    public static final String REFRESH_INTERVAL_MS_DOC = "LDAP group cache refresh interval in milliseconds. If set to zero, persistent LDAP search is used.";
    public static final String SEARCH_PAGE_SIZE_PROP = "ldap.search.page.size";
    public static final int SEARCH_PAGE_SIZE_DEFAULT = 0;
    public static final String SEARCH_PAGE_SIZE_DOC = "Page size for LDAP search if persistent search is disabled (refresh interval is greater than zero). Paging is disabled by default.";
    public static final String PRINCIPAL_MAPPING_PROP = "ldap.principal.mapping";
    public static final String PRINCIPAL_MAPPING_DEFAULT;
    public static final String PRINCIPAL_MAPPING_DOC = "Defines the mechanism used for mapping the user's Principal.Following modes exist: 1. 'default' - (default mode) this mode would store the username (used during AuthN) in the user's principal for AuthZ.2. 'ldap' - this mode would extract the user's principal from LDAP records (which can be of different casing from the username during AuthN) and uses that for AuthZ. ";
    public static final String RETRY_TIMEOUT_MS_PROP = "ldap.retry.timeout.ms";
    public static final int RETRY_TIMEOUT_MS_DEFAULT = 86400000;
    public static final String RETRY_TIMEOUT_MS_DOC = "Timeout for LDAP search retries after which the LDAP authorizer is marked as failed. All requests are denied access if a successful cache refresh cannot be performed within this time.";
    public static final String RETRY_BACKOFF_MS_PROP = "ldap.retry.backoff.ms";
    public static final int RETRY_BACKOFF_MS_DEFAULT = 100;
    public static final String RETRY_BACKOFF_MS_DOC = "Initial retry backoff in milliseconds. Exponential backoff is used if 'ldap.retry.backoff.max.ms' is set to a higher value.";
    public static final String RETRY_BACKOFF_MAX_MS_PROP = "ldap.retry.backoff.max.ms";
    public static final int RETRY_BACKOFF_MAX_MS_DEFAULT = 1000;
    public static final String RETRY_BACKOFF_MAX_MS_DOC = "Maximum retry backoff in milliseconds. Exponential backoff is used if 'ldap.retry.backoff.ms' is set to a lower value.";
    public static final String SEARCH_MODE_PROP = "ldap.search.mode";
    public static final String SEARCH_MODE_DEFAULT;
    public static final String SEARCH_MODE_DOC = "LDAP search mode that indicates if user to group mapping is retrieved by searching for group or user entries. Valid values are USERS and GROUPS.";
    public static final String GROUP_SEARCH_BASE_PROP = "ldap.group.search.base";
    public static final String GROUP_SEARCH_BASE_DEFAULT = "ou=groups";
    public static final String GROUP_SEARCH_BASE_DOC = "LDAP search base for group-based search.";
    public static final String GROUP_SEARCH_FILTER_PROP = "ldap.group.search.filter";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "";
    public static final String GROUP_SEARCH_FILTER_DOC = "LDAP search filter for group-based search.";
    public static final String GROUP_SEARCH_SCOPE_PROP = "ldap.group.search.scope";
    public static final int GROUP_SEARCH_SCOPE_DEFAULT = 1;
    public static final String GROUP_SEARCH_SCOPE_DOC = "LDAP search scope for group-based search. Valid values are 0 (OBJECT), 1 (ONELEVEL) and 2 (SUBTREE).";
    public static final String GROUP_OBJECT_CLASS_PROP = "ldap.group.object.class";
    public static final String GROUP_OBJECT_CLASS_DEFAULT = "groupOfNames";
    public static final String GROUP_OBJECT_CLASS_DOC = "LDAP object class for groups.";
    public static final String GROUP_NAME_ATTRIBUTE_PROP = "ldap.group.name.attribute";
    public static final String GROUP_NAME_ATTRIBUTE_DEFAULT = "cn";
    public static final String GROUP_NAME_ATTRIBUTE_DOC = "Name of attribute that contains the name of the group in a group entry obtained using an LDAP search. A regex pattern may be specified to extract the group name used in ACLs from this attribute by configuring 'ldap.group.name.attribute.pattern'.";
    public static final String GROUP_NAME_ATTRIBUTE_PATTERN_PROP = "ldap.group.name.attribute.pattern";
    public static final String GROUP_NAME_ATTRIBUTE_PATTERN_DEFAULT = "";
    public static final String GROUP_NAME_ATTRIBUTE_PATTERN_DOC = "Java regular expression pattern used to extract the group name used in ACLs from the name of the group obtained from the LDAP attribute specified using  'ldap.group.name.attribute`. By default the full value of the attribute is used";
    public static final String GROUP_MEMBER_ATTRIBUTE_PROP = "ldap.group.member.attribute";
    public static final String GROUP_MEMBER_ATTRIBUTE_DEFAULT = "member";
    public static final String GROUP_MEMBER_ATTRIBUTE_DOC = "Name of attribute that contains the members of the group in a group entry obtained using an LDAP search. A regex pattern may be specified to extract the user principals from this attribute by configuring 'ldap.group.member.attribute.pattern'.";
    public static final String GROUP_MEMBER_ATTRIBUTE_PATTERN_PROP = "ldap.group.member.attribute.pattern";
    public static final String GROUP_MEMBER_ATTRIBUTE_PATTERN_DEFAULT = "";
    public static final String GROUP_MEMBER_ATTRIBUTE_PATTERN_DOC = "Java regular expression pattern used to extract the user principals of group members from group member entries obtained from the LDAP attribute specified using 'ldap.group.member.attribute`. By default the full value of the attribute is used";
    public static final String GROUP_DN_NAME_PATTERN_PROP = "ldap.group.dn.name.pattern";
    public static final String GROUP_DN_NAME_PATTERN_DEFAULT = "";
    public static final String GROUP_DN_NAME_PATTERN_DOC = "Java regular expression pattern used to extract group name from the distinguished name of the group when group is renamed. This is used only when persistent search is enabled. By default the 'ldap.group.name.attribute' is extracted from the DN";
    public static final String USER_SEARCH_BASE_PROP = "ldap.user.search.base";
    public static final String USER_SEARCH_BASE_DEFAULT = "ou=users";
    public static final String USER_SEARCH_BASE_DOC = "LDAP search base for user-based search.";
    public static final String USER_SEARCH_FILTER_PROP = "ldap.user.search.filter";
    public static final String USER_SEARCH_FILTER_DEFAULT = "";
    public static final String USER_SEARCH_FILTER_DOC = "LDAP search filter for user-based search.";
    public static final String USER_SEARCH_SCOPE_PROP = "ldap.user.search.scope";
    public static final int USER_SEARCH_SCOPE_DEFAULT = 1;
    public static final String USER_SEARCH_SCOPE_DOC = "LDAP search scope for user-based search. Valid values are 0 (OBJECT), 1 (ONELEVEL) and 2 (SUBTREE).";
    public static final String USER_OBJECT_CLASS_PROP = "ldap.user.object.class";
    public static final String USER_OBJECT_CLASS_DEFAULT = "person";
    public static final String USER_OBJECT_CLASS_DOC = "LDAP object class for users.";
    public static final String USER_NAME_ATTRIBUTE_PROP = "ldap.user.name.attribute";
    public static final String USER_NAME_ATTRIBUTE_DEFAULT = "uid";
    public static final String USER_NAME_ATTRIBUTE_DOC = "Name of attribute that contains the user principal in a user entry obtained using an LDAP search. A regex pattern may be specified to extract the user principal from this attribute by configuring 'ldap.user.name.attribute.pattern'.";
    public static final String USER_NAME_ATTRIBUTE_PATTERN_PROP = "ldap.user.name.attribute.pattern";
    public static final String USER_NAME_ATTRIBUTE_PATTERN_DEFAULT = "";
    public static final String USER_NAME_ATTRIBUTE_PATTERN_DOC = "Java regular expression pattern used to extract the user principal from the name of the user obtained from the LDAP attribute specified using 'ldap.user.name.attribute`. By default the full value of the attribute is used";
    public static final String USER_MEMBEROF_ATTRIBUTE_PROP = "ldap.user.memberof.attribute";
    public static final String USER_MEMBEROF_ATTRIBUTE_DEFAULT = "memberof";
    public static final String USER_MEMBEROF_ATTRIBUTE_DOC = "Name of attribute that contains the groups in a user entry obtained using an LDAP search. A regex pattern may be specified to extract the group names used in ACLs from this attribute by configuring 'ldap.user.memberof.attribute.pattern'.";
    public static final String USER_MEMBEROF_ATTRIBUTE_PATTERN_PROP = "ldap.user.memberof.attribute.pattern";
    public static final String USER_MEMBEROF_ATTRIBUTE_PATTERN_DEFAULT = "";
    public static final String USER_MEMBEROF_ATTRIBUTE_PATTERN_DOC = "Java regular expression pattern used to extract the names of groups from user entries obtained from the LDAP attribute specified using  'ldap.user.memberof.attribute`. By default the full value of the attribute is used";
    public static final String USER_DN_NAME_PATTERN_PROP = "ldap.user.dn.name.pattern";
    public static final String USER_DN_NAME_PATTERN_DEFAULT = "";
    public static final String USER_DN_NAME_PATTERN_DOC = "Java regular expression pattern used to extract user name from the distinguished name of the user when user is renamed. This is used only when persistent search is enabled. By default the 'ldap.user.name.attribute' is extracted from the DN";
    public static final String USER_PASSWORD_ATTRIBUTE_PROP = "ldap.user.password.attribute";
    public static final String USER_PASSWORD_ATTRIBUTE_DOC = "Name of attribute that contains the password in a user entry obtained using an LDAP search for simple username/password authentication. By default, authentication is performed using simple binding with the provided credentials. This config may be used in deployments where simple binding is disabled for some users.";
    private static final String JNDI_CONNECT_TIMEOUT_MS_PROP = "com.sun.jndi.ldap.connect.timeout";
    public static final String JNDI_READ_TIMEOUT_MS_PROP = "com.sun.jndi.ldap.read.timeout";
    public static final long JNDI_CONNECT_TIMEOUT_MS_DEFAULT = 30000L;
    public static final long JNDI_READ_TIMEOUT_MS_DEFAULT = 30000L;
    private static final String SASL_KERBEROS_LDAP_SERVICE_NAME_DOC = "The Kerberos principal name that LDAP service runs as. The value is 'ldap' in all standard LDAP deployments.";
    public static final String GROUP_AUTHORIZATION_ENABLED_PROP = "ldap.group.authorization.enable";
    public static final boolean GROUP_AUTHORIZATION_ENABLED_DEFAULT = true;
    public static final String GROUP_AUTHORIZATION_ENABLED_DOC = "Flag to explicitly enable/disableldap group authorization. The default value is true (group auth enabled).";
    public static final String IGNORE_PARTIAL_RESULT_EXCEPTION = "ldap.ignore.partial.result.exception";
    public static final String IGNORE_PARTIAL_RESULT_EXCEPTION_DOC = "Indicate whether ignore partial result exception";
    final boolean persistentSearch;
    final int refreshIntervalMs = this.getInt("ldap.refresh.interval.ms");
    final int searchPageSize;
    final long retryTimeoutMs = this.getLong("ldap.retry.timeout.ms");
    final int retryBackoffMs = this.getInt("ldap.retry.backoff.ms");
    final int retryMaxBackoffMs = this.getInt("ldap.retry.backoff.max.ms");
    final SearchMode searchMode;
    final String groupSearchBase;
    final String groupSearchFilter;
    final int groupSearchScope;
    final String groupNameAttribute;
    final Pattern groupNameAttributePattern;
    final String groupMemberAttribute;
    final Pattern groupMemberAttributePattern;
    final Pattern groupDnNamePattern;
    final String userSearchBase;
    final String userSearchFilter;
    final int userSearchScope;
    final String userNameAttribute;
    final Pattern userNameAttributePattern;
    final String userMemberOfAttribute;
    final Pattern userMemberOfAttributePattern;
    final Pattern userDnNamePattern;
    final String userDnSearchFilter;
    final String userPasswordAttribute;
    final String principalMappingMode;
    final boolean ignorePartialResultException;
    final Hashtable<String, String> ldapContextEnvironment;

    public LdapConfig(Map<?, ?> props) {
        super(CONFIG, LdapConfig.ldapAuthorizerToLdapProps(props));
        this.persistentSearch = this.refreshIntervalMs == 0;
        this.searchMode = SearchMode.valueOf(this.getString(SEARCH_MODE_PROP).toUpperCase(Locale.ROOT));
        this.searchPageSize = this.getInt(SEARCH_PAGE_SIZE_PROP);
        this.groupSearchBase = this.getString(GROUP_SEARCH_BASE_PROP);
        this.groupSearchFilter = this.searchFilter(GROUP_OBJECT_CLASS_PROP, this.getString(GROUP_SEARCH_FILTER_PROP));
        this.groupSearchScope = this.getInt(GROUP_SEARCH_SCOPE_PROP);
        this.groupNameAttribute = this.getString(GROUP_NAME_ATTRIBUTE_PROP);
        this.groupNameAttributePattern = this.attributePattern(GROUP_NAME_ATTRIBUTE_PATTERN_PROP);
        this.groupMemberAttribute = this.getString(GROUP_MEMBER_ATTRIBUTE_PROP);
        this.groupMemberAttributePattern = this.attributePattern(GROUP_MEMBER_ATTRIBUTE_PATTERN_PROP);
        String pattern = this.getString(GROUP_DN_NAME_PATTERN_PROP);
        this.groupDnNamePattern = pattern.isEmpty() ? null : Pattern.compile(pattern);
        this.userSearchBase = this.getString(USER_SEARCH_BASE_PROP);
        this.userSearchFilter = this.searchFilter(USER_OBJECT_CLASS_PROP, this.getString(USER_SEARCH_FILTER_PROP));
        this.userSearchScope = this.getInt(USER_SEARCH_SCOPE_PROP);
        this.userNameAttribute = this.getString(USER_NAME_ATTRIBUTE_PROP);
        this.userNameAttributePattern = this.attributePattern(USER_NAME_ATTRIBUTE_PATTERN_PROP);
        this.userMemberOfAttribute = this.getString(USER_MEMBEROF_ATTRIBUTE_PROP);
        this.userMemberOfAttributePattern = this.attributePattern(USER_MEMBEROF_ATTRIBUTE_PATTERN_PROP);
        pattern = this.getString(USER_DN_NAME_PATTERN_PROP);
        this.userDnNamePattern = pattern.isEmpty() ? null : Pattern.compile(pattern);
        String dnSearchFilter = String.format("%s(%s={0})", this.userSearchFilter, this.userNameAttribute);
        this.userDnSearchFilter = this.searchFilter(USER_OBJECT_CLASS_PROP, dnSearchFilter);
        this.userPasswordAttribute = this.getString(USER_PASSWORD_ATTRIBUTE_PROP);
        this.principalMappingMode = this.getString(PRINCIPAL_MAPPING_PROP);
        this.ignorePartialResultException = this.getBoolean(IGNORE_PARTIAL_RESULT_EXCEPTION);
        this.validate();
        this.ldapContextEnvironment = this.createLdapContextEnvironment();
    }

    private boolean sslEnabled() {
        String providerUrl = (String)this.originals().get("ldap.java.naming.provider.url");
        String protocol = (String)this.originals().get("ldap.java.naming.security.protocol");
        if (protocol != null && "ssl".equalsIgnoreCase(protocol)) {
            return true;
        }
        Object[] ldapUrls = providerUrl.split("\\s+");
        if (ldapUrls.length < 1) {
            throw new ConfigException("LDAP provider URL must be specified using the config ldap.java.naming.provider.url");
        }
        log.debug("Number of LDAP Provider URLs: {}", (Object)ldapUrls.length);
        log.debug("Configured LDAP Urls are: {}", (Object)Arrays.toString(ldapUrls));
        boolean isLdapsUrl = "ldaps".equals(URI.create((String)ldapUrls[0]).getScheme());
        for (int idx = 1; idx < ldapUrls.length; ++idx) {
            if (isLdapsUrl == "ldaps".equals(URI.create((String)ldapUrls[idx]).getScheme())) continue;
            throw new ConfigException("LDAP provider urls should be using same protocol either ldap or ldaps");
        }
        return isLdapsUrl;
    }

    private Hashtable<String, String> createLdapContextEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.unprefix(this.originals()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("java.naming.") || ((String)e.getKey()).startsWith("com.sun.jndi.")).forEach(e -> env.put((String)e.getKey(), String.valueOf(e.getValue())));
        Map<String, Object> unprefixedConfigs = this.unprefix(this.values());
        if (this.sslEnabled() && !unprefixedConfigs.containsKey(JAVA_NAMING_SOCKET_FACTORY_PROP)) {
            ConfigurableSslSocketFactory.createSslFactory(unprefixedConfigs);
            env.put(JAVA_NAMING_SOCKET_FACTORY_PROP, ConfigurableSslSocketFactory.class.getName());
        }
        if (!env.containsKey(JNDI_CONNECT_TIMEOUT_MS_PROP)) {
            env.put(JNDI_CONNECT_TIMEOUT_MS_PROP, String.valueOf(30000L));
        }
        if (!env.containsKey(JNDI_READ_TIMEOUT_MS_PROP)) {
            env.put(JNDI_READ_TIMEOUT_MS_PROP, String.valueOf(30000L));
        }
        return env;
    }

    private Map<String, Object> unprefix(Map<String, ?> map) {
        return map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFIG_PREFIX) && e.getValue() != null).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(CONFIG_PREFIX.length()), Map.Entry::getValue));
    }

    private String searchFilter(String objectClassProp, String filter) {
        String classFilter = "(objectClass=" + this.getString(objectClassProp) + ")";
        String configuredFilter = filter;
        if (configuredFilter.isEmpty()) {
            return classFilter;
        }
        return String.format("(&%s%s)", classFilter, configuredFilter);
    }

    private Pattern attributePattern(String patternProp) {
        String patternStr = this.getString(patternProp);
        if (patternStr == null || patternStr.isEmpty()) {
            return null;
        }
        return Pattern.compile(patternStr);
    }

    private void validate() {
        if (!this.originals().containsKey("ldap.java.naming.provider.url")) {
            throw new ConfigException("LDAP provider URL must be specified using the config ldap.java.naming.provider.url");
        }
        if (this.retryTimeoutMs < (long)(this.refreshIntervalMs * 2)) {
            throw new ConfigException(String.format("Retry timeout %s=%d should be at least twice %s=%d", RETRY_TIMEOUT_MS_PROP, this.retryTimeoutMs, REFRESH_INTERVAL_MS_PROP, this.refreshIntervalMs));
        }
        if (this.retryTimeoutMs < (long)this.retryMaxBackoffMs) {
            throw new ConfigException(String.format("Retry timeout %s=%d should be at least %s=%d", RETRY_BACKOFF_MAX_MS_PROP, this.retryMaxBackoffMs, RETRY_TIMEOUT_MS_PROP, this.retryTimeoutMs));
        }
        if (this.retryMaxBackoffMs < this.retryBackoffMs) {
            throw new ConfigException(String.format("Retry max backoff %s=%d should be at least %s=%d", RETRY_BACKOFF_MAX_MS_PROP, this.retryMaxBackoffMs, RETRY_BACKOFF_MS_PROP, this.retryBackoffMs));
        }
    }

    public static boolean ldapEnabled(Map<String, ?> configs) {
        return configs.containsKey("ldap.java.naming.provider.url") || configs.containsKey("ldap.authorizer.java.naming.provider.url");
    }

    public String toString() {
        HashMap<String, String> env = new HashMap<String, String>(this.ldapContextEnvironment);
        if (env.containsKey("java.naming.security.credentials")) {
            env.put("java.naming.security.credentials", "[hidden]");
        }
        return String.format("LdapAuthorizerConfig: %n\t%s%n\t%s", Utils.mkString((Map)this.values(), (String)"", (String)"", (String)"=", (String)"%n\t"), Utils.mkString(env, (String)"", (String)"", (String)"=", (String)"%n\t"));
    }

    private static Map<?, ?> ldapAuthorizerToLdapProps(Map<?, ?> props) {
        HashMap transformed = new HashMap(props.size());
        for (Map.Entry<?, ?> entry : props.entrySet()) {
            String propName = (String)entry.getKey();
            if (propName.startsWith(LDAP_AUTHORIZER_PREFIX)) {
                propName = CONFIG_PREFIX + propName.substring(LDAP_AUTHORIZER_PREFIX.length());
            }
            transformed.put(propName, entry.getValue());
        }
        return transformed;
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }

    static {
        PRINCIPAL_MAPPING_DEFAULT = LdapPrincipalMapping.DEFAULT.name;
        SEARCH_MODE_DEFAULT = SearchMode.GROUPS.name();
        CONFIG = new ConfigDef().define(REFRESH_INTERVAL_MS_PROP, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.MEDIUM, REFRESH_INTERVAL_MS_DOC).define(SEARCH_PAGE_SIZE_PROP, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, SEARCH_PAGE_SIZE_DOC).define(RETRY_BACKOFF_MS_PROP, ConfigDef.Type.INT, (Object)100, ConfigDef.Importance.MEDIUM, RETRY_BACKOFF_MS_DOC).define(RETRY_BACKOFF_MAX_MS_PROP, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, RETRY_BACKOFF_MAX_MS_DOC).define(RETRY_TIMEOUT_MS_PROP, ConfigDef.Type.LONG, (Object)86400000, ConfigDef.Importance.MEDIUM, RETRY_TIMEOUT_MS_DOC).define(SEARCH_MODE_PROP, ConfigDef.Type.STRING, (Object)SEARCH_MODE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{SearchMode.GROUPS.name(), SearchMode.USERS.name()}), ConfigDef.Importance.MEDIUM, SEARCH_MODE_DOC).define(GROUP_SEARCH_BASE_PROP, ConfigDef.Type.STRING, (Object)GROUP_SEARCH_BASE_DEFAULT, ConfigDef.Importance.HIGH, GROUP_SEARCH_BASE_DOC).define(GROUP_SEARCH_FILTER_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, GROUP_SEARCH_FILTER_DOC).define(GROUP_SEARCH_SCOPE_PROP, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, GROUP_SEARCH_SCOPE_DOC).define(GROUP_OBJECT_CLASS_PROP, ConfigDef.Type.STRING, (Object)GROUP_OBJECT_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, GROUP_OBJECT_CLASS_DOC).define(GROUP_NAME_ATTRIBUTE_PROP, ConfigDef.Type.STRING, (Object)GROUP_NAME_ATTRIBUTE_DEFAULT, ConfigDef.Importance.HIGH, GROUP_NAME_ATTRIBUTE_DOC).define(GROUP_NAME_ATTRIBUTE_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, GROUP_NAME_ATTRIBUTE_PATTERN_DOC).define(GROUP_MEMBER_ATTRIBUTE_PROP, ConfigDef.Type.STRING, (Object)GROUP_MEMBER_ATTRIBUTE_DEFAULT, ConfigDef.Importance.HIGH, GROUP_MEMBER_ATTRIBUTE_DOC).define(GROUP_MEMBER_ATTRIBUTE_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, GROUP_MEMBER_ATTRIBUTE_PATTERN_DOC).define(GROUP_DN_NAME_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, GROUP_DN_NAME_PATTERN_DOC).define(USER_SEARCH_BASE_PROP, ConfigDef.Type.STRING, (Object)USER_SEARCH_BASE_DEFAULT, ConfigDef.Importance.MEDIUM, USER_SEARCH_BASE_DOC).define(USER_SEARCH_FILTER_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, USER_SEARCH_FILTER_DOC).define(USER_SEARCH_SCOPE_PROP, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, USER_SEARCH_SCOPE_DOC).define(USER_OBJECT_CLASS_PROP, ConfigDef.Type.STRING, (Object)USER_OBJECT_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, USER_OBJECT_CLASS_DOC).define(USER_NAME_ATTRIBUTE_PROP, ConfigDef.Type.STRING, (Object)USER_NAME_ATTRIBUTE_DEFAULT, ConfigDef.Importance.MEDIUM, USER_NAME_ATTRIBUTE_DOC).define(USER_NAME_ATTRIBUTE_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, USER_NAME_ATTRIBUTE_PATTERN_DOC).define(USER_MEMBEROF_ATTRIBUTE_PROP, ConfigDef.Type.STRING, (Object)USER_MEMBEROF_ATTRIBUTE_DEFAULT, ConfigDef.Importance.MEDIUM, USER_MEMBEROF_ATTRIBUTE_DOC).define(USER_MEMBEROF_ATTRIBUTE_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, USER_MEMBEROF_ATTRIBUTE_PATTERN_DOC).define(USER_DN_NAME_PATTERN_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, USER_DN_NAME_PATTERN_DOC).define(USER_PASSWORD_ATTRIBUTE_PROP, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, USER_PASSWORD_ATTRIBUTE_DOC).define(IGNORE_PARTIAL_RESULT_EXCEPTION, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, IGNORE_PARTIAL_RESULT_EXCEPTION_DOC).define("ldap.sasl.kerberos.service.name", ConfigDef.Type.STRING, (Object)"ldap", ConfigDef.Importance.LOW, SASL_KERBEROS_LDAP_SERVICE_NAME_DOC).define(PRINCIPAL_MAPPING_PROP, ConfigDef.Type.STRING, (Object)PRINCIPAL_MAPPING_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{LdapPrincipalMapping.DEFAULT.name, LdapPrincipalMapping.LDAP.name}), ConfigDef.Importance.LOW, PRINCIPAL_MAPPING_DOC).define(GROUP_AUTHORIZATION_ENABLED_PROP, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, GROUP_AUTHORIZATION_ENABLED_DOC);
        ConfigDef securityDefs = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)securityDefs);
        SaslConfigs.addClientSaslSupport((ConfigDef)securityDefs);
        Set unusedOrRedefinedSecurityConfigs = Utils.mkSet((Object[])new String[]{"sasl.kerberos.service.name", "sasl.mechanism", "sasl.client.callback.handler.class", "sasl.login.refresh.buffer.seconds", "sasl.login.refresh.min.period.seconds", "sasl.login.refresh.window.factor", "sasl.login.refresh.window.jitter"});
        securityDefs.configKeys().values().stream().filter(k -> !unusedOrRedefinedSecurityConfigs.contains(k.name)).forEach(configKey -> CONFIG.define(CONFIG_PREFIX + configKey.name, configKey.type, configKey.defaultValue, configKey.validator, configKey.importance, configKey.documentation));
    }

    public static enum SearchMode {
        GROUPS,
        USERS;

    }
}

