/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider.ldap;

import io.confluent.security.auth.provider.ldap.LdapConfig;
import io.confluent.security.auth.provider.ldap.LdapGroupManager;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.GroupProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;

public class LdapGroupProvider
implements GroupProvider {
    private final Time time;
    private LdapGroupManager groupManager;

    public LdapGroupProvider() {
        this(Time.SYSTEM);
    }

    public LdapGroupProvider(Time time) {
        this.time = time;
    }

    public void configure(Map<String, ?> configs) {
        LdapConfig authorizerConfig = new LdapConfig(configs);
        this.groupManager = new LdapGroupManager(authorizerConfig, this.time);
        this.groupManager.start();
    }

    public String providerName() {
        return ConfluentBuiltInProviders.GroupProviders.LDAP.name();
    }

    public boolean providerConfigured(Map<String, ?> configs) {
        return LdapConfig.ldapEnabled(configs) && new LdapConfig(configs).getBoolean("ldap.group.authorization.enable") != false;
    }

    public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
        if (this.groupManager == null) {
            return Collections.emptySet();
        }
        Set<String> groups = this.groupManager.groups(sessionPrincipal.getName());
        return groups.stream().map(group -> new KafkaPrincipal("Group", group)).collect(Collectors.toSet());
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    public void close() {
        if (this.groupManager != null) {
            this.groupManager.close();
        }
    }

    public LdapGroupManager ldapGroupManager() {
        return this.groupManager;
    }
}

