/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.cache;

import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.cache.ScopeAccessRuleStore;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.InvalidScopeException;
import io.confluent.security.rbac.RbacRoles;
import java.util.Set;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class DefaultAuthCache
extends AbstractAuthCache {
    public DefaultAuthCache(RbacRoles rbacRoles, Scope rootScope, ScopeAccessRuleStore rbacAccessRuleStore, ScopeAccessRuleStore aclAccessRuleStore) {
        super(rbacRoles, rootScope, rbacAccessRuleStore, aclAccessRuleStore);
    }

    public DefaultAuthCache(RbacRoles rbacRoles, Scope rootScope) {
        super(rbacRoles, rootScope, new ScopeAccessRuleStore(), new ScopeAccessRuleStore());
    }

    @Override
    public AuthorizeRule findRule(KafkaPrincipal userPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
        this.ensureNotFailed();
        if (!this.rootScope.containsScope(action.scope())) {
            throw new InvalidScopeException("This authorization cache does not contain scope " + action.scope());
        }
        Set matchingPrincipals = AccessRule.matchingPrincipals((KafkaPrincipal)userPrincipal, groupPrincipals, (KafkaPrincipal)AccessRule.WILDCARD_USER_PRINCIPAL, (KafkaPrincipal)AccessRule.WILDCARD_GROUP_PRINCIPAL);
        AuthorizeRule authorizeRule = this.aclAccessRuleStore.findMatchingRule(matchingPrincipals, host, action);
        if (!authorizeRule.deny()) {
            matchingPrincipals = AccessRule.matchingPrincipals((KafkaPrincipal)userPrincipal, groupPrincipals, null, null);
            authorizeRule.add(this.rbacAccessRuleStore.findMatchingRule(matchingPrincipals, host, action));
        }
        return authorizeRule;
    }
}

