/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.kafka;

import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.provider.ldap.LdapConfig;
import io.confluent.security.auth.provider.ldap.LdapStore;
import io.confluent.security.auth.store.cache.AbstractAuthCache;
import io.confluent.security.auth.store.data.AclBindingKey;
import io.confluent.security.auth.store.data.AclBindingValue;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.IdentityPoolKey;
import io.confluent.security.auth.store.data.IdentityPoolValue;
import io.confluent.security.auth.store.data.JwtIssuerKey;
import io.confluent.security.auth.store.data.JwtIssuerValue;
import io.confluent.security.auth.store.data.RefreshTokenInfoKey;
import io.confluent.security.auth.store.data.RefreshTokenInfoValue;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.auth.store.data.StatusKey;
import io.confluent.security.auth.store.data.StatusValue;
import io.confluent.security.auth.store.external.ExternalStore;
import io.confluent.security.auth.utils.AuthWriterUtils;
import io.confluent.security.authentication.oidc.RefreshTokenInfo;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.acl.AclRule;
import io.confluent.security.authorizer.provider.ProviderFailedException;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.security.store.MetadataStoreStatus;
import io.confluent.security.store.NotMasterWriterException;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.ConsumerListener;
import io.confluent.security.store.kafka.clients.KafkaPartitionWriter;
import io.confluent.security.store.kafka.clients.KafkaUtils;
import io.confluent.security.store.kafka.clients.StatusListener;
import io.confluent.security.store.kafka.clients.Writer;
import io.confluent.security.store.kafka.coordinator.MetadataServiceRebalanceListener;
import io.confluent.security.trustservice.store.TrustWriter;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAuthWriter
implements Writer,
AuthWriter,
TrustWriter,
ConsumerListener<AuthKey, AuthValue> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAuthWriter.class);
    private static final Collection<Uuid> LOCAL_ACL = Collections.singleton(Uuid.ZERO_UUID);
    private final String topic;
    private final int numPartitions;
    private final KafkaStoreConfig config;
    private final Time time;
    private final AbstractAuthCache authCache;
    private final StatusListener statusListener;
    private final Producer<AuthKey, AuthValue> producer;
    private final Supplier<AdminClient> adminClientSupplier;
    private final CompletableFuture<Void> existingRecordsFuture;
    private final Map<AuthEntryType, ExternalStore> externalAuthStores;
    private final AtomicBoolean isMasterWriter;
    private final Map<Integer, KafkaPartitionWriter<AuthKey, AuthValue>> partitionWriters;
    private final AtomicBoolean alive;
    private MetadataServiceRebalanceListener rebalanceListener;
    private ExecutorService mgmtExecutor;
    private ScheduledExecutorService writeExecutor;
    private volatile boolean ready;

    public KafkaAuthWriter(String topic, int numPartitions, KafkaStoreConfig config, Producer<AuthKey, AuthValue> producer, Supplier<AdminClient> adminClientSupplier, AbstractAuthCache authCache, StatusListener statusListener, CompletableFuture<Void> existingRecordsFuture, Time time) {
        this.topic = topic;
        this.numPartitions = numPartitions;
        this.config = config;
        this.statusListener = statusListener;
        this.existingRecordsFuture = existingRecordsFuture;
        this.producer = producer;
        this.adminClientSupplier = adminClientSupplier;
        this.authCache = authCache;
        this.time = time;
        this.externalAuthStores = new HashMap<AuthEntryType, ExternalStore>();
        this.isMasterWriter = new AtomicBoolean();
        this.partitionWriters = new HashMap<Integer, KafkaPartitionWriter<AuthKey, AuthValue>>();
        this.alive = new AtomicBoolean(true);
        this.loadExternalAuthStores();
    }

    @Override
    public void startWriter(int generationId) {
        log.info("Starting writer with generation {}", (Object)generationId);
        if (generationId < 0) {
            throw new IllegalArgumentException("Invalid generation id for master writer " + generationId);
        }
        if (this.mgmtExecutor != null && !this.mgmtExecutor.isTerminated()) {
            throw new IllegalStateException("Starting writer without clearing startup executor of previous generation");
        }
        this.isMasterWriter.set(true);
        this.mgmtExecutor = Executors.newSingleThreadExecutor(ThreadUtils.createThreadFactory((String)"auth-writer-mgmt-%d", (boolean)true));
        this.writeExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"auth-writer-%d", (boolean)true));
        this.mgmtExecutor.submit(() -> {
            try {
                if (this.partitionWriters.isEmpty()) {
                    this.createPartitionWriters();
                    this.existingRecordsFuture.get();
                }
                StatusValue initializing = new StatusValue(MetadataStoreStatus.INITIALIZING, generationId, Integer.valueOf(this.config.brokerId), null);
                this.partitionWriters.forEach((partition, writer) -> writer.start(generationId, new StatusKey(partition.intValue()), initializing, this.writeExecutor));
                this.ready = true;
            }
            catch (Throwable e) {
                log.error("Kafka auth writer initialization failed, resigning", e);
                this.rebalanceListener.onWriterResigned(generationId);
            }
        });
        this.mgmtExecutor.submit(() -> {
            try {
                this.externalAuthStores.forEach((type, store) -> store.start(generationId));
                this.updateExternalStatus(MetadataStoreStatus.INITIALIZED, null, generationId);
            }
            catch (Throwable e) {
                this.updateExternalStatus(MetadataStoreStatus.FAILED, e.getMessage(), generationId);
            }
        });
    }

    @Override
    public void stopWriter(Integer generationId) {
        try {
            log.info("Stopping writer {}", (Object)(generationId == null ? "" : "with generation " + generationId));
            this.ready = false;
            if (this.mgmtExecutor != null) {
                this.mgmtExecutor.shutdownNow();
            }
            if (this.mgmtExecutor != null && !this.mgmtExecutor.awaitTermination(this.config.refreshTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.error("Timed out waiting for auth writer management executor to be terminated");
            }
            this.externalAuthStores.values().forEach(store -> store.stop(generationId));
            this.partitionWriters.values().forEach(KafkaPartitionWriter::stop);
            if (this.writeExecutor != null) {
                this.writeExecutor.shutdownNow();
            }
            if (this.writeExecutor != null && !this.writeExecutor.awaitTermination(this.config.refreshTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                log.error("Timed out waiting for auth writer executor to be terminated");
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while shutting down writer executor");
            throw new InterruptException(e);
        }
        catch (Exception e) {
            log.error("Failed to stop auth writer cleanly", (Throwable)e);
        }
        finally {
            this.mgmtExecutor = null;
            this.writeExecutor = null;
            this.isMasterWriter.set(false);
            if (generationId != null) {
                log.info("Calling onWriterFailure for all partition writers");
                this.partitionWriters.values().forEach(p -> p.onWriterFailure(generationId));
            }
        }
    }

    @Override
    public boolean ready() {
        return this.ready;
    }

    public CompletionStage<Void> addClusterRoleBinding(Optional<KafkaPrincipal> requestorPrincipal, KafkaPrincipal principal, String role, Scope scope, String reason) {
        log.debug("addClusterRoleBinding requestorPrincipal={} principal={} role={} scope={} reason={}", new Object[]{requestorPrincipal, principal, role, scope, reason});
        return this.replaceResourceRoleBinding(requestorPrincipal, principal, role, scope, Collections.emptySet(), reason);
    }

    public CompletionStage<Void> addResourceRoleBinding(Optional<KafkaPrincipal> requestorPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<io.confluent.security.authorizer.ResourcePattern> newResources, String reason) {
        log.debug("addResourceRoleBinding requestorPrincipal={} principal={} role={} scope={} resources={} reason={}", new Object[]{requestorPrincipal, principal, role, scope, newResources, reason});
        this.ensureMasterWriter();
        AuthWriterUtils.validateRoleBindingUpdate(role, scope, newResources, true, this.authCache.rootScope(), this.authCache.rbacRoles());
        AuthWriterUtils.validateRoleResources(newResources);
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.update((AuthKey)key, existingValue -> {
            HashSet updatedResources = new HashSet();
            if (existingValue != null) {
                updatedResources.addAll(((RoleBindingValue)existingValue).resources());
            }
            updatedResources.addAll(newResources);
            log.debug("New binding {} {} {} {}", new Object[]{principal, role, scope, updatedResources});
            return new RoleBindingValue(updatedResources);
        });
    }

    public CompletionStage<Void> replaceResourceRoleBinding(Optional<KafkaPrincipal> requestorPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<io.confluent.security.authorizer.ResourcePattern> resources, String reason) {
        log.debug("replaceResourceRoleBinding requestorPrincipal={} principal={} role={} scope={} resources={} reason={}", new Object[]{requestorPrincipal, principal, role, scope, resources, reason});
        this.ensureMasterWriter();
        AuthWriterUtils.validateRoleBindingUpdate(role, scope, resources, true, this.authCache.rootScope(), this.authCache.rbacRoles());
        AuthWriterUtils.validateRoleResources(resources);
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, (AuthValue)new RoleBindingValue(resources), null, true, false);
    }

    public CompletionStage<Void> removeRoleBinding(Optional<KafkaPrincipal> requestorPrincipal, KafkaPrincipal principal, String role, Scope scope, String reason) {
        log.debug("removeRoleBinding requestorPrincipal={} principal={} role={} scope={} reason={}", new Object[]{requestorPrincipal, principal, role, scope, reason});
        this.ensureMasterWriter();
        AuthWriterUtils.validateRoleBindingUpdate(role, scope, Collections.emptySet(), false, this.authCache.rootScope(), this.authCache.rbacRoles());
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, null, null, true, false);
    }

    public CompletionStage<Void> removeResourceRoleBinding(Optional<KafkaPrincipal> requestorPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePatternFilter> deletedResources, String reason) {
        log.debug("removeResourceRoleBinding requestorPrincipal={} principal={} role={} scope={} resources={} reason={}", new Object[]{requestorPrincipal, principal, role, scope, deletedResources, reason});
        this.ensureMasterWriter();
        AuthWriterUtils.validateRoleBindingUpdate(role, scope, deletedResources, true, this.authCache.rootScope(), this.authCache.rbacRoles());
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.update((AuthKey)key, existingValue -> {
            HashSet updatedResources = new HashSet();
            if (existingValue != null) {
                updatedResources.addAll(((RoleBindingValue)existingValue).resources());
            }
            deletedResources.forEach(pattern -> updatedResources.removeIf(arg_0 -> ((ResourcePatternFilter)pattern).matches(arg_0)));
            if (!updatedResources.isEmpty()) {
                log.debug("New binding {} {} {} {}", new Object[]{principal, role, scope, updatedResources});
                return new RoleBindingValue(updatedResources);
            }
            log.debug("Deleting binding with no remaining resources {} {} {}", new Object[]{principal, role, scope});
            return null;
        });
    }

    public CompletionStage<Void> addJwks(Optional<Principal> requesterPrincipal, String jwtIssuer, String jwksEndpoint, JsonWebKeySet jwks, String reason) {
        log.debug("addJwtIssuer requesterPrincipal={} issuer={} jwksEndpoint={} keys={} reason={}", new Object[]{requesterPrincipal, jwtIssuer, jwksEndpoint, jwks, reason});
        return this.replaceJwks(requesterPrincipal, jwtIssuer, jwksEndpoint, jwks, reason);
    }

    public CompletionStage<Void> removeJwks(Optional<Principal> requesterPrincipal, String jwtIssuer, String jwksEndpoint, String reason) {
        log.debug("removeJwtIssuer requesterPrincipal={} issuer={} jwksEndpoint={} reason={}", new Object[]{requesterPrincipal, jwtIssuer, jwksEndpoint, reason});
        this.ensureMasterWriter();
        JwtIssuerKey key = new JwtIssuerKey(jwtIssuer, null, jwksEndpoint);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, null, null, true, false);
    }

    public CompletionStage<Void> replaceJwks(Optional<Principal> requesterPrincipal, String jwtIssuer, String jwksEndpoint, JsonWebKeySet jwks, String reason) {
        log.debug("replaceJwtIssuer requesterPrincipal={} JwtIssuer={} jwksEndpoint={} jwks={} reason={}", new Object[]{requesterPrincipal, jwtIssuer, jwksEndpoint, jwks, reason});
        this.ensureMasterWriter();
        JwtIssuerKey key = new JwtIssuerKey(jwtIssuer, null, jwksEndpoint);
        JwtIssuerValue value = new JwtIssuerValue(jwks);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, (AuthValue)value, null, true, false);
    }

    public CompletionStage<Void> addIdentityPool(Optional<Principal> requesterPrincipal, String poolId, int version, String issuer, String jwksEndpoint, String subjectClaim, String serviceAccount, String policy, String orgId, String reason) {
        log.debug("addIdentityPool requesterPrincipal={} poolId={} version={} issuer={} jwksEndpoint={} subjectClaim={} serviceAccount={} policy={} orgId={} reason={}", new Object[]{requesterPrincipal, poolId, version, issuer, jwksEndpoint, subjectClaim, serviceAccount, policy, orgId, reason});
        return this.replaceIdentityPool(requesterPrincipal, poolId, version, issuer, jwksEndpoint, subjectClaim, serviceAccount, policy, orgId, reason);
    }

    public CompletionStage<Void> removeIdentityPool(Optional<Principal> requesterPrincipal, String poolId, String reason) {
        log.debug("removeIdentityPool requesterPrincipal={} poolId={} reason={}", new Object[]{requesterPrincipal, poolId, reason});
        this.ensureMasterWriter();
        IdentityPoolKey key = new IdentityPoolKey(poolId);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, null, null, true, false);
    }

    public CompletionStage<Void> replaceIdentityPool(Optional<Principal> requesterPrincipal, String poolId, int version, String issuer, String jwksEndpoint, String subjectClaim, String serviceAccount, String policy, String orgId, String reason) {
        log.debug("replaceIdentityPool requesterPrincipal={} poolId={} version={} issuer={} jwksEndpoint={} subjectClaim={} serviceAccount={} policy={}, orgId={} reason={}", new Object[]{requesterPrincipal, poolId, version, jwksEndpoint, subjectClaim, issuer, serviceAccount, policy, orgId, reason});
        this.ensureMasterWriter();
        IdentityPoolKey key = new IdentityPoolKey(poolId);
        IdentityPoolValue value = new IdentityPoolValue((long)version, issuer, null, jwksEndpoint, subjectClaim, serviceAccount, policy, orgId);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, (AuthValue)value, null, true, false);
    }

    public CompletionStage<Void> addRefreshTokenInfo(Optional<Principal> requesterPrincipal, String issuer, String encryptedRefreshToken, long issuedAt, String subClaim, String sessionId) {
        log.debug("addRefreshTokenInfo requesterPrincipal={} issuer={} encryptedRefreshToken=<sensitive> issuedAt={} subClaim={} sessionId={}", new Object[]{requesterPrincipal, issuer, issuedAt, subClaim, sessionId});
        return this.replaceRefreshTokenInfo(requesterPrincipal, issuer, encryptedRefreshToken, issuedAt, subClaim, sessionId);
    }

    public CompletionStage<Void> removeRefreshTokenInfo(Optional<Principal> requesterPrincipal, String issuer, String subClaim) {
        log.debug("removeRefreshTokenInfo requesterPrincipal={} issuer={} subClaim={}", new Object[]{requesterPrincipal, issuer, subClaim});
        this.ensureMasterWriter();
        RefreshTokenInfoKey key = new RefreshTokenInfoKey(issuer, subClaim);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, null, null, true, false);
    }

    public CompletionStage<Void> replaceRefreshTokenInfo(Optional<Principal> requesterPrincipal, String issuer, String encryptedRefreshToken, long issuedAt, String subClaim, String sessionId) {
        log.debug("addRefreshTokenInfo requesterPrincipal={} issuer={} encryptedRefreshToken=<sensitive> issuedAt={} subClaim={} sessionId={}", new Object[]{requesterPrincipal, issuer, issuedAt, subClaim, sessionId});
        this.ensureMasterWriter();
        RefreshTokenInfoKey key = new RefreshTokenInfoKey(issuer, subClaim);
        RefreshTokenInfoValue value = new RefreshTokenInfoValue(new RefreshTokenInfo(issuer, encryptedRefreshToken, issuedAt, subClaim, sessionId));
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        return partitionWriter.write((AuthKey)key, (AuthValue)value, null, true, false);
    }

    public CompletionStage<Void> createAcls(Optional<KafkaPrincipal> requestorPrincipal, Scope scope, AclBinding aclBinding) {
        return this.createAcls(requestorPrincipal, scope, Collections.singletonList(aclBinding)).get(aclBinding).thenApply(result -> {
            if (result.exception().isPresent()) {
                throw (ApiException)result.exception().get();
            }
            return null;
        });
    }

    public Map<AclBinding, CompletionStage<AclCreateResult>> createAcls(Optional<KafkaPrincipal> requestorPrincipal, Scope scope, List<AclBinding> aclBindings) {
        log.debug("createAcls requestorPrincipal={} scope={} aclBindings={}", new Object[]{requestorPrincipal, scope, aclBindings});
        this.ensureMasterWriter();
        AuthWriterUtils.validateScope(scope, this.authCache.rootScope());
        aclBindings.forEach(this::validateAclBinding);
        HashMap bindingsByResource = new HashMap();
        aclBindings.forEach(binding -> bindingsByResource.computeIfAbsent(io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)binding.pattern()), unused -> new ArrayList()).add(binding));
        Map<AclBinding, CompletionStage<AclCreateResult>> futures = aclBindings.stream().collect(Collectors.toMap(Function.identity(), b -> new CompletableFuture()));
        try {
            this.writeExecutor.submit(() -> {
                try {
                    this.createAcls(scope, bindingsByResource, futures);
                }
                catch (Throwable t) {
                    this.populateAclCreateFailure(futures, t);
                }
            });
        }
        catch (Throwable t) {
            this.populateAclCreateFailure(futures, t);
        }
        return futures;
    }

    private void createAcls(Scope scope, Map<io.confluent.security.authorizer.ResourcePattern, List<AclBinding>> aclBindings, Map<AclBinding, CompletionStage<AclCreateResult>> futures) {
        aclBindings.forEach((resourcePattern, bindings) -> {
            AclBindingKey key = new AclBindingKey(resourcePattern, scope);
            KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
            partitionWriter.update((AuthKey)key, existingValue -> {
                HashSet<AclRule> updatedRules = new HashSet<AclRule>();
                if (existingValue != null) {
                    updatedRules.addAll(this.splitAclsByLinkId(((AclBindingValue)existingValue).aclRules()));
                }
                bindings.forEach(binding -> updatedRules.addAll(this.splitAclsByLinkId(Collections.singleton(AclRule.from((AclBinding)binding)))));
                log.debug("New Acl binding scope={} resourcePattern={} accessRules={}", new Object[]{scope, resourcePattern, updatedRules});
                return new AclBindingValue(this.normalizeAcls(updatedRules));
            }).thenApply(unused -> new AclCreateResult(null)).exceptionally(e -> new AclCreateResult((ApiException)new ProviderFailedException(e))).thenAccept(result -> bindings.forEach(b -> ((CompletionStage)futures.get(b)).toCompletableFuture().complete((AclCreateResult)result)));
        });
    }

    private Collection<AclRule> splitAclsByLinkId(Collection<AclRule> acls) {
        return acls.stream().flatMap(acl -> {
            if (acl.clusterLinkIds().isEmpty()) {
                return Stream.of(this.aclRuleWithClusterLinkIds((AclRule)acl, LOCAL_ACL));
            }
            return acl.clusterLinkIds().stream().map(linkId -> this.aclRuleWithClusterLinkIds((AclRule)acl, (Collection<Uuid>)Collections.singleton(linkId)));
        }).collect(Collectors.toSet());
    }

    public AclBinding normalizeAcl(AclBinding acl) {
        if (acl.entry().clusterLinkIds().equals(LOCAL_ACL)) {
            return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, Collections.emptySet());
        }
        return acl;
    }

    public Collection<AclRule> normalizeAcls(Collection<AclRule> acls) {
        HashMap rules = new HashMap();
        acls.forEach(acl -> {
            AclRule baseRule = this.aclRuleWithClusterLinkIds((AclRule)acl, (Collection<Uuid>)Collections.emptySet());
            rules.compute(baseRule, (key, normalizedRule) -> {
                if (normalizedRule != null && !normalizedRule.clusterLinkIds().equals(acl.clusterLinkIds())) {
                    HashSet<Uuid> linkIds = normalizedRule.clusterLinkIds();
                    if (linkIds.isEmpty()) {
                        linkIds = new HashSet<Uuid>(LOCAL_ACL);
                    }
                    if (acl.clusterLinkIds().isEmpty()) {
                        linkIds.addAll(LOCAL_ACL);
                    } else {
                        linkIds.addAll(acl.clusterLinkIds());
                    }
                    return this.aclRuleWithClusterLinkIds((AclRule)normalizedRule, (Collection<Uuid>)linkIds);
                }
                return acl;
            });
        });
        return rules.values().stream().map(acl -> {
            if (LOCAL_ACL.equals(acl.clusterLinkIds())) {
                return this.aclRuleWithClusterLinkIds((AclRule)acl, (Collection<Uuid>)Collections.emptySet());
            }
            return acl;
        }).collect(Collectors.toSet());
    }

    private AclRule aclRuleWithClusterLinkIds(AclRule rule, Collection<Uuid> clusterLinkIds) {
        return new AclRule(rule.principal(), rule.permissionType(), rule.host(), rule.operation(), clusterLinkIds);
    }

    private void populateAclCreateFailure(Map<AclBinding, CompletionStage<AclCreateResult>> futures, Throwable t) {
        futures.values().stream().map(CompletionStage::toCompletableFuture).filter(future -> !future.isDone()).forEach(future -> future.complete(new AclCreateResult(this.toApiException(t))));
    }

    private ApiException toApiException(Throwable t) {
        if (t instanceof RejectedExecutionException) {
            return new NotMasterWriterException("This node is currently not the master writer for Metadata Service. This could be a transient exception during writer election.");
        }
        if (t instanceof ApiException) {
            return (ApiException)t;
        }
        return new ApiException(t);
    }

    public CompletionStage<Collection<AclBinding>> deleteAcls(Optional<KafkaPrincipal> requestorPrincipal, Scope scope, AclBindingFilter filter, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess) {
        return this.deleteAcls(requestorPrincipal, scope, Collections.singletonList(filter), resourceAccess).get(filter).thenApply(result -> {
            if (result.exception().isPresent()) {
                throw (ApiException)result.exception().get();
            }
            return result.aclBindingDeleteResults().stream().map(AclDeleteResult.AclBindingDeleteResult::aclBinding).collect(Collectors.toList());
        });
    }

    public Map<AclBindingFilter, CompletionStage<AclDeleteResult>> deleteAcls(Optional<KafkaPrincipal> requestorPrincipal, Scope scope, List<AclBindingFilter> filters, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess) {
        log.debug("deleteAclRules requestorPrincipal={} scope={} aclBindingFilters={}", new Object[]{requestorPrincipal, scope, filters});
        this.ensureMasterWriter();
        AuthWriterUtils.validateScope(scope, this.authCache.rootScope());
        Map<AclBindingFilter, CompletionStage<AclDeleteResult>> futures = filters.stream().collect(Collectors.toMap(Function.identity(), b -> new CompletableFuture()));
        try {
            CompletableFuture[] readyFutures = new CompletableFuture[this.partitionWriters.size()];
            for (int i = 0; i < this.partitionWriters.size(); ++i) {
                readyFutures[i] = this.partitionWriters.get(i).incrementalUpdateFuture();
            }
            ((CompletableFuture)CompletableFuture.allOf(readyFutures).thenAcceptAsync(v -> this.deleteAcls(scope, filters, resourceAccess, futures), (Executor)this.writeExecutor)).whenComplete((unused, exception) -> {
                if (exception != null) {
                    this.populateAclDeleteFailure(futures, (Throwable)exception);
                }
            });
        }
        catch (Throwable t) {
            this.populateAclDeleteFailure(futures, t);
        }
        return futures;
    }

    private void populateAclDeleteFailure(Map<AclBindingFilter, CompletionStage<AclDeleteResult>> futures, Throwable t) {
        futures.values().stream().map(CompletionStage::toCompletableFuture).filter(future -> !future.isDone()).forEach(future -> future.complete(new AclDeleteResult(this.toApiException(t))));
    }

    private void deleteAcls(Scope scope, List<AclBindingFilter> filters, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess, Map<AclBindingFilter, CompletionStage<AclDeleteResult>> futures) {
        log.trace("Scheduling deleteAcls for filters {}", filters);
        Map toDeleteBindings = filters.stream().collect(Collectors.toMap(Function.identity(), unused -> new LinkedList()));
        HashMap<io.confluent.security.authorizer.ResourcePattern, Collection> toDeleteRules = new HashMap<io.confluent.security.authorizer.ResourcePattern, Collection>();
        HashMap bindingRules = new HashMap();
        this.ensureMasterWriter();
        toDeleteBindings.forEach((filter, deleteList) -> {
            block2: {
                block1: {
                    this.validateAclFilter((AclBindingFilter)filter);
                    if (!filter.matchesAtMostOne() || !filter.entryFilter().clusterLinkIds().isEmpty()) break block1;
                    io.confluent.security.authorizer.ResourcePattern resourcePattern = io.confluent.security.authorizer.ResourcePattern.from((org.apache.kafka.common.resource.ResourcePatternFilter)filter.patternFilter());
                    AclRule accessRule = AclRule.from((AccessControlEntryFilter)filter.entryFilter());
                    if (!resourceAccess.test(resourcePattern)) break block2;
                    AclBinding aclBinding = new AclBinding(io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)resourcePattern), accessRule.toAccessControlEntry());
                    DeletableAclBinding deletableBinding = new DeletableAclBinding(aclBinding, resourcePattern, this.aclRuleWithClusterLinkIds(accessRule, LOCAL_ACL));
                    if (bindingRules.containsKey(aclBinding)) break block2;
                    toDeleteRules.computeIfAbsent(resourcePattern, unused -> new LinkedList()).add(deletableBinding);
                    deleteList.add(deletableBinding);
                    bindingRules.put(aclBinding, deletableBinding);
                    break block2;
                }
                Collection<AclBinding> matchedBindings = this.aclBindings(scope, (AclBindingFilter)filter, resourceAccess);
                matchedBindings.removeAll(bindingRules.keySet());
                for (AclBinding aclBinding : matchedBindings) {
                    io.confluent.security.authorizer.ResourcePattern resourcePattern = io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)aclBinding.pattern());
                    AclRule accessRule = AclRule.from((AclBinding)aclBinding);
                    DeletableAclBinding deletableBinding = new DeletableAclBinding(this.normalizeAcl(aclBinding), resourcePattern, accessRule);
                    toDeleteRules.computeIfAbsent(resourcePattern, v -> new LinkedList()).add(deletableBinding);
                    deleteList.add(deletableBinding);
                    bindingRules.put(aclBinding, deletableBinding);
                }
            }
        });
        toDeleteRules.forEach((resourcePattern, deletableBindings) -> {
            CompletionStage<Void> future = this.deleteAclRules(scope, (io.confluent.security.authorizer.ResourcePattern)resourcePattern, deletableBindings.stream().map(b -> b.aclRule).collect(Collectors.toList()));
            deletableBindings.forEach(b -> {
                b.future = future.toCompletableFuture();
            });
        });
        toDeleteBindings.forEach((filter, deleteFutures) -> this.future((Collection<DeletableAclBinding>)deleteFutures).thenAccept(result -> ((CompletionStage)futures.get(filter)).toCompletableFuture().complete((AclDeleteResult)result)));
    }

    private CompletionStage<AclDeleteResult> future(Collection<DeletableAclBinding> bindings) {
        return CompletableFuture.allOf(bindings.stream().map(b -> b.future).collect(Collectors.toList()).toArray(new CompletableFuture[bindings.size()])).thenApply(unused -> new AclDeleteResult((Collection)bindings.stream().map(DeletableAclBinding::deleteResult).collect(Collectors.toList())));
    }

    private CompletionStage<Void> deleteAclRules(Scope scope, io.confluent.security.authorizer.ResourcePattern resourcePattern, Collection<AclRule> deletedRules) {
        AclBindingKey key = new AclBindingKey(resourcePattern, scope);
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter((AuthKey)key);
        log.trace("deleteAclRules {} {}", (Object)resourcePattern, deletedRules);
        return partitionWriter.update((AuthKey)key, existingValue -> {
            HashSet<AclRule> updatedRules = new HashSet<AclRule>();
            if (existingValue != null) {
                updatedRules.addAll(this.splitAclsByLinkId(((AclBindingValue)existingValue).aclRules()));
            }
            updatedRules.removeAll(deletedRules);
            if (!updatedRules.isEmpty()) {
                log.debug("New Acl binding scope={} resourcePattern={} accessRules={}", new Object[]{scope, resourcePattern, updatedRules});
                return new AclBindingValue(this.normalizeAcls(updatedRules));
            }
            log.debug("Deleting Acl binding with scope={} resourcePattern={}", (Object)scope, (Object)resourcePattern);
            return null;
        });
    }

    private Collection<AclBinding> aclBindings(Scope scope, AclBindingFilter aclBindingFilter, Predicate<io.confluent.security.authorizer.ResourcePattern> resourceAccess) {
        log.debug("aclBindings scope={} aclBindingFilter={}", (Object)scope, (Object)aclBindingFilter);
        HashSet<AclBinding> aclBindings = new HashSet<AclBinding>();
        for (Scope nextScope = scope; nextScope != null; nextScope = nextScope.parent()) {
            Map<io.confluent.security.authorizer.ResourcePattern, Set<AccessRule>> rules = this.authCache.aclRules(nextScope);
            if (rules == null) continue;
            rules.entrySet().stream().filter(e -> resourceAccess.test((io.confluent.security.authorizer.ResourcePattern)e.getKey())).forEach(e -> {
                ResourcePattern resourcePattern = io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)((io.confluent.security.authorizer.ResourcePattern)e.getKey()));
                ((Set)e.getValue()).forEach(accessRule -> {
                    Collection linkIds = accessRule.clusterLinkIds().isEmpty() ? LOCAL_ACL : accessRule.clusterLinkIds();
                    linkIds.forEach(linkId -> {
                        AclBinding binding = new AclBinding(resourcePattern, AclRule.accessControlEntry((AccessRule)accessRule, Collections.singleton(linkId)));
                        if (aclBindingFilter.matches(binding)) {
                            aclBindings.add(binding);
                        }
                    });
                });
            });
        }
        return aclBindings;
    }

    private void ensureMasterWriter() {
        if (!this.isMasterWriter.get() || !this.ready) {
            throw new NotMasterWriterException("This node is currently not the master writer for Metadata Service. This could be a transient exception during writer election.");
        }
    }

    private void validateAclBinding(AclBinding aclBinding) {
        if (aclBinding.toFilter().findIndefiniteField() != null) {
            throw new InvalidRequestException("Invalid ACL creation: " + aclBinding);
        }
        if (aclBinding.pattern().resourceType().equals((Object)ResourceType.CLUSTER) && !this.isClusterResource(aclBinding.pattern().name())) {
            throw new InvalidRequestException("The only valid name for the CLUSTER resource is kafka-cluster");
        }
    }

    private void validateAclFilter(AclBindingFilter filter) {
        if (filter.isUnknown()) {
            throw new InvalidRequestException("The AclBindingFilter must not contain UNKNOWN elements.");
        }
    }

    private boolean isClusterResource(String name) {
        return name.equals("kafka-cluster");
    }

    public void close(Duration closeTimeout) {
        if (this.alive.getAndSet(false)) {
            this.stopWriter(null);
            this.producer.close(closeTimeout);
        }
    }

    @Override
    public void onConsumerRecord(ConsumerRecord<AuthKey, AuthValue> record, AuthValue oldValue) {
        if (this.partitionWriters.isEmpty() || !this.partitionWriters.containsKey(record.partition())) {
            return;
        }
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriter(record.partition());
        AuthEntryType entryType = ((AuthKey)record.key()).entryType();
        if (entryType == AuthEntryType.STATUS) {
            StatusValue statusValue = (StatusValue)record.value();
            partitionWriter.onStatusConsumed(record.offset(), statusValue.generationId(), statusValue.status(), statusValue.writerBrokerId());
        } else {
            boolean expectPendingWrite = !Objects.equals(record.value(), oldValue);
            partitionWriter.onRecordConsumed(record, oldValue, expectPendingWrite);
        }
    }

    void rebalanceListener(MetadataServiceRebalanceListener rebalanceListener) {
        if (this.rebalanceListener != null) {
            throw new IllegalStateException("Rebalance listener already set on this writer");
        }
        this.rebalanceListener = rebalanceListener;
    }

    public void writeExternalEntry(AuthKey key, AuthValue value, int expectedGenerationId) {
        this.partitionWriter(this.partition(key)).write(key, value, expectedGenerationId, false, true);
    }

    public void writeExternalStatus(MetadataStoreStatus status, String errorMessage, int generationId) {
        block3: {
            ExecutorService executor = this.mgmtExecutor;
            if (executor != null && !executor.isShutdown()) {
                try {
                    executor.submit(() -> this.updateExternalStatus(status, errorMessage, generationId));
                }
                catch (RejectedExecutionException e) {
                    log.trace("Status could not be updated since executor has been shutdown");
                    if (executor.isShutdown()) break block3;
                    throw e;
                }
            }
        }
    }

    private void updateExternalStatus(MetadataStoreStatus status, String errorMessage, int generationId) {
        try {
            boolean hasFailure = this.externalAuthStores.values().stream().anyMatch(ExternalStore::failed);
            switch (status) {
                case INITIALIZED: {
                    if (!hasFailure) break;
                    return;
                }
                case FAILED: {
                    if (hasFailure) break;
                    return;
                }
                default: {
                    throw new IllegalStateException("Unexpected status for external store " + status);
                }
            }
            StatusValue statusValue = new StatusValue(status, generationId, Integer.valueOf(this.config.brokerId), errorMessage);
            this.partitionWriters.forEach((partition, writer) -> writer.writeStatus(generationId, new StatusKey(partition.intValue()), statusValue, status));
        }
        catch (Throwable e) {
            log.error("Failed to write external status to auth topic, writer resigning", e);
            this.rebalanceListener.onWriterResigned(generationId);
        }
    }

    private void createPartitionWriters() throws Throwable {
        this.maybeCreateAuthTopic(this.topic, this.config.topicCreateTimeout);
        if (this.numPartitions == 0) {
            throw new IllegalStateException("Number of partitions not known for " + this.topic);
        }
        for (int i = 0; i < this.numPartitions; ++i) {
            TopicPartition tp = new TopicPartition(this.topic, i);
            this.partitionWriters.put(i, new KafkaPartitionWriter<AuthKey, AuthValue>(tp, this.producer, this.authCache, this.rebalanceListener, this.statusListener, this.config.refreshTimeout, this.time));
        }
    }

    private void maybeCreateAuthTopic(String topic, Duration topicCreateTimeout) {
        try (AdminClient adminClient = this.adminClientSupplier.get();){
            KafkaUtils.waitForTopic(topic, this.numPartitions, this.time, topicCreateTimeout, t -> this.describeAuthTopic((String)t, adminClient), t -> this.createAuthTopic(adminClient, topic));
        }
    }

    private Set<Integer> describeAuthTopic(String topic, AdminClient adminClient) {
        try {
            if (!this.alive.get()) {
                throw new RuntimeException("KafkaAuthWriter has been shutdown");
            }
            return ((TopicDescription)((Map)adminClient.describeTopics(Collections.singleton(topic)).allTopicNames().get()).get(topic)).partitions().stream().map(TopicPartitionInfo::partition).collect(Collectors.toSet());
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof KafkaException) {
                throw (KafkaException)cause;
            }
            throw new KafkaException("Failed to describe auth topic " + topic, cause);
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    private void createAuthTopic(AdminClient adminClient, String topic) {
        try {
            if (!this.alive.get()) {
                throw new RuntimeException("KafkaAuthWriter has been shutdown");
            }
            NewTopic metadataTopic = this.config.metadataTopicCreateConfig(topic, this.numPartitions);
            log.info("Creating auth topic {}", (Object)metadataTopic);
            adminClient.createTopics(Collections.singletonList(metadataTopic)).all().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TopicExistsException) {
                log.debug("Topic was created by different node");
            }
            Throwable cause = e.getCause();
            if (cause instanceof KafkaException) {
                throw (KafkaException)cause;
            }
            throw new KafkaException("Failed to create auth topic " + topic, cause);
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    private int partition(AuthKey key) {
        return Utils.toPositive((int)key.hashCode()) % this.partitionWriters.size();
    }

    public KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter(int partition) {
        KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter = this.partitionWriters.get(partition);
        if (partitionWriter == null) {
            throw new IllegalArgumentException("Partition writer not found for partition " + partition);
        }
        return partitionWriter;
    }

    private KafkaPartitionWriter<AuthKey, AuthValue> partitionWriter(AuthKey key) {
        return this.partitionWriter(this.partition(key));
    }

    private void loadExternalAuthStores() {
        Map configs = this.config.originals();
        if (LdapConfig.ldapEnabled(configs)) {
            LdapStore ldapStore = this.createLdapStore(configs, this.authCache);
            this.externalAuthStores.put(AuthEntryType.USER, ldapStore);
        } else {
            this.externalAuthStores.put(AuthEntryType.USER, new DummyUserStore());
        }
    }

    protected LdapStore createLdapStore(Map<String, ?> configs, AbstractAuthCache authCache) {
        LdapStore ldapStore = new LdapStore(authCache, this, this.time);
        ldapStore.configure(configs);
        return ldapStore;
    }

    private static class DeletableAclBinding {
        final AclBinding binding;
        final io.confluent.security.authorizer.ResourcePattern resourcePattern;
        final AclRule aclRule;
        CompletableFuture<Void> future;

        DeletableAclBinding(AclBinding binding, io.confluent.security.authorizer.ResourcePattern resourcePattern, AclRule aclRule) {
            this.binding = binding;
            this.resourcePattern = resourcePattern;
            this.aclRule = aclRule;
        }

        AclDeleteResult.AclBindingDeleteResult deleteResult() {
            try {
                return (AclDeleteResult.AclBindingDeleteResult)((CompletableFuture)this.future.thenApply(v -> new AclDeleteResult.AclBindingDeleteResult(this.binding))).get();
            }
            catch (Throwable t) {
                return new AclDeleteResult.AclBindingDeleteResult(this.binding, (ApiException)new ProviderFailedException(t));
            }
        }
    }

    private class DummyUserStore
    implements ExternalStore {
        private DummyUserStore() {
        }

        public void configure(Map<String, ?> configs) {
        }

        @Override
        public void start(int generationId) {
            KafkaAuthWriter.this.authCache.map(AuthEntryType.USER.name()).forEach((k, v) -> KafkaAuthWriter.this.writeExternalEntry((AuthKey)k, null, generationId));
        }

        @Override
        public void stop(Integer generationId) {
        }

        @Override
        public boolean failed() {
            return false;
        }
    }
}

