/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class MetricsUtils {
    private static final MetricsRegistry METRICS_REGISTRY;

    public static <T> MetricName newGauge(String group, String type, String name, Map<String, String> tags, final Supplier<T> valueSupplier) {
        MetricName metricName = MetricsUtils.metricName(group, type, name, tags);
        METRICS_REGISTRY.newGauge(metricName, new Gauge<T>(){

            public T value() {
                return valueSupplier.get();
            }
        });
        return metricName;
    }

    public static Meter newMeter(MetricName metricName, String eventType) {
        return METRICS_REGISTRY.newMeter(metricName, eventType, TimeUnit.SECONDS);
    }

    public static void removeMetrics(Set<MetricName> metricNames) {
        metricNames.forEach(arg_0 -> ((MetricsRegistry)METRICS_REGISTRY).removeMetric(arg_0));
    }

    public static long elapsedSeconds(Time time, long timeMs) {
        return timeMs == 0L ? 0L : TimeUnit.MILLISECONDS.toSeconds(time.milliseconds() - timeMs);
    }

    public static MetricName metricName(String group, String type, String name, Map<String, String> tags) {
        String scope = Utils.mkString(tags, (String)"", (String)"", (String)".", (String)".");
        String mbeanTags = Utils.mkString(tags, (String)"", (String)"", (String)"=", (String)",");
        if (!mbeanTags.isEmpty()) {
            mbeanTags = "," + mbeanTags;
        }
        String mbeanName = String.format("%s:type=%s,name=%s%s", group, type, name, mbeanTags);
        return new MetricName(group, type, name, scope, mbeanName);
    }

    static {
        try {
            Class<?> cls = Class.forName("org.apache.kafka.server.metrics.KafkaYammerMetrics");
            METRICS_REGISTRY = (MetricsRegistry)cls.getMethod("defaultRegistry", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate KafkaYammerMetrics, make sure it's in the classpath", e);
        }
    }
}

