/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import java.util.concurrent.ThreadLocalRandom;

public class RetryBackoff {
    private static final int RETRY_BACKOFF_EXP_BASE = 2;
    private final int initialBackoffMs;
    private final int maxBackoffMs;
    private final double retryBackoffMaxExp;

    public RetryBackoff(int initialBackoffMs, int maxBackoffMs) {
        this.initialBackoffMs = initialBackoffMs;
        this.maxBackoffMs = maxBackoffMs;
        this.retryBackoffMaxExp = Math.log((double)maxBackoffMs / (double)Math.max(initialBackoffMs, 1)) / Math.log(2.0);
    }

    public int backoffMs(int attempts) {
        int backoffMs = this.initialBackoffMs;
        if (this.initialBackoffMs != this.maxBackoffMs) {
            double backoffExp = Math.min((double)attempts, this.retryBackoffMaxExp);
            double backoffFactor = Math.pow(2.0, backoffExp);
            backoffMs = (int)((double)this.initialBackoffMs * backoffFactor);
            double randomFactor = ThreadLocalRandom.current().nextDouble(0.8, 1.2);
            backoffMs = (int)(randomFactor * (double)backoffMs);
            backoffMs = Math.max(Math.min(backoffMs, this.maxBackoffMs), this.initialBackoffMs);
        }
        return backoffMs;
    }
}

