/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.Objects;
import java.util.zip.Checksum;

public final class ChecksumInfo {
    private final Checksum checksum;
    private final long sizeInBytes;
    private final long lastModifiedMs;
    private final boolean shouldPersist;

    public ChecksumInfo(Checksum checksum, long sizeInBytes, long lastModifiedMs, boolean shouldPersist) {
        this.checksum = checksum;
        this.sizeInBytes = sizeInBytes;
        this.lastModifiedMs = lastModifiedMs;
        this.shouldPersist = shouldPersist;
    }

    public Checksum checksum() {
        return this.checksum;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long lastModifiedMs() {
        return this.lastModifiedMs;
    }

    public boolean shouldPersist() {
        return this.shouldPersist;
    }

    public String toString() {
        return "ChecksumInfo(checksum=" + this.checksum.getValue() + ", sizeInBytes=" + this.sizeInBytes + ", lastModifiedMs=" + this.lastModifiedMs + ", shouldPersist=" + this.shouldPersist + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumInfo that = (ChecksumInfo)o;
        return this.sizeInBytes == that.sizeInBytes && this.checksum.getValue() == that.checksum.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.checksum.getValue(), this.sizeInBytes);
    }
}

