/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.checksum.serdes.Entry;
import io.confluent.kafka.storage.checksum.serdes.Header;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Store
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_0();
    }

    public static Store getRootAsStore(ByteBuffer _bb) {
        return Store.getRootAsStore(_bb, new Store());
    }

    public static Store getRootAsStore(ByteBuffer _bb, Store obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public Store __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public Header header() {
        return this.header(new Header());
    }

    public Header header(Header obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(o + this.bb_pos), this.bb) : null;
    }

    public Entry entries(int j) {
        return this.entries(new Entry(), j);
    }

    public Entry entries(Entry obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int entriesLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Entry.Vector entriesVector() {
        return this.entriesVector(new Entry.Vector());
    }

    public Entry.Vector entriesVector(Entry.Vector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public static int createStore(FlatBufferBuilder builder, int headerOffset, int entriesOffset) {
        builder.startTable(2);
        Store.addEntries(builder, entriesOffset);
        Store.addHeader(builder, headerOffset);
        return Store.endStore(builder);
    }

    public static void startStore(FlatBufferBuilder builder) {
        builder.startTable(2);
    }

    public static void addHeader(FlatBufferBuilder builder, int headerOffset) {
        builder.addOffset(0, headerOffset, 0);
    }

    public static void addEntries(FlatBufferBuilder builder, int entriesOffset) {
        builder.addOffset(1, entriesOffset, 0);
    }

    public static int createEntriesVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startEntriesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endStore(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishStoreBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedStoreBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public Store get(int j) {
            return this.get(new Store(), j);
        }

        public Store get(Store obj, int j) {
            return obj.__assign(Store.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

