/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.PrimitiveRef;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.interceptor.RecordInterceptor;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.V2InPlaceLogValidator;

public interface KafkaLogValidator {
    public LogValidator.ValidationResult validateMessagesAndAssignOffsets(PrimitiveRef.LongRef var1, long var2, LogValidator.MetricsRecorder var4, BufferSupplier var5);

    default public void maybePrevalidate(long currentTimeMs, LogValidator.MetricsRecorder metricsRecorder, BufferSupplier bufferSupplier) {
    }

    public static KafkaLogValidator newValidator(MemoryRecords records, TopicPartition topicPartition, Time time, CompressionType sourceCompression, CompressionType targetCompression, boolean compactedTopic, byte toMagic, TimestampType timestampType, long timestampBeforeMaxMs, long timestampAfterMaxMs, List<RecordInterceptor> interceptors, int partitionLeaderEpoch, AppendOrigin origin, MetadataVersion interBrokerProtocolVersion) {
        if (targetCompression == CompressionType.ZSTD && interBrokerProtocolVersion.isLessThan(MetadataVersion.IBP_2_1_IV0)) {
            throw new UnsupportedCompressionTypeException("Produce requests to inter.broker.protocol.version < 2.1 broker are not allowed to use ZStandard compression");
        }
        if (toMagic == 2 && records.hasMatchingMagic(toMagic) && sourceCompression == targetCompression) {
            return new V2InPlaceLogValidator(records, topicPartition, compactedTopic, timestampType, timestampBeforeMaxMs, timestampAfterMaxMs, interceptors, partitionLeaderEpoch, origin);
        }
        return new LogValidator(records, topicPartition, time, sourceCompression, targetCompression, compactedTopic, toMagic, timestampType, timestampBeforeMaxMs, timestampAfterMaxMs, interceptors, partitionLeaderEpoch, origin, interBrokerProtocolVersion);
    }
}

