/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import java.util.OptionalLong;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public final class TxnMetadata {
    public final long producerId;
    public final LogOffsetMetadata firstOffset;
    public final long startTimeUpperBoundMs;
    public OptionalLong lastOffset;

    public TxnMetadata(long producerId, LogOffsetMetadata firstOffset, long startTimeUpperBoundMs, OptionalLong lastOffset) {
        Objects.requireNonNull(firstOffset, "firstOffset must be non null");
        this.producerId = producerId;
        this.firstOffset = firstOffset;
        this.startTimeUpperBoundMs = startTimeUpperBoundMs;
        this.lastOffset = lastOffset;
    }

    public TxnMetadata(long producerId, long firstOffset, long startTimeUpperBoundMs) {
        this(producerId, new LogOffsetMetadata(firstOffset), startTimeUpperBoundMs);
    }

    public TxnMetadata(long producerId, LogOffsetMetadata firstOffset, long startTimeUpperBoundMs) {
        this(producerId, firstOffset, startTimeUpperBoundMs, OptionalLong.empty());
    }

    public String toString() {
        return "TxnMetadata(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ", startTimeUpperBoundMs=" + this.startTimeUpperBoundMs + ", lastOffset=" + this.lastOffset + ')';
    }
}

