/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.kms.AWSKMS;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.integration.awskms.AwsKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class AwsKmsDriver
implements KmsDriver {
    public static final String ACCESS_KEY_ID = "access.key.id";
    public static final String SECRET_ACCESS_KEY = "secret.access.key";

    public String getKeyUrlPrefix() {
        return "aws-kms://";
    }

    private AWSCredentialsProvider getCredentials(Map<String, ?> configs) throws GeneralSecurityException {
        try {
            String accessKey = (String)configs.get(ACCESS_KEY_ID);
            String secretKey = (String)configs.get(SECRET_ACCESS_KEY);
            if (accessKey != null && secretKey != null) {
                String keys = "accessKey=" + accessKey + "\nsecretKey=" + secretKey + "\n";
                return new AWSStaticCredentialsProvider((AWSCredentials)new PropertiesCredentials((InputStream)new ByteArrayInputStream(keys.getBytes(StandardCharsets.UTF_8))));
            }
            return new DefaultAWSCredentialsProviderChain();
        }
        catch (Exception e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        AWSKMS testClient = (AWSKMS)this.getTestClient(configs);
        Optional<AWSCredentialsProvider> creds = testClient != null ? Optional.empty() : Optional.of(this.getCredentials(configs));
        return AwsKmsDriver.newKmsClientWithAwsKms(kekUrl, creds, testClient);
    }

    protected static KmsClient newKmsClientWithAwsKms(Optional<String> keyUri, Optional<AWSCredentialsProvider> credentials, AWSKMS awsKms) throws GeneralSecurityException {
        AwsKmsClient client = keyUri.isPresent() ? new AwsKmsClient(keyUri.get()) : new AwsKmsClient();
        if (credentials.isPresent()) {
            client.withCredentialsProvider(credentials.get());
        } else {
            client.withDefaultCredentials();
        }
        if (awsKms != null) {
            AwsKmsDriver.setAwsKms(client, awsKms);
        }
        return client;
    }

    private static void setAwsKms(AwsKmsClient client, AWSKMS awsKms) {
        try {
            Field field = AwsKmsClient.class.getDeclaredField("awsKms");
            field.setAccessible(true);
            field.set(client, awsKms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

