/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security;

import io.confluent.security.auth.client.RestClientConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ConnectSecurityExtensionConfig
extends AbstractConfig {
    public static final String ENABLE_RBAC_CREDENTIAL_INJECTION_CONFIG = "enable.rbac.credential.injection";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("group.id", ConfigDef.Type.STRING, (Object)"STANDALONE", ConfigDef.Importance.LOW, "").define("config.providers", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "").define("key.converter", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "").define("value.converter", ConfigDef.Type.STRING, ConfigDef.Importance.LOW, "").define("enable.rbac.credential.injection", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to enable RBAC credential injection/translation");
    private final RestClientConfig restClientConfig;

    public String connectClusterId() {
        return this.getString("group.id");
    }

    public List<String> configProviders() {
        return this.getList("config.providers");
    }

    public boolean shouldInjectRbacCredentials() {
        return this.getBoolean(ENABLE_RBAC_CREDENTIAL_INJECTION_CONFIG);
    }

    public String metadataServerUrls() {
        return String.join((CharSequence)",", this.restClientConfig.getList("confluent.metadata.bootstrap.server.urls"));
    }

    public ConnectSecurityExtensionConfig(Map<?, ?> configs) {
        super(CONFIG_DEF, configs);
        this.restClientConfig = new RestClientConfig(configs);
    }
}

