/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.connect.security.util.ConnectRestUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;

public class ConnectorSecretConfigFilter
implements ContainerRequestFilter {
    private static final Map<Method, Function<ContainerRequestContext, ConnectorAndConfig>> CONFIG_EXTRACTORS;
    private final Pattern secretPathReference;
    @Context
    private ResourceInfo resourceInfo;

    public ConnectorSecretConfigFilter(String secretConfigProvider) {
        this.secretPathReference = Pattern.compile("\\$\\{" + Pattern.quote(secretConfigProvider) + ":(([^}]*?):)?([^}]*?)\\}");
    }

    public void filter(ContainerRequestContext requestContext) {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        ConnectorAndConfig connectorAndConfig = ConnectorSecretConfigFilter.extractConnectorConfig(resourceMethod, requestContext);
        if (connectorAndConfig == null) {
            return;
        }
        for (String value : connectorAndConfig.config.values()) {
            Set<String> secretPaths = this.secretPaths(value);
            if (secretPaths.stream().allMatch(connectorAndConfig.name::equals)) continue;
            ConnectRestUtils.abortRequest(requestContext, Response.Status.FORBIDDEN, "All secret requests must include a path that matches the name of the connector");
            return;
        }
    }

    Set<String> secretPaths(String configValue) {
        Matcher match = this.secretPathReference.matcher(configValue);
        HashSet<String> result = new HashSet<String>();
        while (match.find()) {
            String path = match.group(2);
            result.add(path != null ? path : "");
        }
        return result;
    }

    static ConnectorAndConfig extractConnectorConfig(Method resourceMethod, ContainerRequestContext requestContext) {
        Function<ContainerRequestContext, ConnectorAndConfig> configExtractor = CONFIG_EXTRACTORS.get(resourceMethod);
        return configExtractor != null ? configExtractor.apply(requestContext) : null;
    }

    static ConnectorAndConfig extractNewConfig(ContainerRequestContext requestContext) {
        CreateConnectorRequest createConnectorRequest;
        try {
            createConnectorRequest = ConnectRestUtils.readEntity(requestContext, CreateConnectorRequest.class);
        }
        catch (IOException e) {
            throw new ConnectException("Failed to parse request entity", (Throwable)e);
        }
        return new ConnectorAndConfig(createConnectorRequest.name(), createConnectorRequest.config());
    }

    static ConnectorAndConfig extractAlteredConfig(ContainerRequestContext requestContext) {
        Map<String, String> config;
        try {
            config = ConnectRestUtils.readEntity(requestContext, new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            throw new ConnectException("Failed to parse request entity", (Throwable)e);
        }
        return new ConnectorAndConfig(ConnectRestUtils.connectorName(requestContext), config);
    }

    static {
        Method alterConfigMethod;
        Method newConfigMethod;
        try {
            newConfigMethod = ConnectorsResource.class.getMethod("createConnector", Boolean.class, HttpHeaders.class, CreateConnectorRequest.class);
            alterConfigMethod = ConnectorsResource.class.getMethod("putConnectorConfig", String.class, HttpHeaders.class, Boolean.class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException("Failed to initialize Secret Registry RBAC filter", (Throwable)e);
        }
        HashMap<Method, Function<ContainerRequestContext, ConnectorAndConfig>> configExtractors = new HashMap<Method, Function<ContainerRequestContext, ConnectorAndConfig>>();
        configExtractors.put(newConfigMethod, ConnectorSecretConfigFilter::extractNewConfig);
        configExtractors.put(alterConfigMethod, ConnectorSecretConfigFilter::extractAlteredConfig);
        CONFIG_EXTRACTORS = Collections.unmodifiableMap(configExtractors);
    }

    private static class ConnectorAndConfig {
        public final String name;
        public final Map<String, String> config;

        public ConnectorAndConfig(String name, Map<String, String> config) {
            this.name = name;
            this.config = config;
        }
    }
}

