/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.security.permissions;

import io.confluent.connect.security.ConnectSecurityFilter;
import io.confluent.connect.security.permissions.PermissionsBuilder;
import io.confluent.connect.security.permissions.entities.Permissions;
import io.confluent.connect.security.rbac.ConnectActions;
import io.confluent.connect.security.rbac.ConnectorOperations;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.Scope;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.connect.health.ConnectClusterState;

@Path(value="/permissions")
@Produces(value={"application/json"})
public class PermissionsResource {
    private final Scope scope;
    private final RestAuthorizer restAuthorizer;
    private final ConnectClusterState clusterState;

    public PermissionsResource(Scope scope, RestAuthorizer restAuthorizer, ConnectClusterState clusterState) {
        this.scope = scope;
        this.restAuthorizer = restAuthorizer;
        this.clusterState = clusterState;
    }

    @GET
    public Permissions getPermissions(@Context ContainerRequestContext requestContext) {
        KafkaPrincipal userPrincipal = ConnectSecurityFilter.kafkaPrincipalFor(requestContext.getSecurityContext().getUserPrincipal());
        PermissionsBuilder permissionsBuilder = new PermissionsBuilder().withScope(this.scope).withPrincipal(userPrincipal).withAuthorizer(this.restAuthorizer);
        this.clusterState.connectors().forEach(connector -> permissionsBuilder.withOperations(ConnectActions.CONNECTOR_RESOURCE, (String)connector, (Collection<Operation>)ConnectorOperations.ALL));
        return permissionsBuilder.build();
    }
}

