/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.metadata.CellRecord;
import org.apache.kafka.common.metadata.RemoveCellRecord;
import org.apache.kafka.image.CellImage;

public class CellDelta {
    private final Map<Integer, Cell> cellIdToCell;
    private byte cellMigrationState;

    public CellDelta(CellImage image) {
        this.cellIdToCell = new HashMap<Integer, Cell>(image.cellIdToCell());
        this.cellMigrationState = image.cellMigrationState();
    }

    public void replay(CellRecord record) {
        Cell cell = new Cell(record.cellId(), new HashSet<Integer>(record.brokers()), CellState.toEnum((byte)record.state()), record.minSize(), record.maxSize());
        this.cellIdToCell.put(record.cellId(), cell);
    }

    public void replay(RemoveCellRecord record) {
        this.cellIdToCell.remove(record.cellId());
    }

    public void replay(CellMigrationRecord record) {
        this.cellMigrationState = record.state();
    }

    public CellImage apply() {
        return new CellImage(this.cellIdToCell, this.cellMigrationState);
    }

    public void finishSnapshot() {
    }

    public String toString() {
        return "CellImage{latestCellIdToCell=" + this.cellIdToCell + "latestCellMigrationState=" + this.cellMigrationState + "}";
    }
}

