/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.image.node.ConfigurationImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationImage {
    private final Logger log = LoggerFactory.getLogger(ConfigurationImage.class);
    private final ConfigResource resource;
    private final Map<String, String> data;

    public ConfigurationImage(ConfigResource resource, Map<String, String> data) {
        this.resource = resource;
        this.data = data;
    }

    public ConfigResource resource() {
        return this.resource;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.data);
        return properties;
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public void write(ConfigResource configResource, ImageWriter writer, ImageWriterOptions options, MetadataEncryptor encryptor) {
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            ConfigRecord record = new ConfigRecord().setResourceType(configResource.type().id()).setResourceName(configResource.name()).setName(entry.getKey()).setValue(entry.getValue());
            if (options.configSchema().isSensitive(record)) {
                writer.writeEncrypted(0, record, encryptor);
            } else {
                writer.write(0, record);
            }
            this.maybeLogUnsupportedConfig(configResource, entry, options);
        }
    }

    private void maybeLogUnsupportedConfig(ConfigResource configResource, Map.Entry<String, String> config, ImageWriterOptions options) {
        if (config.getKey().equals("confluent.placement.constraints") && config.getValue() != null && !config.getValue().isEmpty() && !options.metadataVersion().isTopicPlacementSupported()) {
            this.log.warn("Configuration {} with value {} for topic {} is not supported at metadata version {}.", new Object[]{config.getKey(), config.getValue(), configResource.name(), options.metadataVersion()});
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfigurationImage)) {
            return false;
        }
        ConfigurationImage other = (ConfigurationImage)o;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return new ConfigurationImageNode(this).stringify();
    }
}

