/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.TopicImageNode;
import org.apache.kafka.server.immutable.ImmutableMap;

public class TopicsImageByLinkIdUuidNode
implements MetadataNode {
    private final TopicsImage image;
    private final ImmutableMap<Uuid, TopicImage> linkTopics;

    public TopicsImageByLinkIdUuidNode(TopicsImage image, ImmutableMap<Uuid, TopicImage> linkTopics) {
        this.image = image;
        this.linkTopics = linkTopics;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> children = new ArrayList<String>();
        this.linkTopics.keySet().forEach(topicId -> children.add(topicId.toString()));
        return children;
    }

    @Override
    public MetadataNode child(String name) {
        Uuid id;
        try {
            id = Uuid.fromString((String)name);
        }
        catch (Exception e) {
            return null;
        }
        TopicImage topicImage = (TopicImage)this.linkTopics.get((Object)id);
        if (topicImage == null) {
            return null;
        }
        return new TopicImageNode(topicImage);
    }
}

