/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataEncryptorConfigEntry {
    private final Logger log = LoggerFactory.getLogger(MetadataEncryptorConfigEntry.class);
    final Date created;
    final String className;
    final String bytes;

    @JsonCreator
    public MetadataEncryptorConfigEntry(@JsonProperty(value="created", required=true) Date created, @JsonProperty(value="class_name", required=true) String className, @JsonProperty(value="bytes", required=true) String bytes) {
        this.created = Objects.requireNonNull(created);
        this.className = MetadataEncryptorConfigEntry.ensureNonEmpty(className);
        this.bytes = MetadataEncryptorConfigEntry.ensureNonEmpty(bytes);
    }

    @JsonProperty(value="created")
    public Date getCreated() {
        return this.created;
    }

    @JsonProperty(value="class_name")
    public String getClassName() {
        return this.className;
    }

    @JsonProperty(value="bytes")
    public String getBytes() {
        return this.bytes;
    }

    @JsonAnySetter
    public void unknownField(String name, Object value) {
        this.log.warn("Encountered unknown field {}, ignoring", (Object)name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataEncryptorConfigEntry)) {
            return false;
        }
        MetadataEncryptorConfigEntry that = (MetadataEncryptorConfigEntry)o;
        return Objects.equals(this.created, that.created) && Objects.equals(this.className, that.className) && Objects.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.className, this.bytes);
    }

    private static String ensureNonEmpty(String value) {
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException("value cannot be null");
        }
        return value;
    }
}

