/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.common;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.coordinator.TrogdorMetrics;

public interface Platform {
    public String name();

    public Node curNode();

    public Topology topology();

    public Scheduler scheduler();

    public String runCommand(String[] var1) throws IOException;

    public static class MetricsContainer {
        private static TrogdorMetrics trogdorMetrics = null;

        public static TrogdorMetrics buildMetrics(Time time) {
            if (trogdorMetrics == null) {
                MetricConfig metricConfig = new MetricConfig();
                ArrayList<JmxReporter> reporters = new ArrayList<JmxReporter>();
                JmxReporter jmxReporter = new JmxReporter();
                reporters.add(jmxReporter);
                Metrics metrics = new Metrics(metricConfig, reporters, time);
                trogdorMetrics = new TrogdorMetrics(metrics, "trogdor");
            }
            return trogdorMetrics;
        }

        public static void close() {
            if (trogdorMetrics != null) {
                trogdorMetrics.close();
                trogdorMetrics = null;
            }
        }
    }

    public static class Config {
        public static final String TROGDOR_AGENT_PORT = "trogdor.agent.port";
        public static final String TROGDOR_COORDINATOR_PORT = "trogdor.coordinator.port";
        public static final String TROGDOR_COORDINATOR_HEARTBEAT_MS = "trogdor.coordinator.heartbeat.ms";
        public static final int TROGDOR_COORDINATOR_HEARTBEAT_MS_DEFAULT = 60000;

        public static Platform parse(String curNodeName, String path) throws Exception {
            JsonNode root = JsonUtil.JSON_SERDE.readTree(new File(path));
            JsonNode platformNode = root.get("platform");
            if (platformNode == null) {
                throw new RuntimeException("Expected to find a 'platform' field in the root JSON configuration object");
            }
            String platformName = platformNode.textValue();
            return (Platform)Utils.newParameterizedInstance((String)platformName, (Object[])new Object[]{String.class, curNodeName, Scheduler.class, Scheduler.SYSTEM, JsonNode.class, root});
        }
    }
}

