/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.ConsumerGroupsSpec;
import org.apache.kafka.trogdor.workload.PartitionsSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupsWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupsWorker.class);
    private static final String NAME = ConsumerGroupsWorker.class.getSimpleName();
    private static final ListConsumerGroupOffsetsSpec ALL_PARTITIONS = new ListConsumerGroupOffsetsSpec();
    private static final int THROTTLE_PERIOD_MS = 1000;
    private static final Time TIME = Time.SYSTEM;
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private final String id;
    private final ConsumerGroupsSpec spec;
    private final List<String> groupIds;
    private final HashSet<TopicPartition> partitions;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    private long totalCalls;
    private long startTimeMs;

    public ConsumerGroupsWorker(String id, ConsumerGroupsSpec spec) {
        this.id = id;
        this.spec = spec;
        String groupPrefix = NAME + spec.groupPrefix();
        this.groupIds = new ArrayList<String>(spec.noOfGroups());
        for (int i = 0; i < spec.noOfGroups(); ++i) {
            this.groupIds.add(groupPrefix + "-" + i);
        }
        this.partitions = new HashSet();
        spec.activeTopics().materialize().forEach((topic, partSpec) -> {
            for (Integer partitionNumber : partSpec.partitionNumbers()) {
                this.partitions.add(new TopicPartition(topic, partitionNumber.intValue()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ConsumerOffsetsSpec is already running.");
        }
        ConsumerGroupsWorker consumerGroupsWorker = this;
        synchronized (consumerGroupsWorker) {
            this.totalCalls = 0L;
            this.startTimeMs = TIME.milliseconds();
        }
        log.info("{}: Activating ConsumerOffsetsSpec.", (Object)this.id);
        try {
            this.status = status;
            this.doneFuture = doneFuture;
            this.validateConfigs();
            this.workerExecutor = Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory((String)(NAME + "%d"), (boolean)false));
            this.workerExecutor.submit(new Prepare());
            this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
            this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 30L, 10L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            WorkerUtils.abort(log, NAME, e, doneFuture);
        }
    }

    private void validateConfigs() {
        if (this.spec.targetOperationsPerSec() <= 0) {
            throw new ConfigException("Can't have targetOperationsPerSec <= 0.");
        }
    }

    private int runOperations(Admin admin, List<ConsumerGroupsSpec.ConsumerGroupOperation> operations, long index) throws ExecutionException, InterruptedException {
        block6: for (ConsumerGroupsSpec.ConsumerGroupOperation op : operations) {
            switch (op) {
                case LIST_GROUPS: {
                    this.listGroups(admin);
                    continue block6;
                }
                case DESCRIBE_GROUPS: {
                    this.describeGroups(admin);
                    continue block6;
                }
                case LIST_OFFSETS: {
                    this.listOffsets(admin);
                    continue block6;
                }
                case ALTER_OFFSETS: {
                    this.alterOffsets(admin, index);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unsupported operation " + (Object)((Object)op));
        }
        return 1;
    }

    private void listGroups(Admin admin) throws ExecutionException, InterruptedException {
        List groups = ((Collection)admin.listConsumerGroups().all().get()).stream().map(ConsumerGroupListing::groupId).filter(this.groupIds::contains).collect(Collectors.toList());
        if (groups.size() != this.groupIds.size()) {
            log.error("Some consumer groups are missing in listConsumerGroups response, expected {}, got {}", (Object)this.groupIds.size(), (Object)groups.size());
        }
    }

    private void describeGroups(Admin admin) throws ExecutionException, InterruptedException {
        Map groups = (Map)admin.describeConsumerGroups(this.groupIds).all().get();
        if (groups.size() != this.groupIds.size()) {
            log.error("Some consumer groups are missing in describeConsumerGroups response, expected {}, got {}", (Object)this.groupIds.size(), (Object)groups.size());
        }
    }

    private void listOffsets(Admin admin) throws ExecutionException, InterruptedException {
        Map offsetSpecs = this.groupIds.stream().collect(Collectors.toMap(Function.identity(), g -> ALL_PARTITIONS));
        Map offsets = (Map)admin.listConsumerGroupOffsets(offsetSpecs).all().get();
        if (offsets.size() != this.groupIds.size()) {
            log.error("Some consumer groups are missing in listConsumerGroupOffsets response, expected {}, got {}", (Object)this.groupIds.size(), (Object)offsets.size());
        } else {
            offsets.forEach((g, o) -> {
                if (o.size() != this.partitions.size()) {
                    log.debug("Offsets for some topic partitions of group {} are missing, expected {}, got {}", new Object[]{g, this.partitions.size(), o.size()});
                }
            });
        }
    }

    private void alterOffsets(Admin admin, long index) throws ExecutionException, InterruptedException {
        OffsetAndMetadata offset = new OffsetAndMetadata(index);
        Map offsets = this.partitions.stream().collect(Collectors.toMap(Function.identity(), unused -> offset));
        for (String group : this.groupIds) {
            admin.alterConsumerGroupOffsets(group, offsets).all().get();
        }
    }

    private Admin createAdmin() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("bootstrap.servers", this.spec.bootstrapServers());
        props.putAll(this.spec.commonClientConf());
        props.putAll(this.spec.adminClientConf());
        return Admin.create(props);
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException(NAME + " is not running.");
        }
        log.info("{}: Deactivating " + NAME, (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.statusUpdaterExecutor = null;
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.DAYS);
        new StatusUpdater().run();
        this.workerExecutor = null;
        this.doneFuture = null;
        long lastTimeMs = Time.SYSTEM.milliseconds();
        double callsPerSec = (double)this.totalCalls * 1000.0 / (double)(lastTimeMs - this.startTimeMs);
        log.info("Achieved CallsPerSec : {}", (Object)callsPerSec);
        log.info("{}: Deactivated " + NAME, (Object)this.id);
    }

    public static class StatusData {
        private final double callsPerSec;
        private final double totalCalls;

        @JsonCreator
        StatusData(@JsonProperty(value="totalCalls") double totalCalls, @JsonProperty(value="callsPerSec") double callsPerSec) {
            this.callsPerSec = callsPerSec;
            this.totalCalls = totalCalls;
        }

        @JsonProperty
        public double callsPerSec() {
            return this.callsPerSec;
        }

        @JsonProperty
        public double totalCalls() {
            return this.totalCalls;
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                long lastTimeMs = Time.SYSTEM.milliseconds();
                JsonNode node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(ConsumerGroupsWorker.this.totalCalls, (double)ConsumerGroupsWorker.this.totalCalls * 1000.0 / (double)(lastTimeMs - ConsumerGroupsWorker.this.startTimeMs)));
                ConsumerGroupsWorker.this.status.update(node);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)ConsumerGroupsWorker.this.doneFuture);
            }
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int perPeriod = WorkerUtils.perSecToPerPeriod(ConsumerGroupsWorker.this.spec.targetOperationsPerSec(), 1000L);
            Throttle throttle = new Throttle(perPeriod, 1000);
            Admin admin = null;
            try {
                admin = ConsumerGroupsWorker.this.createAdmin();
                while (!ConsumerGroupsWorker.this.doneFuture.isDone()) {
                    throttle.increment();
                    int noOfOps = ConsumerGroupsWorker.this.runOperations(admin, ConsumerGroupsWorker.this.spec.operations(), COUNTER.incrementAndGet());
                    ConsumerGroupsWorker consumerGroupsWorker = ConsumerGroupsWorker.this;
                    synchronized (consumerGroupsWorker) {
                        ConsumerGroupsWorker.this.totalCalls = ConsumerGroupsWorker.this.totalCalls + (long)noOfOps;
                    }
                }
                return;
            }
            catch (Throwable e) {
                Utils.closeQuietly((AutoCloseable)admin, (String)"Admin");
                WorkerUtils.abort(log, NAME + "#Worker", e, (KafkaFutureImpl<String>)ConsumerGroupsWorker.this.doneFuture);
            }
        }
    }

    class Prepare
    implements Runnable {
        Prepare() {
        }

        @Override
        public void run() {
            if (ConsumerGroupsWorker.this.spec.noOfGroups() <= 0) {
                ConsumerGroupsWorker.this.workerExecutor.submit(new Worker());
                return;
            }
            try {
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                HashSet<TopicPartition> active = new HashSet<TopicPartition>();
                for (Map.Entry<String, PartitionsSpec> entry : ConsumerGroupsWorker.this.spec.activeTopics().materialize().entrySet()) {
                    String topicName = entry.getKey();
                    PartitionsSpec partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        active.add(new TopicPartition(topicName, partitionNumber.intValue()));
                    }
                }
                if (!active.isEmpty()) {
                    ConsumerGroupsWorker.this.status.update((JsonNode)new TextNode("Creating " + newTopics.keySet().size() + " topic(s)"));
                    WorkerUtils.createTopics(log, ConsumerGroupsWorker.this.spec.bootstrapServers(), ConsumerGroupsWorker.this.spec.commonClientConf(), ConsumerGroupsWorker.this.spec.adminClientConf(), newTopics, false);
                    ConsumerGroupsWorker.this.status.update((JsonNode)new TextNode("Created " + newTopics.keySet().size() + " topic(s)"));
                    if (ConsumerGroupsWorker.this.spec.initializeGroupOffsets()) {
                        try (Admin admin = ConsumerGroupsWorker.this.createAdmin();){
                            ConsumerGroupsWorker.this.alterOffsets(admin, 0L);
                        }
                        ConsumerGroupsWorker.this.status.update((JsonNode)new TextNode("Initialized offsets for " + ConsumerGroupsWorker.this.groupIds.size() + " group(s) with " + ConsumerGroupsWorker.this.partitions.size() + " partitions each."));
                    }
                }
                ConsumerGroupsWorker.this.workerExecutor.submit(new Worker());
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, (KafkaFutureImpl<String>)ConsumerGroupsWorker.this.doneFuture);
            }
        }
    }
}

