/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.awskms;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.google.auto.service.AutoService;
import com.google.common.base.Splitter;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.integration.awskms.AwsKmsAead;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoService(value={KmsClient.class})
public final class AwsKmsClient
implements KmsClient {
    public static final String PREFIX = "aws-kms://";
    @Nullable
    private AWSKMS awsKms;
    @Nullable
    private String keyUri;
    @Nullable
    private AWSCredentialsProvider provider;

    public AwsKmsClient() {
    }

    public AwsKmsClient(String uri) {
        if (!uri.toLowerCase(Locale.US).startsWith(PREFIX)) {
            throw new IllegalArgumentException("key URI must starts with aws-kms://");
        }
        this.keyUri = uri;
    }

    public boolean doesSupport(String uri) {
        if (this.keyUri != null && this.keyUri.equals(uri)) {
            return true;
        }
        return this.keyUri == null && uri.toLowerCase(Locale.US).startsWith(PREFIX);
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentials(String credentialPath) throws GeneralSecurityException {
        try {
            if (credentialPath == null) {
                return this.withDefaultCredentials();
            }
            return this.withCredentialsProvider((AWSCredentialsProvider)new PropertiesFileCredentialsProvider(credentialPath));
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    @CanIgnoreReturnValue
    public KmsClient withDefaultCredentials() throws GeneralSecurityException {
        try {
            return this.withCredentialsProvider((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load default credentials", e);
        }
    }

    @CanIgnoreReturnValue
    public KmsClient withCredentialsProvider(AWSCredentialsProvider provider) throws GeneralSecurityException {
        this.provider = provider;
        return this;
    }

    @CanIgnoreReturnValue
    KmsClient withAwsKms(@Nullable AWSKMS awsKms) {
        this.awsKms = awsKms;
        return this;
    }

    private static String removePrefix(String expectedPrefix, String kmsKeyUri) {
        if (!kmsKeyUri.toLowerCase(Locale.US).startsWith(expectedPrefix)) {
            throw new IllegalArgumentException(String.format("key URI must start with %s", expectedPrefix));
        }
        return kmsKeyUri.substring(expectedPrefix.length());
    }

    public Aead getAead(String uri) throws GeneralSecurityException {
        if (this.keyUri != null && !this.keyUri.equals(uri)) {
            throw new GeneralSecurityException(String.format("this client is bound to %s, cannot load keys bound to %s", this.keyUri, uri));
        }
        try {
            String keyId = AwsKmsClient.removePrefix(PREFIX, uri);
            AWSKMS client = this.awsKms;
            List tokens = Splitter.on((char)':').splitToList((CharSequence)keyId);
            if (tokens.size() < 4) {
                throw new IllegalArgumentException("invalid key URI");
            }
            String regionName = (String)tokens.get(3);
            if (client == null) {
                client = (AWSKMS)((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials(this.provider)).withRegion(Regions.fromName((String)regionName))).build();
            }
            return new AwsKmsAead(client, keyId);
        }
        catch (AmazonServiceException e) {
            throw new GeneralSecurityException("cannot load credentials from provider", e);
        }
    }

    @Deprecated
    public static void register(Optional<String> keyUri, Optional<String> credentialPath) throws GeneralSecurityException {
        AwsKmsClient.registerWithAwsKms(keyUri, credentialPath, null);
    }

    static void registerWithAwsKms(Optional<String> keyUri, Optional<String> credentialPath, @Nullable AWSKMS awsKms) throws GeneralSecurityException {
        AwsKmsClient client = keyUri.isPresent() ? new AwsKmsClient(keyUri.get()) : new AwsKmsClient();
        if (credentialPath.isPresent()) {
            client.withCredentials(credentialPath.get());
        } else {
            client.withDefaultCredentials();
        }
        client.withAwsKms(awsKms);
        KmsClients.add((KmsClient)client);
    }
}

