/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.EndpointContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.ApiCallContextOptions;
import com.google.api.gax.rpc.internal.Headers;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.auth.Credentials;
import com.google.auth.Retryable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
public final class GrpcCallContext
implements ApiCallContext {
    private static final GrpcStatusCode UNAUTHENTICATED_STATUS_CODE = GrpcStatusCode.of(Status.Code.UNAUTHENTICATED);
    public static final CallOptions.Key<ApiTracer> TRACER_KEY = CallOptions.Key.create((String)"gax.tracer");
    private final Channel channel;
    @Nullable
    private final Credentials credentials;
    private final CallOptions callOptions;
    @Nullable
    private final Duration timeout;
    @Nullable
    private final Duration streamWaitTimeout;
    @Nullable
    private final Duration streamIdleTimeout;
    @Nullable
    private final Integer channelAffinity;
    @Nullable
    private final RetrySettings retrySettings;
    @Nullable
    private final ImmutableSet<StatusCode.Code> retryableCodes;
    private final ImmutableMap<String, List<String>> extraHeaders;
    private final ApiCallContextOptions options;
    private final EndpointContext endpointContext;

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, null, CallOptions.DEFAULT, null, null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, null, callOptions, null, null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of(), ApiCallContextOptions.getDefaultOptions(), null, null, null);
    }

    private GrpcCallContext(Channel channel, @Nullable Credentials credentials, CallOptions callOptions, @Nullable Duration timeout, @Nullable Duration streamWaitTimeout, @Nullable Duration streamIdleTimeout, @Nullable Integer channelAffinity, ImmutableMap<String, List<String>> extraHeaders, ApiCallContextOptions options, @Nullable RetrySettings retrySettings, @Nullable Set<StatusCode.Code> retryableCodes, EndpointContext endpointContext) {
        this.channel = channel;
        this.credentials = credentials;
        this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions);
        this.timeout = timeout;
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.channelAffinity = channelAffinity;
        this.extraHeaders = (ImmutableMap)Preconditions.checkNotNull(extraHeaders);
        this.options = (ApiCallContextOptions)Preconditions.checkNotNull((Object)options);
        this.retrySettings = retrySettings;
        this.retryableCodes = retryableCodes == null ? null : ImmutableSet.copyOf(retryableCodes);
        this.endpointContext = endpointContext;
    }

    public GrpcCallContext nullToSelf(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = this;
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    public GrpcCallContext withCredentials(Credentials newCredentials) {
        Preconditions.checkNotNull((Object)newCredentials);
        CallCredentials callCredentials = MoreCallCredentials.from((Credentials)newCredentials);
        return new GrpcCallContext(this.channel, newCredentials, this.callOptions.withCallCredentials(callCredentials), this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public GrpcCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof GrpcTransportChannel)) {
            throw new IllegalArgumentException("Expected GrpcTransportChannel, got " + inputChannel.getClass().getName());
        }
        GrpcTransportChannel transportChannel = (GrpcTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public GrpcCallContext withEndpointContext(EndpointContext endpointContext) {
        Preconditions.checkNotNull((Object)endpointContext);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, endpointContext);
    }

    public GrpcCallContext withTimeout(@Nullable Duration timeout) {
        if (timeout != null && (timeout.isZero() || timeout.isNegative())) {
            timeout = null;
        }
        if (timeout != null && this.timeout != null && this.timeout.compareTo(timeout) <= 0) {
            return this;
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public GrpcCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument((streamWaitTimeout.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public GrpcCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument((streamIdleTimeout.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    @BetaApi(value="The surface for channel affinity is not stable yet and may change in the future.")
    public GrpcCallContext withChannelAffinity(@Nullable Integer affinity) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, affinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public GrpcCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, (ImmutableMap<String, List<String>>)newExtraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public GrpcCallContext withRetrySettings(RetrySettings retrySettings) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    public GrpcCallContext withRetryableCodes(Set<StatusCode.Code> retryableCodes) {
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, retryableCodes, this.endpointContext);
    }

    public ApiCallContext merge(ApiCallContext inputCallContext) {
        ImmutableSet<StatusCode.Code> newRetryableCodes;
        RetrySettings newRetrySettings;
        Integer newChannelAffinity;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        Duration newTimeout;
        ApiTracer newTracer;
        CallCredentials newCallCredentials;
        Deadline newDeadline;
        Channel newChannel;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        GrpcCallContext grpcCallContext = (GrpcCallContext)inputCallContext;
        Credentials newCredentials = grpcCallContext.credentials;
        if (newCredentials == null) {
            newCredentials = this.credentials;
        }
        if ((newChannel = grpcCallContext.channel) == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = grpcCallContext.callOptions.getDeadline()) == null) {
            newDeadline = this.callOptions.getDeadline();
        }
        if ((newCallCredentials = grpcCallContext.callOptions.getCredentials()) == null) {
            newCallCredentials = this.callOptions.getCredentials();
        }
        if ((newTracer = (ApiTracer)grpcCallContext.callOptions.getOption(TRACER_KEY)) == null) {
            newTracer = (ApiTracer)this.callOptions.getOption(TRACER_KEY);
        }
        if ((newTimeout = grpcCallContext.timeout) == null) {
            newTimeout = this.timeout;
        }
        if ((newStreamWaitTimeout = grpcCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = grpcCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newChannelAffinity = grpcCallContext.channelAffinity) == null) {
            newChannelAffinity = this.channelAffinity;
        }
        if ((newRetrySettings = grpcCallContext.retrySettings) == null) {
            newRetrySettings = this.retrySettings;
        }
        if ((newRetryableCodes = grpcCallContext.retryableCodes) == null) {
            newRetryableCodes = this.retryableCodes;
        }
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, grpcCallContext.extraHeaders);
        ApiCallContextOptions newOptions = this.options.merge(grpcCallContext.options);
        CallOptions newCallOptions = grpcCallContext.callOptions.withCallCredentials(newCallCredentials).withDeadline(newDeadline);
        if (newTracer != null) {
            newCallOptions = newCallOptions.withOption(TRACER_KEY, (Object)newTracer);
        }
        return new GrpcCallContext(newChannel, newCredentials, newCallOptions, newTimeout, newStreamWaitTimeout, newStreamIdleTimeout, newChannelAffinity, (ImmutableMap<String, List<String>>)newExtraHeaders, newOptions, newRetrySettings, (Set<StatusCode.Code>)newRetryableCodes, this.endpointContext);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    @Nullable
    public Integer getChannelAffinity() {
        return this.channelAffinity;
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    public GrpcCallContext withChannel(Channel newChannel) {
        return new GrpcCallContext(newChannel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public GrpcCallContext withCallOptions(CallOptions newCallOptions) {
        return new GrpcCallContext(this.channel, this.credentials, newCallOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public GrpcCallContext withRequestParamsDynamicHeaderOption(String requestParams) {
        CallOptions newCallOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(this.callOptions, requestParams);
        return this.withCallOptions(newCallOptions);
    }

    @Nonnull
    public ApiTracer getTracer() {
        ApiTracer tracer = (ApiTracer)this.callOptions.getOption(TRACER_KEY);
        if (tracer == null) {
            tracer = BaseApiTracer.getInstance();
        }
        return tracer;
    }

    public GrpcCallContext withTracer(@Nonnull ApiTracer tracer) {
        Preconditions.checkNotNull((Object)tracer);
        return this.withCallOptions(this.callOptions.withOption(TRACER_KEY, (Object)tracer));
    }

    public <T> GrpcCallContext withOption(ApiCallContext.Key<T> key, T value) {
        ApiCallContextOptions newOptions = this.options.withOption(key, value);
        return new GrpcCallContext(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, newOptions, this.retrySettings, (Set<StatusCode.Code>)this.retryableCodes, this.endpointContext);
    }

    public <T> T getOption(ApiCallContext.Key<T> key) {
        return (T)this.options.getOption(key);
    }

    @InternalApi
    public void validateUniverseDomain() {
        try {
            this.endpointContext.validateUniverseDomain(this.credentials, (StatusCode)UNAUTHENTICATED_STATUS_CODE);
        }
        catch (IOException e) {
            if (e instanceof Retryable) {
                Retryable retryable = (Retryable)e;
                throw ApiExceptionFactory.createException((String)"Unable to retrieve the Universe Domain from the Credentials.", (Throwable)e, (StatusCode)GrpcStatusCode.of(Status.Code.UNAVAILABLE), (boolean)retryable.isRetryable());
            }
            throw ApiExceptionFactory.createException((String)"Unable to retrieve the Universe Domain from the Credentials.", (Throwable)e, (StatusCode)UNAUTHENTICATED_STATUS_CODE, (boolean)false);
        }
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.credentials, this.callOptions, this.timeout, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity, this.extraHeaders, this.options, this.retrySettings, this.retryableCodes, this.endpointContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.streamWaitTimeout, that.streamWaitTimeout) && Objects.equals(this.streamIdleTimeout, that.streamIdleTimeout) && Objects.equals(this.channelAffinity, that.channelAffinity) && Objects.equals(this.extraHeaders, that.extraHeaders) && Objects.equals(this.options, that.options) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.retryableCodes, that.retryableCodes) && Objects.equals(this.endpointContext, that.endpointContext);
    }

    Metadata getMetadata() {
        Metadata metadata = new Metadata();
        for (Map.Entry header : this.extraHeaders.entrySet()) {
            String headerKey = (String)header.getKey();
            for (String headerValue : (List)header.getValue()) {
                metadata.put(Metadata.Key.of((String)headerKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)headerValue);
            }
        }
        return metadata;
    }
}

