/*
 * Decompiled with CFR 0.152.
 */
package kafka.availability;

import io.confluent.kafka.availability.NetworkAvailabilityManager;
import kafka.availability.NetworkHealthManager;
import kafka.availability.NetworkHealthManagerConfig;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.NodeToControllerChannelManagerImpl;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;

public final class NetworkHealthManager$ {
    public static final NetworkHealthManager$ MODULE$ = new NetworkHealthManager$();
    private static final String HealthyNetworkCountMetricName = "HealthyNetworkCount";
    private static final String IncomingTrafficMetricName = "NetworkHealthManagerIncomingTrafficPerSample";
    private static final String AutomaticDemotionStatusMetricName = "NetworkHealthManagerAutomaticDemotionStatus";
    private static final String NetworkHealthStatusMetricName = "NetworkHealthManagerNetworkHealthStatus";
    private static final String NetworkHealthStatusWithImpactStatusName = "LeadershipNetworkHealthStatus";
    private static final String HealthCheckTrafficMetricName = "HealthCheckRequestsCount";
    private static final String ExternalClientTrafficMetricName = "ExternalClientRequestsCount";
    private static final Set<String> ReconfigurableConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.NetworkHealthManagerMitigationEnabledProp(), KafkaConfig$.MODULE$.NetworkHealthManagerSampleDurationMsProp(), KafkaConfig$.MODULE$.NetworkHealthManagerNetworkSampleWindowSizeProp(), KafkaConfig$.MODULE$.NetworkHealthManagerMinHealthyNetworkSamplesProp(), KafkaConfig$.MODULE$.NetworkHealthManagerMinPercentageHealthyNetworkSamplesProp(), KafkaConfig$.MODULE$.AutomaticAlterBrokerHealthRetryBackoffMsProp()}));

    public NetworkHealthManager apply(KafkaConfig config, ControllerNodeProvider controllerNodeProvider, Scheduler scheduler, Time time, Metrics metrics, String threadNamePrefix, NetworkAvailabilityManager networkAvailabilityManager, ReplicaManager replicaManager) {
        NodeToControllerChannelManagerImpl brokerToControllerChannelManagerForHealthManager = new NodeToControllerChannelManagerImpl(controllerNodeProvider, time, metrics, config, "health-manager", threadNamePrefix, config.requestTimeoutMs().longValue());
        return new NetworkHealthManager(brokerToControllerChannelManagerForHealthManager, new NetworkHealthManagerConfig(config), networkAvailabilityManager, scheduler, replicaManager);
    }

    public String HealthyNetworkCountMetricName() {
        return HealthyNetworkCountMetricName;
    }

    public String IncomingTrafficMetricName() {
        return IncomingTrafficMetricName;
    }

    public String AutomaticDemotionStatusMetricName() {
        return AutomaticDemotionStatusMetricName;
    }

    public String NetworkHealthStatusMetricName() {
        return NetworkHealthStatusMetricName;
    }

    public String NetworkHealthStatusWithImpactStatusName() {
        return NetworkHealthStatusWithImpactStatusName;
    }

    public String HealthCheckTrafficMetricName() {
        return HealthCheckTrafficMetricName;
    }

    public String ExternalClientTrafficMetricName() {
        return ExternalClientTrafficMetricName;
    }

    public Set<String> ReconfigurableConfigs() {
        return ReconfigurableConfigs;
    }

    private NetworkHealthManager$() {
    }
}

