/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011mt!\u00020`\u0011\u0003!g!\u00024`\u0011\u00039\u0007\"\u0002<\u0002\t\u00039h!\u0002=\u0002\u0001\u0006L\bBCA\u001e\u0007\tU\r\u0011\"\u0001\u0002>!Q\u00111J\u0002\u0003\u0012\u0003\u0006I!a\u0010\t\u0015\u000553A!f\u0001\n\u0003\ty\u0005\u0003\u0006\u0002X\r\u0011\t\u0012)A\u0005\u0003#B!\"!\u0017\u0004\u0005+\u0007I\u0011AA.\u0011)\tyg\u0001B\tB\u0003%\u0011Q\f\u0005\u000b\u0003c\u001a!Q3A\u0005\u0002\u0005M\u0004BCA;\u0007\tE\t\u0015!\u0003\u0002j!Q\u0011qO\u0002\u0003\u0016\u0004%\t!!\u001f\t\u0015\u0005E5A!E!\u0002\u0013\tY\b\u0003\u0006\u0002\u0014\u000e\u0011)\u001a!C!\u0003+C!\"!,\u0004\u0005#\u0005\u000b\u0011BAL\u0011)\tyk\u0001BK\u0002\u0013\u0005\u0013\u0011\u0017\u0005\u000b\u0003\u007f\u001b!\u0011#Q\u0001\n\u0005M\u0006BCAa\u0007\tU\r\u0011\"\u0011\u0002D\"Q\u0011qZ\u0002\u0003\u0012\u0003\u0006I!!2\t\u0015\u0005E7A!f\u0001\n\u0003\n\u0019\u000e\u0003\u0006\u0002f\u000e\u0011\t\u0012)A\u0005\u0003+DaA^\u0002\u0005\u0002\u0005U\b\"\u0003B\u000b\u0007\u0005\u0005I\u0011\u0001B\f\u0011%\u0011YcAI\u0001\n\u0003\u0011i\u0003C\u0005\u0003D\r\t\n\u0011\"\u0001\u0003F!I!\u0011J\u0002\u0012\u0002\u0013\u0005!1\n\u0005\n\u0005\u001f\u001a\u0011\u0013!C\u0001\u0005#B\u0011B!\u0016\u0004#\u0003%\tAa\u0016\t\u0013\tm3!%A\u0005\u0002\tu\u0003\"\u0003B1\u0007E\u0005I\u0011\u0001B2\u0011%\u00119gAI\u0001\n\u0003\u0011I\u0007C\u0005\u0003n\r\t\n\u0011\"\u0001\u0003p!I!qP\u0002\u0002\u0002\u0013\u0005#\u0011\u0011\u0005\n\u0005\u0007\u001b\u0011\u0011!C\u0001\u0003\u001fB\u0011B!\"\u0004\u0003\u0003%\tAa\"\t\u0013\t55!!A\u0005B\t=\u0005\"\u0003BO\u0007\u0005\u0005I\u0011\u0001BP\u0011%\u0011IkAA\u0001\n\u0003\u0012Y\u000bC\u0005\u00030\u000e\t\t\u0011\"\u0011\u00032\"I!1W\u0002\u0002\u0002\u0013\u0005#Q\u0017\u0005\n\u0005o\u001b\u0011\u0011!C!\u0005s;!B!0\u0002\u0003\u0003E\t!\u0019B`\r%A\u0018!!A\t\u0002\u0005\u0014\t\r\u0003\u0004wW\u0011\u0005!q\u001b\u0005\n\u0005g[\u0013\u0011!C#\u0005kC\u0011B!7,\u0003\u0003%\tIa7\t\u0013\t]8&!A\u0005\u0002\ne\b\"CB\nW\u0005\u0005I\u0011BB\u000b\u0011\u001d\u0011I.\u0001C\u0001\u0007/AqA!7\u0002\t\u0003!Y\u0003C\u0004\u0003Z\u0006!\t\u0001\"\u000e\t\u000f\u0011}\u0012\u0001\"\u0003\u0005B!9AQK\u0001\u0005\u0002\u0011]\u0003\"\u0003Bm\u0003\u0005\u0005I\u0011\u0011C2\u0011%\u001190AA\u0001\n\u0003#y\u0007C\u0005\u0004\u0014\u0005\t\t\u0011\"\u0003\u0004\u0016\u0019)am\u0018!\u0004\u001c!Q1QD\u001d\u0003\u0016\u0004%\t!a\u0014\t\u0015\r}\u0011H!E!\u0002\u0013\t\t\u0006\u0003\u0006\u0004\"e\u0012)\u001a!C\u0001\u0007GA!b!\r:\u0005#\u0005\u000b\u0011BB\u0013\u0011)\u0019\u0019$\u000fBK\u0002\u0013\u00051Q\u0007\u0005\u000b\u0007sI$\u0011#Q\u0001\n\r]\u0002BCB\u001es\tU\r\u0011\"\u0001\u0004>!Q1\u0011K\u001d\u0003\u0012\u0003\u0006Iaa\u0010\t\u0015\rM\u0013H!f\u0001\n\u0003\u0019)\u0006\u0003\u0006\u0004\\e\u0012\t\u0012)A\u0005\u0007/BaA^\u001d\u0005\u0002\ru\u0003\"CB5s\t\u0007I\u0011BB6\u0011!\u0019\u0019)\u000fQ\u0001\n\r5\u0004b\u0002BZs\u0011\u00053Q\u0011\u0005\u0007mf\"\taa\"\t\rYLD\u0011ABV\u0011\u001d\u0019Y,\u000fC\u0001\u0007{Cqaa2:\t\u0003\u0019I\rC\u0004\u0004Pf\"\ta!5\t\u000f\rU\u0017\b\"\u0001\u0004X\"911\\\u001d\u0005\u0002\ru\u0007\"CB|sE\u0005I\u0011\u0001B2\u0011%\u0011)\"OA\u0001\n\u0003\u0019I\u0010C\u0005\u0003,e\n\n\u0011\"\u0001\u0003F!I!1I\u001d\u0012\u0002\u0013\u0005AQ\u0001\u0005\n\u0005\u0013J\u0014\u0013!C\u0001\t\u0013A\u0011Ba\u0014:#\u0003%\t\u0001\"\u0004\t\u0013\tU\u0013(%A\u0005\u0002\u0011E\u0001\"\u0003B@s\u0005\u0005I\u0011\tBA\u0011%\u0011\u0019)OA\u0001\n\u0003\ty\u0005C\u0005\u0003\u0006f\n\t\u0011\"\u0001\u0005\u0016!I!QR\u001d\u0002\u0002\u0013\u0005#q\u0012\u0005\n\u0005;K\u0014\u0011!C\u0001\t3A\u0011B!+:\u0003\u0003%\t\u0005\"\b\t\u0013\t=\u0016(!A\u0005B\tE\u0006\"\u0003B\\s\u0005\u0005I\u0011\tC\u0011\u0003\u0019\u0011%o\\6fe*\u0011\u0001-Y\u0001\bG2,8\u000f^3s\u0015\u0005\u0011\u0017!B6bM.\f7\u0001\u0001\t\u0003K\u0006i\u0011a\u0018\u0002\u0007\u0005J|7.\u001a:\u0014\u0007\u0005Ag\u000e\u0005\u0002jY6\t!NC\u0001l\u0003\u0015\u00198-\u00197b\u0013\ti'N\u0001\u0004B]f\u0014VM\u001a\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f!![8\u000b\u0003M\fAA[1wC&\u0011Q\u000f\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0014!bU3sm\u0016\u0014\u0018J\u001c4p'!\u0019!0!\u0001\u0002 \u0005\u0015\u0002CA>\u007f\u001b\u0005a(BA?s\u0003\u0011a\u0017M\\4\n\u0005}d(AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u0004\u0005mQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BA\u0006\u0003\u001b\t!\"Y;uQ>\u0014\u0018N_3s\u0015\u0011\ty!!\u0005\u0002\rM,'O^3s\u0015\r\u0011\u00171\u0003\u0006\u0005\u0003+\t9\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00033\t1a\u001c:h\u0013\u0011\ti\"!\u0002\u0003;\r{gN\u001a7vK:$\u0018)\u001e;i_JL'0\u001a:TKJ4XM]%oM>\u00042![A\u0011\u0013\r\t\u0019C\u001b\u0002\b!J|G-^2u!\u0011\t9#a\u000e\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF2\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0017bAA\u001bU\u00069\u0001/Y2lC\u001e,\u0017bA;\u0002:)\u0019\u0011Q\u00076\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016,\"!a\u0010\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u0002\u0012\u000511m\\7n_:LA!!\u0013\u0002D\ty1\t\\;ti\u0016\u0014(+Z:pkJ\u001cW-\u0001\tdYV\u001cH/\u001a:SKN|WO]2fA\u0005A!M]8lKJLE-\u0006\u0002\u0002RA\u0019\u0011.a\u0015\n\u0007\u0005U#NA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0013\u0015tG\r]8j]R\u001cXCAA/!\u0019\ty&!\u001a\u0002j5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0012\u0018\u0001B;uS2LA!a\u001a\u0002b\t!A*[:u!\u0011\t\t%a\u001b\n\t\u00055\u00141\t\u0002\t\u000b:$\u0007o\\5oi\u0006QQM\u001c3q_&tGo\u001d\u0011\u0002'%tG/\u001a:Ce>\\WM]#oIB|\u0017N\u001c;\u0016\u0005\u0005%\u0014\u0001F5oi\u0016\u0014(I]8lKJ,e\u000e\u001a9pS:$\b%A\nfCJd\u0017p\u0015;beRd\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u0002|A1\u0011qLA?\u0003\u0003KA!a \u0002b\t\u00191+\u001a;\u0011\t\u0005\r\u00151\u0012\b\u0005\u0003\u000b\u000b9\tE\u0002\u0002,)L1!!#k\u0003\u0019\u0001&/\u001a3fM&!\u0011QRAH\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u00126\u0002)\u0015\f'\u000f\\=Ti\u0006\u0014H\u000fT5ti\u0016tWM]:!\u0003AAG\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/\u0006\u0002\u0002\u0018B!\u0011\u0011TAU\u001b\t\tYJ\u0003\u0003\u0002\u0010\u0005u%\u0002BAP\u0003C\u000bA\u0001\u001b;ua*\u0019!-a)\u000b\t\u0005\u0015\u0016qU\u0001\nG>tg\r\\;f]RT\u0011!]\u0005\u0005\u0003W\u000bYJA\u000bLC\u001a\\\u0017\r\u0013;uaN+'O^3s\u0005&tG-\u001a:\u0002#!$H\u000f]*feZ,'OQ5oI\u0016\u0014\b%\u0001\tbk\u0012LG\u000fT8h!J|g/\u001b3feV\u0011\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*!\u0011\u0011XA\u0007\u0003\u0015\tW\u000fZ5u\u0013\u0011\ti,a.\u0003!\u0005+H-\u001b;M_\u001e\u0004&o\u001c<jI\u0016\u0014\u0018!E1vI&$Hj\\4Qe>4\u0018\u000eZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAAc!\u0011\t9-a3\u000e\u0005\u0005%'\u0002BAa\u0003\u0007JA!!4\u0002J\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002/%tG/\u001a:Ce>\\WM]\"mS\u0016tGoQ8oM&<WCAAka\u0011\t9.!9\u0011\u0011\u0005}\u0013\u0011\\AA\u0003;LA!a7\u0002b\t\u0019Q*\u00199\u0011\t\u0005}\u0017\u0011\u001d\u0007\u0001\t-\t\u0019/FA\u0001\u0002\u0003\u0015\t!a:\u0003\u0007}#\u0013'\u0001\rj]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001cuN\u001c4jO\u0002\nB!!;\u0002pB\u0019\u0011.a;\n\u0007\u00055(NA\u0004O_RD\u0017N\\4\u0011\u0007%\f\t0C\u0002\u0002t*\u00141!\u00118z)Q\t90a?\u0002~\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\u0003\fA\u0019\u0011\u0011`\u0002\u000e\u0003\u0005Aq!a\u000f\u0017\u0001\u0004\ty\u0004C\u0004\u0002NY\u0001\r!!\u0015\t\u000f\u0005ec\u00031\u0001\u0002^!9\u0011\u0011\u000f\fA\u0002\u0005%\u0004bBA<-\u0001\u0007\u00111\u0010\u0005\b\u0003'3\u0002\u0019AAL\u0011\u001d\tyK\u0006a\u0001\u0003gCq!!1\u0017\u0001\u0004\t)\rC\u0004\u0002RZ\u0001\rA!\u00041\t\t=!1\u0003\t\t\u0003?\nI.!!\u0003\u0012A!\u0011q\u001cB\n\t1\t\u0019Oa\u0003\u0002\u0002\u0003\u0005)\u0011AAt\u0003\u0011\u0019w\u000e]=\u0015)\u0005](\u0011\u0004B\u000e\u0005;\u0011yB!\t\u0003$\t\u0015\"q\u0005B\u0015\u0011%\tYd\u0006I\u0001\u0002\u0004\ty\u0004C\u0005\u0002N]\u0001\n\u00111\u0001\u0002R!I\u0011\u0011L\f\u0011\u0002\u0003\u0007\u0011Q\f\u0005\n\u0003c:\u0002\u0013!a\u0001\u0003SB\u0011\"a\u001e\u0018!\u0003\u0005\r!a\u001f\t\u0013\u0005Mu\u0003%AA\u0002\u0005]\u0005\"CAX/A\u0005\t\u0019AAZ\u0011%\t\tm\u0006I\u0001\u0002\u0004\t)\rC\u0005\u0002R^\u0001\n\u00111\u0001\u0003\u000e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0018U\u0011\tyD!\r,\u0005\tM\u0002\u0003\u0002B\u001b\u0005\u007fi!Aa\u000e\u000b\t\te\"1H\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0010k\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u00129DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003H)\"\u0011\u0011\u000bB\u0019\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0014+\t\u0005u#\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019F\u000b\u0003\u0002j\tE\u0012AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u00053RC!a\u001f\u00032\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B0U\u0011\t9J!\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\r\u0016\u0005\u0003g\u0013\t$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\t-$\u0006BAc\u0005c\tabY8qs\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003rA\"!1\u000fB?U\u0011\u0011)H!\r\u0011\u0011\u0005}\u0013\u0011\u001cB<\u0005w\u00022a\u001fB=\u0013\r\ti\t \t\u0005\u0003?\u0014i\bB\u0006\u0002d\u0002\n\t\u0011!A\u0003\u0002\u0005\u001d\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003x\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAx\u0005\u0013C\u0011Ba#$\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\n\u0005\u0004\u0003\u0014\ne\u0015q^\u0007\u0003\u0005+S1Aa&k\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00057\u0013)J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BQ\u0005O\u00032!\u001bBR\u0013\r\u0011)K\u001b\u0002\b\u0005>|G.Z1o\u0011%\u0011Y)JA\u0001\u0002\u0004\ty/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B<\u0005[C\u0011Ba#'\u0003\u0003\u0005\r!!\u0015\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0015\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u001e\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tKa/\t\u0013\t-\u0015&!AA\u0002\u0005=\u0018AC*feZ,'/\u00138g_B\u0019\u0011\u0011`\u0016\u0014\t-\u0012\u0019M\u001c\t\u0019\u0005\u000b\u0014Y-a\u0010\u0002R\u0005u\u0013\u0011NA>\u0003/\u000b\u0019,!2\u0003P\u0006]XB\u0001Bd\u0015\r\u0011IM[\u0001\beVtG/[7f\u0013\u0011\u0011iMa2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\b\r\u0003\u0003R\nU\u0007\u0003CA0\u00033\f\tIa5\u0011\t\u0005}'Q\u001b\u0003\f\u0003G\\\u0013\u0011!A\u0001\u0006\u0003\t9\u000f\u0006\u0002\u0003@\u0006)\u0011\r\u001d9msR!\u0012q\u001fBo\u0005?\u0014\tOa9\u0003f\n\u001d(\u0011\u001eBv\u0005[Dq!a\u000f/\u0001\u0004\ty\u0004C\u0004\u0002N9\u0002\r!!\u0015\t\u000f\u0005ec\u00061\u0001\u0002^!9\u0011\u0011\u000f\u0018A\u0002\u0005%\u0004bBA<]\u0001\u0007\u00111\u0010\u0005\b\u0003's\u0003\u0019AAL\u0011\u001d\tyK\fa\u0001\u0003gCq!!1/\u0001\u0004\t)\rC\u0004\u0002R:\u0002\rAa<1\t\tE(Q\u001f\t\t\u0003?\nI.!!\u0003tB!\u0011q\u001cB{\t1\t\u0019O!<\u0002\u0002\u0003\u0005)\u0011AAt\u0003\u001d)h.\u00199qYf$BAa?\u0004\u0010A)\u0011N!@\u0004\u0002%\u0019!q 6\u0003\r=\u0003H/[8o!UI71AA \u0003#\ni&!\u001b\u0002|\u0005]\u00151WAc\u0007\u000fI1a!\u0002k\u0005\u0019!V\u000f\u001d7fsA\"1\u0011BB\u0007!!\ty&!7\u0002\u0002\u000e-\u0001\u0003BAp\u0007\u001b!1\"a90\u0003\u0003\u0005\tQ!\u0001\u0002h\"I1\u0011C\u0018\u0002\u0002\u0003\u0007\u0011q_\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#\u0001>\u0015\u0011\reAQ\u0005C\u0014\tS\u0001\"!Z\u001d\u0014\reB\u0017qDA\u0013\u0003\tIG-A\u0002jI\u0002\n\u0011\"\u001a8e!>Lg\u000e^:\u0016\u0005\r\u0015\u0002C\u0002BJ\u0007O\u0019Y#\u0003\u0003\u0004*\tU%aA*fcB\u0019Qm!\f\n\u0007\r=rL\u0001\u0005F]\u0012\u0004v.\u001b8u\u0003))g\u000e\u001a)pS:$8\u000fI\u0001\u0005e\u0006\u001c7.\u0006\u0002\u00048A)\u0011N!@\u0002\u0002\u0006)!/Y2lA\u0005Aa-Z1ukJ,7/\u0006\u0002\u0004@A11\u0011IB$\u0007\u0017j!aa\u0011\u000b\t\r\u0015\u00131I\u0001\bM\u0016\fG/\u001e:f\u0013\u0011\u0019Iea\u0011\u0003\u0011\u0019+\u0017\r^;sKN\u0004Ba!\u0011\u0004N%!1qJB\"\u0005U\u0019V\u000f\u001d9peR,GMV3sg&|gNU1oO\u0016\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002\tQ\fwm]\u000b\u0003\u0007/\u0002\u0002\"a!\u0004Z\u0005\u0005\u0015\u0011Q\u0005\u0005\u00037\fy)A\u0003uC\u001e\u001c\b\u0005\u0006\u0007\u0004\u001a\r}3\u0011MB2\u0007K\u001a9\u0007C\u0004\u0004\u001e\u0011\u0003\r!!\u0015\t\u000f\r\u0005B\t1\u0001\u0004&!911\u0007#A\u0002\r]\u0002bBB\u001e\t\u0002\u00071q\b\u0005\b\u0007'\"\u0005\u0019AB,\u00031)g\u000e\u001a)pS:$8/T1q+\t\u0019i\u0007\u0005\u0005\u0004p\rU4qOB\u0016\u001b\t\u0019\tH\u0003\u0003\u0004t\tU\u0015!C5n[V$\u0018M\u00197f\u0013\u0011\tYn!\u001d\u0011\t\re4qP\u0007\u0003\u0007wRAa! \u0002D\u00059a.\u001a;x_J\\\u0017\u0002BBA\u0007w\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\fQ\"\u001a8e!>Lg\u000e^:NCB\u0004CCAAA)1\u0019Ib!#\u0004\f\u000e=51SBL\u0011\u001d\u0019i\u0002\u0013a\u0001\u0003#Bqa!$I\u0001\u0004\t\t)\u0001\u0003i_N$\bbBBI\u0011\u0002\u0007\u0011\u0011K\u0001\u0005a>\u0014H\u000fC\u0004\u0004\u0016\"\u0003\raa\u001e\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\re\u0005\n1\u0001\u0004\u001c\u0006A\u0001O]8u_\u000e|G\u000e\u0005\u0003\u0004\u001e\u000e\u001dVBABP\u0015\u0011\u0019\tka)\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0007K\u000b\u0019%\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0019Ika(\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>dG\u0003CB\r\u0007[\u001b9l!/\t\u000f\r=\u0016\n1\u0001\u00042\u0006\u0019!-\u001a9\u0011\u0007\u0015\u001c\u0019,C\u0002\u00046~\u0013aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG\u000fC\u0004\u0004\u0016&\u0003\raa\u001e\t\u000f\re\u0015\n1\u0001\u0004\u001c\u0006!an\u001c3f)\u0011\u0019yl!2\u0011\t\u0005\u00053\u0011Y\u0005\u0005\u0007\u0007\f\u0019E\u0001\u0003O_\u0012,\u0007bBBK\u0015\u0002\u00071qO\u0001\bO\u0016$hj\u001c3f)\u0011\u0019Ym!4\u0011\u000b%\u0014ipa0\t\u000f\rU5\n1\u0001\u0004x\u0005q!M]8lKJ,e\u000e\u001a)pS:$H\u0003BBY\u0007'Dqa!&M\u0001\u0004\u00199(\u0001\u0005f]\u0012\u0004v.\u001b8u)\u0011\u0019Yc!7\t\u000f\rUU\n1\u0001\u0004x\u0005aAo\\*feZ,'/\u00138g_Ra\u0011\u0011ABp\u0007G\u001c\tpa=\u0004v\"91\u0011\u001d(A\u0002\u0005\u0005\u0015!C2mkN$XM]%e\u0011\u001d\u0019)O\u0014a\u0001\u0007O\faaY8oM&<\u0007\u0003BBu\u0007[l!aa;\u000b\u0007\u0005=\u0011-\u0003\u0003\u0004p\u000e-(aC&bM.\f7i\u001c8gS\u001eDq!a%O\u0001\u0004\t9\nC\u0005\u00020:\u0003\n\u00111\u0001\u00024\"9\u0011\u0011\u0019(A\u0002\u0005\u0015\u0017A\u0006;p'\u0016\u0014h/\u001a:J]\u001a|G\u0005Z3gCVdG\u000f\n\u001b\u0015\u0019\re11`B\u007f\u0007\u007f$\t\u0001b\u0001\t\u0013\ru\u0001\u000b%AA\u0002\u0005E\u0003\"CB\u0011!B\u0005\t\u0019AB\u0013\u0011%\u0019\u0019\u0004\u0015I\u0001\u0002\u0004\u00199\u0004C\u0005\u0004<A\u0003\n\u00111\u0001\u0004@!I11\u000b)\u0011\u0002\u0003\u00071qK\u000b\u0003\t\u000fQCa!\n\u00032U\u0011A1\u0002\u0016\u0005\u0007o\u0011\t$\u0006\u0002\u0005\u0010)\"1q\bB\u0019+\t!\u0019B\u000b\u0003\u0004X\tEB\u0003BAx\t/A\u0011Ba#Y\u0003\u0003\u0005\r!!\u0015\u0015\t\t\u0005F1\u0004\u0005\n\u0005\u0017S\u0016\u0011!a\u0001\u0003_$BAa\u001e\u0005 !I!1R.\u0002\u0002\u0003\u0007\u0011\u0011\u000b\u000b\u0005\u0005C#\u0019\u0003C\u0005\u0003\fv\u000b\t\u00111\u0001\u0002p\"91QD\u0019A\u0002\u0005E\u0003bBB\u0011c\u0001\u00071Q\u0005\u0005\b\u0007g\t\u0004\u0019AB\u001c))\u0019I\u0002\"\f\u00050\u0011EB1\u0007\u0005\b\u0007;\u0011\u0004\u0019AA)\u0011\u001d\u0019\tC\ra\u0001\u0007KAqaa\r3\u0001\u0004\u00199\u0004C\u0004\u0004<I\u0002\raa\u0010\u0015\u0015\reAq\u0007C\u001d\tw!i\u0004C\u0004\u0004\u001eM\u0002\r!!\u0015\t\u000f\r\u00052\u00071\u0001\u0004&!911G\u001aA\u0002\r]\u0002bBB*g\u0001\u00071qK\u0001\u0012gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cH\u0003\u0002C\"\t\u000b\u0002\u0002\"a\u0018\u0002Z\u0006\u000551\n\u0005\b\u0007w!\u0004\u0019\u0001C$!!\ty&!7\u0002\u0002\u0012%\u0003\u0003\u0002C&\t#j!\u0001\"\u0014\u000b\t\u0011=\u0013\u0011C\u0001\t[\u0016$\u0018\rZ1uC&!A1\u000bC'\u000511VM]:j_:\u0014\u0016M\\4f\u0003Y1'o\\7Ce>\\WM\u001d*fO&\u001cHO]1uS>tG\u0003BB\r\t3Bq\u0001b\u00176\u0001\u0004!i&\u0001\u0007sK\u001eL7\u000f\u001e:bi&|g\u000e\u0005\u0003\u0005L\u0011}\u0013\u0002\u0002C1\t\u001b\u0012!C\u0011:pW\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]Ra1\u0011\u0004C3\tO\"I\u0007b\u001b\u0005n!91Q\u0004\u001cA\u0002\u0005E\u0003bBB\u0011m\u0001\u00071Q\u0005\u0005\b\u0007g1\u0004\u0019AB\u001c\u0011\u001d\u0019YD\u000ea\u0001\u0007\u007fAqaa\u00157\u0001\u0004\u00199\u0006\u0006\u0003\u0005r\u0011e\u0004#B5\u0003~\u0012M\u0004#D5\u0005v\u0005E3QEB\u001c\u0007\u007f\u00199&C\u0002\u0005x)\u0014a\u0001V;qY\u0016,\u0004\"CB\to\u0005\u0005\t\u0019AB\r\u0001")
public class Broker
implements Product,
Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker x$0) {
        return Broker$.MODULE$.unapply(x$0);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public static Broker fromBrokerRegistration(BrokerRegistration registration) {
        return Broker$.MODULE$.fromBrokerRegistration(registration);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, scala.collection.immutable.Map<String, String> tags) {
        return Broker$.MODULE$.apply(id, endPoints, rack, tags);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(id, endPoints, rack, features);
    }

    public static Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack) {
        return Broker$.MODULE$.apply(id, endPoints, rack);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.endPoints().toList().map((Function1 & Serializable)x$1 -> x$1.toJava())).asJava();
        Map interBrokerClientConfigs = ConfluentConfigs.clientConfigsForEndpoint(config.originals(), config.values(), (Endpoint)interBrokerEndpoint);
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, CollectionConverters$.MODULE$.SetHasAsJava((Set)config.earlyStartListeners().map((Function1 & Serializable)x$2 -> x$2.value())).asJava(), httpServerBinder, auditLogProvider, metrics, interBrokerClientConfigs);
    }

    public AuditLogProvider toServerInfo$default$4() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public String productElementName(int x$1) {
        switch (x$1) {
            case 0: {
                return "id";
            }
            case 1: {
                return "endPoints";
            }
            case 2: {
                return "rack";
            }
            case 3: {
                return "features";
            }
            case 4: {
                return "tags";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    public boolean equals(Object x$1) {
        block3: {
            block2: {
                if (this == x$1) break block2;
                if (!(x$1 instanceof Broker)) break block3;
                Broker broker = (Broker)x$1;
                if (this.id() != broker.id()) break block3;
                Seq<EndPoint> seq = this.endPoints();
                Seq<EndPoint> seq2 = broker.endPoints();
                if (seq != null ? !seq.equals(seq2) : seq2 != null) break block3;
                Option<String> option = this.rack();
                Option<String> option2 = broker.rack();
                if (option != null ? !option.equals(option2) : option2 != null) break block3;
                Features<SupportedVersionRange> features = this.features();
                Features<SupportedVersionRange> features2 = broker.features();
                if (features != null ? !features.equals(features2) : features2 != null) break block3;
                scala.collection.immutable.Map<String, String> map = this.tags();
                scala.collection.immutable.Map<String, String> map2 = broker.tags();
                if ((map != null ? !map.equals(map2) : map2 != null) || !broker.canEqual(this)) break block3;
            }
            return true;
        }
        return false;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((IterableOnceOps)endPoints.map((Function1 & Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final java.util.Set<String> earlyStartListeners;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;
        private final Map<String, ?> interBrokerClientConfig;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public java.util.List<String> additionalRoleDefFiles() {
            return super.additionalRoleDefFiles();
        }

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public java.util.Set<String> earlyStartListeners() {
            return this.earlyStartListeners;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Map<String, ?> interBrokerClientConfig() {
            return this.interBrokerClientConfig;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, earlyStartListeners, httpServerBinder, auditLogProvider, metrics, interBrokerClientConfig);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public java.util.Set<String> copy$default$5() {
            return this.earlyStartListeners();
        }

        public KafkaHttpServerBinder copy$default$6() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$7() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$8() {
            return this.metrics();
        }

        public Map<String, ?> copy$default$9() {
            return this.interBrokerClientConfig();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.earlyStartListeners();
                }
                case 5: {
                    return this.httpServerBinder();
                }
                case 6: {
                    return this.auditLogProvider();
                }
                case 7: {
                    return this.metrics();
                }
                case 8: {
                    return this.interBrokerClientConfig();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "clusterResource";
                }
                case 1: {
                    return "brokerId";
                }
                case 2: {
                    return "endpoints";
                }
                case 3: {
                    return "interBrokerEndpoint";
                }
                case 4: {
                    return "earlyStartListeners";
                }
                case 5: {
                    return "httpServerBinder";
                }
                case 6: {
                    return "auditLogProvider";
                }
                case 7: {
                    return "metrics";
                }
                case 8: {
                    return "interBrokerClientConfig";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.earlyStartListeners())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)Statics.anyHash(this.interBrokerClientConfig())), (int)9);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ServerInfo)) break block3;
                    ServerInfo serverInfo = (ServerInfo)x$1;
                    if (this.brokerId() != serverInfo.brokerId()) break block3;
                    ClusterResource clusterResource = this.clusterResource();
                    ClusterResource clusterResource2 = serverInfo.clusterResource();
                    if (clusterResource != null ? !clusterResource.equals(clusterResource2) : clusterResource2 != null) break block3;
                    Collection collection = this.endpoints();
                    Collection collection2 = serverInfo.endpoints();
                    if (collection != null ? !((Object)collection).equals(collection2) : collection2 != null) break block3;
                    Endpoint endpoint = this.interBrokerEndpoint();
                    Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
                    if (endpoint != null ? !endpoint.equals(endpoint2) : endpoint2 != null) break block3;
                    Collection collection3 = this.earlyStartListeners();
                    Collection collection4 = serverInfo.earlyStartListeners();
                    if (collection3 != null ? !((Object)collection3).equals(collection4) : collection4 != null) break block3;
                    KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
                    KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
                    if (kafkaHttpServerBinder != null ? !kafkaHttpServerBinder.equals(kafkaHttpServerBinder2) : kafkaHttpServerBinder2 != null) break block3;
                    AuditLogProvider auditLogProvider = this.auditLogProvider();
                    AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
                    if (auditLogProvider != null ? !auditLogProvider.equals(auditLogProvider2) : auditLogProvider2 != null) break block3;
                    Metrics metrics = this.metrics();
                    Metrics metrics2 = serverInfo.metrics();
                    if (metrics != null ? !metrics.equals(metrics2) : metrics2 != null) break block3;
                    Map<String, ?> map = this.interBrokerClientConfig();
                    Map<String, ?> map2 = serverInfo.interBrokerClientConfig();
                    if ((map != null ? !((Object)map).equals(map2) : map2 != null) || !serverInfo.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, java.util.Set<String> earlyStartListeners, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics, Map<String, ?> interBrokerClientConfig) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.earlyStartListeners = earlyStartListeners;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            this.interBrokerClientConfig = interBrokerClientConfig;
            Product.$init$((Product)this);
        }
    }
}

