/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.PartitionLoadScheduler;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\b\u0010\u0001YA\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!Y\u0007A!A!\u0002\u0013A\u0007\"\u00027\u0001\t\u0003i\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003x\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0005\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002V\u0001!\t%a\u0016\u0003+\r{wN\u001d3j]\u0006$xN\u001d'pC\u0012,'/S7qY*\u0011\u0001#E\u0001\u0006OJ|W\u000f\u001d\u0006\u0003%M\t1bY8pe\u0012Lg.\u0019;pe*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005]y3\u0003\u0002\u0001\u0019Am\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0004C-jS\"\u0001\u0012\u000b\u0005\r\"\u0013a\u0002:v]RLW.\u001a\u0006\u0003!\u0015R!A\u0005\u0014\u000b\u0005Q9#B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001eL!\u0001\f\u0012\u0003#\r{wN\u001d3j]\u0006$xN\u001d'pC\u0012,'\u000f\u0005\u0002/_1\u0001A!\u0002\u0019\u0001\u0005\u0004\t$!\u0001+\u0012\u0005IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$a\u0002(pi\"Lgn\u001a\t\u0003geJ!A\u000f\u001b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002=\u007f5\tQH\u0003\u0002?'\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0011!\u0018.\\3\u0011\u0005\r;U\"\u0001#\u000b\u0005y*%B\u0001$'\u0003\u0019\u0019w.\\7p]&\u0011\u0001\n\u0012\u0002\u0005)&lW-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005-sU\"\u0001'\u000b\u00055\u001b\u0012AB:feZ,'/\u0003\u0002P\u0019\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018\u0001\u00043fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bc\u0001*e[9\u00111K\u0019\b\u0003)\u0006t!!\u00161\u000f\u0005Y{fBA,_\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\+\u00051AH]8pizJ\u0011AK\u0005\u0003Q%J!\u0001F\u0014\n\u0005I1\u0013B\u0001\t&\u0013\t\u0019C%\u0003\u0002dE\u0005\t2i\\8sI&t\u0017\r^8s\u0019>\fG-\u001a:\n\u0005\u00154'\u0001\u0004#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA2#\u00039aw.\u00193Ck\u001a4WM]*ju\u0016\u0004\"aM5\n\u0005)$$aA%oi\u00069A\u000f\u001b:fC\u0012\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004oaF\u00148\u000f\u001e\t\u0004_\u0002iS\"A\b\t\u000b\u00053\u0001\u0019\u0001\"\t\u000b%3\u0001\u0019\u0001&\t\u000bA3\u0001\u0019A)\t\u000b\u001d4\u0001\u0019\u00015\t\u000b-4\u0001\u0019\u00015\u0002\u0013%\u001c(+\u001e8oS:<W#A<\u0011\u0005a|X\"A=\u000b\u0005i\\\u0018AB1u_6L7M\u0003\u0002}{\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005yd\u0012\u0001B;uS2L1!!\u0001z\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q\u0011n\u001d*v]:Lgn\u001a\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u0005!\u0011\tY!!\u0004\u000e\u0003EI1!a\u0004\u0012\u0005Y\u0001\u0016M\u001d;ji&|g\u000eT8bIN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005!An\\1e)\u0019\t9\"!\n\u00022A1\u0011\u0011DA\u000e\u0003?i\u0011a_\u0005\u0004\u0003;Y(!E\"p[BdW\r^1cY\u00164U\u000f^;sKB\u0019!+!\t\n\u0007\u0005\rbMA\u0006M_\u0006$7+^7nCJL\bbBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u0003iB\u0004B!a\u000b\u0002.5\tQ)C\u0002\u00020\u0015\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0013\u0017\u0001\u0007\u00111\u0007\t\u0005C\u0005UR&C\u0002\u00028\t\u00121cQ8pe\u0012Lg.\u0019;peBc\u0017-\u001f2bG.\fa\u0001Z8M_\u0006$GCCA\u001f\u0003\u0007\n)%a\u0012\u0002LA\u00191'a\u0010\n\u0007\u0005\u0005CG\u0001\u0003V]&$\bbBA\u0014\u0019\u0001\u0007\u0011\u0011\u0006\u0005\u0007%1\u0001\r!a\r\t\u000f\u0005%C\u00021\u0001\u0002\u0018\u00051a-\u001e;ve\u0016Dq!!\u0014\r\u0001\u0004\ty%A\u0006ti\u0006\u0014H\u000fV5nK6\u001b\bcA\u001a\u0002R%\u0019\u00111\u000b\u001b\u0003\t1{gnZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0003{\u0001")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final CoordinatorLoader.Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final PartitionLoadScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private PartitionLoadScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        try {
            this.scheduler().schedule(tp.partition(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.doLoad(tp, coordinator, future, startTimeMs));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        catch (Throwable ex) {
            future.completeExceptionally(new RuntimeException("Unexpected error while scheduling loading.", ex));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block17: {
            long schedulerQueueTimeMs = this.time.milliseconds() - startTimeMs;
            try {
                Option<AbstractLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(60).append("Could not load records from ").append(tp).append(" because the log does not exist.").toString()));
                    break block17;
                }
                if (option instanceof Some) {
                    AbstractLog log = (AbstractLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef previousHighWatermark = LongRef.create((long)-1L);
                    IntRef numRecords = IntRef.create((int)0);
                    int numBytes = 0;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true, false);
                        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                            throw new IllegalStateException(new StringBuilder(40).append("Unexpected tiered segment for ").append(tp).append(" partition").toString());
                        }
                        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Loaded metadata from ").append(tp).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured buffer size (").append($this.loadBufferSize).append(" bytes).").toString());
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = new MemoryRecords(buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(coordinator, batch, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$5(this, numRecords, coordinator, batch, tp, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > previousHighWatermark$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    previousHighWatermark$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                        });
                        numBytes += memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(93).append("Stopped loading records from ").append(tp).append(" because the partition is not online or is no longer the leader.").toString()));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, schedulerQueueTimeMs, (long)numRecords.elem, (long)numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block17;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, Record record) {
        block8: {
            block7: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block6: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block6;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block7;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block8;
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$5(CoordinatorLoaderImpl $this, IntRef numRecords$1, CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, TopicPartition tp$2, Record record) {
        ++numRecords$1.elem;
        try {
            coordinator$2.replay(record.offset(), batch$1.producerId(), batch$1.producerEpoch(), $this.deserializer.deserialize(record.key(), record.value()));
            return;
        }
        catch (CoordinatorLoader.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Unknown record type ").append(ex.unknownType()).append(" while loading offsets and group metadata ").append("from ").append(tp$2).append(". Ignoring it. It could be a left over from an aborted upgrade.").toString());
            return;
        }
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, CoordinatorLoader.Deserializer<T> deserializer, int loadBufferSize, int threads) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new PartitionLoadScheduler(threads, "group-coordinator-loader-");
    }
}

