/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tMw!B\u00181\u0011\u00039d!B\u001d1\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%\t\u0001\u0012\u0005\u0007-\u0006\u0001\u000b\u0011B#\t\u000b]\u000bA\u0011\u0001-\t\u000f\t5\u0017\u0001\"\u0003\u0003P\u001a!\u0011\b\r\u0001[\u0011!9wA!b\u0001\n\u0003A\u0007\u0002\u00037\b\u0005\u0003\u0005\u000b\u0011B5\t\u00115<!Q1A\u0005\u00029D\u0001B]\u0004\u0003\u0002\u0003\u0006Ia\u001c\u0005\tg\u001e\u0011)\u0019!C\u0001i\"A\u0001p\u0002B\u0001B\u0003%Q\u000f\u0003\u0005z\u000f\t\u0015\r\u0011\"\u0001{\u0011%\tya\u0002B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u0012\u001d\u0011)\u0019!C\u0001\u0003'A!\"!\f\b\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\tyc\u0002BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003{9!\u0011!Q\u0001\n\u0005M\u0002BCA \u000f\t\u0015\r\u0011\"\u0001\u0002B!Q\u0011\u0011K\u0004\u0003\u0002\u0003\u0006I!a\u0011\t\r\u0005;A\u0011AA*\u0011%\t\u0019g\u0002b\u0001\n\u0003\t)\u0007\u0003\u0005\u0002x\u001d\u0001\u000b\u0011BA4\u0011%\tIh\u0002a\u0001\n\u0003\tY\bC\u0005\u0002\u0004\u001e\u0001\r\u0011\"\u0001\u0002\u0006\"A\u0011\u0011S\u0004!B\u0013\ti\bC\u0005\u0002\u001c\u001e\u0001\r\u0011\"\u0001\u0002|!I\u0011QT\u0004A\u0002\u0013\u0005\u0011q\u0014\u0005\t\u0003G;\u0001\u0015)\u0003\u0002~!9\u0011qU\u0004\u0005\u0002\u0005%\u0006bBA[\u000f\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0013<A\u0011AAf\u0011\u001d\t)n\u0002C\u0001\u0003/DqAa\u0002\b\t\u0003\u0011I\u0001C\u0004\u0003.\u001d!\tAa\f\t\u000f\ter\u0001\"\u0001\u0003<!9!qH\u0004\u0005\u0002\t\u0005\u0003b\u0002B&\u000f\u0011\u0005!Q\n\u0005\b\u0005/:A\u0011\u0001B-\u0011\u001d\u0011\tg\u0002C\u0001\u0005GBqAa\u001c\b\t\u0003\u0011\t\b\u0003\u0004\u0003t\u001d!\t\u0005\u0012\u0005\b\u0005k:A\u0011\tB<\u0011\u001d\u0011\u0019i\u0002C\u0001\u0005\u000bCqA!$\b\t\u0013\u0011y)\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;pe*\u0011\u0011GM\u0001\u0006cV|G/\u0019\u0006\u0003gQ\n1bY8pe\u0012Lg.\u0019;pe*\tQ'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0019\u0003!E+x\u000e^1D_>\u0014H-\u001b8bi>\u00148CA\u0001<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aN\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005)\u0005c\u0001$J\u00176\tqI\u0003\u0002I{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005);%aA*fiB\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u001f\u000e\u0003=S!\u0001\u0015\u001c\u0002\rq\u0012xn\u001c;?\u0013\t\u0011V(\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*>\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!B1qa2LH#E-\u0003\u0016\ne%1\u0014BY\u0005w\u0013iLa0\u0003LB\u0011\u0001hB\n\u0005\u000fmZ\u0016\r\u0005\u0002]?6\tQL\u0003\u0002_i\u0005)Q\u000f^5mg&\u0011\u0001-\u0018\u0002\b\u0019><w-\u001b8h!\t\u0011W-D\u0001d\u0015\t!G'\u0001\u0004tKJ4XM]\u0005\u0003M\u000e\u0014AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0017\u0001\u00032s_.,'/\u00133\u0016\u0003%\u0004\"\u0001\u00106\n\u0005-l$aA%oi\u0006I!M]8lKJLE\rI\u0001\fcV|G/Y\"p]\u001aLw-F\u0001p!\tA\u0004/\u0003\u0002ra\t1\u0012+^8uC\u000e{wN\u001d3j]\u0006$xN]\"p]\u001aLw-\u0001\u0007rk>$\u0018mQ8oM&<\u0007%A\trk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ,\u0012!\u001e\t\u0003qYL!a\u001e\u0019\u0003#E+x\u000e^1Ti\u0006$X-T1oC\u001e,'/\u0001\nrk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\u0005Y\bc\u0001?\u0002\f5\tQP\u0003\u0002\u007f\u007f\u0006!Q\u000f^5m\u0015\r!\u0017\u0011\u0001\u0006\u0004k\u0005\r!\u0002BA\u0003\u0003\u000f\ta!\u00199bG\",'BAA\u0005\u0003\ry'oZ\u0005\u0004\u0003\u001bi(!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0016S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3s+\t\t)\u0002\u0005\u0004\u0002\u0018\u0005\r\u0012qE\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005Aa-\u001e8di&|gNC\u0002\u007f\u0003?Q!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tIB\u0001\u0005TkB\u0004H.[3s!\r\u0011\u0017\u0011F\u0005\u0004\u0003W\u0019'!D%oi\u0016\u0014h.\u00197BI6Lg.\u0001\fj]R,'O\\1m\u0003\u0012l\u0017N\\*vaBd\u0017.\u001a:!\u0003e\u0019G.^:uKJdUM^3m#V|G/Y\"bY2\u0014\u0017mY6\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003si!!a\u000e\u000b\u0005Ez\u0018\u0002BA\u001e\u0003o\u0011\u0011d\u00117vgR,'\u000fT3wK2\fVo\u001c;b\u0007\u0006dGNY1dW\u0006Q2\r\\;ti\u0016\u0014H*\u001a<fYF+x\u000e^1DC2d'-Y2lA\u0005!A/[7f+\t\t\u0019\u0005\u0005\u0003\u0002F\u00055SBAA$\u0015\rq\u0016\u0011\n\u0006\u0005\u0003\u0017\n\t!\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u001f\n9E\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004CcD-\u0002V\u0005]\u0013\u0011LA.\u0003;\ny&!\u0019\t\u000b\u001d4\u0002\u0019A5\t\u000b54\u0002\u0019A8\t\u000bM4\u0002\u0019A;\t\u000be4\u0002\u0019A>\t\u000f\u0005Ea\u00031\u0001\u0002\u0016!9\u0011q\u0006\fA\u0002\u0005M\u0002bBA -\u0001\u0007\u00111I\u0001\tSN\f5\r^5wKV\u0011\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0019\tGo\\7jG*!\u0011\u0011OA\u000f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003k\nYGA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\nSN\f5\r^5wK\u0002\naD\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1\u0016\u0005\u0005u\u0004c\u0001\u001f\u0002\u0000%\u0019\u0011\u0011Q\u001f\u0003\t1{gnZ\u0001#EJ|7.\u001a:UK:\fg\u000e\u001e'j[&$\bK]8ek\u000e,'/U;pi\u0006|F%Z9\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004y\u0005%\u0015bAAF{\t!QK\\5u\u0011%\tyIGA\u0001\u0002\u0004\ti(A\u0002yIE\nqD\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u!J|G-^2feF+x\u000e^1!Q\rY\u0012Q\u0013\t\u0004y\u0005]\u0015bAAM{\tAao\u001c7bi&dW-\u0001\u0010ce>\\WM\u001d+f]\u0006tG\u000fT5nSR\u001cuN\\:v[\u0016\u0014\u0018+^8uC\u0006\u0011#M]8lKJ$VM\\1oi2KW.\u001b;D_:\u001cX/\\3s#V|G/Y0%KF$B!a\"\u0002\"\"I\u0011qR\u000f\u0002\u0002\u0003\u0007\u0011QP\u0001 EJ|7.\u001a:UK:\fg\u000e\u001e'j[&$8i\u001c8tk6,'/U;pi\u0006\u0004\u0003f\u0001\u0010\u0002\u0016\u0006I1/\u001a;BGRLg/\u001a\u000b\u0005\u0003\u000f\u000bY\u000bC\u0004\u0002.~\u0001\r!a,\u0002\r\u0005\u001cG/\u001b<f!\ra\u0014\u0011W\u0005\u0004\u0003gk$a\u0002\"p_2,\u0017M\\\u0001\u0014O\u0016$(I]8lKJ\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u000b\u0005\u0003s\u000by\fE\u0002=\u0003wK1!!0>\u0005\u0019!u.\u001e2mK\"9\u0011\u0011\u0019\u0011A\u0002\u0005\r\u0017!C9v_R\fG+\u001f9f!\u0011\t)$!2\n\t\u0005\u001d\u0017q\u0007\u0002\u0010\u00072LWM\u001c;Rk>$\u0018\rV=qK\u0006aR\u000f\u001d3bi\u0016\u0014%o\\6feR+g.\u00198u#V|G/\u0019'j[&$HCBAD\u0003\u001b\f\t\u000eC\u0004\u0002P\u0006\u0002\r!! \u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b\u0011\u001d\t\u0019.\ta\u0001\u0003{\nQbY8ogVlWM])v_R\f\u0017!D2p[B,H/Z)v_R\f7\u000f\u0006\u0005\u0002\b\u0006e\u00171\\A|\u0011\u00159'\u00051\u0001j\u0011\u001d\tiN\ta\u0001\u0003?\fA\"];pi\u0006,e\u000e\u001e:jKN\u0004b!!9\u0002l\u0006Eh\u0002BAr\u0003Ot1ATAs\u0013\u0005q\u0014bAAu{\u00059\u0001/Y2lC\u001e,\u0017\u0002BAw\u0003_\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003Sl\u0004c\u0001\u001d\u0002t&\u0019\u0011Q\u001f\u0019\u00035E+x\u000e^1F]RLG/_!oI\u000e{gn];naRLwN\\:\t\u000f\u0005e(\u00051\u0001\u0002|\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\by\u0005u(\u0011AAD\u0013\r\ty0\u0010\u0002\n\rVt7\r^5p]F\u00022\u0001\u000fB\u0002\u0013\r\u0011)\u0001\r\u0002\u0012%\u0016\u0004xN\u001d;Rk>$\u0018MU3tk2$\u0018!\u00043fg\u000e\u0014\u0018NY3Rk>$\u0018\r\u0006\u0003\u0003\f\t\r\u0002c\u0002\u001f\u0003\u000e\tE!QD\u0005\u0004\u0005\u001fi$A\u0002+va2,'\u0007\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\u0011\u00119\"!\u0013\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0007\u0003\u0016\t1QI\u001d:peN\u00042\u0001\u000fB\u0010\u0013\r\u0011\t\u0003\r\u0002\u0011#V|G/\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:DqA!\n$\u0001\u0004\u00119#A\u0006rk>$\u0018-\u00128uSRL\bc\u0001\u001d\u0003*%\u0019!1\u0006\u0019\u0003\u0017E+x\u000e^1F]RLG/_\u0001\u0013cV|G/Y:U_BL7mQ8oM&<7/\u0006\u0002\u00032A!!1\u0007B\u001b\u001b\t\ti\"\u0003\u0003\u00038\u0005u!A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u0019\u0011N!\u0010\t\u000f\t\u0015R\u00051\u0001\u0003(\u0005\u0019b/\u00197jI\u0006$X-U;pi\u0006,e\u000e^5usR!!1\tB%!\u0015a$Q\tB\t\u0013\r\u00119%\u0010\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t\u0015b\u00051\u0001\u0003(\u0005QqN\\#mK\u000e$\u0018n\u001c8\u0015\r\u0005\u001d%q\nB*\u0011\u0019\u0011\tf\na\u0001S\u0006)\u0012/^8uCR{\u0007/[2QCJ$\u0018\u000e^5p]&#\u0007B\u0002B+O\u0001\u0007\u0011.\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006iqN\u001c*fg&<g.\u0019;j_:$b!a\"\u0003\\\tu\u0003B\u0002B)Q\u0001\u0007\u0011\u000eC\u0004\u0003V!\u0002\rAa\u0018\u0011\tq\u0012)%[\u0001\bgR\f'\u000f^;q)\u0011\t9I!\u001a\t\u000f\t\u001d\u0014\u00061\u0001\u0003j\u0005\u0001#/\u001a;sS\u00164X-U;pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u!\u0011a$1N5\n\u0007\t5THA\u0005Gk:\u001cG/[8oa\u0005A1\u000f[;uI><h\u000e\u0006\u0002\u0002\b\u0006)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\t9I!\u001f\t\u000f\tmD\u00061\u0001\u0003~\u0005Ia.Z<D_:4\u0017n\u001a\t\u0004E\n}\u0014b\u0001BAG\nY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005\u001d%q\u0011BF\u0011\u001d\u0011I)\fa\u0001\u0005{\n\u0011b\u001c7e\u0007>tg-[4\t\u000f\tmT\u00061\u0001\u0003~\u00051\u0012n]\"mS\u0016tG/U;pi\u0006$\u0016\u0010]3WC2LG\r\u0006\u0003\u00020\nE\u0005B\u0002BJ]\u0001\u00071*A\u0001t\u0011\u001d\u00119*\u0002a\u0001\u0005{\naaY8oM&<\u0007\"B=\u0006\u0001\u0004Y\bb\u0002BO\u000b\u0001\u0007!qT\u0001\u0017i\u0016t\u0017M\u001c;NKR\u0014\u0018nY:Qk\nd\u0017n\u001d5feB)AH!\u0012\u0003\"B!!1\u0015BW\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016aB7fiJL7m\u001d\u0006\u0005\u0005W\u000b\t!\u0001\u0006d_:$(o\u001c7mKJLAAa,\u0003&\n1B+\u001a8b]RlU\r\u001e:jGN\u0004VO\u00197jg\",'\u000fC\u0004\u00034\u0016\u0001\rA!.\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019!Ma.\n\u0007\te6M\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\u0005EQ\u00011\u0001\u0002\u0016!9\u0011qF\u0003A\u0002\u0005M\u0002b\u0002BT\u000b\u0001\u0007!\u0011\u0019\t\u0005\u0005\u0007\u00149-\u0004\u0002\u0003F*!!qUA%\u0013\u0011\u0011IM!2\u0003\u000f5+GO]5dg\"9\u0011qH\u0003A\u0002\u0005\r\u0013AF9v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0015\u0007=\u0014\t\u000eC\u0004\u0003\u0018\u001a\u0001\rA! ")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile long brokerTenantLimitProducerQuota;
    private volatile long brokerTenantLimitConsumerQuota;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig config, Scheduler scheduler, Option<TenantMetricsPublisher> tenantMetricsPublisher, ReplicaManager replicaManager, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinatorConfig apply_quotaConfig = QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(config);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, tenantMetricsPublisher, replicaManager, clusterLevelQuotaCallback, metrics, time);
        return new QuotaCoordinator(config.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, internalAdminSupplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public long brokerTenantLimitProducerQuota() {
        return this.brokerTenantLimitProducerQuota;
    }

    public void brokerTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerTenantLimitProducerQuota = x$1;
    }

    public long brokerTenantLimitConsumerQuota() {
        return this.brokerTenantLimitConsumerQuota;
    }

    public void brokerTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerTenantLimitConsumerQuota = x$1;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public double getBrokerQuotaLimit(ClientQuotaType quotaType) {
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            return this.brokerTenantLimitConsumerQuota();
        }
        if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            return this.brokerTenantLimitProducerQuota();
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
    }

    public void updateBrokerTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((IterableOnceOps)quotaEntries.map((Function1 & Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
            this.storeQuotaCallback$1(responseStatus, quotaEntries, responseCallback, invalidQuotaEntries);
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            return new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                QuotaEntry quotaEntry = (QuotaEntry)((Some)option2).value();
                return new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((IterableOnceOps)((IterableOps)quotaEntry.computedQuotas().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        int brokerId = x0$1._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)((MapOps)perBrokerQuotas.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$3(this, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                            if (x0$3 != null) {
                                String quotaType = (String)x0$3._1();
                                QuotaValue quotaValue = (QuotaValue)x0$3._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                            }
                            throw new MatchError(null);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.consumer.rate'  to be positive");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block5: {
            block4: {
                Integer n = newConfig.confluentConfig().quotasExpirationTimeMs();
                Integer n2 = oldConfig.confluentConfig().quotasExpirationTimeMs();
                if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                    this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
                }
                Long l = newConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                Long l2 = oldConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                if (l != null ? !((Object)l).equals(l2) : l2 != null) break block4;
                Long l3 = newConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                Long l4 = oldConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                if (!(l3 == null ? l4 != null : !((Object)l3).equals(l4))) break block5;
            }
            this.updateBrokerTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()));
            return;
        }
    }

    private boolean isClientQuotaTypeValid(String s) {
        block3: {
            block2: {
                String string = s;
                String string2 = ClientQuotaType.PRODUCE.toString();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = s;
                String string4 = ClientQuotaType.FETCH.toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        if ($this.isClientQuotaTypeValid(quotaConsumption.quotaType())) {
            String valueOf_name = quotaConsumption.quotaType();
            Object var6_4 = null;
            ClientQuotaType clientQuotaType = Enum.valueOf(ClientQuotaType.class, valueOf_name);
            Double clusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(clientQuotaType, CollectionConverters$.MODULE$.MapHasAsJava(quotaEntry$1.quotaEntity().entityTypes()).asJava());
            quotaEntry$1.updateConsumptionAndRecomputeQuotas(brokerId$1, quotaConsumption, Predef$.MODULE$.Double2double(clusterQuotaLimit), $this.getBrokerQuotaLimit(clientQuotaType), $this.time().milliseconds(), $this.quotaConfig().quotasConsumptionExpirationTimeMs(), $this.quotaConfig().quotasRecomputeIntervalMs(), $this.quotaConfig().quotasLazyEvaluationThreshold());
            return;
        }
        quotaEntry$1.updateConsumption(brokerId$1, quotaConsumption, $this.time().milliseconds());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((IterableOnceOps)quotaEntries$1.map((Function1 & Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((Map)entityResults.$plus$plus((IterableOnce)invalidQuotaEntries$1))));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$3(QuotaCoordinator $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            String quotaType = (String)x0$2._1();
            return $this.isClientQuotaTypeValid(quotaType);
        }
        throw new MatchError(null);
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
        this.brokerTenantLimitProducerQuota = quotaConfig.quotasBrokerLimitProducer();
        this.brokerTenantLimitConsumerQuota = quotaConfig.quotasBrokerLimitConsumer();
    }
}

