/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0014)\u0001=B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0003\u0002!IA\u0011\u0005\b\r\u0002\u0001\r\u0011\"\u0003H\u0011\u001dY\u0005\u00011A\u0005\n1CaA\u0015\u0001!B\u0013A\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007W\u0002\u0001\u000b\u0011B+\t\u000f1\u0004!\u0019!C\u0005[\"1\u0011\u000f\u0001Q\u0001\n9DQA\u001d\u0001\u0005\u0002QCQa\u001d\u0001\u0005\u0002QDQa\u001e\u0001\u0005\u0002aD\u0011\"!\u0017\u0001#\u0003%\t!a\u0017\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011AA@\u0011%\ti\tAI\u0001\n\u0003\ty\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u00111\u0017\u0001\u0005\u0002\u0005\u0005\u0006bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!a2\u0001\t\u0003\tI\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002z\u0002!\t!a?\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!9!1\u0001\u0001\u0005\u0002\t\u0015qa\u0002B\u0006Q!\u0005!Q\u0002\u0004\u0007O!B\tAa\u0004\t\r\u0005#C\u0011\u0001B\t\u0011\u001d\u0011\u0019\u0002\nC\u0001\u0005+\u0011Q\"Q;eSR\u0014V\r]8si\u0016\u0014(BA\u0015+\u0003\u0015\tW\u000fZ5u\u0015\tYC&\u0001\u0006ekJ\f'-\u001b7jifT\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0013!B;uS2\u001c\u0018BA\u001e9\u0005\u001daunZ4j]\u001e\fQ\"\\3ue&\u001cW*\u00198bO\u0016\u0014\bC\u0001 @\u001b\u0005Q\u0013B\u0001!+\u0005a!UO]1cS2LG/_'fiJL7m]'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r+\u0005C\u0001#\u0001\u001b\u0005A\u0003\"\u0002\u001f\u0003\u0001\u0004i\u0014!\u00026pE&#W#\u0001%\u0011\u0005EJ\u0015B\u0001&3\u0005\rIe\u000e^\u0001\nU>\u0014\u0017\nZ0%KF$\"!\u0014)\u0011\u0005Er\u0015BA(3\u0005\u0011)f.\u001b;\t\u000fE#\u0011\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\u0002\r)|'-\u00133!\u0003)\u00198m\u001c:j]\u001el\u0015\r]\u000b\u0002+B!akW/i\u001b\u00059&B\u0001-Z\u0003\u001diW\u000f^1cY\u0016T!A\u0017\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002]/\n9\u0001*Y:i\u001b\u0006\u0004\bC\u00010g\u001b\u0005y&B\u00011b\u0003\u0019\u0019w.\\7p]*\u0011QF\u0019\u0006\u0003G\u0012\fa!\u00199bG\",'\"A3\u0002\u0007=\u0014x-\u0003\u0002h?\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001#j\u0013\tQ\u0007FA\u0006PM\u001a\u001cX\r^\"pk:$\u0018aC:d_JLgnZ'ba\u0002\n\u0001c]3h[\u0016tGo\u00144gg\u0016$X*\u00199\u0016\u00039\u0004\"\u0001R8\n\u0005AD#\u0001E*fO6,g\u000e^(gMN,G/T1q\u0003E\u0019XmZ7f]R|eMZ:fi6\u000b\u0007\u000fI\u0001\u000eO\u0016$8kY8sS:<W*\u00199\u0002+\u001d,G\u000fR;sC\nLG.\u001b;z\u0007>,h\u000e^3sgR\u0011\u0001.\u001e\u0005\u0006m.\u0001\r!X\u0001\u0003S\u0012\fQC]3q_J$H)\u001e:bE&d\u0017\u000e^=MCB\u001cX\rF\bNsn\f\t!!\u0002\u0002.\u0005\u0005\u00131JA(\u0011\u0015QH\u00021\u0001^\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DQ\u0001 \u0007A\u0002u\f1b\u001d;beR|eMZ:fiB\u0011\u0011G`\u0005\u0003\u007fJ\u0012A\u0001T8oO\"1\u00111\u0001\u0007A\u0002u\f\u0011\u0002\\8tg\u000e{WO\u001c;\t\u000f\u0005\u001dA\u00021\u0001\u0002\n\u0005)A.\u00199tKB!\u00111BA\u0014\u001d\u0011\ti!!\t\u000f\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tYB\u0004\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9BL\u0001\u0007yI|w\u000e\u001e \n\u00035J!a\u000b\u0017\n\u0007\u0005}!&A\bnCR,'/[1mSj\fG/[8o\u0013\u0011\t\u0019#!\n\u0002'\u0011+(/\u00192jY&$\u0018\u0010T1qg\u0016$\u0016\u0010]3\u000b\u0007\u0005}!&\u0003\u0003\u0002*\u0005-\"a\u0005#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3UsB,'\u0002BA\u0012\u0003KAq!a\f\r\u0001\u0004\t\t$A\u0002ng\u001e\u0004B!a\r\u0002<9!\u0011QGA\u001c!\r\t\u0019BM\u0005\u0004\u0003s\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:IBq!a\u0011\r\u0001\u0004\t)%A\u0003tG>\u0014X\rE\u00022\u0003\u000fJ1!!\u00133\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0014\r!\u0003\u0005\r!!\u0012\u0002\u001f%\u001cxJ\u001c#f[\u0006tG-Q;eSRD\u0011\"!\u0015\r!\u0003\u0005\r!a\u0015\u0002\u00175L'O]8s'R\fG/\u001a\t\u0006c\u0005U\u0013\u0011G\u0005\u0004\u0003/\u0012$AB(qi&|g.A\u0010sKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us2\u000b\u0007o]3%I\u00164\u0017-\u001e7uI]*\"!!\u0018+\t\u0005\u0015\u0013qL\u0016\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000e\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002p\u0005\u0015$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\"/\u001a9peR$UO]1cS2LG/\u001f'baN,G\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005U$\u0006BA*\u0003?\n1C]3tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:$2!TA>\u0011\u0015Qx\u00021\u0001^\u0003U\u0011X\r]8si\u0012+(/\u00192jY&$\u00180Q;eSR$\u0012\"TAA\u0003\u0007\u000b))!#\t\u000b\u0019\u0003\u0002\u0019\u0001%\t\u000bi\u0004\u0002\u0019A/\t\r\u0005\u001d\u0005\u00031\u0001~\u0003!!x\u000e^1m\u001bN<\u0007\u0002CAF!A\u0005\t\u0019A?\u0002\u0015Q|G/\u00197MCB\u001cX-A\u0010sKB|'\u000f\u001e#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;%I\u00164\u0017-\u001e7uIQ*\"!!%+\u0007u\fy&A\tva\u0012\fG/\u001a%fC2$\bn\u00115fG.$R!TAL\u00037Cq!!'\u0013\u0001\u0004\t\t$A\u0005ce>\\WM]*sG\"1\u0011Q\u0014\nA\u0002u\f\u0011\u0002^5nKN#\u0018-\u001c9\u0002\u001bM$\u0018M\u001d;Bk\u0012LGOS8c)\t\t\u0019\u000b\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\tQLW.\u001a\u0006\u0003\u0003[\u000bAA[1wC&!\u0011\u0011WAT\u0005\u001dIen\u001d;b]R\fqc\u001d;beR\fU\u000fZ5u\u0007>l\u0007/Y2uS>t'j\u001c2\u0002Y\u0019,Go\u00195D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>tG)\u0019;b-\u0006d\u0017\u000eZ1uS>t7k[5qa\u0016$G#A?\u0002%\u0005$G\rV5fe\u0006+H-\u001b;FeJ|'o\u001d\u000b\u0004\u001b\u0006u\u0006BBA`-\u0001\u0007Q0A\u0003d_VtG/A\u000fbI\u0012$\u0016.\u001a:Bk\u0012LG/\u00168l]><h.\u0012=dKB$\u0018n\u001c8t)\ri\u0015Q\u0019\u0005\u0007\u0003\u007f;\u0002\u0019A?\u00027\u0005$G\rV5fe\u0006+H-\u001b;SKR\u0014\u00180\u0012=dKB$\u0018n\u001c8t)\ri\u00151\u001a\u0005\u0007\u0003\u007fC\u0002\u0019A?\u00029\u0005$GmQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N[\u0017\u000e\u001d9fIR\u0019Q*!5\t\r\u0005}\u0016\u00041\u0001~\u0003)\nG\rZ\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:$\u0015\r^1WC2LG-\u0019;j_:\u001c6.\u001b9qK\u0012$2!TAl\u0011\u0019\tyL\u0007a\u0001{\u0006\u0011\u0013\r\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>tG)\u0019;b-\u0006d\u0017\u000eZ1uK\u0012$2!TAo\u0011\u0019\tyl\u0007a\u0001{\u00061\u0012\r\u001a3US\u0016\u00148+Z4nK:$8/Q;eSR,G\rF\u0002N\u0003GDa!a0\u001d\u0001\u0004i\u0018!G1eI\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\%eY\u0016$2!TAu\u0011\u0019\ty,\ba\u0001{\u0006a\u0012\r\u001a3D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t\u0017)\u001e3ji\u0016$GcA'\u0002p\"1\u0011q\u0018\u0010A\u0002u\f\u0011#\u001e9eCR,\u0017)\u001e3ji\u0012\u00137+\u001b>f)\ri\u0015Q\u001f\u0005\u0007\u0003o|\u0002\u0019A?\u0002\tML'0Z\u0001\u001eC\u0012$G)Q\"p]N,X.\u001a:Qe>\u001cWm]:fIJ+7m\u001c:egR\u0019Q*!@\t\r\u0005}\u0006\u00051\u0001~\u0003E\u0011Xm]3u\u0003V$\u0017\u000e^'fiJL7m\u001d\u000b\u0002\u001b\u0006A!/Z:fi*{'\rF\u0002I\u0005\u000fAaA!\u0003#\u0001\u0004A\u0015\u0001\u00038fo*{'-\u00133\u0002\u001b\u0005+H-\u001b;SKB|'\u000f^3s!\t!Ee\u0005\u0002%aQ\u0011!QB\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0007\n]\u0001\"\u0002\u001f'\u0001\u0004i\u0004")
public class AuditReporter
implements Logging {
    private final DurabilityMetricsManager metricManager;
    private int jobId;
    private final HashMap<TopicPartition, OffsetCount> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static AuditReporter apply(DurabilityMetricsManager metricManager) {
        return new AuditReporter(metricManager);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, OffsetCount> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    public HashMap<TopicPartition, OffsetCount> getScoringMap() {
        return this.scoringMap();
    }

    public OffsetCount getDurabilityCounters(TopicPartition id) {
        return (OffsetCount)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable)() -> new OffsetCount(0L, 0L));
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapse, String msg, boolean score, boolean isOnDemandAudit, Option<String> mirrorState) {
        void var17_15;
        void var16_14;
        ObjectRef lapseType = ObjectRef.create((Object)lapse);
        String customerFacing = score ? "Customer impacting" : "Non Customer impacting";
        ObjectRef lapseMsg = ObjectRef.create((Object)new StringBuilder(13).append(customerFacing).append(" ").append(msg).append("\n").append("lapseType: ").append((Enumeration.Value)lapseType.elem).toString());
        mirrorState.foreach((Function1 & Serializable)state -> {
            AuditReporter.$anonfun$reportDurabilityLapse$1(lapseMsg, lapseType, state);
            return BoxedUnit.UNIT;
        });
        Enumeration.Value value = (Enumeration.Value)lapseType.elem;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.error((Function0<String>)(Function0 & Serializable)() -> (String)lapseMsg$1.elem);
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss((Enumeration.Value)lapseType.elem, lossCount);
            }
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var16_14 != false) {
            if (score) {
                this.error((Function0<String>)(Function0 & Serializable)() -> (String)lapseMsg$1.elem);
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> (String)lapseMsg$1.elem);
            }
            if (!isOnDemandAudit) {
                this.metricManager.reportDurabilityLoss((Enumeration.Value)lapseType.elem, lossCount);
            }
        }
        if (var17_15 != false) {
            if (var16_14 == false) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Duplicate ").append((String)lapseMsg$1.elem).toString());
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
                    this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(offsetCount.total(), offsetCount.loss() + lossCount));
                    return;
                }
                this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(0L, lossCount));
                return;
            }
            return;
        }
    }

    public boolean reportDurabilityLapse$default$7() {
        return false;
    }

    public Option<String> reportDurabilityLapse$default$8() {
        return None$.MODULE$;
    }

    public void resetTopicPartition(TopicPartition topicPartition) {
        if (this.scoringMap().contains((Object)topicPartition)) {
            this.scoringMap().remove((Object)topicPartition);
        }
        this.segmentOffsetMap().remove(topicPartition);
    }

    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            OffsetCount offsetCount = (OffsetCount)this.scoringMap().apply((Object)topicPartition);
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, offsetCount.loss() + totalLapse));
            l = offsetCount.loss() + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new OffsetCount(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Instant startAuditJob() {
        return this.metricManager.startAuditJob();
    }

    public Instant startAuditCompactionJob() {
        return this.metricManager.startAuditCompactionJob();
    }

    public long fetchCompactedPartitionDataValidationSkipped() {
        return this.metricManager.fetchCompactedPartitionDataValidationSkipped();
    }

    public void addTierAuditErrors(long count) {
        this.metricManager.addTierAuditError(count);
    }

    public void addTierAuditUnknownExceptions(long count) {
        this.metricManager.addTierAuditUnknownExceptions(count);
    }

    public void addTierAuditRetryExceptions(long count) {
        this.metricManager.addTierAuditRetryExceptions(count);
    }

    public void addCompactedPartitionSkipped(long count) {
        this.metricManager.addCompactedPartitionSkipped(count);
    }

    public void addCompactedPartitionDataValidationSkipped(long count) {
        this.metricManager.addCompactedPartitionDataValidationSkipped(count);
    }

    public void addCompactedPartitionDataValidated(long count) {
        this.metricManager.addCompactedPartitionDataValidated(count);
    }

    public void addTierSegmentsAudited(long count) {
        this.metricManager.addTierSegmentsAudited(count);
    }

    public void addCompactedPartitionIdle(long count) {
        this.metricManager.addCompactedPartitionIdle(count);
    }

    public void addCompactedPartitionAudited(long count) {
        this.metricManager.addCompactedPartitionAudited(count);
    }

    public void updateAuditDbSize(long size) {
        this.metricManager.updateDurabilityAuditDbSize(size);
    }

    public void addDAConsumerProcessedRecords(long count) {
        this.metricManager.addDAConsumerProcessedRecords(count);
    }

    public void resetAuditMetrics() {
        this.metricManager.resetAuditMetrics();
    }

    public int resetJob(int newJobId) {
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return old;
    }

    public static final /* synthetic */ void $anonfun$reportDurabilityLapse$1(ObjectRef lapseMsg$1, ObjectRef lapseType$1, String state) {
        lapseMsg$1.elem = new StringBuilder(14).append((String)lapseMsg$1.elem).append(" mirrorState: ").append(state).toString();
        lapseType$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionLapse();
    }

    public AuditReporter(DurabilityMetricsManager metricManager) {
        this.metricManager = metricManager;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

