/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.DeserializerTrait;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent;
import kafka.durability.events.broker.ClusterLinkTruncationEvent$TruncationType$;
import kafka.durability.events.broker.DeletePartitionEvent;
import kafka.durability.events.broker.DeleteRecordsEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.InjectStateEvent;
import kafka.durability.events.broker.IsrExpandEvent;
import kafka.durability.events.broker.MirrorStateChangeEvent;
import kafka.durability.events.broker.OffsetChangeEvent;
import kafka.durability.events.broker.RetentionChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.events.broker.StartOffsetChangeEvent$;
import kafka.durability.events.controller.AbstractControllerDurabilityEvent;
import kafka.durability.materialization.AbstractDurabilityEventsMaterialize;
import kafka.durability.materialization.validation.BrokerValidator;
import kafka.server.ReplicaManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u0015+\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011)\u0019!C!}!IA\t\u0001B\u0001B\u0003%q(\u0012\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003\\\u0001\u0011\u0005A\f\u0003\u0005c\u0001\t\u0007I\u0011\t\u0016d\u0011\u0019Q\u0007\u0001)A\u0005I\")1\u000e\u0001C!Y\"A!\u0010\u0001EC\u0002\u0013\u00053\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003\u0002CA:\u0001\u0011\u0005!&!\u001e\t\u0015\u0005%\u0005!%A\u0005\u0002)\nY\t\u0003\u0006\u0002\"\u0002\t\n\u0011\"\u0001+\u0003GC\u0001\"a*\u0001\t\u0003Q\u0013\u0011\u0016\u0005\u000b\u0003;\u0004\u0011\u0013!C\u0001U\u0005-\u0005BCAp\u0001E\u0005I\u0011\u0001\u0016\u0002$\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\b\"\u0003B\u0002\u0001E\u0005I\u0011\u0002B\u0003\u0011!\u0011I\u0001\u0001C\u0001U\t-\u0001B\u0003B\r\u0001E\u0005I\u0011\u0001\u0016\u0002\f\"Q!1\u0004\u0001\u0012\u0002\u0013\u0005!&a)\t\u0011\tu\u0001\u0001\"\u0001+\u0005?A!Ba\f\u0001#\u0003%\tAKAF\u0011!\u0011\t\u0004\u0001C\u0001U\tM\u0002\u0002\u0003B\u001c\u0001\u0011\u0005!F!\u000f\t\u0015\t%\u0003!%A\u0005\u0002)\nY\t\u0003\u0005\u0003L\u0001!\tA\u000bB'\u0011!\u0011Y\u0006\u0001C\u0001U\tu\u0003\u0002\u0003B5\u0001\u0011\u0005!Fa\u001b\t\u0015\tm\u0004!%A\u0005\u0002)\nY\t\u0003\u0005\u0003~\u0001!\tA\u000bB@\u0011)\u0011y\tAI\u0001\n\u0003Q\u00131\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u0011i\n\u0001C\u0001\u0005?CqAa,\u0001\t\u0003\u0011\t\fC\u0004\u00038\u0002!\tA!/\t\u0013\t\u0005\u0007!%A\u0005\u0002\u0005-%!\t\"s_.,'\u000fR;sC\nLG.\u001b;z\u000bZ,g\u000e^:NCR,'/[1mSj,'BA\u0016-\u0003=i\u0017\r^3sS\u0006d\u0017N_1uS>t'BA\u0017/\u0003)!WO]1cS2LG/\u001f\u0006\u0002_\u0005)1.\u00194lC\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001+\u0013\t)$FA\u0012BEN$(/Y2u\tV\u0014\u0018MY5mSRLXI^3oiNl\u0015\r^3sS\u0006d\u0017N_3\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011\u0001hO\u0007\u0002s)\u0011!HL\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005qJ$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0003I\n,\u0012a\u0010\t\u0003\u0001\nk\u0011!\u0011\u0006\u0003{1J!aQ!\u0003\u0019\u0011+(/\u00192jY&$\u0018\u0010\u0012\"\u0002\u0007\u0011\u0014\u0007%\u0003\u0002>i\u0005A!/\u001a9peR,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002KY\u0005)\u0011-\u001e3ji&\u0011A*\u0013\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u0002\tQLW.\u001a\t\u0003\u001ffk\u0011\u0001\u0015\u0006\u0003#J\u000bQ!\u001e;jYNT!a\u0015+\u0002\r\r|W.\\8o\u0015\tySK\u0003\u0002W/\u00061\u0011\r]1dQ\u0016T\u0011\u0001W\u0001\u0004_J<\u0017B\u0001.Q\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u0015ifl\u00181b!\t\u0019\u0004\u0001C\u00037\r\u0001\u0007q\u0007C\u0003>\r\u0001\u0007q\bC\u0003G\r\u0001\u0007q\tC\u0003N\r\u0001\u0007a*A\u0005wC2LG-\u0019;peV\tA\r\u0005\u0002fQ6\taM\u0003\u0002hU\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\u0005%4'a\u0004\"s_.,'OV1mS\u0012\fGo\u001c:\u0002\u0015Y\fG.\u001b3bi>\u0014\b%\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\u0012!\u001c\t\u0003]^t!a\\;\u0011\u0005A\u001cX\"A9\u000b\u0005I\u0004\u0014A\u0002\u001fs_>$hHC\u0001u\u0003\u0015\u00198-\u00197b\u0013\t18/\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<t\u0003\u0019awnZ4feV\tA\u0010E\u0002~\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001D:dC2\fGn\\4hS:<'\u0002BA\u0002\u0003\u000b\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003\u000f\t1aY8n\u0013\r\tYA \u0002\u0007\u0019><w-\u001a:\u0002\u00175\fG/\u001a:jC2L'0\u001a\u000b\u0005\u0003#\tI\u0002\u0005\u0003\u0002\u0014\u0005UQ\"A:\n\u0007\u0005]1OA\u0004C_>dW-\u00198\t\u000f\u0005m1\u00021\u0001\u0002\u001e\u00051!/Z2pe\u0012\u0004\u0002\"a\b\u0002*\u00055\u0012QF\u0007\u0003\u0003CQA!a\t\u0002&\u0005A1m\u001c8tk6,'OC\u0002\u0002(Q\u000bqa\u00197jK:$8/\u0003\u0003\u0002,\u0005\u0005\"AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0007\u0003'\ty#a\r\n\u0007\u0005E2OA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u0014\u0005U\u0012bAA\u001cg\n!!)\u001f;f\u0003ai\u0017\r^3sS\u0006d\u0017N_3J]*,7\r^3e'R\fG/\u001a\u000b\u0005\u0003{\t\u0019\u0005\u0005\u0003\u0002\u0014\u0005}\u0012bAA!g\n!QK\\5u\u0011\u001d\t)\u0005\u0004a\u0001\u0003\u000f\n\u0001#\u001b8kK\u000e$8\u000b^1uK\u00163XM\u001c;\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u00051!M]8lKJT1!!\u0015-\u0003\u0019)g/\u001a8ug&!\u0011QKA&\u0005AIeN[3diN#\u0018\r^3Fm\u0016tG/\u0001\u000fnCR,'/[1mSj,wJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u0011\u0005u\u00121LA3\u0003_Bq!!\u0018\u000e\u0001\u0004\ty&A\tpM\u001a\u001cX\r^\"iC:<W-\u0012<f]R\u0004B!!\u0013\u0002b%!\u00111MA&\u0005EyeMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003Oj\u0001\u0019AA5\u0003\u0015\u0019H/\u0019;f!\r\u0001\u00151N\u0005\u0004\u0003[\n%A\u0004)beRLG/[8o'R\fG/\u001a\u0005\u0007\u0003cj\u0001\u0019A7\u0002\u00115,G/\u00193bi\u0006\fA$\\1uKJL\u0017\r\\5{K\u0012+G.\u001a;f%\u0016\u001cwN\u001d3Fm\u0016tG\u000f\u0006\u0006\u0002>\u0005]\u0014\u0011QAB\u0003\u000bCq!!\u001f\u000f\u0001\u0004\tY(\u0001\neK2,G/\u001a*fG>\u0014Hm]#wK:$\b\u0003BA%\u0003{JA!a \u0002L\t\u0011B)\u001a7fi\u0016\u0014VmY8sIN,e/\u001a8u\u0011\u001d\t9G\u0004a\u0001\u0003SB\u0001\"!\u001d\u000f!\u0003\u0005\r!\u001c\u0005\n\u0003\u000fs\u0001\u0013!a\u0001\u0003#\t1$\u001e9eCR,wJ\u001c7z\u0007>lW.\u001b;Ti\u0006\u0014Ho\u00144gg\u0016$\u0018AJ7bi\u0016\u0014\u0018.\u00197ju\u0016$U\r\\3uKJ+7m\u001c:e\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0012\u0016\u0004[\u0006=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m5/\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002M5\fG/\u001a:jC2L'0\u001a#fY\u0016$XMU3d_J$WI^3oi\u0012\"WMZ1vYR$C'\u0006\u0002\u0002&*\"\u0011\u0011CAH\u0003}i\u0017\r^3sS\u0006d\u0017N_3IS\u001eDw+\u0019;fe6\f'o[\"iC:<Wm\u001d\u000b\u0011\u0003{\tY+a.\u0002B\u0006-\u0017Q[Al\u00033Dq!!,\u0012\u0001\u0004\ty+\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u00161W\u0007\u0002%&\u0019\u0011Q\u0017*\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011X\tA\u0002\u0005m\u0016!B3q_\u000eD\u0007\u0003BA\n\u0003{K1!a0t\u0005\rIe\u000e\u001e\u0005\b\u0003\u0007\f\u0002\u0019AAc\u0003\rAw/\u001c\t\u0005\u0003'\t9-C\u0002\u0002JN\u0014A\u0001T8oO\"9\u0011QZ\tA\u0002\u0005=\u0017aA5teB)a.!5\u0002<&\u0019\u00111[=\u0003\u0007M+G\u000fC\u0004\u0002hE\u0001\r!!\u001b\t\u0011\u0005E\u0014\u0003%AA\u00025D\u0011\"a7\u0012!\u0003\u0005\r!!\u0005\u0002-Q\u0014\u0018nZ4fe\u0016$')_#q_\u000eD7\t[1oO\u0016\f\u0011&\\1uKJL\u0017\r\\5{K\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0007\"\fgnZ3tI\u0011,g-Y;mi\u00122\u0014!K7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$s'A\u0011nC.,w)\u001a8fe&\u001c7\u000b^1si>3gm]3u\u0007\"\fgnZ3Fm\u0016tG\u000f\u0006\b\u0002f\u0006-\u0018Q_A|\u0003w\fiP!\u0001\u0011\t\u0005%\u0013q]\u0005\u0005\u0003S\fYE\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\ti\u000f\u0006a\u0001\u0003_\f!!\u001b3\u0011\t\u0005E\u0016\u0011_\u0005\u0004\u0003g\u0014&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\tI\f\u0006a\u0001\u0003wCq!!?\u0015\u0001\u0004\t)-A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bbBAb)\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u007f$\u0002\u0019AA^\u0003\u0019qw\u000eZ3JI\"I\u0011Q\u001a\u000b\u0011\u0002\u0003\u0007\u0011qZ\u0001,[\u0006\\WmR3oKJL7m\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!q\u0001\u0016\u0005\u0003\u001f\fy)\u0001\fnCR,'/[1mSj,7\u000b^1si>3gm]3u))\tiD!\u0004\u0003\u0012\tM!Q\u0003\u0005\b\u0005\u001f1\u0002\u0019AAs\u0003Y\u0019H/\u0019:u\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$\bbBA4-\u0001\u0007\u0011\u0011\u000e\u0005\t\u0003c2\u0002\u0013!a\u0001[\"I!q\u0003\f\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\fm\u0006d\u0017\u000eZ1uK\";V*\u0001\u0011nCR,'/[1mSj,7\u000b^1si>3gm]3uI\u0011,g-Y;mi\u0012\u001a\u0014\u0001I7bi\u0016\u0014\u0018.\u00197ju\u0016\u001cF/\u0019:u\u001f\u001a47/\u001a;%I\u00164\u0017-\u001e7uIQ\n1$\\1uKJL\u0017\r\\5{K\u0016\u0003xn\u00195DQ\u0006tw-Z#wK:$H\u0003CA\u001f\u0005C\u0011YC!\f\t\u000f\t\r\u0012\u00041\u0001\u0003&\u0005\u0001R\r]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\t\u0005\u0003\u0013\u00129#\u0003\u0003\u0003*\u0005-#\u0001E#q_\u000eD7\t[1oO\u0016,e/\u001a8u\u0011\u001d\t9'\u0007a\u0001\u0003SB\u0001\"!\u001d\u001a!\u0003\u0005\r!\\\u0001&[\u0006$XM]5bY&TX-\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM\n!\u0003\u001e:v]\u000e\fG/Z#q_\u000eD7\t[1j]R!\u0011Q\bB\u001b\u0011\u001d\t9g\u0007a\u0001\u0003S\n\u0011$\\1uKJL\u0017\r\\5{K&\u001b&+\u0012=qC:$WI^3oiRA\u0011Q\bB\u001e\u0005\u000b\u00129\u0005C\u0004\u0003>q\u0001\rAa\u0010\u0002\u001d%\u001c(/\u0012=qC:$WI^3oiB!\u0011\u0011\nB!\u0013\u0011\u0011\u0019%a\u0013\u0003\u001d%\u001b(/\u0012=qC:$WI^3oi\"9\u0011q\r\u000fA\u0002\u0005%\u0004\u0002CA99A\u0005\t\u0019A7\u0002G5\fG/\u001a:jC2L'0Z%T%\u0016C\b/\u00198e\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005yR.\u0019;fe&\fG.\u001b>f%\u0016$XM\u001c;j_:\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\r\u0005u\"q\nB-\u0011\u001d\u0011\tF\ba\u0001\u0005'\nAC]3uK:$\u0018n\u001c8DQ\u0006tw-Z#wK:$\b\u0003BA%\u0005+JAAa\u0016\u0002L\t!\"+\u001a;f]RLwN\\\"iC:<W-\u0012<f]RDq!a\u001a\u001f\u0001\u0004\tI'\u0001\u000enCR,'/[1mSj,G)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002>\t}\u0003b\u0002B1?\u0001\u0007!1M\u0001\u0015I\u0016dW\r^3QCJ$\u0018\u000e^5p]\u00163XM\u001c;\u0011\t\u0005%#QM\u0005\u0005\u0005O\nYE\u0001\u000bEK2,G/\u001a)beRLG/[8o\u000bZ,g\u000e^\u0001&[\u0006$XM]5bY&TXm\u00117vgR,'\u000fT5oWR\u0013XO\\2bi&|g.\u0012<f]R$\u0002\"!\u0010\u0003n\t]$\u0011\u0010\u0005\b\u0005_\u0002\u0003\u0019\u0001B9\u0003i\u0019G.^:uKJd\u0015N\\6UeVt7-\u0019;j_:,e/\u001a8u!\u0011\tIEa\u001d\n\t\tU\u00141\n\u0002\u001b\u00072,8\u000f^3s\u0019&t7\u000e\u0016:v]\u000e\fG/[8o\u000bZ,g\u000e\u001e\u0005\b\u0003O\u0002\u0003\u0019AA5\u0011!\t\t\b\tI\u0001\u0002\u0004i\u0017aL7bi\u0016\u0014\u0018.\u00197ju\u0016\u001cE.^:uKJd\u0015N\\6UeVt7-\u0019;j_:,e/\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014!I7bi\u0016\u0014\u0018.\u00197ju\u0016l\u0015N\u001d:peN#\u0018\r^3DQ\u0006tw-Z#wK:$H\u0003CA\u001f\u0005\u0003\u0013YI!$\t\u000f\t\r%\u00051\u0001\u0003\u0006\u00061R.\u001b:s_J\u001cF/\u0019;f\u0007\"\fgnZ3Fm\u0016tG\u000f\u0005\u0003\u0002J\t\u001d\u0015\u0002\u0002BE\u0003\u0017\u0012a#T5se>\u00148\u000b^1uK\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003O\u0012\u0003\u0019AA5\u0011!\t\tH\tI\u0001\u0002\u0004i\u0017aK7bi\u0016\u0014\u0018.\u00197ju\u0016l\u0015N\u001d:peN#\u0018\r^3DQ\u0006tw-Z#wK:$H\u0005Z3gCVdG\u000fJ\u001a\u0002!5\fG/\u001a:jC2L'0Z*uCR,G\u0003CA\u001f\u0005+\u00139J!'\t\u000f\u0005\u001dD\u00051\u0001\u0002j!9\u0011\u0011\u0018\u0013A\u0002\u0005m\u0006b\u0002BNI\u0001\u0007\u0011q^\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f!c\u001d;bY\u0016$v\u000e]5d\u0013\u0012,e/\u001a8ugR1\u0011\u0011\u0003BQ\u0005[CqAa)&\u0001\u0004\u0011)+A\u0003fm\u0016tG\u000f\u0005\u0003\u0003(\n%VBAA(\u0013\u0011\u0011Y+a\u0014\u0003/\u0005\u00137\u000f\u001e:bGR$UO]1cS2LG/_#wK:$\bbBA4K\u0001\u0007\u0011\u0011N\u0001\u001aG\",7m['jgNLgn\u001a+pa&\u001cG)\u001a7fi&|g\u000e\u0006\u0004\u0002>\tM&Q\u0017\u0005\b\u0005G3\u0003\u0019\u0001BS\u0011\u001d\t9G\na\u0001\u0003S\n\u0011\u0003[1oI2,7\u000b^1mK\u00163XM\u001c;t)!\t\tBa/\u0003>\n}\u0006b\u0002BRO\u0001\u0007!Q\u0015\u0005\b\u0003O:\u0003\u0019AA5\u0011!\t\th\nI\u0001\u0002\u0004i\u0017a\u00075b]\u0012dWm\u0015;bY\u0016,e/\u001a8ug\u0012\"WMZ1vYR$3\u0007")
public class BrokerDurabilityEventsMaterialize
extends AbstractDurabilityEventsMaterialize {
    private Logger logger;
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final BrokerValidator validator;
    private volatile boolean bitmap$0;

    @Override
    public DurabilityDB db() {
        return super.db();
    }

    @Override
    public BrokerValidator validator() {
        return this.validator;
    }

    @Override
    public String loggerName() {
        return BrokerDurabilityEventsMaterialize.class.getName();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean materialize(ConsumerRecord<byte[], byte[]> record) {
        void deserialize_value;
        void deserialize_key;
        byte[] byArray = (byte[])((byte[])record.value()).clone();
        byte[] byArray2 = (byte[])((byte[])record.key()).clone();
        Deserializer$ deserialize_this = Deserializer$.MODULE$;
        Object var17_4 = null;
        byArray2 = null;
        byArray = null;
        AbstractDurabilityEvent event = DeserializerTrait.deserialize$(deserialize_this, (byte[])deserialize_key, (byte[])deserialize_value);
        String metadata = new StringBuilder(24).append("Durability audits topic ").append(Utils$.MODULE$.consumerRecordMetadata(record)).toString();
        this.reporter.addDAConsumerProcessedRecords(1L);
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            if (healthCheckEvent.nodeId() == Utils$.MODULE$.getBrokerId(this.replicaManager)) {
                this.materializeHealthCheck(healthCheckEvent);
            }
            return true;
        }
        if (event instanceof InjectStateEvent) {
            InjectStateEvent injectStateEvent = (InjectStateEvent)event;
            this.materializeInjectedState(injectStateEvent);
            return true;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return false;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() == state.latestEpoch() && record.timestamp() < state.latestTimestamp()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Ignoring event ").append(event).append(" with epoch ").append(event.epoch()).append(" as it's from retry and duplicate.").append("Current epoch is ").append(state.latestEpoch()).append(" and state ts: record ts: ").append(record.timestamp()).toString());
            return false;
        }
        this.checkMissingTopicDeletion(event, state);
        if (event.epoch() < state.latestEpoch() || this.staleTopicIdEvents(event, state)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Ignoring event ").append(event).append(". Current state is ").append(state).toString());
            return this.handleStaleEvents(event, state, metadata);
        }
        state.latestTimestamp_$eq(record.timestamp());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state, metadata);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, false);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state, metadata);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state, metadata);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, metadata, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).append(" ").append(metadata).toString());
                return true;
            }
            if (event instanceof AbstractControllerDurabilityEvent) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Broker materialization rejected for ControllerDurabilityEvent ").append(event).toString());
                return false;
            }
            if (event instanceof ClusterLinkTruncationEvent) {
                ClusterLinkTruncationEvent clusterLinkTruncationEvent = (ClusterLinkTruncationEvent)event;
                this.materializeClusterLinkTruncationEvent(clusterLinkTruncationEvent, state, this.materializeClusterLinkTruncationEvent$default$3());
            } else if (event instanceof MirrorStateChangeEvent) {
                MirrorStateChangeEvent mirrorStateChangeEvent = (MirrorStateChangeEvent)event;
                this.materializeMirrorStateChangeEvent(mirrorStateChangeEvent, state, metadata);
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("DurabilityMaterialization: Ignoring unexpected durability event type ").append(event.eventType()).append(": ").append(event).append(",").append(" ").append(metadata).toString());
                return false;
            }
        }
        this.materializeState(state, event.epoch(), event.topicIdPartition());
        this.db().addPartition(event.topicIdPartition().topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
        return true;
    }

    private void materializeInjectedState(InjectStateEvent injectStateEvent) {
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(injectStateEvent.topicIdPartition().topicPartition());
        if (stateOpt.isEmpty()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (injectStateEvent.removePartition()) {
            this.db().deletePartition(injectStateEvent.topicIdPartition().topicPartition());
        } else {
            if (injectStateEvent.epoch() != -1) {
                state.latestEpoch_$eq(injectStateEvent.epoch());
            }
            if (injectStateEvent.highWatermark() != -1L) {
                state.highWatermark_$eq(injectStateEvent.highWatermark());
            }
            if (injectStateEvent.logStartOffset() != -1L) {
                state.committedStartOffset_$eq(injectStateEvent.logStartOffset());
                state.startOffset_$eq(injectStateEvent.logStartOffset());
            }
            if (injectStateEvent.config() != -1L) {
                state.config_$eq(injectStateEvent.config());
            }
            this.db().addPartition(injectStateEvent.topicIdPartition().topicPartition(), state);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Updated the durabilityDB due to injected Event ").append(injectStateEvent).append(" with new state ").append(state).toString());
    }

    private void materializeOffsetChangeEvent(OffsetChangeEvent offsetChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(offsetChangeEvent.topicIdPartition().topicPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.highWatermark(), offsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(offsetChangeEvent.topicIdPartition(), offsetChangeEvent.epoch(), offsetChangeEvent.logStartOffset(), offsetChangeEvent.highWatermark(), offsetChangeEvent.nodeId(), offsetChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state, String metadata, boolean updateOnlyCommitStartOffset) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        if (updateOnlyCommitStartOffset) {
            return;
        }
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicIdPartition().topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicIdPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state, metadata, this.materializeStartOffset$default$4());
    }

    public String materializeDeleteRecordEvent$default$3() {
        return "";
    }

    public boolean materializeDeleteRecordEvent$default$4() {
        return false;
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata, boolean triggeredByEpochChange) {
        boolean shouldApplyHighWatermarkChange = this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, metadata, triggeredByEpochChange);
        if (this.validator().isInISR(topicPartition)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, isr, state, metadata);
        }
        if (shouldApplyHighWatermarkChange) {
            state.highWatermark_$eq(hwm);
            return;
        }
    }

    public String materializeHighWatermarkChanges$default$6() {
        return "";
    }

    public boolean materializeHighWatermarkChanges$default$7() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicIdPartition id, int epoch, long startOffset, long hwm, int nodeId, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr, nodeId);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$6() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent startOffsetChangeEvent, PartitionState state, String metadata, boolean validateHWM) {
        block11: {
            block10: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block9: {
                    if (this.validator().isInSync(startOffsetChangeEvent.isr()) && state.committedStartOffset() < startOffsetChangeEvent.logStartOffset() && this.validator().validateDBLogStartOffset(startOffsetChangeEvent, state, metadata)) {
                        this.validator().validateLocalLogStartOffset(startOffsetChangeEvent.topicIdPartition(), state.mirrorState(), startOffsetChangeEvent.logStartOffset(), metadata);
                        state.committedStartOffset_$eq(startOffsetChangeEvent.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(Math.max(startOffsetChangeEvent.logStartOffset(), state.committedStartOffset()));
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(startOffsetChangeEvent.topicIdPartition().topicPartition(), startOffsetChangeEvent.epoch(), startOffsetChangeEvent.highWatermark(), startOffsetChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
                    }
                    state.startOffset_$eq(startOffsetChangeEvent.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(startOffsetChangeEvent.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(startOffsetChangeEvent.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block9;
                    if (value != null) {
                        return;
                    }
                    break block10;
                }
                if (!value2.equals(value)) break block11;
            }
            state.retentionMs_$eq(startOffsetChangeEvent.retentionValue());
            return;
        }
    }

    public String materializeStartOffset$default$3() {
        return "";
    }

    public boolean materializeStartOffset$default$4() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state, String metadata) {
        this.validator().validateDBEpochChange(epochChangeEvent, state, metadata);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicIdPartition().topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, metadata, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicIdPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.nodeId(), epochChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent, state.mirrorState(), metadata);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        this.truncateEpochChain(state);
    }

    public String materializeEpochChangeEvent$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public void truncateEpochChain(PartitionState state) {
        if (((Tuple2)state.epochChain().min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$)))._2$mcJ$sp() < state.startOffset() && state.epochChain().size() > 2) {
            BufferedIterator iterator = ((List)state.epochChain().toList().sortWith((Function2 & Serializable)(cur, next) -> BoxesRunTime.boxToBoolean((boolean)BrokerDurabilityEventsMaterialize.$anonfun$truncateEpochChain$1(cur, next)))).iterator().buffered();
            boolean continueLoop = true;
            while (iterator.hasNext() && continueLoop) {
                void var10_9;
                void var6_6;
                void var9_8;
                void var5_5;
                Tuple2 tuple2 = (Tuple2)iterator.next();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                int curEpoch = tuple2._1$mcI$sp();
                long curFirstOffset = tuple2._2$mcJ$sp();
                if (!iterator.hasNext()) continue;
                Tuple2 tuple22 = (Tuple2)iterator.head();
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                int nextEpoch = tuple22._1$mcI$sp();
                long nextFirstOffset = tuple22._2$mcJ$sp();
                if (var5_5 < var9_8 && var6_6 <= var10_9) {
                    if (var6_6 < state.startOffset() && var10_9 < state.startOffset()) {
                        state.epochChain().remove((Object)BoxesRunTime.boxToInteger((int)var5_5));
                        continue;
                    }
                    continueLoop = false;
                    continue;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(117).append("Epoch chain map is not in the sorted order: \ncurrent (Epoch, firstOffset) are (").append((int)var5_5).append(", ").append((long)var6_6).append(")\n").append("next (Epoch, firstOffset) are (").append((int)var9_8).append(", ").append((long)var10_9).append(")").toString());
                }
                continueLoop = false;
            }
            return;
        }
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state, String metadata) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicIdPartition().topicPartition(), state, metadata);
    }

    public String materializeISRExpandEvent$default$3() {
        return "";
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
        if (retentionChangeEvent.isCompacted()) {
            state.config_$eq(ConfigFlag$.MODULE$.OnceCompacted().id());
            return;
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent deletePartitionEvent) {
        this.db().deletePartition(deletePartitionEvent.topicIdPartition().topicPartition());
    }

    public void materializeClusterLinkTruncationEvent(ClusterLinkTruncationEvent clusterLinkTruncationEvent, PartitionState state2, String metadata) {
        block8: {
            block10: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block9: {
                    boolean bl = false;
                    Some some = null;
                    Option option = Option$.MODULE$.apply((Object)ClusterLinkTruncationEvent$TruncationType$.MODULE$.apply(clusterLinkTruncationEvent.truncationType()));
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        Enumeration.Value value3 = (Enumeration.Value)some.value();
                        Enumeration.Value value4 = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateHWM();
                        if (!(value4 != null ? !value4.equals(value3) : value3 != null)) {
                            long truncateOffsetTo;
                            if (state2.clusterLinkMirrorState().exists((Function1 & Serializable)state -> BoxesRunTime.boxToBoolean((boolean)state.isTruncationBelowHighWatermarkAllowed())) && (truncateOffsetTo = clusterLinkTruncationEvent.truncateOffsetTo()) < state2.highWatermark()) {
                                state2.highWatermark_$eq(truncateOffsetTo);
                            }
                            this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), clusterLinkTruncationEvent.isr()), state2, metadata, this.materializeStartOffset$default$4());
                            return;
                        }
                    }
                    if (!bl) break block8;
                    value2 = (Enumeration.Value)some.value();
                    value = ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateLSO();
                    if (value != null) break block9;
                    if (value2 != null) {
                        return;
                    }
                    break block10;
                }
                if (!value.equals(value2)) break block8;
            }
            state2.committedStartOffset_$eq(package$.MODULE$.max(state2.committedStartOffset(), clusterLinkTruncationEvent.truncateOffsetTo()));
            state2.lapseWatchStartTime_$eq(0L);
            this.materializeHighWatermarkChanges(clusterLinkTruncationEvent.topicIdPartition().topicPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.isr(), state2, metadata, this.materializeHighWatermarkChanges$default$7());
            this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(clusterLinkTruncationEvent.topicIdPartition(), clusterLinkTruncationEvent.epoch(), clusterLinkTruncationEvent.logStartOffset(), clusterLinkTruncationEvent.highWatermark(), clusterLinkTruncationEvent.nodeId(), this.makeGenericStartOffsetChangeEvent$default$6()), state2, metadata, this.materializeStartOffset$default$4());
            return;
        }
    }

    public String materializeClusterLinkTruncationEvent$default$3() {
        return "";
    }

    public void materializeMirrorStateChangeEvent(MirrorStateChangeEvent mirrorStateChangeEvent, PartitionState state, String metadata) {
        this.materializeHighWatermarkChanges(mirrorStateChangeEvent.topicIdPartition().topicPartition(), mirrorStateChangeEvent.epoch(), mirrorStateChangeEvent.highWatermark(), mirrorStateChangeEvent.isr(), state, metadata, this.materializeHighWatermarkChanges$default$7());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(mirrorStateChangeEvent.topicIdPartition(), mirrorStateChangeEvent.epoch(), mirrorStateChangeEvent.logStartOffset(), mirrorStateChangeEvent.highWatermark(), mirrorStateChangeEvent.nodeId(), mirrorStateChangeEvent.isr()), state, metadata, this.materializeStartOffset$default$4());
        state.mirrorState_$eq(mirrorStateChangeEvent.mirrorState());
    }

    public String materializeMirrorStateChangeEvent$default$3() {
        return "";
    }

    private void materializeState(PartitionState state, int epoch, TopicIdPartition topicIdPartition) {
        if (epoch != -1) {
            state.latestEpoch_$eq(epoch);
        }
        state.topicId_$eq(topicIdPartition.topicId());
    }

    public boolean staleTopicIdEvents(AbstractDurabilityEvent event, PartitionState state) {
        Uuid uuid = state.topicId();
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
            Uuid uuid3 = event.topicIdPartition().topicId();
            Uuid uuid4 = Uuid.ZERO_UUID;
            if (!(uuid3 != null ? !uuid3.equals(uuid4) : uuid4 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void checkMissingTopicDeletion(AbstractDurabilityEvent event, PartitionState state) {
        v0 = state.topicId();
        var4_3 = Uuid.ZERO_UUID;
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = event.topicIdPartition().topicId();
        var5_4 = Uuid.ZERO_UUID;
        if (!(v1 == null ? var5_4 != null : v1.equals(var5_4) == false)) ** GOTO lbl-1000
        v2 = event.topicIdPartition().topicId();
        var6_5 = state.topicId();
        if (v2 == null ? var6_5 != null : v2.equals(var6_5) == false) {
            reset = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = event instanceof EpochChangeEvent ? (var7_7 = (EpochChangeEvent)event).epoch() == 0 && var7_7.firstOffset() == 0L && var7_7.highWatermark() <= 0L : (reset = false);
        }
        if (reset) {
            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkMissingTopicDeletion$1(kafka.durability.events.AbstractDurabilityEvent kafka.durability.db.PartitionState ), ()Ljava/lang/String;)((AbstractDurabilityEvent)event, (PartitionState)state));
            state.reset();
            state.topicId_$eq(event.topicIdPartition().topicId());
            this.reporter.resetTopicPartition(event.topicIdPartition().topicPartition());
            return;
        }
    }

    public boolean handleStaleEvents(AbstractDurabilityEvent event, PartitionState state, String metadata) {
        if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state, metadata, true);
            return true;
        }
        return false;
    }

    public String handleStaleEvents$default$3() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$truncateEpochChain$1(Tuple2 cur, Tuple2 next) {
        return cur._1$mcI$sp() < next._1$mcI$sp();
    }

    public static final /* synthetic */ String $anonfun$checkMissingTopicDeletion$1(AbstractDurabilityEvent event$2, PartitionState state$3) {
        return new StringBuilder(44).append("Durability partition reset for ").append(event$2).append(" old topicID ").append(state$3.topicId()).toString();
    }

    public BrokerDurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        super(db, reporter, time);
        this.validator = new BrokerValidator(replicaManager, reporter, time);
    }
}

