/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization.validation;

import java.io.Serializable;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.validation.AbstractValidator;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\t%c\u0001\u0002\u0014(\u0001AB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005s\bC\u0005G\u0001\t\u0005\t\u0015!\u0003A\u000f\"A\u0001\n\u0001B\u0001B\u0003%\u0011\nC\u0003W\u0001\u0011\u0005q\u000b\u0003\u0005]\u0001\t\u0007I\u0011A\u0015^\u0011\u0019!\u0007\u0001)A\u0005=\"9Q\r\u0001b\u0001\n\u0013i\u0006B\u00024\u0001A\u0003%a\fC\u0004h\u0001\t\u0007I\u0011B/\t\r!\u0004\u0001\u0015!\u0003_\u0011\u001dI\u0007A1A\u0005\nuCaA\u001b\u0001!\u0002\u0013q\u0006\"B6\u0001\t\u0003b\u0007\"\u0002=\u0001\t\u0003I\b\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011%\t)\u0005AI\u0001\n\u0003\t9\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005=\u0002bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003G\u0003A\u0011AAS\u0011%\t9\fAI\u0001\n\u0003\ty\u0003C\u0004\u0002:\u0002!I!a/\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u00111\u001b\u0001\u0005\u0002\u0005U\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013AqA!\u0005\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u0011\t%\u0002\u0001\"\u0001*\u0005WA\u0001Ba\f\u0001\t\u0003I#\u0011G\u0004\n\u0005k9\u0013\u0011!E\u0001\u0005o1\u0001BJ\u0014\u0002\u0002#\u0005!\u0011\b\u0005\u0007-\u000e\"\tA!\u0011\t\u0013\t\r3%%A\u0005\u0002\t\u0015#a\u0004\"s_.,'OV1mS\u0012\fGo\u001c:\u000b\u0005!J\u0013A\u0003<bY&$\u0017\r^5p]*\u0011!fK\u0001\u0010[\u0006$XM]5bY&T\u0018\r^5p]*\u0011A&L\u0001\u000bIV\u0014\u0018MY5mSRL(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eMj\u0011aJ\u0005\u0003i\u001d\u0012\u0011#\u00112tiJ\f7\r\u001e,bY&$\u0017\r^8s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u5\naa]3sm\u0016\u0014\u0018B\u0001\u001f:\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\te\u0016\u0004xN\u001d;feV\t\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002DW\u0005)\u0011-\u001e3ji&\u0011QI\u0011\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u0002\u0013I,\u0007o\u001c:uKJ\u0004\u0013B\u0001 4\u0003\u0011!\u0018.\\3\u0011\u0005)#V\"A&\u000b\u00051k\u0015!B;uS2\u001c(B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011a\u0006\u0015\u0006\u0003#J\u000ba!\u00199bG\",'\"A*\u0002\u0007=\u0014x-\u0003\u0002V\u0017\n!A+[7f\u0003\u0019a\u0014N\\5u}Q!\u0001,\u0017.\\!\t\u0011\u0004\u0001C\u00036\r\u0001\u0007q\u0007C\u0003?\r\u0001\u0007\u0001\tC\u0004I\rA\u0005\t\u0019A%\u00029I+G/\u001a8uS>tG+[7f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:NgV\ta\f\u0005\u0002`E6\t\u0001MC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0007MA\u0002J]R\fQDU3uK:$\u0018n\u001c8US6,W*\u0019:hS:|e-\u0012:s_Jl5\u000fI\u0001\u001b%\u0016$XM\u001c;j_:\u001c\u0016N_3NCJ<\u0017N\\(g\u000bJ\u0014xN]\u0001\u001c%\u0016$XM\u001c;j_:\u001c\u0016N_3NCJ<\u0017N\\(g\u000bJ\u0014xN\u001d\u0011\u000275\u000b\u0007p\u00144gg\u0016$x)\u00199U_2,'/\u00198dKRKW.Z't\u0003qi\u0015\r_(gMN,GoR1q)>dWM]1oG\u0016$\u0016.\\3Ng\u0002\nA&T1y\u0011&<\u0007nV1uKJl\u0017M]6U_2,'/\u00198dK\u001a{'/T5se>\u0014\b+\u0019:uSRLwN\\:\u0002[5\u000b\u0007\u0010S5hQ^\u000bG/\u001a:nCJ\\Gk\u001c7fe\u0006t7-\u001a$pe6K'O]8s!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\u0012!\u001c\t\u0003]Vt!a\\:\u0011\u0005A\u0004W\"A9\u000b\u0005I|\u0013A\u0002\u001fs_>$h(\u0003\u0002uA\u00061\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!\b-A\fwC2LG-\u0019;f\t\nC\u0015n\u001a5XCR,'/\\1sWRa!0`A\u0004\u0003\u0017\t)\"!\n\u0002*A\u0011ql_\u0005\u0003y\u0002\u0014qAQ8pY\u0016\fg\u000eC\u0003\u007f!\u0001\u0007q0\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0005\u00111A\u0007\u0002\u001b&\u0019\u0011QA'\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011\u0011\u0002\tA\u0002y\u000bQ!\u001a9pG\"Dq!!\u0004\u0011\u0001\u0004\ty!A\u0002io6\u00042aXA\t\u0013\r\t\u0019\u0002\u0019\u0002\u0005\u0019>tw\rC\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u000bM$\u0018\r^3\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b,\u0003\t!'-\u0003\u0003\u0002$\u0005u!A\u0004)beRLG/[8o'R\fG/\u001a\u0005\t\u0003O\u0001\u0002\u0013!a\u0001[\u0006AQ.\u001a;bI\u0006$\u0018\r\u0003\u0005\u0002,A\u0001\n\u00111\u0001{\u00035I7/\u00129pG\"\u001c\u0005.\u00198hK\u0006\tc/\u00197jI\u0006$X\r\u0012\"IS\u001eDw+\u0019;fe6\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0007\u0016\u0004[\u0006M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0002-\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002CY\fG.\u001b3bi\u0016$%\tS5hQ^\u000bG/\u001a:nCJ\\G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005%#f\u0001>\u00024\u0005Ib/\u00197jI\u0006$X\rT8dC2dunZ#oI>3gm]3u)9\ty%!\u0016\u0002X\u0005e\u00131LA3\u0003O\u00022aXA)\u0013\r\t\u0019\u0006\u0019\u0002\u0005+:LG\u000fC\u0003\u007f'\u0001\u0007q\u0010\u0003\u0004\u0002\nM\u0001\rA\u0018\u0005\b\u0003\u001b\u0019\u0002\u0019AA\b\u0011\u001d\tif\u0005a\u0001\u0003?\n1![:s!\u0011q\u0017\u0011\r0\n\u0007\u0005\rtOA\u0002TKRDq!a\u0006\u0014\u0001\u0004\tI\u0002\u0003\u0005\u0002(M\u0001\n\u00111\u0001n\u0003\r2\u0018\r\\5eCR,Gj\\2bY2{w-\u00128e\u001f\u001a47/\u001a;%I\u00164\u0017-\u001e7uIY\n\u0011cZ3u%\u0016$XM\u001c;j_:4\u0016\r\\;f)!\ty'!\u001e\u0002x\u0005e\u0004#B0\u0002r\u0005=\u0011bAA:A\n1q\n\u001d;j_:DQA`\u000bA\u0002}Dq!a\u0006\u0016\u0001\u0004\tI\u0002C\u0004\u0002|U\u0001\r!! \u0002\u001bI,G/\u001a8uS>tG+\u001f9f!\u0011\ty(!(\u000f\t\u0005\u0005\u0015q\u0013\b\u0005\u0003\u0007\u000b\tJ\u0004\u0003\u0002\u0006\u00065e\u0002BAD\u0003\u0017s1\u0001]AE\u0013\u0005q\u0013B\u0001\u0017.\u0013\r\tyiK\u0001\u0007KZ,g\u000e^:\n\t\u0005M\u0015QS\u0001\u0007EJ|7.\u001a:\u000b\u0007\u0005=5&\u0003\u0003\u0002\u001a\u0006m\u0015!\u0004*fi\u0016tG/[8o)f\u0004XM\u0003\u0003\u0002\u0014\u0006U\u0015\u0002BAP\u0003C\u0013QBU3uK:$\u0018n\u001c8UsB,'\u0002BAM\u00037\u000b\u0001D^1mS\u0012\fG/\u001a#C\u0019><7\u000b^1si>3gm]3u)\u001dQ\u0018qUAZ\u0003kCq!!+\u0017\u0001\u0004\tY+A\u0003fm\u0016tG\u000f\u0005\u0003\u0002.\u0006=VBAAN\u0013\u0011\t\t,a'\u0003-M#\u0018M\u001d;PM\u001a\u001cX\r^\"iC:<W-\u0012<f]RDq!a\u0006\u0017\u0001\u0004\tI\u0002\u0003\u0005\u0002(Y\u0001\n\u00111\u0001n\u0003\t2\u0018\r\\5eCR,GI\u0011'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005!2/\u001b>f\u0019\u0006\u00048/Z\"bY\u000e,H.\u0019;j_:$\u0012B_A_\u0003\u007f\u000b\t-!2\t\u000f\u0005%\u0006\u00041\u0001\u0002,\"9\u0011q\u0003\rA\u0002\u0005e\u0001bBAb1\u0001\u0007\u0011qB\u0001\u000fe\u0016$XM\u001c;j_:4\u0016\r\\;f\u0011\u0019\t9\u0003\u0007a\u0001[\u0006!B/[7f\u0019\u0006\u00048/Z\"bY\u000e,H.\u0019;j_:$\u0012B_Af\u0003\u001b\fy-!5\t\u000f\u0005%\u0016\u00041\u0001\u0002,\"9\u0011qC\rA\u0002\u0005e\u0001bBAb3\u0001\u0007\u0011q\u0002\u0005\u0007\u0003OI\u0002\u0019A7\u00027Y\fG.\u001b3bi\u0016dunY1m\u0019><7\u000b^1si>3gm]3u))\ty%a6\u0002b\u0006\u001d\u00181\u001e\u0005\b\u00033T\u0002\u0019AAn\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0002\u0005u\u0017bAAp\u001b\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003GT\u0002\u0019AAs\u0003-i\u0017N\u001d:peN#\u0018\r^3\u0011\t}\u000b\t(\u001c\u0005\b\u0003ST\u0002\u0019AA\b\u00031aW-\u00193fe>3gm]3u\u0011\u0019\t9C\u0007a\u0001[\u0006)b/\u00197jI\u0006$X\r\u0012\"Fa>\u001c\u0007n\u00115b]\u001e,G\u0003CA(\u0003c\fI0a?\t\u000f\u0005%6\u00041\u0001\u0002tB!\u0011QVA{\u0013\u0011\t90a'\u0003!\u0015\u0003xn\u00195DQ\u0006tw-Z#wK:$\bbBA\f7\u0001\u0007\u0011\u0011\u0004\u0005\u0007\u0003OY\u0002\u0019A7\u00029Y\fG.\u001b3bi\u0016,\u0005o\\2i\u0007\"\fgnZ3XSRDGj\\2bYRA\u0011q\nB\u0001\u0005\u0007\u0011)\u0001C\u0004\u0002*r\u0001\r!a=\t\u000f\u0005\rH\u00041\u0001\u0002f\"1\u0011q\u0005\u000fA\u00025\f1D^1mS\u0012\fG/Z#q_\u000eD7\t[1j]^KG\u000f\u001b'pG\u0006dG\u0003CA(\u0005\u0017\u0011iAa\u0004\t\u000byl\u0002\u0019A@\t\u000f\u0005]Q\u00041\u0001\u0002\u001a!1\u0011qE\u000fA\u00025\fQe^5uQ&tW*\u0019:hS:|e-\u0012:s_J4uN\u001d+j[\u0016l5OU3uK:$\u0018n\u001c8\u0015\u000bi\u0014)B!\u0007\t\u000f\t]a\u00041\u0001\u0002\u0010\u00051A/[7f\u001bNDqAa\u0007\u001f\u0001\u0004\ty!A\u0006sKR,g\u000e^5p]6\u001b\u0018aI<ji\"Lg.T1sO&twJZ#se>\u0014hi\u001c:TSj,'+\u001a;f]RLwN\u001c\u000b\u0006u\n\u0005\"Q\u0005\u0005\b\u0005Gy\u0002\u0019AA\b\u0003\u0011\u0019\u0018N_3\t\u000f\t\u001dr\u00041\u0001\u0002\u0010\u0005i!/\u001a;f]RLwN\\*ju\u0016\f\u0001\"[:J]NKhn\u0019\u000b\u0004u\n5\u0002bBA/A\u0001\u0007\u0011qL\u0001\bSNLe.S*S)\rQ(1\u0007\u0005\u0006}\u0006\u0002\ra`\u0001\u0010\u0005J|7.\u001a:WC2LG-\u0019;peB\u0011!gI\n\u0004G\tm\u0002cA0\u0003>%\u0019!q\b1\u0003\r\u0005s\u0017PU3g)\t\u00119$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000fR3!SA\u001a\u0001")
public class BrokerValidator
extends AbstractValidator {
    private final ReplicaManager replicaManager;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MaxOffsetGapToleranceTimeMs;
    private final int MaxHighWatermarkToleranceForMirrorPartitions;

    public static Time $lessinit$greater$default$3() {
        return Time.SYSTEM;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public AuditReporter reporter() {
        return super.reporter();
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    private int MaxOffsetGapToleranceTimeMs() {
        return this.MaxOffsetGapToleranceTimeMs;
    }

    private int MaxHighWatermarkToleranceForMirrorPartitions() {
        return this.MaxHighWatermarkToleranceForMirrorPartitions;
    }

    @Override
    public String loggerName() {
        return BrokerValidator.class.getName();
    }

    public boolean validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata, boolean isEpochChange) {
        if (isEpochChange) {
            return true;
        }
        if (hwm > state.highWatermark() + (long)this.MaxHighWatermarkToleranceForMirrorPartitions() && state.mirrorState().exists((Function1 & Serializable)mirrorState -> BoxesRunTime.boxToBoolean((boolean)BrokerValidator.$anonfun$validateDBHighWatermark$1(mirrorState)))) {
            String msg = new StringBuilder(252).append("durability lapse on validation with hwm stored in database, should not append records in the mirror states where mirror partitions are not allowed to fetch data from the source topics\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.HighWatermark();
            Option<String> x$7 = state.mirrorState();
            boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, 1L, x$4, msg, true, x$8, x$7);
            return false;
        }
        if (hwm < state.highWatermark()) {
            String msg = new StringBuilder(175).append("durability lapse on validation with hwm stored in database, hwm decreased from a previous committed value.\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            long x$11 = state.highWatermark() - hwm;
            Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.HighWatermark();
            Option<String> x$15 = state.mirrorState();
            boolean x$16 = this.reporter().reportDurabilityLapse$default$7();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, x$11, x$12, msg, true, x$16, x$15);
        }
        return true;
    }

    public String validateDBHighWatermark$default$5() {
        return "";
    }

    public boolean validateDBHighWatermark$default$6() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata) {
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some) {
            long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (localEndOffset < hwm) {
                String msg = new StringBuilder(207).append("durability lapse on validation with local log end offset, log end offset is found to be less than hwm.\n").append("local end offset: ").append(localEndOffset).append(", hwm: ").append(hwm).append(", event epoch: ").append(epoch).append(", local replica epoch: ").append(state.latestLocalEpoch()).append(", isr: ").append(isr).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                Option<String> x$7 = state.mirrorState();
                boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, x$4, msg, false, x$8, x$7);
                return;
            }
            return;
        }
    }

    public String validateLocalLogEndOffset$default$6() {
        return "";
    }

    private Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            if (state.retentionMs() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs()));
            }
            return Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        }
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value2 != null ? !value2.equals(retentionType) : retentionType != null)) {
            if (state.retentionSz() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz()));
            }
            return Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition);
        }
        return None$.MODULE$;
    }

    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Validating db log startOffset ").append(event).append(" ").append(state).toString());
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.ClusterLinkReplication();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            state.committedStartOffset_$eq(event.logStartOffset());
            state.lapseWatchStartTime_$eq(0L);
            return false;
        }
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            return this.timeLapseCalculation(event, state, event.retentionValue(), metadata);
        }
        Enumeration.Value value7 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value8 = RetentionType$.MODULE$.Other();
        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
            Option<Object> option = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            if (option2 instanceof Some) {
                long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Validating for db log start offset lapse for ").append(event).append(" ").append(state).append(" with retentions (").append(retentionSz).append(", ").append(retentionMs).append(")").toString());
                    Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    Option<Utils.MaxTimestampWithSize> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    if (estimatedSize instanceof Some) {
                        long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)estimatedSize).value());
                        if (prevSegInfo instanceof Some) {
                            Utils.MaxTimestampWithSize prevSegInfo2 = (Utils.MaxTimestampWithSize)((Some)prevSegInfo).value();
                            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                String msg = new StringBuilder(397).append("durability lapse on validation with db log start offset, the start offset is more than expected retention window.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegInfo2.maxTimestamp()).append(", retentionMs: ").append(retentionMs).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize2).append(", retentionSz: ").append(retentionSz).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(13).append("Lapse with ").append(estimatedSize2).append(" ").append(prevSegInfo2).append(" ").append(msg).toString());
                                if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MaxOffsetGapToleranceTimeMs())) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Postponing start offset lapse with details: ").append(msg).toString());
                                    if (state.lapseWatchStartTime() == 0L) {
                                        state.lapseWatchStartTime_$eq(this.time.milliseconds());
                                    }
                                    return false;
                                }
                                TopicPartition x$1 = event.topicIdPartition().topicPartition();
                                long x$2 = state.startOffset();
                                long x$3 = Math.max(event.logStartOffset() - state.startOffset(), 1L);
                                Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                                Option<String> x$7 = state.mirrorState();
                                boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                                this.reporter().reportDurabilityLapse(x$1, x$2, x$3, x$4, msg, false, x$8, x$7);
                                return true;
                            }
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Validation against db log start offset went fine  ").append(estimatedSize2).append(", ").append(prevSegInfo2).toString());
                            return true;
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("validateDBLogStartOffset exits as not able to fetch comparing value ").append(event).append(" ").append(state).toString());
        return true;
    }

    public String validateDBLogStartOffset$default$3() {
        return "";
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("sizeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(289).append("durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window size.\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize).append(", retentionValue: ").append(retentionValue).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                TopicPartition x$1 = event.topicIdPartition().topicPartition();
                long x$2 = state.startOffset();
                long x$3 = Math.max(event.logStartOffset() - state.startOffset(), 1L);
                Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.StartOffset();
                Option<String> x$7 = state.mirrorState();
                boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                this.reporter().reportDurabilityLapse(x$1, x$2, x$3, x$4, msg, true, x$8, x$7);
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("timeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Utils.MaxTimestampWithSize> option = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            Utils.MaxTimestampWithSize prevMs = (Utils.MaxTimestampWithSize)((Some)option).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevMs.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(307).append("durability lapse on validation with db log start offset based on time, the start offset is more than expected retention window time.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevMs.maxTimestamp()).append(", retentionValue: ").append(retentionValue).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                TopicPartition x$1 = event.topicIdPartition().topicPartition();
                long x$2 = state.startOffset();
                long x$3 = Math.max(event.logStartOffset() - state.startOffset(), 1L);
                Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.StartOffset();
                Option<String> x$7 = state.mirrorState();
                boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                this.reporter().reportDurabilityLapse(x$1, x$2, x$3, x$4, msg, true, x$8, x$7);
                return true;
            }
            return true;
        }
        return true;
    }

    public void validateLocalLogStartOffset(TopicIdPartition topicIdPartition, Option<String> mirrorState, long leaderOffset, String metadata) {
        AbstractLog log;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(topicIdPartition.topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null && log.logStartOffset() > leaderOffset) {
            Utils.MaxTimestampWithSize prevSegmentState;
            Option<Utils.MaxTimestampWithSize> option2 = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicIdPartition, log.logStartOffset());
            if (option2 instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (Utils.MaxTimestampWithSize)((Some)option2).value()).maxTimestamp(), log.config().retentionMs) && !this.withinMarginOfErrorForSizeRetention(log.size() + prevSegmentState.size(), log.config().retentionSize)) {
                String msg = new StringBuilder(241).append("durability lapse on validation with local log start offset.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegmentState.maxTimestamp()).append(", retentionMs: ").append(log.config().retentionMs).append("\n").append("Size based lapse info - prevSegmentSize: ").append(prevSegmentState.size()).append(", logSize: ").append(log.size()).append(", retentionSz: ").append(log.config().retentionSize).append("\n").append("broker: ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append("\n").append("partition: ").append(topicIdPartition).append("\n").append("metadata: ").append(metadata).toString();
                TopicPartition x$1 = topicIdPartition.topicPartition();
                long x$2 = log.logStartOffset();
                long x$3 = Math.max(log.logStartOffset() - leaderOffset, 1L);
                Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                this.reporter().reportDurabilityLapse(x$1, x$2, x$3, x$4, msg, false, x$8, mirrorState);
                return;
            }
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent event, PartitionState state, String metadata) {
        if (event.firstOffset() < state.highWatermark() || event.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(209).append("durability lapse on epoch change event with db, first offset for new epoch is less than previous recorded db state hwm\n").append("event first offset: ").append(event.firstOffset()).append(", new epoch: ").append(event.epoch()).append("\n").append("db state hwm: ").append(state.highWatermark()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            TopicPartition x$1 = event.topicIdPartition().topicPartition();
            long x$2 = event.firstOffset();
            long x$3 = Math.max(state.highWatermark() - event.firstOffset(), 1L);
            Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.EpochChange();
            Option<String> x$7 = state.mirrorState();
            boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
            this.reporter().reportDurabilityLapse(x$1, x$2, x$3, x$4, msg, true, x$8, x$7);
            return;
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent event, Option<String> mirrorState, String metadata) {
        if (!this.isInSync(event.isr())) {
            return;
        }
        if (!mirrorState.isEmpty()) {
            return;
        }
        if (this.isInISR(event.topicIdPartition().topicPartition())) {
            Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition());
            Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition());
            if (option2 instanceof Some) {
                int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    if (epoch >= event.epoch() && localEndOffset < event.firstOffset()) {
                        String msg = new StringBuilder(217).append("durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\n").append("in-sync partition ").append(event.topicIdPartition()).append("\n").append("local end offset: ").append(localEndOffset).append(", local epoch ").append(epoch).append("\n").append("first offset: ").append(event.firstOffset()).append(" of the new epoch\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        TopicPartition x$1 = event.topicIdPartition().topicPartition();
                        Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                        boolean x$8 = this.reporter().reportDurabilityLapse$default$7();
                        this.reporter().reportDurabilityLapse(x$1, localEndOffset, 1L, x$4, msg, false, x$8, mirrorState);
                    } else if (localEndOffset < event.highWatermark()) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\n").append("For in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local end offset ").append(localEndOffset).append(",local epoch ").append(epoch).append("\n").append("hwm: ").append(event.highWatermark()).append(", isrSet ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        TopicPartition x$9 = event.topicIdPartition().topicPartition();
                        Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                        boolean x$16 = this.reporter().reportDurabilityLapse$default$7();
                        this.reporter().reportDurabilityLapse(x$9, localEndOffset, 1L, x$12, msg, false, x$16, mirrorState);
                    }
                }
            }
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Follower is lagging ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append(", processing older event ").append(event.topicIdPartition()).append(" ").toString());
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.epoch());
        Option<AbstractLog> log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (localOffset instanceof Some) {
            long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)localOffset).value());
            if (log instanceof Some) {
                AbstractLog localLog = (AbstractLog)((Some)log).value();
                if (firstOffset != -1L) {
                    if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\n").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local first offset: ").append(localOffset).append("\n").append("first offset: ").append(event.firstOffset()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        TopicPartition x$17 = event.topicIdPartition().topicPartition();
                        Enumeration.Value x$20 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                        boolean x$24 = this.reporter().reportDurabilityLapse$default$7();
                        this.reporter().reportDurabilityLapse(x$17, firstOffset, 1L, x$20, msg, false, x$24, mirrorState);
                        return;
                    }
                    return;
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state, String metadata) {
        Object object = new Object();
        try {
            if (Utils$.MODULE$.isCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            if (!state.mirrorState().isEmpty()) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)state.epochChain().toList().sortWith((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerValidator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable)x0$1 -> {
                BrokerValidator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, prevEpoch, state, metadata, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("validating ").append(timeMs).append(" against ").append(retentionMs).toString());
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Validating ").append(size).append(" against ").append(retentionSize).toString());
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public boolean isInISR(TopicPartition topicPartition) {
        return Utils$.MODULE$.getIsrPartition(this.replicaManager(), topicPartition).contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public static final /* synthetic */ boolean $anonfun$validateDBHighWatermark$1(String mirrorState) {
        return !DurabilityAuditMirrorState.fromString(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.apply((Object)mirrorState)))).get().isAppendRecordsAllowed();
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(BrokerValidator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, IntRef prevEpoch$1, PartitionState state$4, String metadata$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(218).append("durability lapse on epoch chain validation with db, local first offset is greater than or equal to next epoch's first offset\n").append("partition ").append(topicPartition$1).append("\n").append("prevEpoch: ").append(prevEpoch$1.elem).append(", prevLocalFirstOffset: ").append(prevLocalEpochFirstOffset$1.elem).append("\n").append("dbEpoch: ").append(dbEpoch).append(", db first offset ").append(dbEpochFirstOffset).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    Enumeration.Value x$4 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                    Option<String> x$7 = state$4.mirrorState();
                    boolean x$8 = $this.reporter().reportDurabilityLapse$default$7();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, x$4, msg, false, x$8, x$7);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(199).append("durability lapse on epoch chain validation, db first offset is greater than local first offset\n").append("partition: ").append(topicPartition$1).append("\n").append("dbEpoch: ").append(dbEpoch).append(", the local first offset: ").append(localEpochFirstOffset).append("\n").append("db first offset: ").append(dbEpochFirstOffset).append(", log start offset: ").append(log.logStartOffset()).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    Enumeration.Value x$12 = DurabilityLapseType$.MODULE$.NonCustomerFacing();
                    Option<String> x$15 = state$4.mirrorState();
                    boolean x$16 = $this.reporter().reportDurabilityLapse$default$7();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, x$12, msg, false, x$16, x$15);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public BrokerValidator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.time = time;
        super(reporter, time);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MaxOffsetGapToleranceTimeMs = 900000;
        this.MaxHighWatermarkToleranceForMirrorPartitions = 10000;
    }
}

