/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.utils;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kafka.durability.utils.KeyAndVersionInfo;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.DurabilityAuditsOffsetMapMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Set;
import scala.runtime.NonLocalReturnControl;

public final class DurabilityObjectStoreUtils$
implements Logging {
    public static final DurabilityObjectStoreUtils$ MODULE$ = new DurabilityObjectStoreUtils$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Set<String> stringFormatUUID(Set<UUID> segments) {
        return (Set)segments.map((Function1 & Serializable)x -> CoreUtils$.MODULE$.uuidToBase64((UUID)x));
    }

    public void putOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, File file) {
        DurabilityAuditsOffsetMapMetadata metadata = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        tierStore.putObject(metadata, file, ObjectType.DA_OFFSET_MAP);
    }

    public TierObjectStoreResponse getOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition) {
        DurabilityAuditsOffsetMapMetadata metadata = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        return tierStore.getObjectStoreFragment(metadata, FragmentType.DA_OFFSET_MAP);
    }

    public void deleteOffsetMapFile(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition) {
        DurabilityAuditsOffsetMapMetadata metadata = new DurabilityAuditsOffsetMapMetadata(topicIdPartition, objectId);
        tierStore.listObject(metadata.toFragmentLocation("", FragmentType.DA_OFFSET_MAP).get().objectPath(), true).forEach((x0$1, x1$1) -> {
            ArrayList<TierObjectStore.KeyAndVersion> deletionList = new ArrayList<TierObjectStore.KeyAndVersion>();
            x1$1.forEach(versionInfo -> deletionList.add(new TierObjectStore.KeyAndVersion((String)x0$1, versionInfo.getVersionId())));
            if (!deletionList.isEmpty()) {
                tierStore.deleteVersions(deletionList);
                return;
            }
        });
    }

    public Map<String, List<VersionInformation>> listObjectWithRetries(TierObjectStore tierStore, TopicIdPartition topicIdPartition, String keyPrefix, boolean getVersionInfo, int count, int maxRetries) {
        while (true) {
            try {
                return tierStore.listObject(keyPrefix, true);
            }
            catch (TierObjectStoreRetriableException e) {
                if (this.logger().underlying().isWarnEnabled()) {
                    String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$1(e, keyPrefix, topicIdPartition);
                    Object var9_8 = null;
                    this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                if (count < maxRetries) {
                    ++count;
                    continue;
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$2(e, keyPrefix, topicIdPartition);
                    Object var10_9 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                throw e;
            }
            catch (Exception e) {
                if (this.logger().underlying().isErrorEnabled()) {
                    String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$listObjectWithRetries$3(e, keyPrefix, topicIdPartition);
                    Object var11_11 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                throw e;
            }
            break;
        }
    }

    public Option<KeyAndVersionInfo> getVersion(TierObjectStore tierStore, UUID objectId, TopicIdPartition topicIdPartition, ObjectType objectType) {
        Object object = new Object();
        try {
            String keyPrefix = new StringBuilder(3).append(TierObjectStore.DataTypePathPrefix.TOPIC.prefix).append("/").append(CoreUtils$.MODULE$.uuidToBase64(objectId)).append("/").append(topicIdPartition.topicIdAsBase64()).append("/").append(topicIdPartition.partition()).toString();
            Map<String, List<VersionInformation>> allBlobsWithVersions = this.listObjectWithRetries(tierStore, topicIdPartition, keyPrefix, true, 0, 3);
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$getVersion$1(keyPrefix, allBlobsWithVersions);
                Object var9_8 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            allBlobsWithVersions.forEach((x0$1, x1$1) -> {
                if (x0$1.contains(objectType.suffix())) {
                    x1$1.forEach(versionInfo -> {
                        DurabilityObjectStoreUtils$ debug_this = MODULE$;
                        if (debug_this.logger().underlying().isDebugEnabled()) {
                            String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$getVersion$4(x0$1, versionInfo, topicIdPartition);
                            Object var8_6 = null;
                            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
                        }
                        Object var7_5 = null;
                        TierObjectStore.Backend backend = tierStore.getBackend();
                        TierObjectStore.Backend backend2 = TierObjectStore.Backend.S3;
                        if (!(backend != null ? !((Object)((Object)backend)).equals((Object)backend2) : backend2 != null)) {
                            if (!((S3VersionInformation)versionInfo).isDeleteMarker()) {
                                throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo((String)x0$1, (VersionInformation)versionInfo)));
                            }
                            return;
                        }
                        TierObjectStore.Backend backend3 = tierStore.getBackend();
                        TierObjectStore.Backend backend4 = TierObjectStore.Backend.Mock;
                        if (!(backend3 != null ? !((Object)((Object)backend3)).equals((Object)backend4) : backend4 != null)) {
                            if (!versionInfo.getVersionId().equals("delete-marker")) {
                                throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo((String)x0$1, (VersionInformation)versionInfo)));
                            }
                            return;
                        }
                        throw new NonLocalReturnControl(object, (Object)Option$.MODULE$.apply((Object)new KeyAndVersionInfo((String)x0$1, (VersionInformation)versionInfo)));
                    });
                    return;
                }
                DurabilityObjectStoreUtils$ debug_this = MODULE$;
                if (debug_this.logger().underlying().isDebugEnabled()) {
                    String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$getVersion$5(keyPrefix, topicIdPartition, x0$1, objectType);
                    Object var8_8 = null;
                    debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
                    return;
                }
            });
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = DurabilityObjectStoreUtils$.$anonfun$getVersion$6(keyPrefix, topicIdPartition);
                Object var10_9 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public String versionListMapToString(Map<String, List<VersionInformation>> versionListMap) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        versionListMap.forEach((k, vList) -> DurabilityObjectStoreUtils$.keyVersions$1(k, vList, sb));
        return sb.toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$1(TierObjectStoreRetriableException e$1, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(42).append("Running into ").append((Object)e$1).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$2(TierObjectStoreRetriableException e$1, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(51).append("Retries failed,  into ").append((Object)e$1).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listObjectWithRetries$3(Exception e$2, String keyPrefix$1, TopicIdPartition topicIdPartition$1) {
        return new StringBuilder(42).append("Running into ").append(e$2).append(" get list for keyPrefix ").append(keyPrefix$1).append(" for ").append(topicIdPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$1(String keyPrefix$2, Map allBlobsWithVersions$1) {
        return new StringBuilder(24).append("got version map for ").append(keyPrefix$2).append(": \n ").append(MODULE$.versionListMapToString(allBlobsWithVersions$1)).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$4(String blobKey$2, VersionInformation versionInfo$1, TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(60).append("Checking blob found with key ").append(blobKey$2).append(" version ").append(versionInfo$1).append(" for topicIdPartition ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$5(String keyPrefix$2, TopicIdPartition topicIdPartition$2, String blobKey$2, ObjectType objectType$1) {
        return new StringBuilder(101).append("File suffix not matching, found object: pattern = ").append(keyPrefix$2).append(", topicIdPartition = ").append(topicIdPartition$2).append(", key = ").append(blobKey$2).append("; expected file type: ").append(objectType$1.suffix()).toString();
    }

    public static final /* synthetic */ String $anonfun$getVersion$6(String keyPrefix$2, TopicIdPartition topicIdPartition$2) {
        return new StringBuilder(55).append("No versioned objects for pattern ").append(keyPrefix$2).append(" for topicIdPartition ").append(topicIdPartition$2).toString();
    }

    private static final scala.collection.mutable.StringBuilder versions$1(VersionInformation v, scala.collection.mutable.StringBuilder sb$1, String k$1) {
        sb$1.append(k$1).append(": ").append(v.getVersionId());
        if (v instanceof S3VersionInformation) {
            S3VersionInformation s3v = (S3VersionInformation)v;
            sb$1.append("(isDeleteMarker: ").append(s3v.isDeleteMarker()).append(")");
        }
        return sb$1.append("\n");
    }

    private static final void keyVersions$1(String k, List vList, scala.collection.mutable.StringBuilder sb$1) {
        vList.stream().forEach(v -> DurabilityObjectStoreUtils$.versions$1(v, sb$1, k));
    }

    private DurabilityObjectStoreUtils$() {
    }
}

