/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import kafka.log.AbstractLog;
import kafka.log.OffsetsToClean;
import kafka.utils.Logging;
import org.apache.kafka.storage.internals.log.LogSegment;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$ = new LogCleanerManager$();
    private static final String kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName = "uncleanable-partitions-count";
    private static final String kafka$log$LogCleanerManager$$UncleanableBytesMetricName = "uncleanable-bytes";
    private static final String kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName = "time-since-last-run-ms";
    private static final String kafka$log$LogCleanerManager$$AchievedCleaningRatio = "AchievedCleaningRatio";
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionBytes = "compacted-partition-bytes";
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes = "compacted-partition-local-bytes";
    private static final String kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes = "compacted-partition-tiered-bytes";
    private static final Set<String> GaugeMetricNameNoTag = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName()}));
    private static final Set<String> HistogramMetricNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.kafka$log$LogCleanerManager$$AchievedCleaningRatio()}));
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName() {
        return kafka$log$LogCleanerManager$$UncleanablePartitionsCountMetricName;
    }

    public String kafka$log$LogCleanerManager$$UncleanableBytesMetricName() {
        return kafka$log$LogCleanerManager$$UncleanableBytesMetricName;
    }

    public String kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName() {
        return kafka$log$LogCleanerManager$$TimeSinceLastRunMsMetricName;
    }

    public String kafka$log$LogCleanerManager$$AchievedCleaningRatio() {
        return kafka$log$LogCleanerManager$$AchievedCleaningRatio;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionBytes;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionLocalBytes;
    }

    public String kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes() {
        return kafka$log$LogCleanerManager$$CompactedPartitionTieredBytes;
    }

    public Set<String> GaugeMetricNameNoTag() {
        return GaugeMetricNameNoTag;
    }

    public Set<String> HistogramMetricNames() {
        return HistogramMetricNames;
    }

    public boolean isCompactAndDelete(AbstractLog log) {
        return log.config().compact() && log.config().delete();
    }

    public long localEarliestDirtyBatchTimestamp(AbstractLog log, long firstDirtyOffset) {
        Collection<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset);
        return Predef$.MODULE$.Long2long(log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).stream().filter(x$8 -> Predef$.MODULE$.Long2long(x$8) > 0L).min(Comparator.naturalOrder()).orElse(Predef$.MODULE$.long2Long(Long.MAX_VALUE)));
    }

    public long maxCompactionDelay(AbstractLog log, Function0<Object> earliestDirtyTimestamp, long now) {
        long maxCompactionLagMs = package$.MODULE$.max(log.config().maxCompactionLagMs(), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        if (cleanUntilTime < 0L) {
            return 0L;
        }
        long earliestDirtySegmentTimestamp = earliestDirtyTimestamp.apply$mcJ$sp();
        if (earliestDirtySegmentTimestamp < cleanUntilTime) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public OffsetsToClean cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        boolean bl;
        long l;
        long localLogStartOffset = log.localLogStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> localLogStartOffset));
        if (checkpointDirtyOffset < localLogStartOffset) {
            if (!this.isCompactAndDelete(log) && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$2(log, localLogStartOffset, checkpointDirtyOffset);
                Object var14_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l = localLogStartOffset;
            bl = true;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$3(log, checkpointDirtyOffset, localLogStartOffset);
                Object var15_7 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l = localLogStartOffset;
            bl = true;
        } else {
            l = checkpointDirtyOffset;
            bl = false;
        }
        boolean bl2 = bl;
        long l2 = l;
        long minCompactionLagMs = package$.MODULE$.max(log.config().compactionLagMs(), 0L);
        Some some = new Some((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset()));
        Option option = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Collection<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(l2);
            none$ = CollectionConverters$.MODULE$.CollectionHasAsScala(dirtyNonActiveSegments).asScala().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s))).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset()));
        } else {
            none$ = None$.MODULE$;
        }
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)new .colon.colon((Object)some, (List)new .colon.colon((Object)option, (List)new .colon.colon((Object)none$, (List)new .colon.colon(this.dualCompactionCleaningBound(log), (List)Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).min((Ordering)Ordering.Long$.MODULE$));
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$7(log, lastCleanOffset, now, l2, firstUncleanableDirtyOffset);
            Object var16_13 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return new OffsetsToClean(l2, package$.MODULE$.max(l2, firstUncleanableDirtyOffset), bl2);
    }

    public Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        long firstUncleanableOffset = ((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log.localNonActiveLogSegmentsFrom(uncleanableOffset)).asScala().headOption().getOrElse((Function0 & Serializable)() -> log.activeSegment())).baseOffset();
        long cleanableBytes = log.localLogSegments(package$.MODULE$.min(firstDirtyOffset, firstUncleanableOffset), firstUncleanableOffset).stream().mapToLong(x$11 -> x$11.size()).sum();
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public Option<Object> dualCompactionCleaningBound(AbstractLog log) {
        if (log.tierPartitionState().isTieringEnabled() && log.config().confluentLogConfig().tierCleanerDualCompaction) {
            return new Some((Object)BoxesRunTime.boxToLong((long)(log.tierPartitionState().committedEndOffset() + 1L)));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$2(AbstractLog log$3, long localLogStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(102).append("Resetting first dirty offset of ").append(log$3.name()).append(" to local log start offset ").append(localLogStartOffset$1).append(" ").append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$3(AbstractLog log$3, long checkpointDirtyOffset$1, long localLogStartOffset$1) {
        return new StringBuilder(136).append("The last checkpoint dirty offset for partition ").append(log$3.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").append("which is larger than the log end offset ").append(log$3.logEndOffset()).append(". Resetting to the local log start offset ").append(localLogStartOffset$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$5(AbstractLog log$3, LogSegment s$1, long now$3, long minCompactionLagMs$1, boolean isUncleanable$1) {
        return new StringBuilder(131).append("Checking if log segment may be cleaned: log='").append(log$3.name()).append("' segment.baseOffset=").append(s$1.baseOffset()).append(" ").append("segment.largestTimestamp=").append(s$1.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").append("is uncleanable=").append(isUncleanable$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, AbstractLog log$3, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        LogCleanerManager$ debug_this = MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$5(log$3, s, now$3, minCompactionLagMs$1, isUncleanable);
            Object var8_6 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
        }
        return isUncleanable;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$7(AbstractLog log$3, Option lastCleanOffset$1, long now$3, long firstDirtyOffset$1, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(139).append("Finding range of cleanable offsets for log=").append(log$3.name()).append(". Last clean offset=").append(lastCleanOffset$1).append(" ").append("now=").append(now$3).append(" => firstDirtyOffset=").append(firstDirtyOffset$1).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").append("activeSegment.baseOffset=").append(log$3.activeSegment().baseOffset()).toString();
    }

    private LogCleanerManager$() {
    }
}

