/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r=v!B$I\u0011\u0003ie!B(I\u0011\u0003\u0001\u0006\"B,\u0002\t\u0003Af\u0001B-\u0002\u0001iC\u0001B\\\u0002\u0003\u0002\u0003\u0006Ia\u001c\u0005\u000b\u0003\u0003\u0019!\u0011!Q\u0001\n\u0005\r\u0001BCA\r\u0007\t\u0005\t\u0015!\u0003\u0002\u001c!1qk\u0001C\u0001\u0003OAq!a\u000f\u0004\t\u0003\ni\u0004C\u0004\u0002F\r!\t%a\u0012\t\u000f\u0005=3\u0001\"\u0011\u0002H!9\u0011\u0011K\u0001\u0005\n\u0005M\u0003bBA7\u0003\u0011%\u0011q\u000e\u0005\b\u0003w\nA\u0011AA?\u0011\u001d\ti)\u0001C\u0001\u0003\u001f3Qa\u0014%\u0001\u0003'C!\"a)\u0010\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\t\ti\u0004B\u0001B\u0003%\u00111\u0011\u0005\u000b\u0003K{!\u0011!Q\u0001\n\u0005\u001d\u0006BCA\\\u001f\t\u0005\t\u0015!\u0003\u0002:\"Q\u00111Y\b\u0003\u0002\u0003\u0006I!!2\t\u0015\u0005-wB!A!\u0002\u0013\ti\r\u0003\u0006\u0002X>\u0011\t\u0011)A\u0005\u00033D!\"a9\u0010\u0005\u0003\u0005\u000b\u0011BAs\u0011)\tYo\u0004BC\u0002\u0013\u0005\u0011Q\u001e\u0005\u000b\u0005_y!\u0011!Q\u0001\n\u0005=\bBCA\r\u001f\t\u0005\t\u0015!\u0003\u0002\u001c!Q!\u0011G\b\u0003\u0002\u0003\u0006IAa\r\t\r]{A\u0011\u0001B%\u0011%\u0011\u0019g\u0004b\u0001\n\u0013\u0011)\u0007\u0003\u0005\u0003t=\u0001\u000b\u0011\u0002B4\u0011%\u0011)h\u0004b\u0001\n\u0003\u00119\b\u0003\u0005\u0003\u0006>\u0001\u000b\u0011\u0002B=\u0011%\u00119i\u0004b\u0001\n\u0013\u0011I\t\u0003\u0005\u0003\u0012>\u0001\u000b\u0011\u0002BF\u0011%\t\ta\u0004b\u0001\n\u0013\u0011\u0019\n\u0003\u0005\u0003\u0016>\u0001\u000b\u0011BA\u0002\u0011%\u00119j\u0004b\u0001\n\u0013\u0011I\n\u0003\u0005\u0003\">\u0001\u000b\u0011\u0002BN\u0011%\u0011\u0019k\u0004b\u0001\n\u0013\u0011)\u000b\u0003\u0005\u0003.>\u0001\u000b\u0011\u0002BT\u0011%\tIh\u0004b\u0001\n\u0013\u0011y\u000b\u0003\u0005\u00032>\u0001\u000b\u0011BA+\u0011%\u0011\u0019l\u0004b\u0001\n\u0013\u0011)\f\u0003\u0005\u0003:>\u0001\u000b\u0011\u0002B\\\u0011%\u0011Yl\u0004b\u0001\n\u0003\u0012i\f\u0003\u0005\u0003F>\u0001\u000b\u0011\u0002B`\u0011%\u00119m\u0004b\u0001\n\u0013\u0011I\r\u0003\u0005\u0003R>\u0001\u000b\u0011\u0002Bf\u0011%\u0011\u0019n\u0004b\u0001\n\u0013\u0011)\u000e\u0003\u0005\u0003d>\u0001\u000b\u0011\u0002Bl\u0011%\u0011)o\u0004b\u0001\n\u0013\u00119\u000f\u0003\u0005\u0003p>\u0001\u000b\u0011\u0002Bu\u0011!qwB1A\u0005B\tE\b\u0002\u0003B{\u001f\u0001\u0006IAa=\t\u0013\t]xB1A\u0005\n\te\b\u0002CB\u0004\u001f\u0001\u0006IAa?\t\u0013\r%q\u00021A\u0005\n\r-\u0001\"CB\u0011\u001f\u0001\u0007I\u0011BB\u0012\u0011!\u0019Ic\u0004Q!\n\r5\u0001bBB\u0016\u001f\u0011\u0005\u0011Q\b\u0005\b\u0007[yA\u0011AA\u001f\u0011\u001d\u0019yc\u0004C!\u0007cAqa!\u0012\u0010\t\u0003\u001a9\u0005C\u0004\u0004v=!Iaa\u001e\t\u000f\r\u0015u\u0002\"\u0003\u0004\b\"91\u0011R\b\u0005\n\r-\u0005bBBG\u001f\u0011%1q\u0012\u0005\b\u0007#{A\u0011BBJ\u0011\u001d\u0019Yj\u0004C\u0005\u0007;Cqa!*\u0010\t\u0003\u001a9+\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4fe*\u0011\u0011JS\u0001\u0005e\u00064GOC\u0001L\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AT\u0001\u000e\u0003!\u0013\u0001cS1gW\u0006\u0014\u0016M\u001a;NC:\fw-\u001a:\u0014\u0005\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b\na!+\u00194u\u0013>$\u0006N]3bIN\u00191a\u00175\u0011\u0005q3W\"A/\u000b\u0005y{\u0016\u0001B;uS2T!\u0001Y1\u0002\rM,'O^3s\u0015\tY%M\u0003\u0002dI\u00061\u0011\r]1dQ\u0016T\u0011!Z\u0001\u0004_J<\u0017BA4^\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005%dW\"\u00016\u000b\u0005-T\u0015!B;uS2\u001c\u0018BA7k\u0005\u001daunZ4j]\u001e\faa\u00197jK:$\bG\u00019x!\r\t8/^\u0007\u0002e*\u0011\u0011*Y\u0005\u0003iJ\u0014qbS1gW\u0006\u0014\u0016M\u001a;DY&,g\u000e\u001e\t\u0003m^d\u0001\u0001B\u0005y\t\u0005\u0005\t\u0011!B\u0001s\n\u0019q\fJ\u0019\u0012\u0005il\bC\u0001*|\u0013\ta8KA\u0004O_RD\u0017N\\4\u0011\u0005Is\u0018BA@T\u0005\r\te._\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tIaU\u0007\u0003\u0003\u0017Q1!!\u0004M\u0003\u0019a$o\\8u}%\u0019\u0011\u0011C*\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\tbU\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\b\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005r,A\u0003gCVdG/\u0003\u0003\u0002&\u0005}!\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014H\u0003CA\u0015\u0003[\t9$!\u000f\u0011\u0007\u0005-2!D\u0001\u0002\u0011\u0019qw\u00011\u0001\u00020A\"\u0011\u0011GA\u001b!\u0011\t8/a\r\u0011\u0007Y\f)\u0004\u0002\u0006y\u0003[\t\t\u0011!A\u0003\u0002eDq!!\u0001\b\u0001\u0004\t\u0019\u0001C\u0004\u0002\u001a\u001d\u0001\r!a\u0007\u0002\r\u0011|wk\u001c:l)\t\ty\u0004E\u0002S\u0003\u0003J1!a\u0011T\u0005\u0011)f.\u001b;\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA%!\r\u0011\u00161J\u0005\u0004\u0003\u001b\u001a&a\u0002\"p_2,\u0017M\\\u0001\nSN\u0014VO\u001c8j]\u001e\f!c\u0019:fCR,Gj\\4ESJ,7\r^8ssR1\u0011QKA3\u0003S\u0002B!a\u0016\u0002b5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0002j_*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005e#\u0001\u0002$jY\u0016Dq!a\u001a\f\u0001\u0004\t)&\u0001\u0004m_\u001e$\u0015N\u001d\u0005\b\u0003WZ\u0001\u0019AA\u0002\u0003)awn\u001a#je:\u000bW.Z\u0001\fY>\u001c7\u000eR1uC\u0012K'\u000f\u0006\u0003\u0002r\u0005]\u0004cA5\u0002t%\u0019\u0011Q\u000f6\u0003\u0011\u0019KG.\u001a'pG.Dq!!\u001f\r\u0001\u0004\t)&A\u0004eCR\fG)\u001b:\u0002%!\f7\u000fR5gM\u0016\u0014XM\u001c;M_\u001e$\u0015N\u001d\u000b\u0005\u0003\u0013\ny\bC\u0004\u0002\u00026\u0001\r!a!\u0002\r\r|gNZ5h!\u0011\t))!#\u000e\u0005\u0005\u001d%B\u00011K\u0013\u0011\tY)a\"\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u001a[\u0006L(-\u001a#fY\u0016$X-T3uC\u0012\fG/\u0019'pO\u0012K'\u000f\u0006\u0003\u0002@\u0005E\u0005bBAA\u001d\u0001\u0007\u00111Q\u000b\u0005\u0003+\u000byjE\u0003\u0010#\u0006]\u0005\u000eE\u0003O\u00033\u000bi*C\u0002\u0002\u001c\"\u00131BU1gi6\u000bg.Y4feB\u0019a/a(\u0005\r\u0005\u0005vB1\u0001z\u0005\u0005!\u0016!C2mkN$XM]%e\u0003-\u0011XmY8sIN+'\u000fZ3\u0011\r\u0005%\u00161WAO\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016!D:fe&\fG.\u001b>bi&|gNC\u0002\u00022~\u000baaY8n[>t\u0017\u0002BA[\u0003W\u00131BU3d_J$7+\u001a:eK\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA^\u0003\u007fk!!!0\u000b\u0007\u0005E\u0016-\u0003\u0003\u0002B\u0006u&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\bi>\u0004\u0018nY%e!\u0011\tY,a2\n\t\u0005%\u0017Q\u0018\u0002\u0005+VLG-\u0001\u0003uS6,\u0007\u0003BAh\u0003'l!!!5\u000b\u0007-\fi,\u0003\u0003\u0002V\u0006E'\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002\\\u0006}WBAAo\u0015\u0011\t9.!0\n\t\u0005\u0005\u0018Q\u001c\u0002\b\u001b\u0016$(/[2t\u0003M!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007p\u00149u!\u0015\u0011\u0016q]A\u0002\u0013\r\tIo\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u00029\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sKV\u0011\u0011q\u001e\t\u0007\u0003c\fI0!@\u000e\u0005\u0005M(\u0002BA{\u0003o\f!bY8oGV\u0014(/\u001a8u\u0015\rq\u0016QL\u0005\u0005\u0003w\f\u0019PA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004\u0002\"a@\u0003\u0002\t\u0015!\u0011C\u0007\u0003\u0003oLAAa\u0001\u0002x\n\u0019Q*\u00199\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002^\u0005!A.\u00198h\u0013\u0011\u0011yA!\u0003\u0003\u000f%sG/Z4feB!!1\u0003B\u0015\u001d\u0011\u0011)B!\n\u000f\t\t]!1\u0005\b\u0005\u00053\u0011\tC\u0004\u0003\u0003\u001c\t}a\u0002BA\u0005\u0005;I\u0011!Z\u0005\u0003G\u0012L!a\u00132\n\u0005%\u000b\u0017b\u0001B\u0014e\u0006Q!+\u00194u\u0007>tg-[4\n\t\t-\"Q\u0006\u0002\f\u0003\u0012$'/Z:t'B,7MC\u0002\u0003(I\fQdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X\rI\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H\u000f\u0005\u0004\u0002\u0000\nU\"\u0011H\u0005\u0005\u0005o\t9P\u0001\u0005PaRLwN\\1m!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\nQa\u001d;pe\u0016T1Aa\u0011K\u0003\u0011!\u0018.\u001a:\n\t\t\u001d#Q\b\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sKRA\"1\nB'\u0005\u001f\u0012\tFa\u0015\u0003V\t]#\u0011\fB.\u0005;\u0012yF!\u0019\u0011\t9{\u0011Q\u0014\u0005\b\u0003Gc\u0002\u0019AA\u0002\u0011\u001d\t\t\t\ba\u0001\u0003\u0007Cq!!*\u001d\u0001\u0004\t9\u000bC\u0004\u00028r\u0001\r!!/\t\u000f\u0005\rG\u00041\u0001\u0002F\"9\u00111\u001a\u000fA\u0002\u00055\u0007bBAl9\u0001\u0007\u0011\u0011\u001c\u0005\b\u0003Gd\u0002\u0019AAs\u0011\u001d\tY\u000f\ba\u0001\u0003_Dq!!\u0007\u001d\u0001\u0004\tY\u0002C\u0004\u00032q\u0001\rAa\r\u0002\r\rdwn]3e+\t\u00119\u0007\u0005\u0003\u0003j\t=TB\u0001B6\u0015\u0011\u0011i'a=\u0002\r\u0005$x.\\5d\u0013\u0011\u0011\tHa\u001b\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d\u0019Gn\\:fI\u0002\n1\"\u00199j-\u0016\u00148/[8ogV\u0011!\u0011\u0010\t\u0005\u0005w\u0012\t)\u0004\u0002\u0003~)\u0019!qP1\u0002\u000f\rd\u0017.\u001a8ug&!!1\u0011B?\u0005-\t\u0005/\u001b,feNLwN\\:\u0002\u0019\u0005\u0004\u0018NV3sg&|gn\u001d\u0011\u0002\u0015I\fg\r^\"p]\u001aLw-\u0006\u0002\u0003\fB\u0019\u0011O!$\n\u0007\t=%O\u0001\u0006SC\u001a$8i\u001c8gS\u001e\f1B]1gi\u000e{gNZ5hAU\u0011\u00111A\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013A\u00037pO\u000e{g\u000e^3yiV\u0011!1\u0014\t\u0005\u0003\u001f\u0014i*\u0003\u0003\u0003 \u0006E'A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0003(B\u0019AL!+\n\u0007\t-VL\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0006\u0002\u0002V\u0005AA-\u0019;b\t&\u0014\b%A\u0006eCR\fG)\u001b:M_\u000e\\WC\u0001B\\!\u0015\u0011\u0016q]A9\u00031!\u0017\r^1ESJdunY6!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!q\u0018\t\u0004c\n\u0005\u0017b\u0001Bbe\ni!+\u001a9mS\u000e\fG/\u001a3M_\u001e\faB]3qY&\u001c\u0017\r^3e\u0019><\u0007%\u0001\u0006oKR\u001c\u0005.\u00198oK2,\"Aa3\u0011\u0007E\u0014i-C\u0002\u0003PJ\u00141cS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2\f1B\\3u\u0007\"\fgN\\3mA\u0005yQ\r\u001f9je\u0006$\u0018n\u001c8US6,'/\u0006\u0002\u0003XB!!\u0011\u001cBp\u001b\t\u0011YNC\u0002\u0003^v\u000bQ\u0001^5nKJLAA!9\u0003\\\nY1+_:uK6$\u0016.\\3s\u0003A)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u0014\b%A\tfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016,\"A!;\u0011\u00079\u0013Y/C\u0002\u0003n\"\u0013A\u0004V5nS:<w\u000b[3fY\u0016C\b/\u001b:bi&|gnU3sm&\u001cW-\u0001\nfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\u0004SC\u0001Bz!\u0011\t8/!(\u0002\u000f\rd\u0017.\u001a8uA\u0005a!/\u00194u\u0013>$\u0006N]3bIV\u0011!1 \t\u0004\u0005{\u001cab\u0001B\u0000\u00019!1\u0011AB\u0003\u001d\u0011\tIaa\u0001\n\u0003-K!!\u0013&\u0002\u001bI\fg\r^%p)\"\u0014X-\u00193!\u0003!)\u00070Z2vi>\u0014XCAB\u0007!\u0015\u0011\u0016q]B\b!\u0011\u0019\tb!\b\u000e\u0005\rM!\u0002BA{\u0007+Q1aSB\f\u0015\u0011\u0019Iba\u0007\u0002\u0013\r|gN\u001a7vK:$(BAA.\u0013\u0011\u0019yba\u0005\u0003\u001b\u00153XM\u001c;Fq\u0016\u001cW\u000f^8s\u00031)\u00070Z2vi>\u0014x\fJ3r)\u0011\tyd!\n\t\u0013\r\u001d\"(!AA\u0002\r5\u0011a\u0001=%c\u0005IQ\r_3dkR|'\u000fI\u0001\bgR\f'\u000f^;q\u0003!\u0019\b.\u001e;e_^t\u0017\u0001\u0003:fO&\u001cH/\u001a:\u0015\t\u0005}21\u0007\u0005\b\u0007kq\u0004\u0019AB\u001c\u0003!a\u0017n\u001d;f]\u0016\u0014\bCBB\u001d\u0007\u007f\tiJD\u0002r\u0007wI1a!\u0010s\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0007\u0003\u001a\u0019E\u0001\u0005MSN$XM\\3s\u0015\r\u0019iD]\u0001\u000eQ\u0006tG\r\\3SKF,Xm\u001d;\u0015\u0011\r%3qKB4\u0007W\u0002b!!=\u0002z\u000e-\u0003\u0003BB'\u0007'j!aa\u0014\u000b\t\rE\u0013QX\u0001\taJ|Go\\2pY&!1QKB(\u0005)\t\u0005/['fgN\fw-\u001a\u0005\b\u00073z\u0004\u0019AB.\u0003\u0019AW-\u00193feB!1QLB2\u001b\t\u0019yF\u0003\u0003\u0004b\u0005u\u0016\u0001\u0003:fcV,7\u000f^:\n\t\r\u00154q\f\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\r%t\b1\u0001\u0004L\u00059!/Z9vKN$\bbBB7\u007f\u0001\u00071qN\u0001\u000eGJ,\u0017\r^3e)&lW-T:\u0011\u0007I\u001b\t(C\u0002\u0004tM\u0013A\u0001T8oO\u0006iR.Y=cK\n+\u0018\u000e\u001c3SC\u001a$8K\\1qg\"|G/T1oC\u001e,'\u000f\u0006\u0002\u0004zA)!+a:\u0004|A!1QPBA\u001b\t\u0019yHC\u0002J\u0005\u0003JAaa!\u0004\u0000\t!2JU1giNs\u0017\r]:i_Rl\u0015M\\1hKJ\fqBY;jY\u0012\u0014\u0016M\u001a;DY&,g\u000e\u001e\u000b\u0003\u0005g\f1CY;jY\u0012tU\r^<pe.\u001c\u0005.\u00198oK2$\"Aa3\u0002\u001b\r\u0014X-\u0019;f\t\u0006$\u0018\rR5s)\t\t)&\u0001\tck&dG-T3uC\u0012\fG/\u0019'pOR\u00111Q\u0013\t\u0004\u001d\u000e]\u0015bABM\u0011\n\u00012*\u00194lC6+G/\u00193bi\u0006dunZ\u0001\u0013EVLG\u000e\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0002\u0004 B!!1PBQ\u0013\u0011\u0019\u0019K! \u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039aW-\u00193fe\u0006sG-\u00129pG\",\"a!+\u0011\u0007E\u001cY+C\u0002\u0004.J\u0014a\u0002T3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007\u000e")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig config) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
    }

    public static boolean hasDifferentLogDir(KafkaConfig config) {
        return KafkaRaftManager$.MODULE$.hasDifferentLogDir(config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftIoThread().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$4 -> {
                x$4.destroy();
                return BoxedUnit.UNIT;
            }), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.executor().foreach((Function1 & Serializable)x$5 -> x$5.shutdown()), this, Level.WARN);
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                TopicPartition logDirName_topicPartition = $this.topicPartition;
                Object var3_3 = null;
                return Optional.of(new File($this.config.metadataLogDir(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition)).toPath());
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 1024;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), new KRaftSnapshotMetrics(this.metrics), this.logContext(), topicIdPath, this.clusterId, this.config.nodeId(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteEnableFlag(), () -> $this.config.confluentConfig().clusterMetadataSnapshotTierDeleteRetentionMs(), this.time));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.clusterId, nodeId, this.raftConfig(), (RaftTracer)new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)tracers.elem)).asJava(), this.logContext()));
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$6 -> this.client().traceLogStartOffsetChange(), x$7 -> this.client().traceLogSnapshotGeneration());
    }

    /*
     * WARNING - void declaration
     */
    private NetworkClient buildNetworkClient() {
        void clientChannelBuilder_logContext;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        LogContext logContext = this.logContext();
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string = this.config.saslMechanismControllerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var12_8 = null;
        kafkaConfig = null;
        string = null;
        time = null;
        logContext = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)clientChannelBuilder_logContext, null, null);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.clusterId = clusterId;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.hasDifferentLogDir(config);
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
        this.executor = None$.MODULE$;
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

