/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.HashMap;
import java.util.Map;
import kafka.tier.domain.TierRecordType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

public class RestoreMetricsManager {
    private final Metrics metrics;
    private final HashMap<String, RestoreGaugeMetrics> gaugeMetricsMap;
    private static final String METRIC_GROUP_NAME = "KafkaRestore";
    public static final String RESTORE_STARTED = "RestoreStarted";
    public static final String RESTORE_IN_PROGRESS = "RestoreInProgress";
    public static final String RESTORE_END_WITH_SUCCESS = "RestoreEndWithSuccess";
    public static final String RESTORE_END_WITH_FAILURE = "RestoreEndWithFailure";
    public static final String RESTORE_PARTITIONS_WAITING_COUNT = "RestorePartitionsWaitingCount";
    public static final String RESTORE_PARTITIONS_IN_PROGRESS_COUNT = "RestorePartitionsInProgressCount";
    public static final String RESTORE_PARTITIONS_FAILED_COUNT = "RestorePartitionsFailedCount";
    public static final String RESTORE_PARTITIONS_COMPLETED_COUNT = "RestorePartitionsCompletedCount";
    public static final String RESTORE_FILES_SUCCESS = "RestoreFilesSuccess";
    public static final String RESTORE_FILES_FAILED = "RestoreFilesFailed";
    public static final String RESTORE_SEGMENTS_SUCCESS = "RestoreSegmentsSuccess";
    public static final String RESTORE_SEGMENTS_FAILED = "RestoreSegmentsFailed";
    public static final String RESTORE_BYTES_SUCCESS = "RestoreBytesSuccess";
    public static final String RESTORE_BYTES_FAILED = "RestoreBytesFailed";
    public static final String RESTORE_TIME_TO_REPLAY_EVENTS_MS = "RestoreTimeToReplayEvents";
    public static final String RESTORE_EVENTS_REPLAYED_COUNT = "RestoreEventsReplayedCount";
    public static final String RESTORE_EVENTS_REPLAY_FAILED_COUNT = "RestoreEventsReplayFailedCount";
    public static final String RESTORE_EVENTS_COMMIT_AND_SWAP_COUNT = "RestoreEventsCommitAndSwapCount";
    public static final String RESTORE_EVENTS_FORCE_RESTORE_OR_UNFREEZE_COUNT = "RestoreEventsForceRestoreOrUnfreezeCount";
    public static final String RESTORE_EVENTS_SEGMENTS_TO_RESTORE_COUNT = "RestoreEventsSegmentsToRestoreCount";
    public static final String RESTORE_EVENTS_SEGMENTS_TO_DELETE_COUNT = "RestoreEventsSegmentsToDeleteCount";
    public static final String RESTORE_TIME_TO_BUILD_FTPS_STATES_FROM_SNAPSHOTS_MS = "RestoreTimeToBuildFtpsStatesFromSnapshots";
    public static final String RESTORE_OVERALL_RATE_BYTES_PER_SECOND = "RestoreOverallRate";
    public static final String RESTORE_OBJECT_COPY_MS = "RestoreObjectCopyMs";
    public static final String RESTORE_LIST_VERSIONS_MS = "RestoreListVersionsMs";
    public static final String RESTORE_FETCH_FTPS_MS = "RestoreFetchFtpsMs";
    public static final String RESTORE_FETCH_TIER_TOPIC_SNAPSHOT_MS = "RestoreFetchTierTopicSnapshotMs";
    public static final String RESTORE_OBJECT_COPY_FAILURES = "RestoreObjectCopyFailures";
    public static final String RESTORE_LIST_VERSIONS_FAILURES = "RestoreListVersionsFailures";
    public static final String RESTORE_FETCH_FTPS_FAILURES = "RestoreFetchFtpsFailures";
    private final Sensor restoreObjectCopyMs;
    private final Sensor restoreListVersionsMs;
    private final Sensor restoreFetchFtpsMs;
    private final Sensor restoreFetchTierTopicSnapshotMs;
    private long restoreStartTimeMs;
    private final Map<String, String> restoreMetricsTags;
    private static final String RESTORE_CLUSTER_TAG = "restore_cluster";

    public RestoreMetricsManager(Metrics metrics, String clusterId) {
        this.metrics = metrics;
        this.restoreMetricsTags = new HashMap<String, String>();
        this.restoreMetricsTags.put(RESTORE_CLUSTER_TAG, clusterId);
        this.gaugeMetricsMap = new HashMap();
        this.addGaugeMetrics(RESTORE_STARTED);
        this.addGaugeMetrics(RESTORE_IN_PROGRESS);
        this.addGaugeMetrics(RESTORE_END_WITH_SUCCESS);
        this.addGaugeMetrics(RESTORE_END_WITH_FAILURE);
        this.addGaugeMetrics(RESTORE_PARTITIONS_WAITING_COUNT);
        this.addGaugeMetrics(RESTORE_PARTITIONS_IN_PROGRESS_COUNT);
        this.addGaugeMetrics(RESTORE_PARTITIONS_FAILED_COUNT);
        this.addGaugeMetrics(RESTORE_PARTITIONS_COMPLETED_COUNT);
        this.addGaugeMetrics(RESTORE_FILES_SUCCESS);
        this.addGaugeMetrics(RESTORE_FILES_FAILED);
        this.addGaugeMetrics(RESTORE_SEGMENTS_SUCCESS);
        this.addGaugeMetrics(RESTORE_SEGMENTS_FAILED);
        this.addGaugeMetrics(RESTORE_BYTES_SUCCESS);
        this.addGaugeMetrics(RESTORE_BYTES_FAILED);
        this.addGaugeMetrics(RESTORE_FETCH_FTPS_FAILURES);
        this.addGaugeMetrics(RESTORE_LIST_VERSIONS_FAILURES);
        this.addGaugeMetrics(RESTORE_OBJECT_COPY_FAILURES);
        this.addGaugeMetrics(RESTORE_TIME_TO_REPLAY_EVENTS_MS);
        this.addGaugeMetrics(RESTORE_EVENTS_REPLAYED_COUNT);
        this.addGaugeMetrics(RESTORE_EVENTS_REPLAY_FAILED_COUNT);
        this.addGaugeMetrics(RESTORE_EVENTS_COMMIT_AND_SWAP_COUNT);
        this.addGaugeMetrics(RESTORE_EVENTS_FORCE_RESTORE_OR_UNFREEZE_COUNT);
        this.addGaugeMetrics(RESTORE_EVENTS_SEGMENTS_TO_RESTORE_COUNT);
        this.addGaugeMetrics(RESTORE_EVENTS_SEGMENTS_TO_DELETE_COUNT);
        this.addGaugeMetrics(RESTORE_TIME_TO_BUILD_FTPS_STATES_FROM_SNAPSHOTS_MS);
        this.restoreObjectCopyMs = metrics.sensor(RESTORE_OBJECT_COPY_MS);
        this.addSensorMetrics(this.restoreObjectCopyMs, RESTORE_OBJECT_COPY_MS, "Time to call copy objects in milliseconds");
        this.restoreListVersionsMs = metrics.sensor(RESTORE_LIST_VERSIONS_MS);
        this.addSensorMetrics(this.restoreListVersionsMs, RESTORE_LIST_VERSIONS_MS, "Time to call list versions in milliseconds");
        this.restoreFetchFtpsMs = metrics.sensor(RESTORE_FETCH_FTPS_MS);
        this.addSensorMetrics(this.restoreFetchFtpsMs, RESTORE_FETCH_FTPS_MS, "Time to fetch ftps file in milliseconds");
        this.restoreFetchTierTopicSnapshotMs = metrics.sensor(RESTORE_FETCH_TIER_TOPIC_SNAPSHOT_MS);
        this.addSensorMetrics(this.restoreFetchTierTopicSnapshotMs, RESTORE_FETCH_TIER_TOPIC_SNAPSHOT_MS, "Time to fetch tier topic snapshots in milliseconds");
    }

    public void record(String metricName, long value) {
        if (this.gaugeMetricsMap.containsKey(metricName)) {
            this.gaugeMetricsMap.get(metricName).record(value);
        }
    }

    public void update(String metricName, long value) {
        if (this.gaugeMetricsMap.containsKey(metricName)) {
            this.gaugeMetricsMap.get(metricName).update(value);
        }
    }

    public long readGauge(String metricName) {
        if (this.gaugeMetricsMap.containsKey(metricName)) {
            return this.gaugeMetricsMap.get(metricName).count;
        }
        return 0L;
    }

    public Sensor restoreObjectCopyMs() {
        return this.restoreObjectCopyMs;
    }

    public Sensor restoreListVersionsMs() {
        return this.restoreListVersionsMs;
    }

    public Sensor restoreFetchFtpsMs() {
        return this.restoreFetchFtpsMs;
    }

    public Sensor restoreFetchTierTopicSnapshotMs() {
        return this.restoreFetchTierTopicSnapshotMs;
    }

    public void recordReplayedEventMetrics(TierRecordType recordType, Boolean appendSucceeded) {
        if (appendSucceeded.booleanValue()) {
            this.update(RESTORE_EVENTS_REPLAYED_COUNT, 1L);
        } else {
            if (recordType == TierRecordType.MetadataSnapshotUploadInitiate || recordType == TierRecordType.PartitionFence) {
                return;
            }
            this.update(RESTORE_EVENTS_REPLAY_FAILED_COUNT, 1L);
        }
        switch (recordType) {
            case CompactionCommitAndSwap: {
                this.update(RESTORE_EVENTS_COMMIT_AND_SWAP_COUNT, 1L);
                break;
            }
            case PartitionForceRestore: 
            case PartitionUnfreezeLogStartOffset: {
                this.update(RESTORE_EVENTS_FORCE_RESTORE_OR_UNFREEZE_COUNT, 1L);
            }
        }
    }

    public void startRestoreRecord() {
        this.restoreStartTimeMs = System.currentTimeMillis();
        this.record(RESTORE_IN_PROGRESS, 1L);
        this.addGaugeMetrics(RESTORE_OVERALL_RATE_BYTES_PER_SECOND);
    }

    public void endRestoreRecord() {
        boolean isRestoreSuccess;
        boolean bl = isRestoreSuccess = this.gaugeMetricsMap.get(RESTORE_PARTITIONS_FAILED_COUNT).count == 0L;
        if (isRestoreSuccess) {
            this.record(RESTORE_END_WITH_SUCCESS, 1L);
            this.record(RESTORE_END_WITH_FAILURE, 0L);
        } else {
            this.record(RESTORE_END_WITH_SUCCESS, 0L);
            this.record(RESTORE_END_WITH_FAILURE, 1L);
        }
        this.removeGaugeMetrics(RESTORE_OVERALL_RATE_BYTES_PER_SECOND);
        this.record(RESTORE_IN_PROGRESS, 0L);
    }

    public void recordRestoreOverallRate() {
        if (this.gaugeMetricsMap.get(RESTORE_IN_PROGRESS).count == 1L) {
            long bytesRestoredSoFar = this.gaugeMetricsMap.get(RESTORE_BYTES_SUCCESS).count;
            long restoreTimeUsedInMillis = System.currentTimeMillis() - this.restoreStartTimeMs;
            if (restoreTimeUsedInMillis > 0L) {
                long restoreBytesPerSecond = bytesRestoredSoFar / restoreTimeUsedInMillis * 1000L;
                this.record(RESTORE_OVERALL_RATE_BYTES_PER_SECOND, restoreBytesPerSecond);
            }
        }
    }

    public void recordRestoreObjectCopyFailures(long value) {
        this.update(RESTORE_OBJECT_COPY_FAILURES, value);
    }

    public void recordRestoreListVersionsFailures(long value) {
        this.update(RESTORE_LIST_VERSIONS_FAILURES, value);
    }

    public void recordRestoreFetchFtpsFailures(long value) {
        this.update(RESTORE_FETCH_FTPS_FAILURES, value);
    }

    private void addGaugeMetrics(String metricName) {
        String description = "partitions count in " + metricName + " state";
        this.gaugeMetricsMap.put(metricName, new RestoreGaugeMetrics(metricName, description));
    }

    private void removeGaugeMetrics(String metricName) {
        this.gaugeMetricsMap.get(metricName).deregister();
        this.gaugeMetricsMap.remove(metricName);
    }

    private void addSensorMetrics(Sensor sensor, String metricName, String description) {
        MetricName metric50Percentile = this.metrics.metricName(metricName + "50Percentile", METRIC_GROUP_NAME, "The 50-percentile total time for " + description + " calls made to the object store in ms", this.restoreMetricsTags);
        MetricName metric90Percentile = this.metrics.metricName(metricName + "90Percentile", METRIC_GROUP_NAME, "The 90-percentile total time for " + description + " calls made to the object store in ms", this.restoreMetricsTags);
        MetricName metric99Percentile = this.metrics.metricName(metricName + "99Percentile", METRIC_GROUP_NAME, "The 99-percentile total time for " + description + " calls made to the object store in ms", this.restoreMetricsTags);
        Percentile p50 = new Percentile(metric50Percentile, 50.0);
        Percentile p90 = new Percentile(metric90Percentile, 90.0);
        Percentile p99 = new Percentile(metric99Percentile, 99.0);
        double maxTotalTimeMs = 30000.0;
        int totalBucketSizeInBytes = (int)maxTotalTimeMs * 4;
        Percentiles percentiles = new Percentiles(totalBucketSizeInBytes, maxTotalTimeMs, Percentiles.BucketSizing.CONSTANT, new Percentile[]{p50, p90, p99});
        sensor.add((CompoundStat)percentiles);
    }

    private class RestoreGaugeMetrics {
        private MetricName metricName;
        private volatile long count;

        public RestoreGaugeMetrics(String gaugeName, String description) {
            this.metricName = RestoreMetricsManager.this.metrics.metricName(gaugeName, RestoreMetricsManager.METRIC_GROUP_NAME, description, RestoreMetricsManager.this.restoreMetricsTags);
            Gauge<Long> gauge2 = new Gauge<Long>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Long value(MetricConfig config, long now) {
                    1 var4_3 = this;
                    synchronized (var4_3) {
                        return RestoreGaugeMetrics.this.count;
                    }
                }
            };
            RestoreMetricsManager.this.metrics.addMetric(this.metricName, (MetricValueProvider)gauge2);
        }

        public void deregister() {
            RestoreMetricsManager.this.metrics.removeMetric(this.metricName);
        }

        public synchronized void record(long value) {
            this.count = value;
        }

        public synchronized void update(long value) {
            this.count += value;
        }
    }
}

