/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.AbstractIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentStateIterator
extends AbstractIterator<SegmentState> {
    private static final Logger log = LoggerFactory.getLogger(SegmentStateIterator.class);
    private static final int ENTRY_LENGTH_SIZE = 2;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
    private final TopicIdPartition topicIdPartition;
    private long position;
    private long endPosition;
    private CheckedFileIO channel;
    private ByteBuffer entryBuffer = null;

    public SegmentStateIterator(TopicIdPartition topicIdPartition, CheckedFileIO channel, long startPosition) throws IOException {
        this.topicIdPartition = topicIdPartition;
        this.channel = channel;
        this.position = startPosition;
        this.endPosition = channel.size();
    }

    protected SegmentState makeNext() {
        if (this.position >= this.endPosition) {
            return (SegmentState)this.allDone();
        }
        long currentPosition = this.position;
        try {
            this.lengthBuffer.clear();
            this.channel.read(this.lengthBuffer, currentPosition);
            if (this.lengthBuffer.hasRemaining()) {
                return (SegmentState)this.allDone();
            }
            this.lengthBuffer.flip();
            short length = this.lengthBuffer.getShort();
            if ((currentPosition += (long)this.lengthBuffer.limit()) + (long)length > this.endPosition) {
                return (SegmentState)this.allDone();
            }
            if (this.entryBuffer == null || length > this.entryBuffer.capacity()) {
                if (this.entryBuffer != null) {
                    log.debug("Resizing tier partition state iterator buffer from " + this.entryBuffer.capacity() + " to " + length);
                }
                this.entryBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
            }
            this.entryBuffer.clear();
            this.entryBuffer.limit(length);
            this.channel.read(this.entryBuffer, currentPosition);
            if (this.entryBuffer.hasRemaining()) {
                return (SegmentState)this.allDone();
            }
            this.entryBuffer.flip();
            TierObjectMetadata metadata = new TierObjectMetadata(this.topicIdPartition, TierPartitionStateEntry.getRootAsTierPartitionStateEntry((ByteBuffer)this.entryBuffer));
            SegmentState segmentState = new SegmentState(metadata, this.position);
            this.position = currentPosition += (long)this.entryBuffer.limit();
            return segmentState;
        }
        catch (IOException e) {
            throw new KafkaStorageException("Encountered error during iteration at byte offset " + currentPosition, (Throwable)e);
        }
    }

    public long position() {
        return this.position;
    }
}

