/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tEf\u0001B\u000b\u0017\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000bU\u0003A\u0011\u0001,\t\u000bu\u0003A\u0011\u00010\t\u000bi\u0004A\u0011A>\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAqAa\u0011\u0001\t\u0013\u0011)\u0005C\u0004\u0003T\u0001!IA!\u0016\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!\u0011\u000f\u0001\u0005\n\tM\u0004b\u0002B<\u0001\u0011%!\u0011\u0010\u0005\b\u0005G\u0003A\u0011\u0002BS\u00051\u0019uN\u001c4jO\"+G\u000e]3s\u0015\t9\u0002$\u0001\u0004tKJ4XM\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\r\u0002\u000bU$\u0018\u000e\\:\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0005)ZS\"\u0001\f\n\u000512\"!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\u0004d_:4\u0017n\u001a\t\u0003U=J!\u0001\r\f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011G>tg-[4SKB|7/\u001b;pef\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\f\u0002\u00115,G/\u00193bi\u0006L!a\u000e\u001b\u0003!\r{gNZ5h%\u0016\u0004xn]5u_JL\u0018!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsB\u0019QD\u000f\u001f\n\u0005mr\"AB(qi&|g\u000e\u0005\u0002>\r6\taH\u0003\u0002@\u0001\u00061\u0001o\u001c7jGfT!aF!\u000b\u0005e\u0011%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!a\u0012 \u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014X#\u0001&\u0011\u0005-\u000bfB\u0001'P\u001b\u0005i%B\u0001(\u0017\u0003\u0011a\u0017N\\6\n\u0005Ak\u0015AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefL!AU*\u0003\u00171Kgn['b]\u0006<WM\u001d\u0006\u0003!6\u000b1c\u00197vgR,'\u000fT5oW6\u000bg.Y4fe\u0002\na\u0001P5oSRtDCB,Y3j[F\f\u0005\u0002+\u0001!)\u0001f\u0002a\u0001S!)Qf\u0002a\u0001]!)\u0011g\u0002a\u0001e!)\u0001h\u0002a\u0001s!)\u0001j\u0002a\u0001\u0015\u0006Q\u0011\r\u001c7D_:4\u0017nZ:\u0015\u0005}\u0013\b\u0003\u00021fO>l\u0011!\u0019\u0006\u0003E\u000e\fq!\\;uC\ndWM\u0003\u0002e=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\f'aA'baB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw\r\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u0007\u001f\nTWm\u0019;\t\u000b5B\u0001\u0019A:\u0011\u0005QDX\"A;\u000b\u000552(BA<B\u0003\u0019\u0019w.\\7p]&\u0011\u00110\u001e\u0002\u000f\u0003\n\u001cHO]1di\u000e{gNZ5h\u0003qA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014V-];fgR$R\u0001`A\u0003\u0003;\u00012!`A\u0001\u001b\u0005q(BA@w\u0003\u001diWm]:bO\u0016L1!a\u0001\u007f\u0005m!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX\rR1uC\"9\u0011qA\u0005A\u0002\u0005%\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0017\t9B\u0004\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002G\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t)\"a\u0004\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011\u0011DA\u000e\u0005\u001d\u0011V-];fgRTA!!\u0006\u0002\u0010!9\u0011qD\u0005A\u0002\u0005\u0005\u0012AC1vi\"DU\r\u001c9feB\u0019!&a\t\n\u0007\u0005\u0015bC\u0001\u0006BkRD\u0007*\u001a7qKJ\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\u000b\u0003W\t\t&!\u001f\u0002\u0004\u0006]\u0005CBA\u0017\u0003{\t\u0019E\u0004\u0003\u00020\u0005eb\u0002BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\"$\u0001\u0004=e>|GOP\u0005\u0002?%\u0019\u00111\b\u0010\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005mb\u0004\u0005\u0003\u0002F\u0005-cbA?\u0002H%\u0019\u0011\u0011\n@\u00027\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\ti%a\u0014\u0003+\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm];mi*\u0019\u0011\u0011\n@\t\u000f\u0005M#\u00021\u0001\u0002V\u0005)\"/Z:pkJ\u001cW\rV8D_:4\u0017n\u001a(b[\u0016\u001c\bCBA\u0017\u0003{\t9\u0006\u0005\u0003\u0002Z\u0005Md\u0002BA.\u0003_rA!!\u0018\u0002n9!\u0011qLA6\u001d\u0011\t\t'!\u001b\u000f\t\u0005\r\u0014q\r\b\u0005\u0003c\t)'C\u0001F\u0013\t\u0019E)\u0003\u0002\u001a\u0005&\u0011q/Q\u0005\u0003\u007fZL1!!\u001d\u007f\u0003i!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z9vKN$H)\u0019;b\u0013\u0011\t)(a\u001e\u0003/\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm]8ve\u000e,'bAA9}\"9\u00111\u0010\u0006A\u0002\u0005u\u0014aD5oG2,H-Z*z]>t\u00170\\:\u0011\u0007u\ty(C\u0002\u0002\u0002z\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0006*\u0001\r!a\"\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0003BAE\u0003'k!!a#\u000b\t\u00055\u0015qR\u0001\u0005CV$\bNC\u0002\u0002\u0012Z\f\u0001b]3dkJLG/_\u0005\u0005\u0003+\u000bYI\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u000f\u0005e%\u00021\u0001\u0002~\u0005!\u0012N\\2mk\u0012,Gi\\2v[\u0016tG/\u0019;j_:\fac\u0019:fCR,Gk\u001c9jG\u000e{gNZ5h\u000b:$(/\u001f\u000b\u000b\u0003?\u000b\u0019-a7\u0002l\u00065HCBAQ\u0003O\u000bI\f\u0005\u0003\u0002F\u0005\r\u0016\u0002BAS\u0003\u001f\u0012Q\u0004R3tGJL'-Z\"p]\u001aLwm\u001d*fg>,(oY3SKN,H\u000e\u001e\u0005\b\u0003S[\u0001\u0019AAV\u0003\u0011q\u0017-\\3\u0011\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\t\fE\u0002\u00022yI1!a-\u001f\u0003\u0019\u0001&/\u001a3fM&\u0019a.a.\u000b\u0007\u0005Mf\u0004C\u0004\u0002<.\u0001\r!!0\u0002\u000bY\fG.^3\u0011\u0007u\ty,C\u0002\u0002Bz\u00111!\u00118z\u0011\u001d\t)m\u0003a\u0001\u0003\u000f\f\u0011\u0002\\8h\u0007>tg-[4\u0011\t\u0005%\u0017q[\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006\u0019An\\4\u000b\t\u0005E\u00171[\u0001\nS:$XM\u001d8bYNT1!!6B\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!7\u0002L\nIAj\\4D_:4\u0017n\u001a\u0005\b\u0003;\\\u0001\u0019AAp\u0003)!x\u000e]5d!J|\u0007o\u001d\t\u0005\u0003C\f9/\u0004\u0002\u0002d*\u0019\u0011Q]6\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003S\f\u0019O\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u001f\f\u0001\u0004\ti\bC\u0004\u0002\u001a.\u0001\r!! \u0002%\u0019LG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0007\u0003g\fyP!\u0003\u0011\u000b\u0001\f)0!?\n\u0007\u0005]\u0018M\u0001\u0004Ck\u001a4WM\u001d\t\b;\u0005m\u00181VA_\u0013\r\tiP\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\u0005A\u00021\u0001\u0003\u0004\u000591m\u001c8gS\u001e\u001c\b\u0003\u0003B\u0003\u0005\u000f\tY+!0\u000e\u0003\rL!AZ2\t\u000f\t-A\u00021\u0001\u0003\u000e\u0005Y1m\u001c8gS\u001et\u0015-\\3t!\u0011i\"Ha\u0004\u0011\r\t\u0015!\u0011CAV\u0013\r\u0011\u0019b\u0019\u0002\u0004'\u0016$\u0018\u0001\u0006<bY&$\u0017\r^3D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\u0006\u0005\u0003\u001a\t}!\u0011\u0006B\u0018!\ri\"1D\u0005\u0004\u0005;q\"\u0001B+oSRDqA!\t\u000e\u0001\u0004\u0011\u0019#\u0001\u0005sKN|WO]2f!\r!(QE\u0005\u0004\u0005O)(AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\b\u0005Wi\u0001\u0019\u0001B\u0017\u0003A\u0019wN\u001c4jO\u0016sGO]5fg6\u000b\u0007\u000f\u0005\u0005\u0003\u0006\t\u001d\u00111VAV\u0011\u001d\t))\u0004a\u0001\u0003\u000f\u000bqc\u0019:fCR,'I]8lKJ\u001cuN\u001c4jO\u0016sGO]=\u0015\u0011\tU\"1\bB \u0005\u0003\"b!!)\u00038\te\u0002bBAU\u001d\u0001\u0007\u00111\u0016\u0005\b\u0003ws\u0001\u0019AA_\u0011\u001d\u0011iD\u0004a\u0001\u0003{\nq\u0002]3s\u0005J|7.\u001a:D_:4\u0017n\u001a\u0005\b\u0003wr\u0001\u0019AA?\u0011\u001d\tIJ\u0004a\u0001\u0003{\nAd\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0004\u0003H\t5#\u0011\u000b\u000b\u0007\u0003C\u0013IEa\u0013\t\u000f\u0005%v\u00021\u0001\u0002,\"9\u00111X\bA\u0002\u0005u\u0006b\u0002B(\u001f\u0001\u0007!qB\u0001\u0018Kb\u0004H.[2ji2L8+\u001a;D_:4\u0017nZ&fsNDQ!L\bA\u0002M\fabY8oM&<7+\u001f8p]fl7\u000f\u0006\u0005\u0003X\t}#\u0011\rB4!\u0019\ti#!\u0010\u0003ZA!\u0011Q\tB.\u0013\u0011\u0011i&a\u0014\u0003-\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u001c\u0016P\\8os6Dq!!+\u0011\u0001\u0004\tY\u000bC\u0004\u0003dA\u0001\rA!\u001a\u0002\u0011MLhn\u001c8z[N\u0004b!!\f\u0002>\u0005-\u0006b\u0002B5!\u0001\u0007\u0011QP\u0001\fSN\u001cVM\\:ji&4X-\u0001\bce>\\WM]*z]>t\u00170\\:\u0015\t\t\u0015$q\u000e\u0005\b\u0003S\u000b\u0002\u0019AAV\u0003M\u0011'o\\6fe\u0012{7-^7f]R\fG/[8o)\u0011\tYK!\u001e\t\u000f\u0005%&\u00031\u0001\u0002,\u0006\u00112m\u001c8gS\u001e\u0014Vm\u001d9p]N,G+\u001f9f)\u0011\u0011YHa$\u0011\t\tu$\u0011\u0012\b\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*\u0019!1\u0011<\u0002\u0011I,\u0017/^3tiNLAAa\"\u0003\u0002\u00069B)Z:de&\u0014WmQ8oM&<7OU3ta>t7/Z\u0005\u0005\u0005\u0017\u0013iI\u0001\u0006D_:4\u0017n\u001a+za\u0016TAAa\"\u0003\u0002\"9!\u0011S\nA\u0002\tM\u0015AC2p]\u001aLw\rV=qKB!QD\u000fBK!\u0011\u00119J!(\u000f\u0007Q\u0014I*C\u0002\u0003\u001cV\f\u0011bQ8oM&<G)\u001a4\n\t\t}%\u0011\u0015\u0002\u0005)f\u0004XMC\u0002\u0003\u001cV\faC]3t_V\u00148-\u001a(b[\u0016$vN\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0005\u0005O\u0013i\u000bE\u0002\u001e\u0005SK1Aa+\u001f\u0005\rIe\u000e\u001e\u0005\b\u0005_#\u0002\u0019AAV\u00031\u0011Xm]8ve\u000e,g*Y7f\u0001")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(config.originals()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(config.nonInternalValues()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    public DescribeConfigsResponseData handleDescribeConfigsRequest(RequestChannel.Request request, AuthHelper authHelper) {
        void var6_6;
        void var5_5;
        DescribeConfigsRequest describeConfigsRequest = (DescribeConfigsRequest)request.body(ClassTag$.MODULE$.apply(DescribeConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        Tuple2 tuple2 = CollectionConverters$.MODULE$.ListHasAsScala(describeConfigsRequest.data().resources()).asScala().partition((Function1 & Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$handleDescribeConfigsRequest$1(authHelper, request, resource)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer authorizedResources = (Buffer)tuple2._1();
        Buffer unauthorizedResources = (Buffer)tuple2._2();
        List<DescribeConfigsResponseData.DescribeConfigsResult> authorizedConfigs = this.describeConfigs((List<DescribeConfigsRequestData.DescribeConfigsResource>)var5_5.toList(), describeConfigsRequest.data().includeSynonyms(), request.session().principal(), describeConfigsRequest.data().includeDocumentation());
        Buffer unauthorizedConfigs = (Buffer)var6_6.map((Function1 & Serializable)resource -> {
            Errors errors;
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type)))) {
                errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
            } else if (ConfigResource.Type.TOPIC.equals(type)) {
                errors = Errors.TOPIC_AUTHORIZATION_FAILED;
            } else {
                throw new InvalidRequestException(new StringBuilder(39).append("Unexpected resource type ").append(type).append(" for resource ").append(resource.resourceName()).toString());
            }
            Errors error = errors;
            return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(error.code()).setErrorMessage(error.message()).setConfigs(Collections.emptyList()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType());
        });
        return new DescribeConfigsResponseData().setResults(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)authorizedConfigs.$plus$plus((IterableOnce)unauthorizedConfigs)).asJava());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return resourceToConfigNames.map((Function1 & Serializable)x0$1 -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    String topic = x0$1.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig.fromProps($this.config.extractLogConfigMap(), (Properties)topicProps);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                } else {
                    if (ConfigResource.Type.BROKER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                            void createResponseConfig$1_createConfigEntry2;
                            Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                            Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry2, arg_0));
                            describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                            return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                        }
                        if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(x0$1.resourceName()).toString());
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs($this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        void createResponseConfig$1_createConfigEntry;
                        if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(x0$1.resourceName()).toString());
                        }
                        ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)x0$1.resourceType()), x0$1.resourceName());
                        this.validateConfigPolicy(configResource, (Map<String, String>)((Map)Map$.MODULE$.empty()), principal);
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
                        scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                        return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                    }
                    if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                        Properties properties;
                        if (this.clusterLinkManager() == null) {
                            throw new UnsupportedVersionException("Cannot describe CLUSTER_LINK resources in this version of the software.");
                        }
                        String linkName = x0$1.resourceName();
                        if (linkName == null || linkName.isEmpty()) {
                            throw new InvalidRequestException("Cluster link name must not be empty");
                        }
                        Uuid linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                        this.clusterLinkManager().ensureClusterLinkExists(linkId);
                        ConfigRepository configRepository = $this.configRepository;
                        if (configRepository instanceof ZkConfigRepository) {
                            properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, CoreUtils$.MODULE$.toJavaUUID(linkId).toString()));
                        } else {
                            if (!(configRepository instanceof KRaftMetadataCache)) throw new IllegalStateException("Unsupported config repository type");
                            properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                        }
                        Properties persistentProps = properties;
                        String errorMessage = new StringBuilder(202).append("Cluster link configs could not be decoded for link '").append(linkName).append("', '").append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append("' ").append("may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.").toString();
                        try {
                            void createResponseConfig$1_createConfigEntry;
                            scala.collection.mutable.Set explicitlySetConfigKeys = CollectionConverters$.MODULE$.SetHasAsScala(persistentProps.keySet()).asScala();
                            this.debug((Function0<String>)((Function0 & Serializable)() -> ConfigHelper.$anonfun$describeConfigs$9((Set)explicitlySetConfigKeys)));
                            ClusterLinkConfig config = (ClusterLinkConfig)((Object)((Object)this.clusterLinkManager().linkConfigFromPersistentProps(linkName, persistentProps, false).getOrElse((Function0 & Serializable)() -> {
                                throw new InvalidConfigurationException(errorMessage);
                            })));
                            Function2 & Serializable intersect = (arg_0, arg_1) -> ConfigHelper.$anonfun$describeConfigs$11(this, (Set)explicitlySetConfigKeys, config, arg_0, arg_1);
                            scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(config);
                            Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                            describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(createResponseConfig$1_configEntries).asJava());
                            return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
                        }
                        catch (ConfigException configException) {
                            throw new InvalidConfigurationException(errorMessage);
                        }
                    }
                    if (!ConfigResource.Type.CLIENT_METRICS.equals(type)) throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    String subscriptionName = x0$1.resourceName();
                    if (subscriptionName == null || subscriptionName.isEmpty()) {
                        throw new InvalidRequestException("Client metrics subscription name must not be empty");
                    }
                    Properties entityProps = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, subscriptionName));
                    ListBuffer configEntries = new ListBuffer();
                    entityProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> configEntries.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name.toString()).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.CLIENT_METRICS_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()))));
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)configEntries).asJava());
                }
                return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(x0$1).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        });
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option configEntryType = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LogConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1 & Serializable)s -> this.configSynonyms((String)s, DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)s, true), isSensitive)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym);
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((IterableOnceOps)configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), CollectionConverters$.MODULE$.MapHasAsJava(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List<String> allNames = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        String valueAsString = isSensitive ? null : (value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
        List allSynonyms = this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$6)));
        List synonyms = !includeSynonyms ? package$.MODULE$.List().empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(Set<String> explicitlySetConfigKeys, AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType = config.typeOf(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)Option$.MODULE$.apply((Object)configEntryType));
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(explicitlySetConfigKeys.contains((Object)name) ? DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        if (ConfigDef.Type.BOOLEAN.equals(type)) {
            return DescribeConfigsResponse.ConfigType.BOOLEAN;
        }
        if (ConfigDef.Type.STRING.equals(type)) {
            return DescribeConfigsResponse.ConfigType.STRING;
        }
        if (ConfigDef.Type.INT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.INT;
        }
        if (ConfigDef.Type.SHORT.equals(type)) {
            return DescribeConfigsResponse.ConfigType.SHORT;
        }
        if (ConfigDef.Type.LONG.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LONG;
        }
        if (ConfigDef.Type.DOUBLE.equals(type)) {
            return DescribeConfigsResponse.ConfigType.DOUBLE;
        }
        if (ConfigDef.Type.LIST.equals(type)) {
            return DescribeConfigsResponse.ConfigType.LIST;
        }
        if (ConfigDef.Type.CLASS.equals(type)) {
            return DescribeConfigsResponse.ConfigType.CLASS;
        }
        if (ConfigDef.Type.PASSWORD.equals(type)) {
            return DescribeConfigsResponse.ConfigType.PASSWORD;
        }
        return DescribeConfigsResponse.ConfigType.UNKNOWN;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(resourceName));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsRequest$1(AuthHelper authHelper$1, RequestChannel.Request request$1, DescribeConfigsRequestData.DescribeConfigsResource resource) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
        if (ConfigResource.Type.BROKER.equals(type) ? true : (ConfigResource.Type.BROKER_LOGGER.equals(type) ? true : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? true : ConfigResource.Type.CLIENT_METRICS.equals(type)))) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            return authHelper$1.authorize(request$1.context(), AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, resource.resourceName(), authHelper$1.authorize$default$5(), authHelper$1.authorize$default$6(), authHelper$1.authorize$default$7());
        }
        throw new InvalidRequestException(new StringBuilder(39).append("Unexpected resource type ").append(type).append(" for resource ").append(resource.resourceName()).toString());
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource x1$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x1$1.configurationKeys()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).map((Function1 & Serializable)x$4 -> CollectionConverters$.MODULE$.ListHasAsScala(x$4).asScala().toSet())).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String name = (String)x0$1._1();
                Object value = x0$1._2();
                return (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            }
            throw new MatchError(null);
        });
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs(CollectionConverters$.MODULE$.BufferHasAsJava(configEntries).asJava());
    }

    public static final /* synthetic */ String $anonfun$describeConfigs$9(Set explicitlySetConfigKeys$1) {
        return new StringBuilder(28).append("Explicitly set config keys ").append(explicitlySetConfigKeys$1).append(".").toString();
    }

    public static final /* synthetic */ DescribeConfigsResponseData.DescribeConfigsResourceResult $anonfun$describeConfigs$11(ConfigHelper $this, Set explicitlySetConfigKeys$1, ClusterLinkConfig config$1, String name, Object value) {
        return $this.createClusterLinkConfigEntry((Set<String>)explicitlySetConfigKeys$1, config$1, name, value);
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean sslTruststorePasswordCheck;
            String configName = (String)x0$1._1();
            boolean recordInterceptorCheck = !configName.equals("confluent.append.record.interceptor.classes");
            boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
            boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
            boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
            boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
            boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
            boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
            boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
            boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
            boolean bearerAuthIssuerEndpoint = !configName.equals("confluent.bearer.auth.issuer.endpoint.url");
            boolean bearerAuthClientId = !configName.equals("confluent.bearer.auth.client.id");
            boolean bearerAuthClientSecret = !configName.equals("confluent.bearer.auth.client.secret");
            boolean bearerAuthClientScope = !configName.equals("confluent.bearer.auth.scope");
            boolean bearerAuthClientScopeClaim = !configName.equals("confluent.bearer.auth.scope.claim.name");
            boolean bearerAuthClientSubClaim = !configName.equals("confluent.bearer.auth.sub.claim.name");
            boolean bearerAuthLogicalCluster = !configName.equals("confluent.bearer.auth.logical.cluster");
            boolean bearerAuthIdentityPool = !configName.equals("confluent.bearer.auth.identity.pool.id");
            boolean bearerAuthBufferExpirySecond = !configName.equals("confluent.bearer.auth.cache.expiry.buffer.seconds");
            boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
            boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
            boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
            boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
            boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
            boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
            boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
            boolean bl = sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
            return basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && bearerAuthIssuerEndpoint && bearerAuthClientId && bearerAuthClientSecret && bearerAuthClientScope && bearerAuthClientScopeClaim && bearerAuthClientSubClaim && bearerAuthLogicalCluster && bearerAuthIdentityPool && bearerAuthBufferExpirySecond && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((Object)configName)));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$6) {
        return perBrokerConfig$1 || x$6.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return (Buffer)allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

