/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig$;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.TopicPlacementReplicaPlacer;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.metrics.ClientMetricsConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\t\u0013\u0001]A\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tc\u0001\u0011\t\u0011)A\u0005[!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00035\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u001dI\u0005A1A\u0005\u0002)Ca!\u0015\u0001!\u0002\u0013Y\u0005\"\u0002*\u0001\t\u0013\u0019\u0006\"\u0002.\u0001\t\u0013Y\u0006\"\u00027\u0001\t\u0013i\u0007\"B8\u0001\t\u0013\u0001\b\"\u0002>\u0001\t\u0013Y\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u0007\u0001A\u0011IA\u0005\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\u000f\u0001\t\u0013\tYD\u0001\u0011D_:$(o\u001c7mKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]Z\u000bG.\u001b3bi>\u0014(BA\n\u0015\u0003\u0019\u0019XM\u001d<fe*\tQ#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A\u0002\u0005\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005!A.\u00198h\u0015\u0005i\u0012\u0001\u00026bm\u0006L!a\b\u000e\u0003\r=\u0013'.Z2u!\t\t\u0013&D\u0001#\u0015\t\u0019C%\u0001\u0006d_:$(o\u001c7mKJT!!F\u0013\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0005\u0003U\t\u0012acQ8oM&<WO]1uS>tg+\u00197jI\u0006$xN]\u0001\fW\u000647.Y\"p]\u001aLw-F\u0001.!\tqs&D\u0001\u0013\u0013\t\u0001$CA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001D6bM.\f7i\u001c8gS\u001e\u0004\u0013aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0016\u0003Q\u00022!\u000e\u001e=\u001b\u00051$BA\u001c9\u0003!1WO\\2uS>t'BA\u001d\u001d\u0003\u0011)H/\u001b7\n\u0005m2$\u0001C*vaBd\u0017.\u001a:\u0011\u0005u\nU\"\u0001 \u000b\u0005}\u0002\u0015AB2p[6|gN\u0003\u0002\u0014I%\u0011!I\u0010\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006\u0001R.\u001a;bI\u0006$\u0018MV3sg&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019;\u0005\n\u0005\u0002/\u0001!)1&\u0002a\u0001[!)!'\u0002a\u0001i\u00051An\\4hKJ,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u001e\nQa\u001d7gi)L!\u0001U'\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq#[:QCJ$\u0018\u000e^5p]\u001e\u0013x.\u001e9F]\u0006\u0014G.\u001a3\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013qAQ8pY\u0016\fg.A\twC2LG-\u0019;f)>\u0004\u0018n\u0019(b[\u0016$\"\u0001X0\u0011\u0005Uk\u0016B\u00010W\u0005\u0011)f.\u001b;\t\u000b\u0001L\u0001\u0019A1\u0002\t9\fW.\u001a\t\u0003E&t!aY4\u0011\u0005\u00114V\"A3\u000b\u0005\u00194\u0012A\u0002\u001fs_>$h(\u0003\u0002i-\u00061\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tAg+\u0001\nwC2LG-\u0019;f\u0005J|7.\u001a:OC6,GC\u0001/o\u0011\u0015\u0001'\u00021\u0001b\u0003\u0011\"\bN]8x\u000bb\u001cW\r\u001d;j_:4uN]+oW:|wO\u001c*fg>,(oY3UsB,GC\u0001/r\u0011\u0015\u00118\u00021\u0001t\u0003!\u0011Xm]8ve\u000e,\u0007C\u0001;y\u001b\u0005)(B\u0001<x\u0003\u0019\u0019wN\u001c4jO*\u0011q\bJ\u0005\u0003sV\u0014abQ8oM&<'+Z:pkJ\u001cW-A\u0013wC2LG-\u0019;f\u0005J|7.\u001a:TG\",W.\u0019,bY&$\u0017\r^5p]\u000e{gNZ5hgR\u0011A\f \u0005\u0006m2\u0001\r! \t\u0005}~\f\u0017-D\u00019\u0013\r\t\t\u0001\u000f\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u0003<bY&$\u0017\r^3\u0015\u0007q\u000b9\u0001C\u0003s\u001b\u0001\u00071\u000fF\u0003]\u0003\u0017\ti\u0001C\u0003s\u001d\u0001\u00071\u000fC\u0003w\u001d\u0001\u0007Q0A\rwC2LG-\u0019;f)>\u0004\u0018nY\"p]\u001aLwm\u00115b]\u001e,G#\u0003/\u0002\u0014\u0005]\u00111DA\u001b\u0011\u0019\t)b\u0004a\u0001{\u0006\u0011\u0002O]3w%\u0016\u001cx\u000e\u001c<fI\u000e{gNZ5h\u0011\u0019\tIb\u0004a\u0001{\u0006\tb.Z<SKN|GN^3e\u0007>tg-[4\t\u000f\u0005uq\u00021\u0001\u0002 \u00059!M]8lKJ\u001c\b#\u0002@\u0002\"\u0005\u0015\u0012bAA\u0012q\tA\u0011\n^3sCR|'\u000f\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ad\u0017mY3nK:$(bAA\u0018I\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u00024\u0005%\"\u0001D+tC\ndWM\u0011:pW\u0016\u0014\bBBA\u001c\u001f\u0001\u0007A+A\rjgR{\u0007/[2QY\u0006\u001cW-\\3oiN+\b\u000f]8si\u0016$\u0017!\u000b<bY&$\u0017\r^3U_BL7\r\u00157bG\u0016lWM\u001c;D_:4\u0017nZ;sCRLwN\\\"iC:<W\rF\u0005]\u0003{\ty%a\u0015\u0002V!9\u0011q\b\tA\u0002\u0005\u0005\u0013A\u00059sKZ$v\u000e]5d!2\f7-Z7f]R\u0004RA`A\"\u0003\u000fJ1!!\u00129\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003BA%\u0003\u0017j!!!\f\n\t\u00055\u0013Q\u0006\u0002\u000f)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0011\u001d\t\t\u0006\u0005a\u0001\u0003\u0003\n\u0011C\\3x)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0011\u001d\ti\u0002\u0005a\u0001\u0003?Aa!a\u000e\u0011\u0001\u0004!\u0006")
public class ControllerConfigurationValidator
implements ConfigurationValidator {
    private final KafkaConfig kafkaConfig;
    private final Supplier<MetadataVersion> metadataVersion;
    private final Logger logger;

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public Supplier<MetadataVersion> metadataVersion() {
        return this.metadataVersion;
    }

    public Logger logger() {
        return this.logger;
    }

    private boolean isPartitionGroupEnabled() {
        if (Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isK2TopicCreationEnabled()) && this.metadataVersion().get() == null) {
            throw null;
        }
        return false;
    }

    private void validateTopicName(String name) {
        if (name.isEmpty()) {
            throw new InvalidRequestException("Default topic resources are not allowed.");
        }
        Topic.validate((String)name);
    }

    private void validateBrokerName(String name) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
            Integer n;
            try {
                n = Integer.valueOf(name);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidRequestException("Unable to parse broker name as a base 10 number.");
            }
            Integer brokerId = n;
            if (Predef$.MODULE$.Integer2int(brokerId) < 0) {
                throw new InvalidRequestException("Invalid negative broker ID.");
            }
            return;
        }
    }

    private void throwExceptionForUnknownResourceType(ConfigResource resource) {
        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.type()).toString());
    }

    private void validateBrokerSchemaValidationConfigs(Map<String, String> config) {
        HashMap<String, Object> allConfigs = new HashMap<String, Object>(this.kafkaConfig().originals());
        allConfigs.putAll(config);
        try {
            LogConfig.createSchemaValidationInterceptorIfNeeded(allConfigs, (Logger)this.logger()).ifPresent(x$1 -> x$1.close());
            return;
        }
        catch (Exception e) {
            this.logger().error("Error closing schema validation interceptor", (Throwable)e);
            return;
        }
    }

    public void validate(ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validate(ConfigResource resource, Map<String, String> config) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.TOPIC.equals(type)) {
            this.validateTopicName(resource.name());
            Properties properties = new Properties();
            ArrayBuffer nullTopicConfigs = new ArrayBuffer();
            config.entrySet().forEach(e -> {
                if (e.getValue() == null) {
                    nullTopicConfigs.$plus$eq(e.getKey());
                    return;
                }
                properties.setProperty((String)e.getKey(), (String)e.getValue());
            });
            if (nullTopicConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(44).append("Null value not supported for topic configs: ").append(nullTopicConfigs.mkString(",")).toString());
            }
            LogConfig.validate((Properties)properties, this.kafkaConfig().extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isRemoteLogStorageSystemEnabled()), (boolean)this.isPartitionGroupEnabled(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().isNominalTopicCreationEnabled()));
            this.validateBrokerSchemaValidationConfigs(config);
            return;
        }
        if (ConfigResource.Type.BROKER.equals(type)) {
            this.validateBrokerName(resource.name());
            return;
        }
        if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
            ClusterLinkConfig$.MODULE$.create(config, (Option<KafkaConfig>)new Some((Object)this.kafkaConfig()), true);
            return;
        }
        if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
            Properties properties = new Properties();
            config.entrySet().forEach(e -> properties.setProperty((String)e.getKey(), (String)e.getValue()));
            ClientMetricsConfigs.validate((String)resource.name(), (Properties)properties);
            return;
        }
        this.throwExceptionForUnknownResourceType(resource);
    }

    public void validateTopicConfigChange(Map<String, String> prevResolvedConfig, Map<String, String> newResolvedConfig, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        LogConfig curLogConfig = LogConfig.fromProps(prevResolvedConfig, (Properties)new Properties());
        LogConfig nextLogConfig = LogConfig.fromProps(newResolvedConfig, (Properties)new Properties());
        LogConfig.validateChange((LogConfig)curLogConfig, (LogConfig)nextLogConfig, (MetadataVersion)this.metadataVersion().get(), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierFeature()), (boolean)Predef$.MODULE$.Boolean2boolean(this.kafkaConfig().confluentConfig().tierCleanerFeatureEnable()));
        this.validateBrokerSchemaValidationConfigs(newResolvedConfig);
        this.validateTopicPlacementConfigurationChange(curLogConfig.confluentLogConfig().topicPlacementConstraints, nextLogConfig.confluentLogConfig().topicPlacementConstraints, brokers, isTopicPlacementSupported);
    }

    private void validateTopicPlacementConfigurationChange(Optional<TopicPlacement> prevTopicPlacement, Optional<TopicPlacement> newTopicPlacement, Iterator<UsableBroker> brokers, boolean isTopicPlacementSupported) {
        if (!Objects.equals(prevTopicPlacement, newTopicPlacement)) {
            newTopicPlacement.ifPresent(topicPlacement -> {
                if (!isTopicPlacementSupported) {
                    throw new InvalidConfigurationException("Topic placement is not supported.");
                }
                TopicPlacementReplicaPlacer.validateTopicPlacementConfigurationChange((TopicPlacement)topicPlacement, (Iterator)brokers, (Logger)this.logger(), x$2 -> DirectoryId.MIGRATING);
            });
            return;
        }
    }

    public ControllerConfigurationValidator(KafkaConfig kafkaConfig, Supplier<MetadataVersion> metadataVersion) {
        this.kafkaConfig = kafkaConfig;
        this.metadataVersion = metadataVersion;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

