/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001B\u0011#\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011)\u0019!C\u0001u!Aa\t\u0001B\u0001B\u0003%1\b\u0003\u0005H\u0001\t\u0015\r\u0011\"\u0001I\u0011!a\u0005A!A!\u0002\u0013I\u0005\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\t\u0011U\u0003!\u0011!Q\u0001\n=C\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00051\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003J\u0011!Q\u0007A!A!\u0002\u0013Y\u0004\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u00111\u0004!Q1A\u0005\n5D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\ti\u0002\u0011)\u0019!C\u0001k\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nmBq!a\u0002\u0001\t\u0003\tI\u0001C\u0005\u0002&\u0001\u0011\r\u0011\"\u0001\u0002(!A\u0011\u0011\t\u0001!\u0002\u0013\tI\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u00111\u000b\u0001!\u0002\u0013\t9\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0001\u0002X!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005}\u0004\u0001\"\u0001\u0002\u0002\"9\u0011q\u0011\u0001\u0005\u0002\u0005%u!CAFE\u0005\u0005\t\u0012AAG\r!\t#%!A\t\u0002\u0005=\u0005bBA\u0004=\u0011\u0005\u0011\u0011\u0013\u0005\n\u0003's\u0012\u0013!C\u0001\u0003+\u0013qcS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\u0004vn\u001c7\u000b\u0005\r\"\u0013AB:feZ,'OC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007J\u0001\u0006kRLGn]\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\u0004d_:4\u0017n\u001a\t\u0003m]j\u0011AI\u0005\u0003q\t\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0002wA\u0011Ah\u0011\b\u0003{\u0005\u0003\"A\u0010\u0016\u000e\u0003}R!\u0001\u0011\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0011%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"+\u0003)\u0019G.^:uKJLE\rI\u0001\tEJ|7.\u001a:JIV\t\u0011\n\u0005\u0002*\u0015&\u00111J\u000b\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0012\nqA\\3uo>\u00148.\u0003\u0002U#\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002\t\u0005\u0004\u0018n]\u000b\u00021B\u0011a'W\u0005\u00035\n\u0012\u0011#\u00119j%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003\u0015\t\u0007/[:!\u0003\u0011!\u0018.\\3\u0011\u0005y;W\"A0\u000b\u0005E\u0002'BA1c\u0003\u0019\u0019w.\\7p]*\u0011Qe\u0019\u0006\u0003I\u0016\fa!\u00199bG\",'\"\u00014\u0002\u0007=\u0014x-\u0003\u0002i?\n!A+[7f\u0003)qW/\u001c+ie\u0016\fGm]\u0001 e\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003Z<\u0017\n\u001a7f\u001b\u0016$(/[2OC6,\u0017A\u00067pO\u0006sG\r\u00165sK\u0006$g*Y7f!J,g-\u001b=\u0002\u000f5,GO]5dgV\ta\u000e\u0005\u0002pc6\t\u0001O\u0003\u0002mA&\u0011!\u000f\u001d\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ,\u0012A\u001e\t\u0003o~l\u0011\u0001\u001f\u0006\u0003sj\fAaY8sK*\u0011An\u001f\u0006\u0003yv\fa!_1n[\u0016\u0014(\"\u0001@\u0002\u0007\r|W.C\u0002\u0002\u0002a\u0014Q!T3uKJ\f1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002\n\u0001B\\8eK:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005Y\u0002\u0001\"\u0002\u001b\u0014\u0001\u0004)\u0004\"B\u001d\u0014\u0001\u0004Y\u0004\"B$\u0014\u0001\u0004I\u0005\"B'\u0014\u0001\u0004y\u0005\"\u0002,\u0014\u0001\u0004A\u0006\"\u0002/\u0014\u0001\u0004i\u0006\"B5\u0014\u0001\u0004I\u0005\"\u00026\u0014\u0001\u0004Y\u0004\"B6\u0014\u0001\u0004Y\u0004\"\u00027\u0014\u0001\u0004q\u0007\"\u0002;\u0014\u0001\u00041\b\u0002CA\u0003'A\u0005\t\u0019A\u001e\u0002\u001dQD'/Z1e!>|GnU5{KV\u0011\u0011\u0011\u0006\t\u0005\u0003W\ti$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u0019\tGo\\7jG*!\u00111GA\u001b\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003o\tI$\u0001\u0003vi&d'BAA\u001e\u0003\u0011Q\u0017M^1\n\t\u0005}\u0012Q\u0006\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u001fQD'/Z1e!>|GnU5{K\u0002\n1\u0004\u001e5sK\u0006$\u0007o\\8m\u0007\u0006\u0004\u0018mY5usN+gn]8s\u001fB$XCAA$!\u0015I\u0013\u0011JA'\u0013\r\tYE\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\fy%C\u0002\u0002RA\u0014aaU3og>\u0014\u0018\u0001\b;ie\u0016\fG\r]8pY\u000e\u000b\u0007/Y2jif\u001cVM\\:pe>\u0003H\u000fI\u0001\neVtg.\u00192mKN,\"!!\u0017\u0011\r\u0005m\u0013QMA5\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003GR\u0013AC2pY2,7\r^5p]&!\u0011qMA/\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007Y\nY'C\u0002\u0002n\t\u00121cS1gW\u0006\u0014V-];fgRD\u0015M\u001c3mKJ\f!B];o]\u0006\u0014G.Z:!\u00035\u0019'/Z1uK\"\u000bg\u000e\u001a7feR!\u0011QOA>!\rI\u0013qO\u0005\u0004\u0003sR#\u0001B+oSRDa!! \u001b\u0001\u0004I\u0015AA5e\u0003A\u0011Xm]5{KRC'/Z1e!>|G\u000e\u0006\u0003\u0002v\u0005\r\u0005BBAC7\u0001\u0007\u0011*A\u0004oK^\u001c\u0016N_3\u0002\u0011MDW\u000f\u001e3po:$\"!!\u001e\u0002/-\u000bgm[1SKF,Xm\u001d;IC:$G.\u001a:Q_>d\u0007C\u0001\u001c\u001f'\tq\u0002\u0006\u0006\u0002\u0002\u000e\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0012TCAALU\rY\u0014\u0011T\u0016\u0003\u00037\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0015\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class KafkaRequestHandlerPool
implements Logging {
    private final KafkaConfig config;
    private final String clusterId;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final Meter aggregateIdleMeter;
    private final String nodeName;
    private final AtomicInteger threadPoolSize;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$12() {
        return "broker";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.config, this.clusterId(), this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time, this.nodeName));
        Runnable daemon_runnable = (Runnable)this.runnables().apply(id);
        String daemon_name = new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString();
        Object var2_3 = null;
        Object var3_2 = null;
        new KafkaThread(daemon_name, daemon_runnable, true).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1 & Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    /*
     * WARNING - void declaration
     */
    public KafkaRequestHandlerPool(KafkaConfig config, String clusterId, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics, Meter aggregateIdleMeter, String nodeName) {
        None$ none$;
        this.config = config;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.nodeName = nodeName;
        this.threadPoolSize = new AtomicInteger(numThreads);
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            void add_stat;
            void add_metricName;
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            Value value = new Value();
            MetricName metricName = ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics);
            if (sensor == null) {
                throw null;
            }
            sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
            metricName = null;
            value = null;
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

