/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.google.common.util.concurrent.AtomicDouble;
import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe$;
import kafka.server.StorageProbe$LogDirMetrics$;
import kafka.server.StorageProbeLatencyAggregator;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rEw!B1c\u0011\u00039g!B5c\u0011\u0003Q\u0007\"B9\u0002\t\u0003\u0011\bbB:\u0002\u0005\u0004%\t\u0001\u001e\u0005\b\u0003\u0017\t\u0001\u0015!\u0003v\u0011%\ti!AI\u0001\n\u0003\tyAB\u0003jE\u0002\tY\u0003\u0003\u0006\u0002L\u0019\u0011)\u0019!C\u0005\u0003\u001bB!\"!\u0016\u0007\u0005\u0003\u0005\u000b\u0011BA(\u0011)\t9F\u0002BC\u0002\u0013%\u0011\u0011\f\u0005\u000b\u0003g2!\u0011!Q\u0001\n\u0005m\u0003BCA;\r\t\u0015\r\u0011\"\u0003\u0002x!Q\u0011\u0011\u0010\u0004\u0003\u0002\u0003\u0006I!a\u0005\t\rE4A\u0011AA>\u0011%\t)I\u0002b\u0001\n\u0013\t9\t\u0003\u0005\u0002\u0010\u001a\u0001\u000b\u0011BAE\u0011%\t\tJ\u0002b\u0001\n\u0013\t\u0019\nC\u0004\u0002\u0016\u001a\u0001\u000b\u0011B?\t\u0013\u0005]eA1A\u0005\n\u0005M\u0005bBAM\r\u0001\u0006I! \u0005\n\u000373!\u0019!C\u0005\u0003'Cq!!(\u0007A\u0003%Q\u0010C\u0005\u0002 \u001a\u0011\r\u0011\"\u0003\u0002\u0014\"9\u0011\u0011\u0015\u0004!\u0002\u0013i\b\"CAR\r\t\u0007I\u0011BAJ\u0011\u001d\t)K\u0002Q\u0001\nuD\u0011\"a*\u0007\u0005\u0004%I!!+\t\u0011\u0005}f\u0001)A\u0005\u0003WC\u0011\"!1\u0007\u0005\u0004%I!a1\t\u0011\u0005-g\u0001)A\u0005\u0003\u000bD\u0011\"!4\u0007\u0005\u0004%I!a4\t\u0011\u0005\u001dh\u0001)A\u0005\u0003#D\u0011\"!;\u0007\u0005\u0004%I!!+\t\u0011\u0005-h\u0001)A\u0005\u0003WC\u0011\"!<\u0007\u0005\u0004%I!a<\t\u0011\u0005]h\u0001)A\u0005\u0003cD1\"!?\u0007\u0001\u0004\u0005\r\u0011\"\u0003\u0002|\"Y!1\u0001\u0004A\u0002\u0003\u0007I\u0011\u0002B\u0003\u0011-\u0011\tB\u0002a\u0001\u0002\u0003\u0006K!!@\t\u0013\tMa\u00011A\u0005\n\tU\u0001\"CB\u000b\r\u0001\u0007I\u0011BB\f\u0011!\u0019YB\u0002Q!\n\t]\u0001\"CB\u000f\r\t\u0007I\u0011BB\u0010\u0011!\u0019iC\u0002Q\u0001\n\r\u0005\u0002\"CB\u0018\r\t\u0007I\u0011BAD\u0011!\u0019\tD\u0002Q\u0001\n\u0005%\u0005\"CB\u001a\r\u0001\u0007I\u0011BB\u001b\u0011%\u00199D\u0002a\u0001\n\u0013\u0019I\u0004\u0003\u0005\u0004>\u0019\u0001\u000b\u0015\u0002B?\u0011\u001d\u00199E\u0002C\u0001\u0007\u0013Bqaa\u0013\u0007\t\u0003\u0019I\u0005C\u0004\u0004N\u0019!\taa\u0014\t\u000f\ruc\u0001\"\u0001\u0004`!91q\r\u0004\u0005\u0002\r%\u0003bBB9\r\u0011\u00051\u0011\n\u0005\b\u0007g2A\u0011IB;\u0011\u001d\u0019YH\u0002C!\u0007{Bqaa!\u0007\t\u0003\u001a)I\u0002\u0004\u00034\u0019\u0001%Q\u0007\u0005\u000b\u0005\u0007R$Q3A\u0005\u0002\t\u0015\u0003B\u0003B+u\tE\t\u0015!\u0003\u0003H!Q!q\u000b\u001e\u0003\u0016\u0004%\t!!+\t\u0015\te#H!E!\u0002\u0013\tY\u000b\u0003\u0006\u0003\\i\u0012)\u001a!C\u0001\u0005;B!B!\u001d;\u0005#\u0005\u000b\u0011\u0002B0\u0011)\u0011\u0019H\u000fBK\u0002\u0013\u0005!Q\u000f\u0005\u000b\u0005\u0007S$\u0011#Q\u0001\n\t]\u0004B\u0003BCu\tU\r\u0011\"\u0001\u0003\b\"Q!\u0011\u0013\u001e\u0003\u0012\u0003\u0006IA!#\t\u0015\tM%H!f\u0001\n\u0003\u0011)\b\u0003\u0006\u0003\u0016j\u0012\t\u0012)A\u0005\u0005oB!Ba&;\u0005+\u0007I\u0011\u0001B;\u0011)\u0011IJ\u000fB\tB\u0003%!q\u000f\u0005\u0007cj\"\tAa'\t\u0013\t-&(!A\u0005\u0002\t5\u0006\"\u0003B_uE\u0005I\u0011\u0001B`\u0011%\u0011\u0019MOI\u0001\n\u0003\u0011)\rC\u0005\u0003Jj\n\n\u0011\"\u0001\u0003L\"I!q\u001a\u001e\u0012\u0002\u0013\u0005!\u0011\u001b\u0005\n\u0005+T\u0014\u0013!C\u0001\u0005/D\u0011Ba7;#\u0003%\tA!5\t\u0013\tu'(%A\u0005\u0002\tE\u0007\"\u0003Bpu\u0005\u0005I\u0011IAJ\u0011%\u0011\tOOA\u0001\n\u0003\t9\tC\u0005\u0003dj\n\t\u0011\"\u0001\u0003f\"I!q\u001e\u001e\u0002\u0002\u0013\u0005#\u0011\u001f\u0005\n\u0005wT\u0014\u0011!C\u0001\u0005{D\u0011b!\u0001;\u0003\u0003%\tea\u0001\t\u0013\r\u001d!(!A\u0005B\r%\u0001\"CB\u0006u\u0005\u0005I\u0011IB\u0007\u0011%\u0019yAOA\u0001\n\u0003\u001a\tbB\u0005\u0004\u000e\u001a\t\t\u0011#\u0001\u0004\u0010\u001aI!1\u0007\u0004\u0002\u0002#\u00051\u0011\u0013\u0005\u0007cr#\ta!+\t\u0013\r-A,!A\u0005F\r5\u0001\"CBV9\u0006\u0005I\u0011QBW\u0011%\u0019i\fXA\u0001\n\u0003\u001by,\u0001\u0007Ti>\u0014\u0018mZ3Qe>\u0014WM\u0003\u0002dI\u000611/\u001a:wKJT\u0011!Z\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0017!D\u0001c\u00051\u0019Fo\u001c:bO\u0016\u0004&o\u001c2f'\t\t1\u000e\u0005\u0002m_6\tQNC\u0001o\u0003\u0015\u00198-\u00197b\u0013\t\u0001XN\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\fQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001v!\r180`\u0007\u0002o*\u0011\u00010_\u0001\nS6lW\u000f^1cY\u0016T!A_7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002}o\n\u00191+\u001a;\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\rM#(/\u001b8h\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0012)\"\u00111CA\r!\ra\u0017QC\u0005\u0004\u0003/i'a\u0002\"p_2,\u0017M\\\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011QE7\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKNIa!!\f\u00024\u0005e\u0012Q\t\t\u0004}\u0006=\u0012bAA\u0019\u007f\n1qJ\u00196fGR\u00042A`A\u001b\u0013\r\t9d \u0002\t%Vtg.\u00192mKB!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0011\fQ!\u001e;jYNLA!a\u0011\u0002>\t9Aj\\4hS:<\u0007c\u00015\u0002H%\u0019\u0011\u0011\n2\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011q\n\t\u0004Q\u0006E\u0013bAA*E\nY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKV\u0011\u00111\f\t\u0005\u0003;\ny'\u0004\u0002\u0002`)!\u0011qHA1\u0015\u0011\t\u0019'!\u001a\u0002\r\r|W.\\8o\u0015\r)\u0017q\r\u0006\u0005\u0003S\nY'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003[\n1a\u001c:h\u0013\u0011\t\t(a\u0018\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\fgR\f'\u000f\u001e+ie\u0016\fG-\u0006\u0002\u0002\u0014\u0005a1\u000f^1siRC'/Z1eAQA\u0011QPA@\u0003\u0003\u000b\u0019\t\u0005\u0002i\r!9\u00111J\u0007A\u0002\u0005=\u0003bBA,\u001b\u0001\u0007\u00111\f\u0005\n\u0003kj\u0001\u0013!a\u0001\u0003'\tqA^3sg&|g.\u0006\u0002\u0002\nB\u0019A.a#\n\u0007\u00055UNA\u0002J]R\f\u0001B^3sg&|g\u000eI\u0001\u0012Y\u0006$XM\\2z\u001b\u0016$(/[2OC6,W#A?\u0002%1\fG/\u001a8ds6+GO]5d\u001d\u0006lW\rI\u0001\u0017GV\u0014(/\u001a8u/JLG/Z'fiJL7MT1nK\u000692-\u001e:sK:$xK]5uK6+GO]5d\u001d\u0006lW\rI\u0001)Y\u0006\u001cHoU;dG\u0016\u001c8OZ;m!J|'-Z,j]\u0012|w/\u001a3Bm\u001elU\r\u001e:jG:\u000bW.Z\u0001*Y\u0006\u001cHoU;dG\u0016\u001c8OZ;m!J|'-Z,j]\u0012|w/\u001a3Bm\u001elU\r\u001e:jG:\u000bW.\u001a\u0011\u0002Q1\f7\u000f^*vG\u000e,7o\u001d4vYB\u0013xNY3XS:$wn^3e\u001b\u0006DX*\u001a;sS\u000et\u0015-\\3\u0002S1\f7\u000f^*vG\u000e,7o\u001d4vYB\u0013xNY3XS:$wn^3e\u001b\u0006DX*\u001a;sS\u000et\u0015-\\3!\u0003i\u0019Hn\\<Xe&$XmQ8v]R,'/T3ue&\u001cg*Y7f\u0003m\u0019Hn\\<Xe&$XmQ8v]R,'/T3ue&\u001cg*Y7fA\u0005ia.^7TY><xK]5uKN,\"!a+\u0011\t\u00055\u00161X\u0007\u0003\u0003_SA!!-\u00024\u00061\u0011\r^8nS\u000eTA!!.\u00028\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005e\u00161A\u0001\u0005kRLG.\u0003\u0003\u0002>\u0006=&AC!u_6L7\rT8oO\u0006qa.^7TY><xK]5uKN\u0004\u0013!\u00057bgR4\u0015N^3MCR,gnY5fgV\u0011\u0011Q\u0019\t\u0004Q\u0006\u001d\u0017bAAeE\ni2\u000b^8sC\u001e,\u0007K]8cK2\u000bG/\u001a8ds\u0006;wM]3hCR|'/\u0001\nmCN$h)\u001b<f\u0019\u0006$XM\\2jKN\u0004\u0013AE<j]\u0012|w/\u0011<h\u0019\u0006$XM\\2jKN,\"!!5\u0011\t\u0005M\u00171]\u0007\u0003\u0003+TA!!.\u0002X*!\u0011\u0011XAm\u0015\u0011\t\u0019'a7\u000b\t\u0005u\u0017q\\\u0001\u0007O>|w\r\\3\u000b\u0005\u0005\u0005\u0018aA2p[&!\u0011Q]Ak\u00051\tEo\\7jG\u0012{WO\u00197f\u0003M9\u0018N\u001c3po\u00063x\rT1uK:\u001c\u0017.Z:!\u0003I9\u0018N\u001c3po6\u000b\u0007\u0010T1uK:\u001c\u0017.Z:\u0002']Lg\u000eZ8x\u001b\u0006DH*\u0019;f]\u000eLWm\u001d\u0011\u0002\u0019MDW\u000f\u001e3po:4E.Y4\u0016\u0005\u0005E\b\u0003BAW\u0003gLA!!>\u00020\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fQb\u001d5vi\u0012|wO\u001c$mC\u001e\u0004\u0013A\u0002;ie\u0016\fG-\u0006\u0002\u0002~B!\u0011QLA\u0000\u0013\u0011\u0011\t!a\u0018\u0003\u0017-\u000bgm[1UQJ,\u0017\rZ\u0001\u000bi\"\u0014X-\u00193`I\u0015\fH\u0003\u0002B\u0004\u0005\u001b\u00012\u0001\u001cB\u0005\u0013\r\u0011Y!\u001c\u0002\u0005+:LG\u000fC\u0005\u0003\u0010\u0015\n\t\u00111\u0001\u0002~\u0006\u0019\u0001\u0010J\u0019\u0002\u000fQD'/Z1eA\u00059Q.\u001a;sS\u000e\u001cXC\u0001B\f!\u0019\u0011IB!\u000b\u000309!!1\u0004B\u0013\u001d\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011M\u00061AH]8pizJ\u0011A\\\u0005\u0004\u0005Oi\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005W\u0011iC\u0001\u0003MSN$(b\u0001B\u0014[B\u0019!\u0011\u0007\u001e\u000e\u0003\u0019\u0011Q\u0002T8h\t&\u0014X*\u001a;sS\u000e\u001c8C\u0002\u001el\u0005o\u0011i\u0004E\u0002m\u0005sI1Aa\u000fn\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u0007\u0003@%!!\u0011\tB\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011q\u0017-\\3\u0016\u0005\t\u001d\u0003\u0003\u0002B%\u0005#rAAa\u0013\u0003NA\u0019!QD7\n\u0007\t=S.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\u0011\u0019FC\u0002\u0003P5\fQA\\1nK\u0002\nQcY;se\u0016tGo\u0016:ji\u0016\u001cF/\u0019:uK\u0012l5/\u0001\fdkJ\u0014XM\u001c;Xe&$Xm\u0015;beR,G-T:!\u0003%A\u0017n\u001d;pOJ\fW.\u0006\u0002\u0003`A!!\u0011\rB7\u001b\t\u0011\u0019G\u0003\u0003\u0003f\t\u001d\u0014\u0001B2pe\u0016TAAa\u0005\u0003j)!!1NAp\u0003\u0019I\u0018-\\7fe&!!q\u000eB2\u0005%A\u0015n\u001d;pOJ\fW.\u0001\u0006iSN$xn\u001a:b[\u0002\n\u0011\u0002[3beR\u0014W-\u0019;\u0016\u0005\t]\u0004C\u0002B1\u0005s\u0012i(\u0003\u0003\u0003|\t\r$!B$bk\u001e,\u0007c\u00017\u0003\u0000%\u0019!\u0011Q7\u0003\t1{gnZ\u0001\u000bQ\u0016\f'\u000f\u001e2fCR\u0004\u0013A\u00057bi\u0016t7-_,j]\u0012|w/\u001a3Bm\u001e,\"A!#\u0011\r\t\u0005$\u0011\u0010BF!\ra'QR\u0005\u0004\u0005\u001fk'A\u0002#pk\ndW-A\nmCR,gnY=XS:$wn^3e\u0003Z<\u0007%\u0001\nmCR,gnY=XS:$wn^3e\u001b\u0006D\u0018a\u00057bi\u0016t7-_,j]\u0012|w/\u001a3NCb\u0004\u0013AD:m_^<&/\u001b;f\u0007>,h\u000e^\u0001\u0010g2|wo\u0016:ji\u0016\u001cu.\u001e8uAQ\u0001\"q\u0006BO\u0005?\u0013\tKa)\u0003&\n\u001d&\u0011\u0016\u0005\b\u0005\u0007J\u0005\u0019\u0001B$\u0011\u001d\u00119&\u0013a\u0001\u0003WCqAa\u0017J\u0001\u0004\u0011y\u0006C\u0004\u0003t%\u0003\rAa\u001e\t\u000f\t\u0015\u0015\n1\u0001\u0003\n\"9!1S%A\u0002\t]\u0004b\u0002BL\u0013\u0002\u0007!qO\u0001\u0005G>\u0004\u0018\u0010\u0006\t\u00030\t=&\u0011\u0017BZ\u0005k\u00139L!/\u0003<\"I!1\t&\u0011\u0002\u0003\u0007!q\t\u0005\n\u0005/R\u0005\u0013!a\u0001\u0003WC\u0011Ba\u0017K!\u0003\u0005\rAa\u0018\t\u0013\tM$\n%AA\u0002\t]\u0004\"\u0003BC\u0015B\u0005\t\u0019\u0001BE\u0011%\u0011\u0019J\u0013I\u0001\u0002\u0004\u00119\bC\u0005\u0003\u0018*\u0003\n\u00111\u0001\u0003x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BaU\u0011\u00119%!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0019\u0016\u0005\u0003W\u000bI\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t5'\u0006\u0002B0\u00033\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003T*\"!qOA\r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!7+\t\t%\u0015\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0014i\u000fE\u0002m\u0005SL1Aa;n\u0005\r\te.\u001f\u0005\n\u0005\u001f!\u0016\u0011!a\u0001\u0003\u0013\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005g\u0004bA!>\u0003x\n\u001dX\"A=\n\u0007\te\u0018P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\n\u0005\u007fD\u0011Ba\u0004W\u0003\u0003\u0005\rAa:\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004{\u000e\u0015\u0001\"\u0003B\b/\u0006\u0005\t\u0019AAE\u0003!A\u0017m\u001d5D_\u0012,GCAAE\u0003!!xn\u0015;sS:<G#A?\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019ba\u0005\t\u0013\t=!,!AA\u0002\t\u001d\u0018aC7fiJL7m]0%KF$BAa\u0002\u0004\u001a!I!q\u0002\u0015\u0002\u0002\u0003\u0007!qC\u0001\t[\u0016$(/[2tA\u0005aQ.\u001a;sS\u000e\u001cxI]8vaV\u00111\u0011\u0005\t\u0005\u0007G\u0019I#\u0004\u0002\u0004&)!!1CB\u0014\u0015\r\u0019\u0017QM\u0005\u0005\u0007W\u0019)CA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013\u0001G<sSR,G+[7f/\u0006\u0014h\u000e\u00165sKNDw\u000e\u001c3Ng\u0006IrO]5uKRKW.Z,be:$\u0006N]3tQ>dG-T:!\u0003Q\u0019Hn\\<Xe&$X\r\u00165sKNDw\u000e\u001c3NgV\u0011!QP\u0001\u0019g2|wo\u0016:ji\u0016$\u0006N]3tQ>dG-T:`I\u0015\fH\u0003\u0002B\u0004\u0007wA\u0011Ba\u00040\u0003\u0003\u0005\rA! \u0002+Mdwn^,sSR,G\u000b\u001b:fg\"|G\u000eZ'tA!\u001a\u0001g!\u0011\u0011\u00071\u001c\u0019%C\u0002\u0004F5\u0014\u0001B^8mCRLG.Z\u0001\bgR\f'\u000f^;q)\t\u00119!\u0001\u0005tQV$Hm\\<o\u0003\u001d\u0001\u0018-\u001f7pC\u0012$\"a!\u0015\u0011\t\rM3\u0011L\u0007\u0003\u0007+RAaa\u0016\u0002\u0004\u0005\u0019a.[8\n\t\rm3Q\u000b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018!\u00029s_\n,GCAB1!!\u0011Iea\u0019\u0003H\tu\u0014\u0002BB3\u0005'\u00121!T1q\u0003\r\u0011XO\u001c\u0015\u0004k\r-\u0004c\u0001@\u0004n%\u00191qN@\u0003\u0011=3XM\u001d:jI\u0016\f\u0011f]3u\u0019\u0006\u001cHoU;dG\u0016\u001c8OZ;m!J|'-Z,j]\u0012|w/\u001a3BO\u001e\u0014XmZ1uS>t\u0017!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0007o\u0002bA!\u0013\u0004z\t\u001d\u0013b\u0001?\u0003T\u00059b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0005\u000f\u0019y\bC\u0004\u0004\u0002b\u0002\r!a\u0014\u0002\u00139,woQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$bAa\u0002\u0004\b\u000e-\u0005bBBEs\u0001\u0007\u0011qJ\u0001\n_2$7i\u001c8gS\u001eDqa!!:\u0001\u0004\ty%A\u0007M_\u001e$\u0015N]'fiJL7m\u001d\t\u0004\u0005ca6#\u0002/\u0004\u0014\u000e}\u0005\u0003FBK\u00077\u00139%a+\u0003`\t]$\u0011\u0012B<\u0005o\u0012y#\u0004\u0002\u0004\u0018*\u00191\u0011T7\u0002\u000fI,h\u000e^5nK&!1QTBL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\u000e\t\u0005\u0007C\u001b9+\u0004\u0002\u0004$*!1QUA\u0002\u0003\tIw.\u0003\u0003\u0003B\r\rFCABH\u0003\u0015\t\u0007\u000f\u001d7z)A\u0011yca,\u00042\u000eM6QWB\\\u0007s\u001bY\fC\u0004\u0003D}\u0003\rAa\u0012\t\u000f\t]s\f1\u0001\u0002,\"9!1L0A\u0002\t}\u0003b\u0002B:?\u0002\u0007!q\u000f\u0005\b\u0005\u000b{\u0006\u0019\u0001BE\u0011\u001d\u0011\u0019j\u0018a\u0001\u0005oBqAa&`\u0001\u0004\u00119(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u00057Q\u001a\t\u0006Y\u000e\r7qY\u0005\u0004\u0007\u000bl'AB(qi&|g\u000eE\tm\u0007\u0013\u00149%a+\u0003`\t]$\u0011\u0012B<\u0005oJ1aa3n\u0005\u0019!V\u000f\u001d7fo!I1q\u001a1\u0002\u0002\u0003\u0007!qF\u0001\u0004q\u0012\u0002\u0004")
public class StorageProbe
implements Runnable,
Logging,
BrokerReconfigurable {
    private volatile StorageProbe$LogDirMetrics$ LogDirMetrics$module;
    private final KafkaConfig config;
    private final Time time;
    private final boolean startThread;
    private final int version;
    private final String latencyMetricName;
    private final String currentWriteMetricName;
    private final String lastSuccessfulProbeWindowedAvgMetricName;
    private final String lastSuccessfulProbeWindowedMaxMetricName;
    private final String slowWriteCounterMetricName;
    private final AtomicLong numSlowWrites;
    private final StorageProbeLatencyAggregator lastFiveLatencies;
    private final AtomicDouble windowAvgLatencies;
    private final AtomicLong windowMaxLatencies;
    private final AtomicBoolean shutdownFlag;
    private KafkaThread thread;
    private List<LogDirMetrics> metrics;
    private final KafkaMetricsGroup metricsGroup;
    private final int writeTimeWarnThresholdMs;
    private volatile long slowWriteThresholdMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return true;
    }

    public static Set<String> ReconfigurableConfigs() {
        return StorageProbe$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public StorageProbe$LogDirMetrics$ LogDirMetrics() {
        if (this.LogDirMetrics$module == null) {
            this.LogDirMetrics$lzycompute$1();
        }
        return this.LogDirMetrics$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private Time time() {
        return this.time;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private int version() {
        return this.version;
    }

    private String latencyMetricName() {
        return this.latencyMetricName;
    }

    private String currentWriteMetricName() {
        return this.currentWriteMetricName;
    }

    private String lastSuccessfulProbeWindowedAvgMetricName() {
        return this.lastSuccessfulProbeWindowedAvgMetricName;
    }

    private String lastSuccessfulProbeWindowedMaxMetricName() {
        return this.lastSuccessfulProbeWindowedMaxMetricName;
    }

    private String slowWriteCounterMetricName() {
        return this.slowWriteCounterMetricName;
    }

    private AtomicLong numSlowWrites() {
        return this.numSlowWrites;
    }

    private StorageProbeLatencyAggregator lastFiveLatencies() {
        return this.lastFiveLatencies;
    }

    private AtomicDouble windowAvgLatencies() {
        return this.windowAvgLatencies;
    }

    private AtomicLong windowMaxLatencies() {
        return this.windowMaxLatencies;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private List<LogDirMetrics> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(List<LogDirMetrics> x$1) {
        this.metrics = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private int writeTimeWarnThresholdMs() {
        return this.writeTimeWarnThresholdMs;
    }

    private long slowWriteThresholdMs() {
        return this.slowWriteThresholdMs;
    }

    private void slowWriteThresholdMs_$eq(long x$1) {
        this.slowWriteThresholdMs = x$1;
    }

    public void startup() {
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics_$eq((List<LogDirMetrics>)((IterableOnceOps)this.config().logDirs().map((Function1 & Serializable)logDir -> {
                scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), logDir)}));
                AtomicLong currentWriteTimeStartedMs = new AtomicLong(-1L);
                return new LogDirMetrics(this, (String)logDir, currentWriteTimeStartedMs, this.metricsGroup().newHistogram(this.latencyMetricName(), true, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.currentWriteMetricName(), (Gauge)new Gauge<Object>(this, currentWriteTimeStartedMs){
                    private final /* synthetic */ StorageProbe $outer;
                    private final AtomicLong currentWriteTimeStartedMs$1;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$2(this.currentWriteTimeStartedMs$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentWriteTimeStartedMs$1 = currentWriteTimeStartedMs$1;
                    }
                }, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.lastSuccessfulProbeWindowedAvgMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final double value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$3();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.lastSuccessfulProbeWindowedMaxMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$4();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.slowWriteCounterMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$5();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava()));
            })).toList());
            String nonDaemon_name = "StorageProbe";
            Object var1_1 = null;
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
            return;
        }
    }

    public void shutdown() {
        this.shutdownFlag().set(true);
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics().foreach((Function1 & Serializable)logDir -> {
                StorageProbe.$anonfun$shutdown$1(this, logDir);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ByteBuffer payload() {
        return ByteBuffer.wrap(new StringBuilder(1).append(this.version()).append(",").append(this.time().milliseconds()).toString().getBytes(StandardCharsets.UTF_8));
    }

    public scala.collection.immutable.Map<String, Object> probe() {
        return this.metrics().map((Function1 & Serializable)logDir -> {
            try {
                Tuple2 tuple2;
                Path path = Paths.get(logDir.name(), "storage.probe");
                ByteBuffer payloadBytes = this.payload();
                logDir.currentWriteStartedMs().set(this.time().hiResClockMs());
                FileChannel fc = FileChannelWrapper.open((Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
                try {
                    FileChannelWrapper.truncate((FileChannel)fc, (long)0L);
                    long startMs = this.time().hiResClockMs();
                    FileChannelWrapper.write((FileChannel)fc, (ByteBuffer)payloadBytes);
                    FileChannelWrapper.force((FileChannel)fc, (boolean)true);
                    long tookMs = this.time().hiResClockMs() - startMs;
                    this.lastFiveLatencies().enqueue(tookMs);
                    if (tookMs >= (long)this.writeTimeWarnThresholdMs()) {
                        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("slow storage probe write detected (>=").append(this.writeTimeWarnThresholdMs()).append("ms). Flush took ").append(tookMs).append("ms").toString());
                    }
                    if (tookMs >= this.slowWriteThresholdMs()) {
                        this.numSlowWrites().incrementAndGet();
                    } else {
                        this.numSlowWrites().set(0L);
                    }
                    this.setLastSuccessfulProbeWindowedAggregation();
                    logDir.histogram().update(tookMs);
                    tuple2 = new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)tookMs));
                }
                finally {
                    logDir.currentWriteStartedMs().set(-1L);
                    FileChannelWrapper.close((FileChannel)fc);
                }
                return tuple2;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Failed writing storage probe data to logdir ").append(logDir.name()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void run() {
        ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD);
        do {
            ThreadCountersManager.wrapIO(() -> this.probe());
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    public void setLastSuccessfulProbeWindowedAggregation() {
        if (this.lastFiveLatencies().isEmpty()) {
            this.windowAvgLatencies().set(0.0);
            this.windowMaxLatencies().set(0L);
            return;
        }
        this.windowAvgLatencies().set(this.lastFiveLatencies().avg());
        this.windowMaxLatencies().set(this.lastFiveLatencies().max());
    }

    public Set<String> reconfigurableConfigs() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.StorageProbeSlowWriteThresholdMsProp()}));
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Long l = oldConfig.confluentConfig().storageProbeSlowWriteThresholdMs();
        Long l2 = newConfig.confluentConfig().storageProbeSlowWriteThresholdMs();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            this.slowWriteThresholdMs_$eq(Predef$.MODULE$.Long2long(newConfig.confluentConfig().storageProbeSlowWriteThresholdMs()));
            return;
        }
    }

    private final void LogDirMetrics$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirMetrics$module == null) {
                this.LogDirMetrics$module = new StorageProbe$LogDirMetrics$(this);
            }
            return;
        }
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$2(AtomicLong currentWriteTimeStartedMs$1) {
        long startedMs = currentWriteTimeStartedMs$1.get();
        if (startedMs == -1L) {
            return 0L;
        }
        return this.time().hiResClockMs() - startedMs;
    }

    public final /* synthetic */ double kafka$server$StorageProbe$$$anonfun$startup$3() {
        return this.windowAvgLatencies().get();
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$4() {
        return this.windowMaxLatencies().get();
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$5() {
        return this.numSlowWrites().get();
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(StorageProbe $this, LogDirMetrics logDir) {
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), (Object)logDir.name())}));
        $this.metricsGroup().removeMetric($this.latencyMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.currentWriteMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.lastSuccessfulProbeWindowedAvgMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.lastSuccessfulProbeWindowedMaxMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.slowWriteCounterMetricName(), CollectionConverters$.MODULE$.MapHasAsJava((Map)tags).asJava());
    }

    public StorageProbe(KafkaConfig config, Time time, boolean startThread) {
        this.config = config;
        this.time = time;
        this.startThread = startThread;
        this.version = 0;
        this.latencyMetricName = "StorageProbeLatencyMs";
        this.currentWriteMetricName = "CurrentWriteDurationMs";
        this.lastSuccessfulProbeWindowedAvgMetricName = "LastSuccessfulProbeWindowedAvgMs";
        this.lastSuccessfulProbeWindowedMaxMetricName = "LastSuccessfulProbeWindowedMaxMs";
        this.slowWriteCounterMetricName = "SlowWriteCounter";
        this.numSlowWrites = new AtomicLong(0L);
        this.lastFiveLatencies = new StorageProbeLatencyAggregator(5);
        this.windowAvgLatencies = new AtomicDouble(0.0);
        this.windowMaxLatencies = new AtomicLong(0L);
        this.shutdownFlag = new AtomicBoolean(false);
        this.metrics = Nil$.MODULE$;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.writeTimeWarnThresholdMs = 5000;
        this.slowWriteThresholdMs = 5000L;
    }

    public class LogDirMetrics
    implements Product,
    Serializable {
        private final String name;
        private final AtomicLong currentWriteStartedMs;
        private final Histogram histogram;
        private final Gauge<Object> heartbeat;
        private final Gauge<Object> latencyWindowedAvg;
        private final Gauge<Object> latencyWindowedMax;
        private final Gauge<Object> slowWriteCount;
        public final /* synthetic */ StorageProbe $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public AtomicLong currentWriteStartedMs() {
            return this.currentWriteStartedMs;
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public Gauge<Object> heartbeat() {
            return this.heartbeat;
        }

        public Gauge<Object> latencyWindowedAvg() {
            return this.latencyWindowedAvg;
        }

        public Gauge<Object> latencyWindowedMax() {
            return this.latencyWindowedMax;
        }

        public Gauge<Object> slowWriteCount() {
            return this.slowWriteCount;
        }

        public LogDirMetrics copy(String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat, Gauge<Object> latencyWindowedAvg, Gauge<Object> latencyWindowedMax, Gauge<Object> slowWriteCount) {
            return new LogDirMetrics(this.kafka$server$StorageProbe$LogDirMetrics$$$outer(), name, currentWriteStartedMs, histogram, heartbeat, latencyWindowedAvg, latencyWindowedMax, slowWriteCount);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AtomicLong copy$default$2() {
            return this.currentWriteStartedMs();
        }

        public Histogram copy$default$3() {
            return this.histogram();
        }

        public Gauge<Object> copy$default$4() {
            return this.heartbeat();
        }

        public Gauge<Object> copy$default$5() {
            return this.latencyWindowedAvg();
        }

        public Gauge<Object> copy$default$6() {
            return this.latencyWindowedMax();
        }

        public Gauge<Object> copy$default$7() {
            return this.slowWriteCount();
        }

        public String productPrefix() {
            return "LogDirMetrics";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.currentWriteStartedMs();
                }
                case 2: {
                    return this.histogram();
                }
                case 3: {
                    return this.heartbeat();
                }
                case 4: {
                    return this.latencyWindowedAvg();
                }
                case 5: {
                    return this.latencyWindowedMax();
                }
                case 6: {
                    return this.slowWriteCount();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirMetrics;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "currentWriteStartedMs";
                }
                case 2: {
                    return "histogram";
                }
                case 3: {
                    return "heartbeat";
                }
                case 4: {
                    return "latencyWindowedAvg";
                }
                case 5: {
                    return "latencyWindowedMax";
                }
                case 6: {
                    return "slowWriteCount";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof LogDirMetrics && ((LogDirMetrics)x$1).kafka$server$StorageProbe$LogDirMetrics$$$outer() == this.kafka$server$StorageProbe$LogDirMetrics$$$outer())) break block3;
                    LogDirMetrics logDirMetrics = (LogDirMetrics)x$1;
                    String string = this.name();
                    String string2 = logDirMetrics.name();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !BoxesRunTime.equalsNumNum((Number)this.currentWriteStartedMs(), (Number)logDirMetrics.currentWriteStartedMs())) break block3;
                    Histogram histogram = this.histogram();
                    Histogram histogram2 = logDirMetrics.histogram();
                    if (histogram != null ? !histogram.equals(histogram2) : histogram2 != null) break block3;
                    Gauge<Object> gauge2 = this.heartbeat();
                    Gauge<Object> gauge3 = logDirMetrics.heartbeat();
                    if (gauge2 != null ? !gauge2.equals(gauge3) : gauge3 != null) break block3;
                    Gauge<Object> gauge4 = this.latencyWindowedAvg();
                    Gauge<Object> gauge5 = logDirMetrics.latencyWindowedAvg();
                    if (gauge4 != null ? !gauge4.equals(gauge5) : gauge5 != null) break block3;
                    Gauge<Object> gauge6 = this.latencyWindowedMax();
                    Gauge<Object> gauge7 = logDirMetrics.latencyWindowedMax();
                    if (gauge6 != null ? !gauge6.equals(gauge7) : gauge7 != null) break block3;
                    Gauge<Object> gauge8 = this.slowWriteCount();
                    Gauge<Object> gauge9 = logDirMetrics.slowWriteCount();
                    if ((gauge8 != null ? !gauge8.equals(gauge9) : gauge9 != null) || !logDirMetrics.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ StorageProbe kafka$server$StorageProbe$LogDirMetrics$$$outer() {
            return this.$outer;
        }

        public LogDirMetrics(StorageProbe $outer, String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat, Gauge<Object> latencyWindowedAvg, Gauge<Object> latencyWindowedMax, Gauge<Object> slowWriteCount) {
            this.name = name;
            this.currentWriteStartedMs = currentWriteStartedMs;
            this.histogram = histogram;
            this.heartbeat = heartbeat;
            this.latencyWindowedAvg = latencyWindowedAvg;
            this.latencyWindowedMax = latencyWindowedMax;
            this.slowWriteCount = slowWriteCount;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

