/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import kafka.server.ClusterLinkQuotas;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkCheckLinkAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskType;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\rf!\u0002\u001c8\u0003\u0003q\u0004\u0002C*\u0001\u0005\u000b\u0007I\u0011\u0001+\t\u0011a\u0003!\u0011!Q\u0001\nUC\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tC\u0002\u0011\t\u0011)A\u00057\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!b\u0001\n\u0003I\u0007\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00119\u0004!Q1A\u0005\u0002=D\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Q\u00111\u0001\u0001\u0003\u0002\u0004%I!!\u0002\t\u0015\u0005\u001d\u0001A!a\u0001\n\u0013\tI\u0001C\u0005\u0002\u0016\u0001\u0011\t\u0011)Q\u0005g\"Q\u0011q\u0004\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u0017\u0005m\u0003\u00011AA\u0002\u0013E\u0011Q\f\u0005\f\u0003K\u0002\u0001\u0019!a\u0001\n#\t9\u0007C\u0006\u0002l\u0001\u0001\r\u0011!Q!\n\u0005}\u0003\"CA8\u0001\t\u0007I\u0011AA9\u0011!\tI\b\u0001Q\u0001\n\u0005M\u0004\"CA>\u0001\u0001\u0007I\u0011BA?\u0011%\t9\t\u0001a\u0001\n\u0013\tI\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA@\u0011%\ty\t\u0001b\u0001\n\u0013\t\t\n\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAJ\u0011-\t\u0019\r\u0001a\u0001\u0002\u0004%I!!2\t\u0017\u0005\u0015\b\u00011AA\u0002\u0013%\u0011q\u001d\u0005\f\u0003G\u0004\u0001\u0019!A!B\u0013\t9\rC\u0005\u0002t\u0002\u0011\r\u0011\"\u0005\u0002v\"A!1\u0001\u0001!\u0002\u0013\t9\u0010C\u0004\u0003\u0006\u0001!\tAa\u0002\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!Q\u0002\u0001\u0005\n\t-\u0001b\u0002B\b\u0001\u0019E!1\u0002\u0005\b\u0005#\u0001a\u0011\u0003B\u0006\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005\u0017AqA!\u0006\u0001\t\u0013\u0011Y\u0001C\u0004\u0003\u0018\u00011\tBa\u0003\t\u000f\te\u0001A\"\u0005\u0003\f!A!1\u0004\u0001\u0005\u0002]\u0012i\u0002\u0003\u0005\u0003F\u0001!\ta\u000eB$\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqAa\u0017\u0001\t\u0003\u0011Y\u0001C\u0004\u0003^\u0001!\tAa\u0003\t\u000f\t}\u0003\u0001\"\u0001\u0003b!A!\u0011\u000e\u0001\u0005B]\u0012Y\u0007C\u0004\u0003r\u0001!\t!!\u0002\t\u000f\tM\u0004\u0001\"\u0011\u0003v!9!\u0011\u0012\u0001\u0007\u0012\t-\u0005b\u0002BH\u0001\u0011\u0005#\u0011\u0013\u0005\b\u0005C\u0003A\u0011\u0002B\u0006\u0005\u0001\n%m\u001d;sC\u000e$8\t\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;NC:\fw-\u001a:\u000b\u0005aJ\u0014\u0001\u00027j].T!AO\u001e\u0002\rM,'O^3s\u0015\u0005a\u0014!B6bM.\f7\u0001A\n\u0005\u0001}*U\n\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r*s!a\u0012%\u000e\u0003]J!!S\u001c\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003\u00172\u0013Qb\u00117jK:$X*\u00198bO\u0016\u0014(BA%8!\tq\u0015+D\u0001P\u0015\t\u00016(A\u0003vi&d7/\u0003\u0002S\u001f\n9Aj\\4hS:<\u0017AE2mkN$XM\u001d'j].l\u0015M\\1hKJ,\u0012!\u0016\t\u0003\u000fZK!aV\u001c\u0003%\rcWo\u001d;fe2Kgn['b]\u0006<WM]\u0001\u0014G2,8\u000f^3s\u0019&t7.T1oC\u001e,'\u000fI\u0001\tY&t7\u000eR1uCV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_w\u0005\u0011!p[\u0005\u0003Av\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0001\nY&t7\u000eR1uC\u0002\n1\u0002\\5oW6+GO]5dgV\tA\r\u0005\u0002HK&\u0011am\u000e\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0007mS:\\W*\u001a;sS\u000e\u001c\b%A\u0006uCN\\W*\u00198bO\u0016\u0014X#\u00016\u0011\u0005\u001d[\u0017B\u000178\u0005Y\u0019E.^:uKJd\u0015N\\6UCN\\W*\u00198bO\u0016\u0014\u0018\u0001\u0004;bg.l\u0015M\\1hKJ\u0004\u0013A\u0005:f[>$X-\u00113nS:4\u0015m\u0019;pef,\u0012\u0001\u001d\t\u0005\u0001F\u001ch/\u0003\u0002s\u0003\nIa)\u001e8di&|g.\r\t\u0003\u000fRL!!^\u001c\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0005\u0002Ho&\u0011\u0001p\u000e\u0002\u0017\u00072,8\u000f^3s\u0019&t7.\u00113nS:\u001cE.[3oi\u0006\u0019\"/Z7pi\u0016\fE-\\5o\r\u0006\u001cGo\u001c:zA\u0005\tBn\\2bY\u0006#W.\u001b8GC\u000e$xN]=\u0011\u0007\u0001ch0\u0003\u0002~\u0003\nIa)\u001e8di&|g\u000e\r\t\u0003\u000f~L1!!\u00018\u0005U\u0019E.^:uKJd\u0015N\\6M_\u000e\fG.\u00113nS:\f!\u0002\\5oW\u000e{gNZ5h+\u0005\u0019\u0018A\u00047j].\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0017\t\t\u0002E\u0002A\u0003\u001bI1!a\u0004B\u0005\u0011)f.\u001b;\t\u0011\u0005MQ\"!AA\u0002M\f1\u0001\u001f\u00132\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011)\u00079\tI\u0002E\u0002A\u00037I1!!\bB\u0005!1x\u000e\\1uS2,\u0017\u0001\u0002;j[\u0016\u0004B!a\t\u000265\u0011\u0011Q\u0005\u0006\u0004!\u0006\u001d\"\u0002BA\u0015\u0003W\taaY8n[>t'b\u0001\u001f\u0002.)!\u0011qFA\u0019\u0003\u0019\t\u0007/Y2iK*\u0011\u00111G\u0001\u0004_J<\u0017\u0002BA\u001c\u0003K\u0011A\u0001V5nK\u00061\u0011/^8uCN\u0004B!!\u0010\u0002@5\t\u0011(C\u0002\u0002Be\u0012\u0011c\u00117vgR,'\u000fT5oWF+x\u000e^1t\u0003\u0019a\u0014N\\5u}Q!\u0012qIA%\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013QKA,\u00033\u0002\"a\u0012\u0001\t\u000bM\u000b\u0002\u0019A+\t\u000be\u000b\u0002\u0019A.\t\u000b\t\f\u0002\u0019\u00013\t\u000b!\f\u0002\u0019\u00016\t\u000b9\f\u0002\u0019\u00019\t\u000bi\f\u0002\u0019A>\t\r\u0005\r\u0011\u00031\u0001t\u0011\u001d\ty\"\u0005a\u0001\u0003CAq!!\u000f\u0012\u0001\u0004\tY$A\u0003bI6Lg.\u0006\u0002\u0002`A!\u0001)!\u0019w\u0013\r\t\u0019'\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013\u0005$W.\u001b8`I\u0015\fH\u0003BA\u0006\u0003SB\u0011\"a\u0005\u0014\u0003\u0003\u0005\r!a\u0018\u0002\r\u0005$W.\u001b8!Q\r!\u0012\u0011D\u0001\ng\u000eDW\rZ;mKJ,\"!a\u001d\u0011\u0007\u001d\u000b)(C\u0002\u0002x]\u0012Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005a2\r\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRLXCAA@!\u0015\u0001\u0015\u0011MAA!\r9\u00151Q\u0005\u0004\u0003\u000b;$\u0001I\"mkN$XM\u001d'j].\u001c\u0005.Z2l\u0019&t7.\u0011<bS2\f'-\u001b7jif\f\u0001e\u00197vgR,'\u000fT5oW\u000eCWmY6Bm\u0006LG.\u00192jY&$\u0018p\u0018\u0013fcR!\u00111BAF\u0011%\t\u0019\u0002GA\u0001\u0002\u0004\ty(A\u000fdYV\u001cH/\u001a:MS:\\7\t[3dW\u00063\u0018-\u001b7bE&d\u0017\u000e^=!\u00035a\u0017M_=SKN|WO]2fgV\u0011\u00111\u0013\t\u0007\u0003+\u000by*a)\u000e\u0005\u0005]%\u0002BAM\u00037\u000bq!\\;uC\ndWMC\u0002\u0002\u001e\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a&\u0003\r\t+hMZ3sa\u0011\t)+a,\u0011\u000b\u001d\u000b9+a+\n\u0007\u0005%vG\u0001\u0007MCjL(+Z:pkJ\u001cW\r\u0005\u0003\u0002.\u0006=F\u0002\u0001\u0003\f\u0003c[\u0012\u0011!A\u0001\u0006\u0003\t)LA\u0002`IE\na\u0002\\1{sJ+7o\\;sG\u0016\u001c\b%\u0005\u0003\u00028\u0006u\u0006c\u0001!\u0002:&\u0019\u00111X!\u0003\u000f9{G\u000f[5oOB\u0019\u0001)a0\n\u0007\u0005\u0005\u0017IA\u0002B]f\f\u0001\u0004\\1{sJ+7o\\;sG\u0016\u0014V-\u00199fe\u001a+H/\u001e:f+\t\t9\r\r\u0003\u0002J\u0006}\u0007CBAf\u00033\fi.\u0004\u0002\u0002N*!\u0011qZAi\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003'\f).\u0001\u0003vi&d'BAAl\u0003\u0011Q\u0017M^1\n\t\u0005m\u0017Q\u001a\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB!\u0011QVAp\t-\t\tOHA\u0001\u0002\u0003\u0015\t!!.\u0003\u0007}##'A\rmCjL(+Z:pkJ\u001cWMU3ba\u0016\u0014h)\u001e;ve\u0016\u0004\u0013\u0001\b7buf\u0014Vm]8ve\u000e,'+Z1qKJ4U\u000f^;sK~#S-\u001d\u000b\u0005\u0003\u0017\tI\u000fC\u0005\u0002\u0014u\t\t\u00111\u0001\u0002lB\"\u0011Q^Ay!\u0019\tY-!7\u0002pB!\u0011QVAy\t1\t\t/!;\u0002\u0002\u0003\u0005)\u0011AA[\u0003\u0011awnY6\u0016\u0005\u0005]\b\u0003BA}\u0003\u007fl!!a?\u000b\t\u0005u\u0018Q[\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0002\u0005m(AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\tde\u0016\fG/\u001a*f[>$X-\u00113nS:$\u0012A^\u0001\bgR\f'\u000f^;q)\t\tY!\u0001\nti\u0006\u0014H/\u001e9BGRLg/\u001a+bg.\u001c\u0018\u0001H:uCJ$X\u000f]!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f)\u0006\u001c8n]\u0001'gR\f'\u000f^;q\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017i\u0019;jm\u0016|%/\u00138bGRLg/\u001a+bg.\u001c\u0018\u0001C:ikR$wn\u001e8\u0002'MDW\u000f\u001e3po:\f5\r^5wKR\u000b7o[:\u0002;MDW\u000f\u001e3po:\fE\rZ5uS>t\u0017\r\\!di&4X\rV1tWN\fqe\u001d5vi\u0012|wO\\!eI&$\u0018n\u001c8bY\u0006\u001bG/\u001b<f\u001fJLe.Y2uSZ,G+Y:lg\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\tYAa\b\u0003$!1!\u0011\u0005\u0016A\u0002M\f\u0011B\\3x\u0007>tg-[4\t\u000f\t\u0015\"\u00061\u0001\u0003(\u0005YQ\u000f\u001d3bi\u0016$7*Z=t!\u0019\u0011ICa\u000b\u000305\u0011\u00111T\u0005\u0005\u0005[\tYJA\u0002TKR\u0004BA!\r\u0003@9!!1\u0007B\u001e!\r\u0011)$Q\u0007\u0003\u0005oQ1A!\u000f>\u0003\u0019a$o\\8u}%\u0019!QH!\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tEa\u0011\u0003\rM#(/\u001b8h\u0015\r\u0011i$Q\u0001\u0014O\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\u000b\u0002m\u0006Aq-\u001a;BI6Lg.\u0006\u0002\u0003NA!!q\nB,\u001b\t\u0011\tF\u0003\u0003\u0002\\\tM#\u0002\u0002B+\u0003W\tqa\u00197jK:$8/\u0003\u0003\u0003Z\tE#AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0012GJ,\u0017\r^3B]\u0012\u001cV\r^!e[&t\u0017AC2m_N,\u0017\tZ7j]\u0006A\u0011n]!di&4X\r\u0006\u0002\u0003dA\u0019\u0001I!\u001a\n\u0007\t\u001d\u0014IA\u0004C_>dW-\u00198\u0002)=t\u0017I^1jY\u0006\u0014\u0017\u000e\\5us\u000eC\u0017M\\4f)\u0011\tYA!\u001c\t\u000f\t=\u0004\u00071\u0001\u0003d\u0005Y\u0011n]!wC&d\u0017M\u00197f\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0006yA/Y:l\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0003\u0003x\t}\u0004#\u0002!\u0002b\te\u0004cA$\u0003|%\u0019!QP\u001c\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:DqA!!3\u0001\u0004\u0011\u0019)\u0001\u0005uCN\\G+\u001f9f!\r9%QQ\u0005\u0004\u0005\u000f;$\u0001\u0003+bg.$\u0016\u0010]3\u0002AQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:4uN]!eI&$\u0018n\u001c8bYR\u000b7o\u001b\u000b\u0005\u0005o\u0012i\tC\u0004\u0003\u0002N\u0002\rAa!\u0002)I,w-[:uKJd\u0015M_=SKN|WO]2f)\u0011\tYAa%\t\u000f\tUE\u00071\u0001\u0003\u0018\u0006aA.\u0019>z%\u0016\u001cx.\u001e:dKB\"!\u0011\u0014BO!\u00159\u0015q\u0015BN!\u0011\tiK!(\u0005\u0019\t}%1SA\u0001\u0002\u0003\u0015\t!!.\u0003\u0007}#3'A\u000btQV$Hm\\<o\u0013\u0012dWMU3t_V\u00148-Z:")
public abstract class AbstractClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetrics linkMetrics;
    private final ClusterLinkTaskManager taskManager;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory;
    private final Function0<ClusterLinkLocalAdmin> localAdminFactory;
    private volatile ClusterLinkConfig linkConfig;
    private final Time time;
    private final ClusterLinkQuotas quotas;
    private volatile Option<ClusterLinkAdminClient> admin;
    private final ClusterLinkScheduler scheduler;
    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability;
    private final Buffer<LazyResource<?>> lazyResources;
    private ScheduledFuture<?> lazyResourceReaperFuture;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    @Override
    public ClusterLinkTaskManager taskManager() {
        return this.taskManager;
    }

    public Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    public Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    public void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    @Override
    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<ClusterLinkCheckLinkAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckLinkAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Buffer<LazyResource<?>> lazyResources() {
        return this.lazyResources;
    }

    private ScheduledFuture<?> lazyResourceReaperFuture() {
        return this.lazyResourceReaperFuture;
    }

    private void lazyResourceReaperFuture_$eq(ScheduledFuture<?> x$1) {
        this.lazyResourceReaperFuture = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    public ClusterLinkAdminClient createRemoteAdmin() {
        return (ClusterLinkAdminClient)this.remoteAdminFactory().apply((Object)this.linkConfig());
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.startupAdditionalActiveOrInactiveTasks();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Startup of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)new Some((Object)new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig>)(Function0 & Serializable)() -> this.currentConfig(), this.linkMetrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()), this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin(), this.localAdminFactory, this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
        this.startupAdditionalActiveTasks();
        this.lazyResourceReaperFuture_$eq(this.scheduler().schedule("ShutdownIdleResources", () -> this.shutdownIdleResources(), this.currentConfig().clientsMaxIdleMs(), this.currentConfig().clientsMaxIdleMs()));
    }

    public abstract void startupAdditionalActiveTasks();

    public abstract void startupAdditionalActiveOrInactiveTasks();

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Shutting down ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).toString());
        this.shutdownAdditionalActiveOrInactiveTasks();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Shutdown of ").append(this.getClass().getSimpleName()).append(" with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)None$.MODULE$);
        this.shutdownAdditionalActiveTasks();
        Option$.MODULE$.apply(this.lazyResourceReaperFuture()).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.cancel(true)));
        this.lazyResourceReaperFuture_$eq(null);
    }

    public abstract void shutdownAdditionalActiveTasks();

    public abstract void shutdownAdditionalActiveOrInactiveTasks();

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.linkConfig_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Reconfiguring ").append(this.getClass().getSimpleName()).append(". oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Reconfiguring AdminClient and restarting tasks for ").append(this.getClass().getSimpleName()).toString());
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks();
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    public ClusterLinkAdminClient getClusterLinkAdmin() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public ConfluentAdmin getAdmin() {
        return this.getClusterLinkAdmin().admin();
    }

    public void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some((Object)this.createRemoteAdmin()));
    }

    public void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> a.close(), this, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused());
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks();
            if (!Predef$.MODULE$.Boolean2boolean(this.linkConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.linkConfig().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.linkConfig().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckLinkAvailability>)new Some((Object)new ClusterLinkCheckLinkAvailability((Function0<ClusterLinkConfig>)(Function0 & Serializable)() -> this.linkConfig(), this.linkMetrics(), this.clusterLinkManager(), intervalMs, this.scheduler(), this.linkData().linkName(), (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> this.getAdmin(), this.localAdminFactory, this.time, this.quotas.requestQuotaAdapter(this.linkData()))));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.linkConfig();
    }

    @Override
    public Option<TaskDescription> taskDescription(TaskType taskType) {
        if (ClusterLinkCheckAvailabilityTaskType$.MODULE$.equals(taskType)) {
            return this.clusterLinkCheckAvailability().flatMap((Function1 & Serializable)x$5 -> x$5.taskDescription());
        }
        return this.taskDescriptionForAdditionalTask(taskType);
    }

    public abstract Option<TaskDescription> taskDescriptionForAdditionalTask(TaskType var1);

    @Override
    public void registerLazyResource(LazyResource<?> lazyResource) {
        this.lazyResources().$plus$eq(lazyResource);
    }

    private void shutdownIdleResources() {
        this.lazyResources().foreach((Function1 & Serializable)x$6 -> {
            x$6.closeIdleResource();
            return BoxedUnit.UNIT;
        });
    }

    public AbstractClusterLinkClientManager(ClusterLinkManager clusterLinkManager, ClusterLinkData linkData, ClusterLinkMetrics linkMetrics, ClusterLinkTaskManager taskManager, Function1<ClusterLinkConfig, ClusterLinkAdminClient> remoteAdminFactory, Function0<ClusterLinkLocalAdmin> localAdminFactory, ClusterLinkConfig linkConfig, Time time, ClusterLinkQuotas quotas) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.linkMetrics = linkMetrics;
        this.taskManager = taskManager;
        this.remoteAdminFactory = remoteAdminFactory;
        this.localAdminFactory = localAdminFactory;
        this.linkConfig = linkConfig;
        this.time = time;
        this.quotas = quotas;
        this.scheduler = taskManager.scheduler();
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.lazyResources = (Buffer)Buffer$.MODULE$.empty();
        this.lock = new Object();
    }
}

