/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStatus;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSensorFactory;
import kafka.server.link.ClusterLinkTaskManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.FetcherRemoveReason;
import kafka.server.link.LazyResource;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskSensorsManager;
import kafka.server.link.TaskType;
import kafka.server.link.UnavailableLinkReason;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r\u0005x!\u0002&L\u0011\u0003\u0011f!\u0002+L\u0011\u0003)\u0006\"\u0002/\u0002\t\u0003if\u0001\u00020\u0002\u0001}CQ\u0001X\u0002\u0005\u00021DQa\\\u0002\u0005\u0002ADQ\u0001^\u0002\u0005\u0002ADa!^\u0002\u0005\u0002-3\b\u0002CA\u0010\u0007\u0011\u00051*!\t\t\u0011\u0005\u00153\u0001\"\u0001L\u0003\u000fBq!!\u001c\u0004\t\u0003Y\u0005\u000fC\u0004\u0002p\r!\t!!\u001d\t\u000f\u0005M4\u0001\"\u0001\u0002v\u00191\u0011\u0011W\u0001\u0001\u0003gC!\"!/\u000e\u0005\u000b\u0007I\u0011AA^\u0011)\t\u0019-\u0004B\u0001B\u0003%\u0011Q\u0018\u0005\u000796!\t!!2\t\u0013\u0005-WB1A\u0005\u0002\u00055\u0007\u0002CAk\u001b\u0001\u0006I!a4\t\u000f\u0005]W\u0002\"\u0003\u0002Z\")q.\u0004C\u0001a\")A/\u0004C\u0001a\"9Q/\u0004C\u0001\u0017\u0006-\b\u0002CAy\u001b\u0011\u00051*a=\t\u0011\u0005]X\u0002\"\u0001L\u0003sDq!a\u001c\u000e\t\u0003\t\t\bC\u0004\u0002~6!\t!a@\t\u000f\t}Q\u0002\"\u0001\u0003\"!9!\u0011H\u0007\u0005\u0002\tm\u0002b\u0002B'\u001b\u0011\u0005#q\n\u0005\b\u0005GjA\u0011\tB3\r\u0019\u0011I)\u0001\u0001\u0003\f\"Q!\u0011T\u0010\u0003\u0006\u0004%\tAa'\t\u0015\t%vD!A!\u0002\u0013\u0011i\n\u0003\u0006\u0003,~\u0011)\u0019!C\u0001\u0005[C!Ba, \u0005\u0003\u0005\u000b\u0011BA\u0005\u0011\u0019av\u0004\"\u0001\u00032\"9\u0011q[\u0010\u0005\n\u0005e\u0007\"B8 \t\u0003\u0002\bbB; \t\u0003Z%\u0011\u0018\u0005\u0006i~!\t\u0005\u001d\u0005\b\u0003_zB\u0011IA9\u0011\u001d\u0011yl\bC!\u0005\u0003DqA!3 \t\u0003\u0012Y\rC\u0004\u0003r~!\tEa=\t\u000f\r=q\u0004\"\u0011\u0004\u0012!91qG\u0010\u0005B\rebABB \u0003\u0001\u0019\t\u0005\u0003\u0006\u0004J=\u0012)\u0019!C\u0001\u0005[C!ba\u00130\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\u0019ie\fBC\u0002\u0013\u00051q\n\u0005\u000b\u00077z#\u0011!Q\u0001\n\rE\u0003BCB/_\t\u0005\t\u0015!\u0003\u0004`!Q\u0011QM\u0018\u0003\u0002\u0003\u0006Ia!\u0019\t\rq{C\u0011AB4\u0011%\u0019\u0019h\fb\u0001\n\u0003\u0019)\b\u0003\u0005\u0004x=\u0002\u000b\u0011BB0\u0011%\u0019Ih\fb\u0001\n\u0013\u0019Y\b\u0003\u0005\u0004\u0002>\u0002\u000b\u0011BB?\u0011%\u0019\u0019i\fb\u0001\n\u0013\u0019)\t\u0003\u0005\u0004\u0012>\u0002\u000b\u0011BBD\u0011%\u0019\u0019j\fb\u0001\n\u0003\u0019)\n\u0003\u0005\u0004\u001e>\u0002\u000b\u0011BBL\u0011%\u0019yj\fb\u0001\n\u0003\u0019\t\u000b\u0003\u0005\u0004*>\u0002\u000b\u0011BBR\u0011%\u0019Yk\fb\u0001\n\u0003\u0019i\u000b\u0003\u0005\u00046>\u0002\u000b\u0011BBX\u0011-\u00199l\fa\u0001\u0002\u0004%\ta!/\t\u0017\r\u0005w\u00061AA\u0002\u0013\u000511\u0019\u0005\f\u0007\u0013|\u0003\u0019!A!B\u0013\u0019Y\fC\u0003p_\u0011\u0005\u0003\u000fC\u0003u_\u0011\u0005\u0003\u000fC\u0004\u0004L>\"\te!4\t\u000f\rEw\u0006\"\u0011\u0004T\u0006\t2\t\\;ti\u0016\u0014H*\u001b8l\r\u0006LG.\u001a3\u000b\u00051k\u0015\u0001\u00027j].T!AT(\u0002\rM,'O^3s\u0015\u0005\u0001\u0016!B6bM.\f7\u0001\u0001\t\u0003'\u0006i\u0011a\u0013\u0002\u0012\u00072,8\u000f^3s\u0019&t7NR1jY\u0016$7CA\u0001W!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0015\u0002\u000f\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s'\u0011\u0019a\u000b\u00194\u0011\u0005\u0005$gBA*c\u0013\t\u00197*\u0001\nDYV\u001cH/\u001a:MS:\\g)Y2u_JL\u0018B\u00010f\u0015\t\u00197\n\u0005\u0002hU6\t\u0001N\u0003\u0002j\u001f\u0006)Q\u000f^5mg&\u00111\u000e\u001b\u0002\b\u0019><w-\u001b8h)\u0005i\u0007C\u00018\u0004\u001b\u0005\t\u0011aB:uCJ$X\u000f\u001d\u000b\u0002cB\u0011qK]\u0005\u0003gb\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0006sK\u000e|gNZ5hkJ,GcA9xy\")\u0001p\u0002a\u0001s\u0006Ia.Z<D_:4\u0017n\u001a\t\u0003'jL!a_&\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw\rC\u0003~\u000f\u0001\u0007a0A\u0006va\u0012\fG/\u001a3LKf\u001c\b#B@\u0002\u0006\u0005%QBAA\u0001\u0015\r\t\u0019\u0001W\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0004\u0003\u0003\u00111aU3u!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001fAVBAA\t\u0015\r\t\u0019\"U\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]\u0001,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/A\u0016!H1eI2Kgn[3e\r\u0016$8\r[3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\u0007E\f\u0019\u0003C\u0004\u0002&!\u0001\r!a\n\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0002*\u0005M\u0012\u0011\b\b\u0005\u0003W\tyC\u0004\u0003\u0002\u0010\u00055\u0012\"A-\n\u0007\u0005E\u0002,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\t\u0013R,'/\u00192mK*\u0019\u0011\u0011\u0007-\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010P\u0003\u001d\u0019G.^:uKJLA!a\u0011\u0002>\tI\u0001+\u0019:uSRLwN\\\u0001!e\u0016lwN^3MS:\\W\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0003r\u0003\u0013\n\u0019\u0007C\u0004\u0002&%\u0001\r!a\u0013\u0011\u000b}\f)!!\u0014\u0011\t\u0005=\u0013qL\u0007\u0003\u0003#RA!a\u0015\u0002V\u000511m\\7n_:T1\u0001UA,\u0015\u0011\tI&a\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti&A\u0002pe\u001eLA!!\u0019\u0002R\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA3\u0013\u0001\u0007\u0011qM\u0001\u0007e\u0016\f7o\u001c8\u0011\u0007M\u000bI'C\u0002\u0002l-\u00131CR3uG\",'OU3n_Z,'+Z1t_:\f!d\u001d5vi\u0012|wO\\%eY\u00164U\r^2iKJ$\u0006N]3bIN\fQbY;se\u0016tGoQ8oM&<W#A=\u0002)A\f'\u000f^5uS>tW*\u001b:s_J\u001cF/\u0019;f)!\t9(a#\u0002\u0010\u0006\u0005\u0006\u0003BA=\u0003\u000bsA!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t&A\u0004sKBd\u0017nY1\n\t\u0005\r\u0015QP\u0001\u000e%\u0016\u0004H.[2b'R\fG/^:\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u000b\u001b&\u0014(o\u001c:J]\u001a|'\u0002BAB\u0003{Bq!!$\r\u0001\u0004\ti%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005EE\u00021\u0001\u0002\u0014\u0006)\u0002/\u001a:tSN$XM\u001c;NSJ\u0014xN]*uCR,\u0007\u0003BAK\u00037sA!!\u001f\u0002\u0018&!\u0011\u0011TAE\u0003)i\u0015N\u001d:pe&sgm\\\u0005\u0005\u0003;\u000byJA\u0003Ti\u0006$XM\u0003\u0003\u0002\u001a\u0006%\u0005bBAR\u0019\u0001\u0007\u0011QU\u0001\u0016k:\fg/Y5mC\ndW\rT5oWJ+\u0017m]8o!\u00159\u0016qUAV\u0013\r\tI\u000b\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007M\u000bi+C\u0002\u00020.\u0013Q#\u00168bm\u0006LG.\u00192mK2Kgn\u001b*fCN|gNA\u0007DY&,g\u000e^'b]\u0006<WM]\n\u0006\u001bY\u000b)L\u001a\t\u0004C\u0006]\u0016bAAYK\u0006YA/Y:l\u001b\u0006t\u0017mZ3s+\t\ti\fE\u0002T\u0003\u007fK1!!1L\u0005Y\u0019E.^:uKJd\u0015N\\6UCN\\W*\u00198bO\u0016\u0014\u0018\u0001\u0004;bg.l\u0015M\\1hKJ\u0004C\u0003BAd\u0003\u0013\u0004\"A\\\u0007\t\u000f\u0005e\u0006\u00031\u0001\u0002>\u0006I1o\u00195fIVdWM]\u000b\u0003\u0003\u001f\u00042aUAi\u0013\r\t\u0019n\u0013\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%A\u0005fq\u000e,\u0007\u000f^5p]R\u0011\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0018\u0001\u00026bm\u0006LA!!;\u0002`\n)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>tG#B9\u0002n\u0006=\b\"\u0002=\u0017\u0001\u0004I\b\"B?\u0017\u0001\u0004q\u0018!C1eIR{\u0007/[2t)\r\t\u0018Q\u001f\u0005\u0007\u0003c<\u0002\u0019\u0001@\u0002\u0019I,Wn\u001c<f)>\u0004\u0018nY:\u0015\u0007E\fY\u0010\u0003\u0004\u0002xb\u0001\rA`\u0001\u0015M\u0016$8\r\u001b+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\r\t\u0005!q\u0003B\u000e!\u0019\u0011\u0019A!\u0004\u0003\u00125\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!\u0001\u0006d_:\u001cWO\u001d:f]RTAAa\u0003\u0002d\u0006!Q\u000f^5m\u0013\u0011\u0011yA!\u0002\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002X\u0005'I1A!\u0006Y\u0005\rIe\u000e\u001e\u0005\b\u00053Q\u0002\u0019AA\u0005\u0003\u0015!x\u000e]5d\u0011\u001d\u0011iB\u0007a\u0001\u0005#\t\u0011\u0002^5nK>,H/T:\u0002\u001d\u0019,Go\u00195U_BL7-\u00138g_RA!1\u0005B\u0016\u0005[\u0011y\u0003\u0005\u0004\u0003\u0004\t5!Q\u0005\t\u0004'\n\u001d\u0012b\u0001B\u0015\u0017\n!2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY%oM>DqA!\u0007\u001c\u0001\u0004\tI\u0001C\u0004\u0003\u001em\u0001\rA!\u0005\t\u000f\tE2\u00041\u0001\u00034\u0005y1\u000f^1si>3gm]3u'B,7\rE\u0002X\u0005kI1Aa\u000eY\u0005\u0011auN\\4\u0002\u001bI,\u0007\u000f\\5dCN#\u0018\r^;t)\u0011\u0011iDa\u0013\u0011\u000f}\u0014y$!\u0014\u0003D%!!\u0011IA\u0001\u0005\ri\u0015\r\u001d\t\u0007\u0005\u0007\u0011iA!\u0012\u0011\t\u0005m\"qI\u0005\u0005\u0005\u0013\niDA\bQCJ$\u0018\u000e^5p]N#\u0018\r^;t\u0011\u001d\t)\u0003\ba\u0001\u0003\u0017\nq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0005\u0005#\u0012I\u0006E\u0003X\u0003O\u0013\u0019\u0006E\u0002T\u0005+J1Aa\u0016L\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0007b\u0002B.;\u0001\u0007!QL\u0001\ti\u0006\u001c8\u000eV=qKB\u00191Ka\u0018\n\u0007\t\u00054J\u0001\u0005UCN\\G+\u001f9f\u0003Q\u0011XmZ5ti\u0016\u0014H*\u0019>z%\u0016\u001cx.\u001e:dKR\u0019\u0011Oa\u001a\t\u000f\t%d\u00041\u0001\u0003l\u0005aA.\u0019>z%\u0016\u001cx.\u001e:dKB\"!Q\u000eB<!\u0015\u0019&q\u000eB:\u0013\r\u0011\th\u0013\u0002\r\u0019\u0006T\u0018PU3t_V\u00148-\u001a\t\u0005\u0005k\u00129\b\u0004\u0001\u0005\u0019\te$qMA\u0001\u0002\u0003\u0015\tAa\u001f\u0003\u0007}#C'\u0005\u0003\u0003~\t\r\u0005cA,\u0003\u0000%\u0019!\u0011\u0011-\u0003\u000f9{G\u000f[5oOB\u0019qK!\"\n\u0007\t\u001d\u0005LA\u0002B]f\u0014\u0011cQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s'\u0019ybK!$\u0003\u0014B\u0019\u0011Ma$\n\u0007\tEUM\u0001\rJ]\n|WO\u001c3D_:tWm\u0019;j_:l\u0015M\\1hKJ\u00042!\u0019BK\u0013\r\u00119*\u001a\u0002\u001a\u001fV$(m\\;oI\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\u0005mS:\\G)\u0019;b+\t\u0011i\n\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\r\u0011\u0019kT\u0001\u0003u.LAAa*\u0003\"\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005\u0019Bn\\2bY2{w-[2bY\u000ecWo\u001d;feV\u0011\u0011\u0011B\u0001\u0015Y>\u001c\u0017\r\u001c'pO&\u001c\u0017\r\\\"mkN$XM\u001d\u0011\u0015\r\tM&Q\u0017B\\!\tqw\u0004C\u0004\u0003\u001a\u0012\u0002\rA!(\t\u000f\t-F\u00051\u0001\u0002\nQ)\u0011Oa/\u0003>\")\u0001p\na\u0001s\")Qp\na\u0001}\u0006aA.\u001b8l\u00072,8\u000f^3sgV\u0011!1\u0019\t\u0006\u007f\n\u0015\u0017\u0011B\u0005\u0005\u0005\u000f\f\tAA\u0002TKF\f\u0011#\u001a8bE2,7\t\\;ti\u0016\u0014H*\u001b8l)\u0015\t(Q\u001aBl\u0011\u001d\u0011ym\u000ba\u0001\u0005#\fQB\\3uo>\u00148n\u00117jK:$\bcA*\u0003T&\u0019!Q[&\u00031\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG\u000fC\u0004\u0003Z.\u0002\rAa7\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004RaVAT\u0005;\u0004BAa8\u0003n6\u0011!\u0011\u001d\u0006\u0005\u0005G\u0014)/A\u0005j]R,'O\\1mg*!!q\u001dBu\u0003\u0015\tG-\\5o\u0015\u0011\u0011Y/!\u0016\u0002\u000f\rd\u0017.\u001a8ug&!!q\u001eBq\u0005Q\tE-\\5o\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006A\u0002O]8dKN\u001c(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000bE\u0014)p!\u0002\t\u000f\t]H\u00061\u0001\u0003z\u000691\r[1o]\u0016d\u0007\u0003\u0002B~\u0007\u0003i!A!@\u000b\t\t}\u0018\u0011K\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0019\u0019A!@\u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\t\u000f\r\u001dA\u00061\u0001\u0004\n\u0005Y!/\u001a<feN,gj\u001c3f!\u0011\u0011Ypa\u0003\n\t\r5!Q \u0002\f%\u00164XM]:f\u001d>$W-\u0001\u000ej]&$\u0018.\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000f\u0006\u0004\u0004\u0014\ru1Q\u0006\t\u0006\u007f\n\u00157Q\u0003\t\u0007\u0005\u0007\u0011iaa\u0006\u0011\t\u0005u7\u0011D\u0005\u0005\u00077\tyN\u0001\u0003W_&$\u0007bBB\u0010[\u0001\u00071\u0011E\u0001\u001aS:LG/[1uK\u000e{gN\\3di&|gNU3rk\u0016\u001cH\u000f\u0005\u0003\u0004$\r%RBAB\u0013\u0015\u0011\u00199#!\u0015\u0002\u0011I,\u0017/^3tiNLAaa\u000b\u0004&\t\t\u0013J\\5uS\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogJ+\u0017/^3ti\"91qF\u0017A\u0002\rE\u0012A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0007G\u0019\u0019$\u0003\u0003\u00046\r\u0015\"A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010^\u0001\u0014_:\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0006c\u000em2Q\b\u0005\b\u0005ot\u0003\u0019\u0001B}\u0011\u001d\u00199A\fa\u0001\u0007\u0013\u0011\u0001DR1jY\u0016$7\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t'\u0011ycka\u0011\u0011\u0007\u0005\u001c)%C\u0002\u0004H\u0015\u00141\u0002T5oW6+GO]5dg\u0006AA.\u001b8l\u001d\u0006lW-A\u0005mS:\\g*Y7fA\u00059Q.\u001a;sS\u000e\u001cXCAB)!\u0011\u0019\u0019fa\u0016\u000e\u0005\rU#\u0002BB'\u0003#JAa!\u0017\u0004V\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0019Q,g.\u00198u!J,g-\u001b=\u0011\u000b]\u000b9+!\u0003\u0011\u0007M\u001b\u0019'C\u0002\u0004f-\u0013\u0001CR1jY\u0016$G*\u001b8l%\u0016\f7o\u001c8\u0015\u0015\r%41NB7\u0007_\u001a\t\b\u0005\u0002o_!91\u0011\n\u001cA\u0002\u0005%\u0001bBB'm\u0001\u00071\u0011\u000b\u0005\b\u0007;2\u0004\u0019AB0\u0011\u001d\t)G\u000ea\u0001\u0007C\na\u0001^3oC:$XCAB0\u0003\u001d!XM\\1oi\u0002\n!#\u001e8qe\u00164\u0017\u000e_3e\u0019&t7NT1nKV\u00111Q\u0010\t\u0005\u0003;\u001cy(\u0003\u0003\u0002\u001c\u0005}\u0017aE;oaJ,g-\u001b=fI2Kgn\u001b(b[\u0016\u0004\u0013\u0001\u0002;bON,\"aa\"\u0011\u0011\r%5qRB?\u0003\u0013i!aa#\u000b\t\r5\u0015\u0011A\u0001\nS6lW\u000f^1cY\u0016LAA!\u0011\u0004\f\u0006)A/Y4tA\u0005Ib-Y5mK\u0012d\u0015N\\6D_VtG/T3ue&\u001cg*Y7f+\t\u00199\n\u0005\u0003\u0002P\re\u0015\u0002BBN\u0003#\u0012!\"T3ue&\u001cg*Y7f\u0003i1\u0017-\u001b7fI2Kgn[\"pk:$X*\u001a;sS\u000et\u0015-\\3!\u0003\u001d1\u0017m\u0019;pef,\"aa)\u0011\u0007M\u001b)+C\u0002\u0004(.\u0013\u0001d\u00117vgR,'\u000fT5oWN+gn]8s\r\u0006\u001cGo\u001c:z\u0003!1\u0017m\u0019;pef\u0004\u0013A\u0005;bg.\u001cVM\\:peNl\u0015M\\1hKJ,\"aa,\u0011\u0007M\u001b\t,C\u0002\u00044.\u0013!\u0003V1tWN+gn]8sg6\u000bg.Y4fe\u0006\u0019B/Y:l'\u0016t7o\u001c:t\u001b\u0006t\u0017mZ3sA\u0005qB.\u001b8l\r\u0006LG.\u001e:f%\u0016$(/_!ui\u0016l\u0007\u000f^:TK:\u001cxN]\u000b\u0003\u0007w\u0003Baa\u0015\u0004>&!1qXB+\u0005\u0019\u0019VM\\:pe\u0006\u0011C.\u001b8l\r\u0006LG.\u001e:f%\u0016$(/_!ui\u0016l\u0007\u000f^:TK:\u001cxN]0%KF$2!]Bc\u0011%\u00199\rRA\u0001\u0002\u0004\u0019Y,A\u0002yIE\nq\u0004\\5oW\u001a\u000b\u0017\u000e\\;sKJ+GO]=BiR,W\u000e\u001d;t'\u0016t7o\u001c:!\u0003m\u0019G.^:uKJd\u0015N\\6UCN\\\u0017i\u0019;jm\u0016\u001cVM\\:peR!11XBh\u0011\u001d\u0011Y\u0006\u0013a\u0001\u0005;\nAd\u00197vgR,'\u000fT5oWR\u000b7o[%o\u000bJ\u0014xN]*f]N|'\u000f\u0006\u0004\u0004<\u000eU7q\u001b\u0005\b\u00057J\u0005\u0019\u0001B/\u0011\u001d\u0019I.\u0013a\u0001\u00077\f\u0011\"\u001a:s_J\u001cu\u000eZ3\u0011\u0007M\u001bi.C\u0002\u0004`.\u0013Q\u0002V1tW\u0016\u0013(o\u001c:D_\u0012,\u0007")
public final class ClusterLinkFailed {

    public static class ClientManager
    implements ClusterLinkFactory.ClientManager,
    Logging {
        private final ClusterLinkTaskManager taskManager;
        private final ClusterLinkScheduler scheduler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ClientManager.onAvailabilityChange$(this, isAvailable);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public ClusterLinkTaskManager taskManager() {
            return this.taskManager;
        }

        @Override
        public ClusterLinkScheduler scheduler() {
            return this.scheduler;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting up failed client manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down failed client manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        public void addTopics(Set<String> addTopics) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Adding topics ").append(addTopics).append(" for failed client manager").toString());
        }

        public void removeTopics(Set<String> removeTopics) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Removing topics ").append(removeTopics).append(" for failed client manager").toString());
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs, long startOffsetSpec) {
            throw new InvalidClusterLinkException("Cluster link is in failed state.");
        }

        public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public Option<TaskDescription> taskDescription(TaskType taskType) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void registerLazyResource(LazyResource<?> lazyResource) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        public ClientManager(ClusterLinkTaskManager taskManager) {
            this.taskManager = taskManager;
            this.scheduler = taskManager.scheduler();
        }
    }

    public static class ConnectionManager
    implements ClusterLinkFactory.InboundConnectionManager,
    ClusterLinkFactory.OutboundConnectionManager {
        private final ClusterLinkData linkData;
        private final String localLogicalCluster;

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ConnectionManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public boolean active() {
            return ClusterLinkFactory.ConnectionManager.active$(this);
        }

        @Override
        public void onControllerChange(boolean isActive) {
            ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
        }

        @Override
        public void onLinkMetadataPartitionLeaderChange() {
            ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
        }

        @Override
        public int persistentConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
        }

        @Override
        public int reverseConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.ConnectionManager.lazyResources$(this);
        }

        @Override
        public boolean isLinkCoordinator() {
            return ClusterLinkFactory.ConnectionManager.isLinkCoordinator$(this);
        }

        @Override
        public Option<Object> linkCoordinatorId() {
            return ClusterLinkFactory.ConnectionManager.linkCoordinatorId$(this);
        }

        @Override
        public ClusterLinkData linkData() {
            return this.linkData;
        }

        @Override
        public String localLogicalCluster() {
            return this.localLogicalCluster;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public Seq<String> linkClusters() {
            return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus(this.linkData().clusterId());
        }

        @Override
        public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
            throw new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void processReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection is no longer required");
        }

        @Override
        public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
            throw new NetworkException("Cluster link has failed, connection cannot be created");
        }

        public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection not required any more");
        }

        public ConnectionManager(ClusterLinkData linkData, String localLogicalCluster) {
            this.linkData = linkData;
            this.localLogicalCluster = localLogicalCluster;
        }
    }

    public static class FailedClusterLinkMetrics
    implements ClusterLinkFactory.LinkMetrics {
        private final String linkName;
        private final Metrics metrics;
        private final Option<String> tenant;
        private final String unprefixedLinkName;
        private final scala.collection.immutable.Map<String, String> tags;
        private final MetricName failedLinkCountMetricName;
        private final ClusterLinkSensorFactory factory;
        private final TaskSensorsManager taskSensorsManager;
        private Sensor linkFailureRetryAttemptsSensor;

        public String linkName() {
            return this.linkName;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Option<String> tenant() {
            return this.tenant;
        }

        private String unprefixedLinkName() {
            return this.unprefixedLinkName;
        }

        private scala.collection.immutable.Map<String, String> tags() {
            return this.tags;
        }

        public MetricName failedLinkCountMetricName() {
            return this.failedLinkCountMetricName;
        }

        public ClusterLinkSensorFactory factory() {
            return this.factory;
        }

        public TaskSensorsManager taskSensorsManager() {
            return this.taskSensorsManager;
        }

        public Sensor linkFailureRetryAttemptsSensor() {
            return this.linkFailureRetryAttemptsSensor;
        }

        public void linkFailureRetryAttemptsSensor_$eq(Sensor x$1) {
            this.linkFailureRetryAttemptsSensor = x$1;
        }

        @Override
        public void startup() {
            this.metrics().addMetric(this.failedLinkCountMetricName(), (x$2, x$3) -> 1.0);
            this.linkFailureRetryAttemptsSensor_$eq(this.factory().createSensorForTotalAndRateMetrics((Option<String>)new Some((Object)this.linkName()), (Option<Sensor>)None$.MODULE$, "link-failure-retry-attempts", "link failure retry attempts", this.factory().createSensorForTotalAndRateMetrics$default$5()));
            this.taskSensorsManager().createFailedLinkTasksSensors(this.factory());
        }

        @Override
        public void shutdown() {
            this.metrics().removeMetric(this.failedLinkCountMetricName());
            this.metrics().removeSensor(this.linkFailureRetryAttemptsSensor().name());
            this.taskSensorsManager().removeSensors();
        }

        @Override
        public Sensor clusterLinkTaskActiveSensor(TaskType taskType) {
            return this.taskSensorsManager().activeSensor(taskType);
        }

        @Override
        public Sensor clusterLinkTaskInErrorSensor(TaskType taskType, TaskErrorCode errorCode) {
            return this.taskSensorsManager().inErrorSensor(taskType, errorCode);
        }

        public FailedClusterLinkMetrics(String linkName, Metrics metrics, Option<String> tenantPrefix2, FailedLinkReason reason) {
            this.linkName = linkName;
            this.metrics = metrics;
            this.tenant = tenantPrefix2.map((Function1 & Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix));
            this.unprefixedLinkName = (String)this.tenant().map((Function1 & Serializable)t -> this.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> this.linkName());
            this.tags = ((IterableOnceOps)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason.name())), (List)new .colon.colon((Object)this.tenant().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.failedLinkCountMetricName = new MetricName("broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), "Number of failed cluster links at the broker.", CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
            this.factory = new ClusterLinkSensorFactory(metrics, this.tags(), Long.MAX_VALUE);
            this.taskSensorsManager = new TaskSensorsManager(linkName, this.tags(), metrics);
        }
    }

    public static class FetcherManager
    implements ClusterLinkFactory.FetcherManager,
    Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public boolean isEmpty() {
            return ClusterLinkFactory.FetcherManager.isEmpty$(this);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.FetcherManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public void maybeNotifyReadyForFetch(Partition partition) {
            ClusterLinkFactory.FetcherManager.maybeNotifyReadyForFetch$(this, partition);
        }

        @Override
        public Seq<LazyResource<?>> lazyResources() {
            return ClusterLinkFactory.FetcherManager.lazyResources$(this);
        }

        @Override
        public int fetcherCount() {
            return ClusterLinkFactory.FetcherManager.fetcherCount$(this);
        }

        @Override
        public int throttledPartitionCount() {
            return ClusterLinkFactory.FetcherManager.throttledPartitionCount$(this);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting up failed fetcher manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down failed fetcher manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void addLinkedFetcherForPartitions(Iterable<Partition> partitions) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Adding linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void removeLinkedFetcherForPartitions(Set<TopicPartition> partitions, FetcherRemoveReason reason) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Removing linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void shutdownIdleFetcherThreads() {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down idle fetcher threads for failed fetcher manager");
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public ReplicaStatus.MirrorInfo partitionMirrorState(TopicPartition topicPartition, ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason) {
            return new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.LINK_FAILED, -1L, -1L);
        }
    }
}

