/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.durability.audit.manager.BrokerAuditManager$;
import kafka.durability.audit.manager.BrokerAuditManagerTrait;
import kafka.durability.audit.request.ClusterLinkTruncationRequest;
import kafka.durability.events.broker.ClusterLinkTruncationEvent$TruncationType$;
import kafka.log.AbstractLog;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$Default$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkFetcherThread$AdjustmentType$;
import kafka.server.link.ClusterLinkFetcherThread$MaxPartitionLagOrder$;
import kafka.server.link.ClusterLinkLeaderEndPoint;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.LinkType;
import kafka.server.link.LinkType$Cloud$;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$SourceTopicIdChanged$;
import kafka.server.link.MirrorFailureType$TruncationBelowHighWatermark$;
import kafka.server.link.MirrorFailureType$UnexpectedTruncation$;
import org.apache.kafka.clients.StaleMetadataException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u001dh!\u0002%J\u0003\u0003\u0001\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\nY\u0002\u0011\t\u0011)A\u0005[FD\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\tq\u0002\u0011\t\u0011)A\u0005s\"AA\u0010\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u001b\u0001\t\u0005\t\u0015!\u0003\u00028!Q\u0011Q\b\u0001\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005\u0015\u0003A!A!\u0002\u0013\t9\u0005\u0003\u0006\u0002N\u0001\u0011\t\u0011)A\u0005\u0003\u001fB!\"!\u0016\u0001\u0005\u0003\u0005\u000b\u0011BA,\u0011-\t\u0019\u0007\u0001BC\u0002\u0013\u0005\u0011*!\u001a\t\u0015\u00055\u0004A!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002p\u0001\u0011\t\u0011)A\u0005\u0003cB!\"! \u0001\u0005\u0003\u0005\u000b\u0011BA@\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007C\u0011\"!,\u0001\u0005\u0004%I!a,\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003cC\u0011\"a1\u0001\u0005\u0004%I!a,\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003cC\u0011\"a2\u0001\u0005\u0004%I!a,\t\u0011\u0005%\u0007\u0001)A\u0005\u0003cC\u0011\"a3\u0001\u0005\u0004%I!!4\t\u0011\u0005U\u0007\u0001)A\u0005\u0003\u001fD\u0011\"a6\u0001\u0005\u0004%I!!7\t\u0011\u0005}\u0007\u0001)A\u0005\u00037D\u0011\"!9\u0001\u0005\u0004%I!a9\t\u0011\u0005=\b\u0001)A\u0005\u0003KD\u0011\"!=\u0001\u0005\u0004%I!a=\t\u0011\tM\u0001\u0001)A\u0005\u0003kD!B!\u0006\u0001\u0005\u0004%\t!\u0013B\f\u0011!\u0011I\u0003\u0001Q\u0001\n\te\u0001\"\u0003B\u0016\u0001\t\u0007I\u0011KAg\u0011!\u0011i\u0003\u0001Q\u0001\n\u0005=\u0007b\u0002B\u0018\u0001\u0011\u0005#\u0011\u0007\u0005\n\u0005s\u0001!\u0019!C!\u0003\u001bD\u0001Ba\u000f\u0001A\u0003%\u0011q\u001a\u0005\b\u0005{\u0001A\u0011\u000bB \u0011\u001d\u0011i\u0006\u0001C)\u0005?BqAa\u001a\u0001\t#\u0012I\u0007C\u0004\u0003\u0004\u0002!\tE!\"\t\u0011\tM\u0005\u0001\"\u0001J\u0005+C\u0001Ba'\u0001\t#J%Q\u0014\u0005\b\u0005W\u0003A\u0011\tBW\u0011\u001d\u0011i\r\u0001C!\u0005cA\u0001Ba4\u0001\t\u0003I%\u0011\u001b\u0005\b\u0005G\u0004A\u0011\tBs\u0011\u001d\u0011I\u0010\u0001C!\u0005wDqa!\u0003\u0001\t\u0003\u001aY\u0001C\u0004\u0004\u000e\u0001!\taa\u0004\t\u000f\rU\u0001\u0001\"\u0001\u0004\u0018!91Q\t\u0001\u0005\n\r\u001d\u0003bBB)\u0001\u0011E11\u000b\u0005\t\u00073\u0002A\u0011A%\u00032!911\f\u0001\u0005B\ru\u0003bBB3\u0001\u0011\u00053q\r\u0005\b\u0007_\u0002A\u0011BB9\u0011\u001d\u0019i\t\u0001C\u0005\u0007\u001fCqaa%\u0001\t\u0013\u0019)\nC\u0004\u0004\u001c\u0002!Ia!(\t\u0011\r\u001d\u0006\u0001\"\u0001J\u0007SC\u0001ba.\u0001\t\u0003I5\u0011X\u0004\n\u0007\u0003L\u0015\u0011!E\u0001\u0007\u00074\u0001\u0002S%\u0002\u0002#\u00051Q\u0019\u0005\b\u0003\u0003+E\u0011ABg\u0011%\u0019y-RI\u0001\n\u0003\u0019\tN\u0001\nDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014(B\u0001&L\u0003\u0011a\u0017N\\6\u000b\u00051k\u0015AB:feZ,'OC\u0001O\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A)\u0011\u0005I\u001bV\"A&\n\u0005Q[%\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0003oC6,\u0007CA,a\u001d\tAf\f\u0005\u0002Z96\t!L\u0003\u0002\\\u001f\u00061AH]8pizR\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\fX\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u001a4\u000e\u0003qK!a\u001a/\u0003\u0007%sG/A\u0006gKR\u001c\u0007.\u001a:Q_>d\u0007C\u0001*k\u0013\tY7JA\u0006GKR\u001c\u0007.\u001a:Q_>d\u0017A\u00027fC\u0012,'\u000f\u0005\u0002o_6\t\u0011*\u0003\u0002q\u0013\nI2\t\\;ti\u0016\u0014H*\u001b8l\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0013\ta'/\u0003\u0002t\u0017\n)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0001\u00042s_.,'oQ8oM&<\u0007C\u0001*w\u0013\t98JA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!E2mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0011aN_\u0005\u0003w&\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003M\u0019G.^:uKJd\u0015N\\6NKR\fG-\u0019;b!\tqg0\u0003\u0002\u0000\u0013\n\u00192\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC\u0006qa-\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\bc\u00018\u0002\u0006%\u0019\u0011qA%\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u00042AUA\u0007\u0013\r\tya\u0013\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0001\u0003]1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007I\u000b)\"C\u0002\u0002\u0018-\u0013\u0001\u0003U1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0005\u0003;\t\t$\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0015)H/\u001b7t\u0015\u0011\t)#a\n\u0002\r\r|W.\\8o\u0015\rq\u0015\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003_\t1a\u001c:h\u0013\u0011\t\u0019$a\b\u0003%\u0015C\bo\u001c8f]RL\u0017\r\u001c\"bG.|gMZ\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bc\u0001*\u0002:%\u0019\u00111H&\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u0019!+!\u0011\n\u0007\u0005\r3J\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\ndYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\bc\u00018\u0002J%\u0019\u00111J%\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\u0005i&lW\r\u0005\u0003\u0002\u001e\u0005E\u0013\u0002BA*\u0003?\u0011A\u0001V5nK\u0006\u0001B-\u001f8b[&\u001cg)\u001a;dQNK'0\u001a\t\u0006K\u0006e\u0013QL\u0005\u0004\u00037b&!\u0003$v]\u000e$\u0018n\u001c81!\rq\u0017qL\u0005\u0004\u0003CJ%!\u0005$fi\u000eD'+Z:q_:\u001cXmU5{K\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u00072LWM\u001c;\u0016\u0005\u0005\u001d\u0004c\u00018\u0002j%\u0019\u00111N%\u00031\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG/\u0001\ndYV\u001cH/\u001a:MS:\\7\t\\5f]R\u0004\u0013!\u00047pO\u000e{g\u000e^3yi>\u0003H\u000fE\u0003f\u0003g\n9(C\u0002\u0002vq\u0013aa\u00149uS>t\u0007\u0003BA\u000f\u0003sJA!a\u001f\u0002 \tQAj\\4D_:$X\r\u001f;\u0002\rQ,g.\u00198u!\u0011)\u00171\u000f,\u0002\rqJg.\u001b;?)!\n))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151TAO\u0003?\u000b\t+a)\u0002&\u0006\u001d\u0016\u0011VAV!\tq\u0007\u0001C\u0003V+\u0001\u0007a\u000bC\u0003d+\u0001\u0007A\rC\u0003i+\u0001\u0007\u0011\u000eC\u0003m+\u0001\u0007Q\u000eC\u0003u+\u0001\u0007Q\u000fC\u0003y+\u0001\u0007\u0011\u0010C\u0003}+\u0001\u0007Q\u0010C\u0004\u0002\u0002U\u0001\r!a\u0001\t\u000f\u0005%Q\u00031\u0001\u0002\f!9\u0011\u0011C\u000bA\u0002\u0005M\u0001bBA\r+\u0001\u0007\u00111\u0004\u0005\b\u0003k)\u0002\u0019AA\u001c\u0011\u001d\ti$\u0006a\u0001\u0003\u007fAq!!\u0012\u0016\u0001\u0004\t9\u0005C\u0004\u0002NU\u0001\r!a\u0014\t\u000f\u0005US\u00031\u0001\u0002X!9\u00111M\u000bA\u0002\u0005\u001d\u0004\"CA8+A\u0005\t\u0019AA9\u0011\u001d\ti(\u0006a\u0001\u0003\u007f\na\u0003\\5oW\u001a+Go\u00195fe\u001acwn^\"p]R\u0014x\u000e\\\u000b\u0003\u0003c\u0003B!a-\u0002>6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,\u0001\u0003mC:<'BAA^\u0003\u0011Q\u0017M^1\n\t\u0005}\u0016Q\u0017\u0002\b\u0013:$XmZ3s\u0003]a\u0017N\\6GKR\u001c\u0007.\u001a:GY><8i\u001c8ue>d\u0007%A\u0010mS:\\g)\u001a;dQ\u0016\u0014X*\u0019=MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N\f\u0001\u0005\\5oW\u001a+Go\u00195fe6\u000b\u0007\u0010T1hO&tw\rU1si&$\u0018n\u001c8tA\u0005iB.\u001b8l\r\u0016$8\r[3s\u0019\u0006<w-\u001b8h!\u0006\u0014H/\u001b;j_:l5/\u0001\u0010mS:\\g)\u001a;dQ\u0016\u0014H*Y4hS:<\u0007+\u0019:uSRLwN\\'tA\u00059Ro]3J]\u0012,\u0007/\u001a8eK:$(+\u001a;f]RLwN\\\u000b\u0003\u0003\u001f\u00042!ZAi\u0013\r\t\u0019\u000e\u0018\u0002\b\u0005>|G.Z1o\u0003a)8/Z%oI\u0016\u0004XM\u001c3f]R\u0014V\r^3oi&|g\u000eI\u0001\u0013k:\u0004(/\u001a4jq\u0016$G*\u001b8l\u001d\u0006lW-\u0006\u0002\u0002\\B!\u00111WAo\u0013\r\t\u0017QW\u0001\u0014k:\u0004(/\u001a4jq\u0016$G*\u001b8l\u001d\u0006lW\rI\u0001\b[\u0016$(/[2t+\t\t)\u000f\u0005\u0003\u0002h\u0006-XBAAu\u0015\u0011\t\t/a\t\n\t\u00055\u0018\u0011\u001e\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013a\u00079beRLG/[8o\u0019\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/\u0006\u0002\u0002vBA\u0011q\u001fB\u0001\u0005\u000b\u0011i!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u007f\fI,\u0001\u0003vi&d\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\u00119A!\u0003\u000e\u0005\u0005\r\u0012\u0002\u0002B\u0006\u0003G\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002f\u0005\u001fI1A!\u0005]\u0005\u0011auN\\4\u00029A\f'\u000f^5uS>tG*Y:u\u0007\u0006,x\r\u001b;VaRKW.Z'tA\u0005A\u0002/\u0019:uSRLwN\\:XSRDg*Z<SK\u000e|'\u000fZ:\u0016\u0005\te\u0001C\u0002B\u000e\u0005K\u0011)!\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\u001diW\u000f^1cY\u0016T1Aa\t]\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0011iB\u0001\u0004Ck\u001a4WM]\u0001\u001aa\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<(+Z2pe\u0012\u001c\b%A\rue\u0006t7/\u001b;j_:$v\u000eU;tQN+\b\u000f]8si\u0016$\u0017A\u0007;sC:\u001c\u0018\u000e^5p]R{\u0007+^:i'V\u0004\bo\u001c:uK\u0012\u0004\u0013A\u00023p/>\u00148\u000e\u0006\u0002\u00034A\u0019QM!\u000e\n\u0007\t]BL\u0001\u0003V]&$\u0018aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u00039ygn\u00144gg\u0016$H+[3sK\u0012$\u0002\"a4\u0003B\t\u0015#\u0011\u000b\u0005\b\u0005\u0007Z\u0003\u0019\u0001B\u0003\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u0012,\u0001\u0004\u0011I%\u0001\u0007sKF,Xm\u001d;Fa>\u001c\u0007\u000e\u0005\u0004\u0003L\t5\u0013\u0011W\u0007\u0003\u0003{LAAa\u0014\u0002~\nAq\n\u001d;j_:\fG\u000eC\u0004\u0003T-\u0002\rA!\u0016\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u00119F!\u0017\u000e\u0003\u0001I1Aa\u0017s\u0005%1U\r^2i\t\u0006$\u0018-A\tp]B\u000b'\u000f^5uS>tg)\u001a8dK\u0012$b!a4\u0003b\t\u0015\u0004b\u0002B2Y\u0001\u0007!QA\u0001\u0003iBDqAa\u0012-\u0001\u0004\u0011I%\u0001\riC:$G.\u001a)beRLG/[8o\u000bb\u001cW\r\u001d;j_:$b!a4\u0003l\t5\u0004b\u0002B2[\u0001\u0007!Q\u0001\u0005\b\u0005_j\u0003\u0019\u0001B9\u0003\u0005)\u0007\u0003\u0002B:\u0005{rAA!\u001e\u0003z9\u0019\u0011La\u001e\n\u0003uK1Aa\u001f]\u0003\u001d\u0001\u0018mY6bO\u0016LAAa \u0003\u0002\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005wb\u0016\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005='q\u0011BE\u0011\u001d\u0011\u0019G\fa\u0001\u0005\u000bAqAa#/\u0001\u0004\u0011i)A\u000bpM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u0007I\u0013y)C\u0002\u0003\u0012.\u0013Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-\u0001\rwC2LG-\u0019;f\u001b&\u0014(o\u001c:UeVt7-\u0019;j_:$b!a4\u0003\u0018\ne\u0005b\u0002B2_\u0001\u0007!Q\u0001\u0005\b\u0005\u0017{\u0003\u0019\u0001BG\u0003=*\b\u000fZ1uK\u001a+Go\u00195PM\u001a\u001cX\r^!oI6\u000b\u0017PY3NCJ\\GK];oG\u0006$\u0018n\u001c8D_6\u0004H.\u001a;f)\u0011\u0011\u0019Da(\t\u000f\t\u0005\u0006\u00071\u0001\u0003$\u0006aa-\u001a;dQ>3gm]3ugBA!Q\u0015BT\u0005\u000b\u0011i)\u0004\u0002\u0003\"%!!\u0011\u0016B\u0011\u0005\ri\u0015\r]\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\t=&Q\u0019Bd\u0005\u0017\u0004R!ZA:\u0005c\u0003BAa-\u0003B6\u0011!Q\u0017\u0006\u0005\u0005o\u0013I,A\u0002m_\u001eTAAa/\u0003>\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u0005\u007f\u000b9#A\u0004ti>\u0014\u0018mZ3\n\t\t\r'Q\u0017\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\t\r\u0014\u00071\u0001\u0003\u0006!9!\u0011Z\u0019A\u0002\t5\u0011a\u00034fi\u000eDwJ\u001a4tKRDqAa\u00152\u0001\u0004\u0011)&\u0001\u000fd_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\r\u0016$8\r\u001b*fcV,7\u000f^:\u000215\f\u0017PY3O_RLg-\u001f*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000e\u0006\u0003\u00034\tM\u0007b\u0002Bkg\u0001\u0007!q[\u0001\na\u0006\u0014H/\u001b;j_:\u0004BA!7\u0003`6\u0011!1\u001c\u0006\u0004\u0005;l\u0015aB2mkN$XM]\u0005\u0005\u0005C\u0014YNA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$BAa:\u0003nB1!Q\u0015Bu\u0005\u000bIAAa;\u0003\"\t\u00191+\u001a;\t\u000f\t=H\u00071\u0001\u0003r\u0006\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!!\u0011)Ka*\u0003\u0006\tM\bc\u0001*\u0003v&\u0019!q_&\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X-\u0001\tsK6|g/\u001a)beRLG/[8ogR!!Q`B\u0003!!\u0011)Ka*\u0003\u0006\t}\bc\u0001*\u0004\u0002%\u001911A&\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\r\u001dQ\u00071\u0001\u0003h\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7/A\nsK6|g/Z!mYB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0003~\u0006!s-\u001a;MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N4uN\u001d)p_2l\u0015n\u001a:bi&|g\u000e\u0006\u0003\u0003h\u000eE\u0001bBB\no\u0001\u0007!QB\u0001\u0006]><Xj]\u0001 C\u0012TWo\u001d;MC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N\u0014V-];je\u0016$G\u0003BB\r\u0007\u0007\u0002r!ZB\u000e\u0007?\u0019\t%C\u0002\u0004\u001eq\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BB\u0011\u0007wqAaa\t\u000469!1QEB\u0019\u001d\u0011\u00199ca\f\u000f\t\r%2Q\u0006\b\u00043\u000e-\u0012\"\u0001(\n\u00051k\u0015B\u0001&L\u0013\r\u0019\u0019$S\u0001\u0019\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002BB\u001c\u0007s\ta\"\u00113kkN$X.\u001a8u)f\u0004XMC\u0002\u00044%KAa!\u0010\u0004@\tq\u0011\t\u001a6vgRlWM\u001c;UsB,'\u0002BB\u001c\u0007s\u0001R!ZA:\u0005ODqaa\u00059\u0001\u0004\u0011i!A\u0012qCJ$\u0018\u000e^5p]2\u000bwMR8s)\"\u0014x\u000e\u001e;mK\u0006sG-T5he\u0006$\u0018n\u001c8\u0015\u0011\t51\u0011JB&\u0007\u001bBqAa\u0019:\u0001\u0004\u0011)\u0001C\u0004\u0004\u0014e\u0002\rA!\u0004\t\u000f\r=\u0013\b1\u0001\u0003\u000e\u0005\u0011B.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z't\u0003e\u0019G.Z1s!\u0006\u0014H/\u001b;j_:d\u0015N\\6GC&dWO]3\u0015\r\tM2QKB,\u0011\u001d\u0011\u0019G\u000fa\u0001\u0005\u000bAqA!3;\u0001\u0004\u0011i!\u0001\fva\u0012\fG/\u001a#z]\u0006l\u0017n\u0019$fi\u000eD7+\u001b>f\u0003U)\b\u000fZ1uK\u001a+Go\u00195fe2\u000bwm\u0015;biN$bAa\r\u0004`\r\u0005\u0004b\u0002B2y\u0001\u0007!Q\u0001\u0005\b\u0007Gb\u0004\u0019\u0001B\u0007\u0003\ra\u0017mZ\u0001\u0016kB$\u0017\r^3GKR\u001c\u0007.\u001a:CsR,'+\u0019;f)\u0019\u0011\u0019d!\u001b\u0004l!9!1M\u001fA\u0002\t\u0015\u0001bBB7{\u0001\u0007!QB\u0001\u0006Ef$Xm]\u0001\u0017O\u0016$xJ]\"sK\u0006$X\rV8qS\u000e\u001cVM\\:peRQ11OB=\u0007{\u001ayh!#\u0011\t\u0005\u001d8QO\u0005\u0005\u0007o\nIO\u0001\u0004TK:\u001cxN\u001d\u0005\u0007\u0007wr\u0004\u0019\u0001,\u0002\u000bQ|\u0007/[2\t\u000bUs\u0004\u0019\u0001,\t\u000f\r\u0005e\b1\u0001\u0004\u0004\u0006!1\u000f^1u!\u0011\t9o!\"\n\t\r\u001d\u0015\u0011\u001e\u0002\u000f\u001b\u0016\f7/\u001e:bE2,7\u000b^1u\u0011\u0019\u0019YI\u0010a\u0001-\u0006YA-Z:de&\u0004H/[8o\u0003M)h\u000e\u001d:fM&DX\r\u001a+pa&\u001cg*Y7f)\r16\u0011\u0013\u0005\u0007\u0007wz\u0004\u0019\u0001,\u0002\u0013Q|\u0007/[2UC\u001e\u001cH\u0003BBL\u00073\u0003bA!*\u0003(Z3\u0006BBB>\u0001\u0002\u0007a+\u0001\rhKRlUm]:bO\u0016\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$Baa(\u0004&B!!qABQ\u0013\u0011\u0019\u0019+a\t\u0003\u00155+GO]5d\u001d\u0006lW\r\u0003\u0004\u0004|\u0005\u0003\rAV\u0001\u0018G\u0006d7-\u001e7bi\u0016l\u0015N\u001d:peR{\u0007/[2Sa>$baa+\u00044\u000eU\u0006#B3\u0002t\r5\u0006cA3\u00040&\u00191\u0011\u0017/\u0003\r\u0011{WO\u00197f\u0011\u0019\u0019YH\u0011a\u0001-\"911\r\"A\u0002\t5\u0011aH;qI\u0006$X\rU1si&$\u0018n\u001c8MCN$8)Y;hQR,\u0006\u000fV5nKR1!1GB^\u0007{CqAa\u0019D\u0001\u0004\u0011)\u0001C\u0004\u0004@\u000e\u0003\rA!\u0004\u0002\u001d\r\fWo\u001a5u+B$\u0016.\\3Ng\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s!\tqWiE\u0002F\u0007\u000f\u00042!ZBe\u0013\r\u0019Y\r\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r\r\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007O\u000b\u0003\u0007'TC!!\u001d\u0004V.\u00121q\u001b\t\u0005\u00073\u001c\u0019/\u0004\u0002\u0004\\*!1Q\\Bp\u0003%)hn\u00195fG.,GMC\u0002\u0004br\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019)oa7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class ClusterLinkFetcher
extends ReplicaFetcherThread {
    private final FetcherPool fetcherPool;
    private final KafkaConfig brokerConfig;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final Time time;
    private final Function0<FetchResponseSize> dynamicFetchSize;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Option<String> tenant;
    private final Integer linkFetcherFlowControl;
    private final Integer linkFetcherMaxLaggingPartitions;
    private final Integer linkFetcherLaggingPartitionMs;
    private final boolean useIndependentRetention;
    private final String unprefixedLinkName;
    private final Metrics metrics;
    private final ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs;
    private final Buffer<TopicPartition> partitionsWithNewRecords;
    private final boolean transitionToPushSupported;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$18() {
        return None$.MODULE$;
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer linkFetcherFlowControl() {
        return this.linkFetcherFlowControl;
    }

    private Integer linkFetcherMaxLaggingPartitions() {
        return this.linkFetcherMaxLaggingPartitions;
    }

    private Integer linkFetcherLaggingPartitionMs() {
        return this.linkFetcherLaggingPartitionMs;
    }

    private boolean useIndependentRetention() {
        return this.useIndependentRetention;
    }

    private String unprefixedLinkName() {
        return this.unprefixedLinkName;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ConcurrentHashMap<TopicPartition, Object> partitionLastCaughtUpTimeMs() {
        return this.partitionLastCaughtUpTimeMs;
    }

    public Buffer<TopicPartition> partitionsWithNewRecords() {
        return this.partitionsWithNewRecords;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public void doWork() {
        this.updateDynamicFetchSize();
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString(), this.fetcherManager.onPartitionLinkFailure$default$4());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public boolean handlePartitionException(TopicPartition tp, Throwable e) {
        Option<MirrorFailureType> failure2 = MirrorFailureType$.MODULE$.failureType(e);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Handle mirror partition failure ").append(failure2).append(" for partition ").append(tp).append(" due to exception ").append(e).toString());
        if (failure2.exists((Function1 & Serializable)failure -> BoxesRunTime.boxToBoolean((boolean)this.fetcherManager.onPartitionLinkFailure(tp, failure, e.getMessage(), false)))) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Request metadata update because of errors for partition ").append(tp).toString());
            this.clusterLinkMetadata.requestUpdate();
        }
        return true;
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        if (this.validateMirrorTruncation(tp, offsetTruncationState)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Mirror partition truncation validation completed, proceeding to truncate ").append(tp).append(" to ").append(offsetTruncationState).toString());
            LinkType linkType = this.clusterLinkMetrics.linkType();
            LinkType$Cloud$ linkType$Cloud$ = LinkType$Cloud$.MODULE$;
            if (linkType == null || !linkType.equals(linkType$Cloud$)) {
                Partition partition = this.replicaMgr.getPartitionOrException(tp);
                AbstractLog log = partition.localLogOrException();
                BrokerAuditManagerTrait.submitAuditRequest$(BrokerAuditManager$.MODULE$, new ClusterLinkTruncationRequest(new TopicIdPartition((Uuid)log.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), tp), partition.getLeaderEpoch(), log.highWatermark(), log.logStartOffset(), partition.inSyncReplicaIds(), offsetTruncationState.offset(), ClusterLinkTruncationEvent$TruncationType$.MODULE$.TruncateHWM()));
            }
            return super.truncate(tp, offsetTruncationState);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean validateMirrorTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        boolean bl;
        Object object = new Object();
        try {
            Partition partition = this.replicaMgr.getPartitionOrException(tp);
            AbstractLog log = partition.localLogOrException();
            Option<Object> sourceEpoch = offsetTruncationState.currentLeaderEpoch();
            BooleanRef partitionFailed = BooleanRef.create((boolean)false);
            try {
                if (offsetTruncationState.offset() < log.highWatermark() && log.latestEpoch().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 >= 0)) {
                    Uuid uuid = partition.getLinkedTopicId();
                    Uuid uuid2 = Uuid.ZERO_UUID;
                    if (uuid == null ? uuid2 != null : !uuid.equals(uuid2)) {
                        Uuid topicId;
                        MetadataResponseData.MetadataResponseTopic topicResponse = ((ClusterLinkLeaderEndPoint)super.leader()).fetchTopicMetadata(tp.topic());
                        if (topicResponse == null || topicResponse.errorCode() != Errors.NONE.code()) {
                            throw new StaleMetadataException("Failed to obtain topic id from source leader for validating truncation, will retry after obtaining new metadata.");
                        }
                        Uuid uuid3 = topicId = topicResponse.topicId();
                        Uuid uuid4 = partition.getLinkedTopicId();
                        if (uuid3 == null ? uuid4 != null : !uuid3.equals(uuid4)) {
                            Uuid uuid5 = topicId;
                            Uuid uuid6 = Uuid.ZERO_UUID;
                            if (uuid5 == null ? uuid6 != null : !uuid5.equals(uuid6)) {
                                void failPartition$1_cause;
                                String string = new StringBuilder(66).append("Topic id ").append(topicId).append(" obtained from leader does not match persisted topic id ").append(partition.getLinkedTopicId()).append(".").toString();
                                MirrorFailureType$SourceTopicIdChanged$ failPartition$1_failureType = MirrorFailureType$SourceTopicIdChanged$.MODULE$;
                                String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                                this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                                this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                                this.markPartitionFailed(tp);
                                partitionFailed.elem = true;
                                return false;
                            }
                        }
                    }
                    if (sourceEpoch.exists((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 <= BoxesRunTime.unboxToInt((Object)log.latestEpoch().get()))) {
                        void failPartition$1_cause;
                        String string = new StringBuilder(78).append("Source leader epoch ").append(sourceEpoch).append(" is not greater than latest epoch in the destination log ").append(log.latestEpoch()).append(".").toString();
                        MirrorFailureType$UnexpectedTruncation$ failPartition$1_failureType = MirrorFailureType$UnexpectedTruncation$.MODULE$;
                        String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                        this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                        this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                        this.markPartitionFailed(tp);
                        partitionFailed.elem = true;
                        return false;
                    }
                    if (sourceEpoch.nonEmpty() && log.latestEpoch().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 > 0)) {
                        int prevLogEpoch = BoxesRunTime.unboxToInt((Object)log.latestEpoch().get()) - 1;
                        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition oldEpochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(BoxesRunTime.unboxToInt((Object)sourceEpoch.get())).setLeaderEpoch(prevLogEpoch);
                        Option epochResponse = ((ClusterLinkLeaderEndPoint)super.leader()).fetchEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)oldEpochData)})))).get((Object)tp);
                        if (epochResponse.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcher.$anonfun$validateMirrorTruncation$5(x$4)))) {
                            throw new StaleMetadataException("Failed to obtain epoch end offsets from source leader for validating truncation, will retry after obtaining new metadata.");
                        }
                        epochResponse.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.endOffset())).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)sourceOffsetForPrevEpoch -> {
                            Option<OffsetAndEpoch> destOffsetForPrevEpoch = log.endOffsetForEpoch(prevLogEpoch);
                            if (destOffsetForPrevEpoch.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcher.$anonfun$validateMirrorTruncation$8(sourceOffsetForPrevEpoch, x$6)))) {
                                void failPartition$1_cause;
                                String string = new StringBuilder(253).append("Destination log contains records for previous epoch ").append(prevLogEpoch).append(" up to ").append(destOffsetForPrevEpoch).append(", ").append("but end offset for the same epoch in the source log is ").append(sourceOffsetForPrevEpoch).append(". Source offset for older epochs should not be ").append("greater since new records could not have been appended at older epoch after an epoch bump.").toString();
                                MirrorFailureType$UnexpectedTruncation$ failPartition$1_failureType = MirrorFailureType$UnexpectedTruncation$.MODULE$;
                                String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                                this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                                $this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                                this.markPartitionFailed(tp);
                                partitionFailed$1.elem = true;
                                Object var10_10 = null;
                                string = null;
                                Object var12_11 = null;
                                throw new NonLocalReturnControl.mcZ.sp(object, false);
                            }
                        });
                    }
                    if (!Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkAllowTruncationBelowHWM()) && this.fetcherManager.isCloudToCloudLink()) {
                        void failPartition$1_cause;
                        String string = "Truncation below high watermark is disallowed.";
                        MirrorFailureType$TruncationBelowHighWatermark$ failPartition$1_failureType = MirrorFailureType$TruncationBelowHighWatermark$.MODULE$;
                        String failPartition$1_errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp).append(" due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(". ").append("Destination high watermark is ").append(log.highWatermark()).append(", destination log end offset is ").append(log.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append((String)failPartition$1_cause).toString();
                        this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
                        this.fetcherManager.onPartitionLinkFailure(tp, failPartition$1_failureType, failPartition$1_errorMessage, false);
                        this.markPartitionFailed(tp);
                        partitionFailed.elem = true;
                        return false;
                    }
                }
            }
            catch (RetriableException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(128).append("Failed to validate mirror partition truncation to ").append(offsetTruncationState.offset()).append(" below ").append("destination high watermark ").append(log.highWatermark()).append(", will retry when new metadata is available.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.handlePartitionException(tp, e);
                partitionFailed.elem = true;
            }
            if (partitionFailed.elem) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkFetcher.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, new FetchState(((ClusterLinkLeaderEndPoint)super.leader()).lastFetchTimeMs(), partitionData.highWatermark()));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, tp);
        Optional<Object> sourceLeaderLogStartOffset = !this.useIndependentRetention() ? Optional.of(BoxesRunTime.boxToLong((long)partitionData.logStartOffset())) : Optional.empty();
        Option<LogAppendInfo> appendInfo = this.replicaMgr.appendRecordsToFollowerReplica(tp, fetchOffset, AppendOrigin.CLUSTER_LINK, -1L, Optional.empty(), records, partitionData.highWatermark(), sourceLeaderLogStartOffset, this.quota);
        appendInfo.foreach((Function1 & Serializable)info -> {
            ClusterLinkFetcher.$anonfun$processPartitionData$1(this, tp, info);
            return BoxedUnit.UNIT;
        });
        return appendInfo;
    }

    @Override
    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewRecords().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewRecords().toSeq());
            this.partitionsWithNewRecords().clear();
            return;
        }
    }

    public void maybeNotifyReadyForFetch(Partition partition) {
        if (ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.linkFetcherFlowControl(), false)) {
            this.maybeNotifyReadyForFetch();
            return;
        }
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> addedPartitions = super.addPartitions(initialFetchStates);
        addedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$addPartitions$1(this, p)));
        return addedPartitions;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removePartitions(topicPartitions);
        removedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$removePartitions$1(this, p)));
        return removedPartitions;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removeAllPartitions() {
        Map<TopicPartition, PartitionFetchState> removedPartitions = super.removeAllPartitions();
        removedPartitions.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToLong((long)ClusterLinkFetcher.$anonfun$removeAllPartitions$1(this, p)));
        return removedPartitions;
    }

    public Set<TopicPartition> getLaggingPartitionsForPoolMigration(long nowMs) {
        scala.collection.mutable.Set migratingPartitions = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, lastCaughtUpTimeMs) -> ClusterLinkFetcher.$anonfun$getLaggingPartitionsForPoolMigration$1(this, nowMs, migratingPartitions, topicPartition, BoxesRunTime.unboxToLong((Object)lastCaughtUpTimeMs)));
        return migratingPartitions;
    }

    public Tuple2<Enumeration.Value, Option<Set<TopicPartition>>> adjustLaggingPartitionsRequired(long nowMs) {
        PriorityQueue maxHeap = PriorityQueue$.MODULE$.empty((Ordering)ClusterLinkFetcherThread$MaxPartitionLagOrder$.MODULE$);
        scala.collection.mutable.Set partitionsToThrottle = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        this.partitionLastCaughtUpTimeMs().forEach((topicPartition, lastCaughtUpTimeMs) -> ClusterLinkFetcher.$anonfun$adjustLaggingPartitionsRequired$1(this, nowMs, maxHeap, partitionsToThrottle, topicPartition, BoxesRunTime.unboxToLong((Object)lastCaughtUpTimeMs)));
        if (maxHeap.size() < Predef$.MODULE$.Integer2int(this.linkFetcherMaxLaggingPartitions())) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Increase(), (Object)None$.MODULE$);
        }
        if (partitionsToThrottle.isEmpty()) {
            return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.NoAdjustment(), (Object)None$.MODULE$);
        }
        return new Tuple2((Object)ClusterLinkFetcherThread$AdjustmentType$.MODULE$.Decrease(), (Object)new Some((Object)partitionsToThrottle));
    }

    private long partitionLagForThrottleAndMigration(TopicPartition tp, long nowMs, long lastCaughtUpTimeMs) {
        FetcherLagMetrics lagStats = this.fetcherLagStats().stats().get(tp);
        if (lagStats != null && lagStats.lag() > 0L) {
            if (nowMs - lastCaughtUpTimeMs > (long)Predef$.MODULE$.Integer2int(this.linkFetcherLaggingPartitionMs())) {
                return lagStats.lag();
            }
        } else {
            return this.fetcherManager.laggingPartitionsForTest(tp);
        }
        return 0L;
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString(), true);
    }

    public void updateDynamicFetchSize() {
        FetchResponseSize dynamicSize = (FetchResponseSize)this.dynamicFetchSize.apply();
        ((ClusterLinkLeaderEndPoint)super.leader()).setFetchSize(dynamicSize.perPartitionSize());
        ((ClusterLinkLeaderEndPoint)super.leader()).updateFetchResponseSize(dynamicSize.responseSize());
    }

    @Override
    public void updateFetcherLagStats(TopicPartition tp, long lag) {
        super.updateFetcherLagStats(tp, lag);
        long topicLag = this.fetcherManager.getTopicLag(tp.topic());
        if (topicLag >= 0L) {
            Sensor sensor = this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-lag", (MeasurableStat)new Value(), "Mirror topic lag");
            long nowMs = this.time.milliseconds();
            sensor.record((double)topicLag, nowMs);
            if (topicLag == 0L) {
                this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)nowMs));
            }
        }
        Option<Object> rpoInSeconds = this.calculateMirrorTopicRpo(tp.topic(), lag);
        Sensor rpoSensor = this.getOrCreateTopicSensor(tp.topic(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicRpoMetricName(), (MeasurableStat)new Value(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicRpoMetricDescription());
        rpoInSeconds.foreach((Function1)(JFunction1.mcVD.sp & Serializable)x$1 -> rpoSensor.record(x$1));
    }

    @Override
    public void updateFetcherByteRate(TopicPartition tp, long bytes) {
        super.updateFetcherByteRate(tp, bytes);
        String topic = tp.topic();
        this.getOrCreateTopicSensor(topic, "mirror-topic-byte-total", (MeasurableStat)new CumulativeSum(), "Mirror topic throughput").record((double)bytes);
        this.brokerTopicStats().topicStats(topic).mirrorBytesInRate().mark(bytes);
        this.brokerTopicStats().allTopicsStats().mirrorBytesInRate().mark(bytes);
        FetcherPool fetcherPool = this.fetcherPool;
        FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
        if (fetcherPool == null) {
            return;
        }
        if (fetcherPool.equals(fetcherPool$Default$)) {
            this.fetcherManager.cumulativeDefaultPoolFetchedBytes().addAndGet(bytes);
            return;
        }
    }

    private Sensor getOrCreateTopicSensor(String topic, String name, MeasurableStat stat, String description) {
        String sensorName = new StringBuilder(3).append(name).append("-").append(this.tenant).append("-").append(this.unprefixedLinkName()).append("-").append(this.unprefixedTopicName(topic)).toString();
        Sensor sensor = this.metrics().sensor(sensorName, this.metrics().config(), TimeUnit.MINUTES.toSeconds(5L), new Sensor[0]);
        MetricName metricName = new MetricName(name, "cluster-link-metrics", description, CollectionConverters$.MODULE$.MapHasAsJava(this.topicTags(topic)).asJava());
        if (sensor == null) {
            throw null;
        }
        sensor.add(metricName, stat, null);
        return sensor;
    }

    private String unprefixedTopicName(String topic) {
        return (String)this.tenant.map((Function1 & Serializable)t -> topic.substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> topic);
    }

    private Map<String, String> topicTags(String topic) {
        String unprefixedTopic = this.unprefixedTopicName(topic);
        return ((IterableOnceOps)new .colon.colon((Object)this.tenant.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)unprefixedTopic)), (List)Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private MetricName getMessageRateMetricName(String topic) {
        return new MetricName(ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricName(), "cluster-link-metrics", ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricDescription(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicTags(topic)).asJava());
    }

    public Option<Object> calculateMirrorTopicRpo(String topic, long lag) {
        KafkaMetric mirrorTopicMessageMetric = this.metrics().metric(this.getMessageRateMetricName(topic));
        if (mirrorTopicMessageMetric == null) {
            return None$.MODULE$;
        }
        double mirrorTopicMessageRate = BoxesRunTime.unboxToDouble((Object)mirrorTopicMessageMetric.metricValue());
        if (lag > 0L && mirrorTopicMessageRate == 0.0) {
            return None$.MODULE$;
        }
        if (lag == 0L) {
            return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)lag / mirrorTopicMessageRate)));
    }

    public void updatePartitionLastCaughtUpTime(TopicPartition tp, long caughtUpTimeMs) {
        this.partitionLastCaughtUpTimeMs().put(tp, BoxesRunTime.boxToLong((long)caughtUpTimeMs));
    }

    private final void failPartition$1(MirrorFailureType failureType, String cause, TopicPartition tp$4, OffsetTruncationState offsetTruncationState$2, AbstractLog log$1, BooleanRef partitionFailed$1) {
        String errorMessage = new StringBuilder(181).append("Failing mirror partition ").append(tp$4).append(" due to unexpected truncation to offset ").append(offsetTruncationState$2.offset()).append(". ").append("Destination high watermark is ").append(log$1.highWatermark()).append(", destination log end offset is ").append(log$1.latestEpoch()).append(". ").append("Source topic may have been deleted and recreated. ").append(cause).toString();
        this.error((Function0<String>)(Function0 & Serializable)() -> failPartition$1_errorMessage);
        this.fetcherManager.onPartitionLinkFailure(tp$4, failureType, errorMessage, false);
        this.markPartitionFailed(tp$4);
        partitionFailed$1.elem = true;
    }

    public static final /* synthetic */ boolean $anonfun$validateMirrorTruncation$5(OffsetForLeaderEpochResponseData.EpochEndOffset x$4) {
        return x$4.errorCode() != Errors.NONE.code();
    }

    public static final /* synthetic */ boolean $anonfun$validateMirrorTruncation$8(long sourceOffsetForPrevEpoch$1, OffsetAndEpoch x$6) {
        return x$6.offset() < sourceOffsetForPrevEpoch$1;
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcher $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable)x$7 -> {
                    x$7.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(ClusterLinkFetcher $this, TopicPartition tp$5, LogAppendInfo info) {
        if (info.numMessages() > 0L) {
            $this.partitionsWithNewRecords().$plus$eq((Object)tp$5);
        }
        $this.getOrCreateTopicSensor(tp$5.topic(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricName(), (MeasurableStat)new Rate(), ClusterLinkFetcherThread$.MODULE$.mirrorTopicMessageRateMetricDescription()).record((double)info.numMessages(), $this.time.milliseconds());
    }

    public static final /* synthetic */ long $anonfun$addPartitions$1(ClusterLinkFetcher $this, TopicPartition p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().putIfAbsent(p, BoxesRunTime.boxToLong((long)$this.time.milliseconds())));
    }

    public static final /* synthetic */ long $anonfun$removePartitions$1(ClusterLinkFetcher $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ long $anonfun$removeAllPartitions$1(ClusterLinkFetcher $this, Tuple2 p) {
        return BoxesRunTime.unboxToLong((Object)$this.partitionLastCaughtUpTimeMs().remove(p._1()));
    }

    public static final /* synthetic */ void $anonfun$getLaggingPartitionsForPoolMigration$1(ClusterLinkFetcher $this, long nowMs$1, scala.collection.mutable.Set migratingPartitions$1, TopicPartition topicPartition, long lastCaughtUpTimeMs) {
        if ($this.partitionLagForThrottleAndMigration(topicPartition, nowMs$1, lastCaughtUpTimeMs) > 0L) {
            migratingPartitions$1.$plus$eq((Object)topicPartition);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$adjustLaggingPartitionsRequired$1(ClusterLinkFetcher $this, long nowMs$2, PriorityQueue maxHeap$1, scala.collection.mutable.Set partitionsToThrottle$1, TopicPartition topicPartition, long lastCaughtUpTimeMs) {
        long lag = $this.partitionLagForThrottleAndMigration(topicPartition, nowMs$2, lastCaughtUpTimeMs);
        if (lag > 0L) {
            if (maxHeap$1.size() >= Predef$.MODULE$.Integer2int($this.linkFetcherMaxLaggingPartitions())) {
                long maxPartitionLag = ((ClusterLinkFetcherThread.PartitionAndLag)maxHeap$1.head()).lag();
                if (lag < maxPartitionLag) {
                    partitionsToThrottle$1.$plus$eq((Object)((ClusterLinkFetcherThread.PartitionAndLag)maxHeap$1.dequeue()).partition());
                    maxHeap$1.$plus$eq((Object)new ClusterLinkFetcherThread.PartitionAndLag(topicPartition, lag));
                    return;
                }
                partitionsToThrottle$1.$plus$eq((Object)topicPartition);
                return;
            }
            maxHeap$1.$plus$eq((Object)new ClusterLinkFetcherThread.PartitionAndLag(topicPartition, lag));
            return;
        }
    }

    public ClusterLinkFetcher(String name, int fetcherId, FetcherPool fetcherPool, ClusterLinkLeaderEndPoint leader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, Option<LogContext> logContextOpt, Option<String> tenant) {
        this.fetcherPool = fetcherPool;
        this.brokerConfig = brokerConfig;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.time = time;
        this.dynamicFetchSize = dynamicFetchSize;
        this.clusterLinkClient = clusterLinkClient;
        this.tenant = tenant;
        super(name, fetcherId, leader, brokerConfig, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), (Function0<MetadataVersion>)new Serializable(brokerConfig){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        });
        this.linkFetcherFlowControl = clusterLinkConfig.linkFetcherFlowControl();
        this.linkFetcherMaxLaggingPartitions = clusterLinkConfig.linkFetcherMaxLaggingPartitions();
        this.linkFetcherLaggingPartitionMs = clusterLinkConfig.linkFetcherLaggingPartitionMs();
        this.useIndependentRetention = clusterLinkConfig.useIndependentRetention();
        this.unprefixedLinkName = (String)tenant.map((Function1 & Serializable)t -> $this.clusterLinkMetadata.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable)() -> $this.clusterLinkMetadata.linkName());
        this.metrics = clusterLinkMetrics.metrics();
        this.partitionLastCaughtUpTimeMs = new ConcurrentHashMap();
        this.partitionsWithNewRecords = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.transitionToPushSupported = false;
        this.isOffsetForLeaderEpochSupported = true;
    }
}

