/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClientType$Fetcher$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherWithSharedThread;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.SharedFetcherTag;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\r\u001b\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\u0006C\u0002!\tA\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u0019a\b\u0001)A\u0005]\"9Q\u0010\u0001a\u0001\n\u0013q\b\"CA\u0003\u0001\u0001\u0007I\u0011BA\u0004\u0011\u001d\t\u0019\u0002\u0001Q!\n}D\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0002bBA\u0014\u0001\u0001\u0006K\u0001\u0011\u0005\t\u0003W\u0001A\u0011\u0001\u000e\u0002.!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!a\u001e\u0001\t#\tI\bC\u0004\u0002\u0000\u0001!I!!!\u00039\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rU8pY*\u00111\u0004H\u0001\u0005Y&t7N\u0003\u0002\u001e=\u000511/\u001a:wKJT\u0011aH\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-r\u0012!B;uS2\u001c\u0018BA\u0017+\u0005\u001daunZ4j]\u001e\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"\u0001M\u0019\u000e\u0003qI!A\r\u000f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\tY&t7NT1nKB\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\u0013\u000e\u0003aR!!\u000f\u0011\u0002\rq\u0012xn\u001c;?\u0013\tYD%\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e%\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011\u0011IQ\u0007\u00025%\u00111I\u0007\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017!E2p]:,7\r^5p]6\u000bg.Y4feB\u0011\u0011IR\u0005\u0003\u000fj\u0011Ad\u00117vgR,'\u000fT5oW\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\bCA!K\u0013\tY%D\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018aF:fY\u0016\u001cGo\u001c:NKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z!\t\te*\u0003\u0002P5\t\u00113\t\\;ti\u0016\u0014H*\u001b8l'\u0016dWm\u0019;pe6+GO]5dgJ+w-[:uef\fQ!];pi\u0006\u0004\"\u0001\r*\n\u0005Mc\"aF\"mkN$XM\u001d'j].\u0014V-];fgR\fVo\u001c;b\u0003\u0011!\u0018.\\3\u0011\u0005Y{V\"A,\u000b\u0005-B&BA-[\u0003\u0019\u0019w.\\7p]*\u0011qd\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a/\n!A+[7f\u0003\u0019a\u0014N\\5u}QI1\rZ3gO\"L'n\u001b\t\u0003\u0003\u0002AQAL\u0005A\u0002=BQaM\u0005A\u0002QBQaP\u0005A\u0002\u0001CQ\u0001R\u0005A\u0002\u0015CQ\u0001S\u0005A\u0002%CQ\u0001T\u0005A\u00025CQ\u0001U\u0005A\u0002ECQ\u0001V\u0005A\u0002U\u000b!\u0002\u001e5sK\u0006$\u0007k\\8m+\u0005q\u0007\u0003B8umfl\u0011\u0001\u001d\u0006\u0003cJ\fq!\\;uC\ndWM\u0003\u0002tI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0004(aA'baB\u0011\u0011i^\u0005\u0003qj\u0011\u0001c\u00155be\u0016$g)\u001a;dQ\u0016\u0014H+Y4\u0011\u0005\u0005S\u0018BA>\u001b\u0005y\u0019E.^:uKJd\u0015N\\6TQ\u0006\u0014X\r\u001a$fi\u000eDWM\u001d+ie\u0016\fG-A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0013\u0001C5t\u0003\u000e$\u0018N^3\u0016\u0003}\u00042aIA\u0001\u0013\r\t\u0019\u0001\n\u0002\b\u0005>|G.Z1o\u00031I7/Q2uSZ,w\fJ3r)\u0011\tI!a\u0004\u0011\u0007\r\nY!C\u0002\u0002\u000e\u0011\u0012A!\u00168ji\"A\u0011\u0011C\u0007\u0002\u0002\u0003\u0007q0A\u0002yIE\n\u0011\"[:BGRLg/\u001a\u0011)\u00079\t9\u0002E\u0002$\u00033I1!a\u0007%\u0005!1x\u000e\\1uS2,\u0017!E2mkN$XM\u001d'j].\u001cuN\u001c4jOV\t\u0001)A\u000bdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e|F%Z9\u0015\t\u0005%\u0011Q\u0005\u0005\t\u0003#\u0001\u0012\u0011!a\u0001\u0001\u0006\u00112\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4!Q\r\t\u0012qC\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002\n\u0005=\u00121\u0007\u0005\u0007\u0003c\u0011\u0002\u0019\u0001!\u0002\u00139,woQ8oM&<\u0007bBA\u001b%\u0001\u0007\u0011qG\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fE\u0003\u0002:\u0005mB'D\u0001s\u0013\r\tiD\u001d\u0002\u0004'\u0016$\u0018\u0001D1tg&<g\u000e\u00165sK\u0006$GcB=\u0002D\u00055\u0013q\u000b\u0005\b\u0003\u000b\u001a\u0002\u0019AA$\u0003%1W\r^2iKJLE\rE\u0002$\u0003\u0013J1!a\u0013%\u0005\rIe\u000e\u001e\u0005\b\u0003\u001f\u001a\u0002\u0019AA)\u0003-1W\r^2iKJ\u0004vn\u001c7\u0011\u0007A\n\u0019&C\u0002\u0002Vq\u00111BR3uG\",'\u000fU8pY\"9\u0011\u0011L\nA\u0002\u0005\u001d\u0013AD:pkJ\u001cWM\u0011:pW\u0016\u0014\u0018\nZ\u0001\u000ee\u0016lwN^3GKR\u001c\u0007.\u001a:\u0015\u0011\u0005%\u0011qLA1\u0003WBq!!\u0017\u0015\u0001\u0004\t9\u0005C\u0004\u0002dQ\u0001\r!!\u001a\u0002\u000f\u0019,Go\u00195feB\u0019\u0011)a\u001a\n\u0007\u0005%$D\u0001\u0012DYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014x+\u001b;i'\"\f'/\u001a3UQJ,\u0017\r\u001a\u0005\u0007\u0003[\"\u0002\u0019A=\u0002\rQD'/Z1e\u0003!\u0019\b.\u001e;e_^tGCAA\u0005\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$XCAA$\u0003e\u0019'/Z1uKNC\u0017M]3e\r\u0016$8\r[3s)\"\u0014X-\u00193\u0015\u0007e\fY\b\u0003\u0004\u0002~]\u0001\rA^\u0001\u0011g\"\f'/\u001a3GKR\u001c\u0007.\u001a:UC\u001e\f1c\u0019:fCR,g*\u001a;x_J\\7\t\\5f]R$B!a!\u0002\nB\u0019\u0011)!\"\n\u0007\u0005\u001d%D\u0001\rDYV\u001cH/\u001a:MS:\\g*\u001a;x_J\\7\t\\5f]RDa!! \u0019\u0001\u00041\b")
public class ClusterLinkFetcherThreadPool
implements Logging {
    private final KafkaConfig brokerConfig;
    private final String linkName;
    private final ClusterLinkConnectionManager connectionManager;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool;
    private volatile boolean isActive;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public scala.collection.mutable.Map<SharedFetcherTag, ClusterLinkSharedFetcherThread> threadPool() {
        return this.threadPool;
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Reconfiguring cluster link fetcher thread pool for link ").append($this.linkName).append(" with newConfig ").append((Object)newConfig).append(" updatedKeys ").append(updatedKeys).toString());
        this.clusterLinkConfig_$eq(newConfig);
    }

    public ClusterLinkSharedFetcherThread assignThread(int fetcherId, FetcherPool fetcherPool, int sourceBrokerId) {
        ClusterLinkSharedFetcherThread clusterLinkSharedFetcherThread;
        BooleanRef isNewThread = BooleanRef.create((boolean)false);
        SharedFetcherTag sharedFetcherTag = new SharedFetcherTag(fetcherId, fetcherPool);
        synchronized (this) {
            if (!this.isActive()) {
                throw new IllegalStateException("Cluster link thread pool is no longer active");
            }
            clusterLinkSharedFetcherThread = (ClusterLinkSharedFetcherThread)this.threadPool().getOrElseUpdate((Object)sharedFetcherTag, (Function0 & Serializable)() -> {
                isNewThread$1.elem = true;
                return this.createSharedFetcherThread(sharedFetcherTag);
            });
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Assigned ").append((Object)(isNewThread$1.elem ? "new" : "existing")).append(" shared fetcher thread with tag ").append(sharedFetcherTag).append(" to source broker ").append(sourceBrokerId).toString());
        if (isNewThread.elem) {
            clusterLinkSharedFetcherThread.start();
        }
        return clusterLinkSharedFetcherThread;
    }

    public void removeFetcher(int sourceBrokerId, ClusterLinkFetcherWithSharedThread fetcher, ClusterLinkSharedFetcherThread thread) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Removing fetcher ").append(fetcher).toString());
        thread.removeFetcher(sourceBrokerId, fetcher);
        synchronized (this) {
            boolean bl2;
            if (thread.numFetchers() == 0) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Removing shared fetcher thread with tag ").append(thread.sharedFetcherTag()).append(" for link ").append($this.linkName).toString());
                bl2 = this.threadPool().remove((Object)thread.sharedFetcherTag()).nonEmpty();
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Shutting down shared fetcher thread with tag ").append(thread.sharedFetcherTag()).toString());
            thread.shutdown();
            return;
        }
    }

    public void shutdown() {
        Seq seq;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Shutting down cluster link fetcher thread pool for link ").append($this.linkName).toString());
        synchronized (this) {
            this.isActive_$eq(false);
            seq = this.threadPool().values().toSeq();
        }
        seq.foreach((Function1 & Serializable)thread -> {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.shutdown(), this, Level.WARN);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized int deadThreadCount() {
        return this.threadPool().values().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isThreadFailed()));
    }

    public ClusterLinkSharedFetcherThread createSharedFetcherThread(SharedFetcherTag sharedFetcherTag) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Creating new shared cluster link fetcher thread for link ").append($this.linkName).append(" with id ").append(sharedFetcherTag).toString());
        ClusterLinkNetworkClient clusterLinkClient = this.createNetworkClient(sharedFetcherTag);
        String threadName = new StringBuilder(34).append("ClusterLinkSharedFetcherThread-").append(this.brokerConfig.brokerId()).append("-").append(this.linkName).append("-").append(sharedFetcherTag.fetcherId()).append("-").append(sharedFetcherTag.fetcherPool().name()).toString();
        ClusterLinkSharedFetcherThread thread = new ClusterLinkSharedFetcherThread(threadName, sharedFetcherTag, this.linkName, this, clusterLinkClient, this.quota, this.clusterLinkConfig().replicaFetchBackoff(), this.time);
        this.threadPool().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sharedFetcherTag), (Object)thread));
        return thread;
    }

    private ClusterLinkNetworkClient createNetworkClient(SharedFetcherTag sharedFetcherTag) {
        int fetcherId = sharedFetcherTag.fetcherId();
        FetcherPool fetcherPool = sharedFetcherTag.fetcherPool();
        LogContext logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcherThread brokerId=").append(this.brokerConfig.brokerId()).append(" ").append("fetcherId=").append(fetcherId).append(" fetcherPool=").append(fetcherPool.name()).append("] link=").append(this.linkName).append("] ").toString(), this.connectionManager.maxLogLevel());
        ClusterLinkNetworkClient clusterLinkClient = new ClusterLinkNetworkClient(this.brokerConfig, this.clusterLinkConfig(), ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(this.linkName), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), this.clusterLinkMetrics.metrics(), this.selectorMetricsRegistry, (Map<String, String>)((Map)ClusterLinkFactory$.MODULE$.linkMetricTags(this.linkName).$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-pool"), (Object)fetcherPool.name())})))), this.time, new StringBuilder(20).append("link-").append(this.linkName).append("-fetcher-").append(fetcherId).append("-pool-").append(fetcherPool.name()).toString(), ClusterLinkClientType$Fetcher$.MODULE$, logContext, this.connectionManager.maxLogLevel());
        this.connectionManager.enableClusterLink(clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        return clusterLinkClient;
    }

    public ClusterLinkFetcherThreadPool(KafkaConfig brokerConfig, String linkName, ClusterLinkConfig initialConfig, ClusterLinkConnectionManager connectionManager, ClusterLinkMetrics clusterLinkMetrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkRequestQuota quota, Time time) {
        this.brokerConfig = brokerConfig;
        this.linkName = linkName;
        this.connectionManager = connectionManager;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.quota = quota;
        this.time = time;
        this.threadPool = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.isActive = true;
        this.clusterLinkConfig = initialConfig;
    }
}

