/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AsyncSend;
import kafka.server.BrokerTopicStats;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.FetcherPool;
import kafka.server.KafkaConfig;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$AwaitingFetchResponse$;
import kafka.server.link.ClusterLinkFetcherThread$FetcherShutdown$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeFetch$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTransitionTierStates$;
import kafka.server.link.ClusterLinkFetcherThread$MaybeTruncate$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSharedFetcherThread;
import kafka.server.link.FetchResponseSize;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tuh\u0001\u0002\u001e<\u0001\tC\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00119\u0004!\u0011!Q\u0001\n=D\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\ts\u0002\u0011\t\u0011)A\u0005u\"QQ\u0010\u0001B\u0001B\u0003%a0a\u0001\t\u0015\u0005-\u0001A!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003+A!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u00055\u0002BCA\u001a\u0001\t\u0005\t\u0015!\u0003\u00026!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005%\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002R\u0001\u0011\t\u0011)A\u0005\u0003'B!\"!\u0017\u0001\u0005\u0003\u0005\u000b\u0011BA.\u0011)\t\t\u0007\u0001B\u0001B\u0003%\u00111\r\u0005\u000b\u0003S\u0002!\u0011!Q\u0001\n\u0005-\u0004bCA<\u0001\t\u0015\r\u0011\"\u0011<\u0003sB!\"!!\u0001\u0005\u0003\u0005\u000b\u0011BA>\u0011)\t\u0019\t\u0001B\u0001B\u0003%\u0011Q\u0011\u0005\u000b\u0003\u0017\u0003!\u0011!Q\u0001\n\u00055\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\n\u0003\u0013\u0004!\u0019!C!\u0003\u0017D\u0001\"a5\u0001A\u0003%\u0011Q\u001a\u0005\n\u0003+\u0004!\u0019!C!\u0003/D\u0001\"a8\u0001A\u0003%\u0011\u0011\u001c\u0005\n\u0003C\u0004!\u0019!C!\u0003GD\u0001\"!>\u0001A\u0003%\u0011Q\u001d\u0005\n\u0003o\u0004!\u0019!C\u0005\u0003sD\u0001B!\u0004\u0001A\u0003%\u00111 \u0005\n\u0005\u001f\u0001\u0001\u0019!C\t\u0005#A\u0011B!\u0007\u0001\u0001\u0004%\tBa\u0007\t\u0011\t\u001d\u0002\u0001)Q\u0005\u0005'A\u0011B!\r\u0001\u0001\u0004%\tBa\r\t\u0013\t=\u0003\u00011A\u0005\u0012\tE\u0003\u0002\u0003B+\u0001\u0001\u0006KA!\u000e\t\u000f\te\u0003\u0001\"\u0011\u0003\\!9!Q\f\u0001\u0005R\t}\u0003b\u0002B<\u0001\u0011\u0005#\u0011\u0010\u0005\b\u0005\u007f\u0002A\u0011\u000bB.\u0011\u001d\u0011\t\t\u0001C)\u00057BqAa!\u0001\t#\u0012)\tC\u0004\u0003\u001c\u0002!\tF!(\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"9!q\u001a\u0001\u0005\u0012\tE\u0007b\u0002Bp\u0001\u0011E#1\f\u0005\b\u0005C\u0004A\u0011\u000bBr\u0011\u001d\u0011y\u000f\u0001C!\u0005cDqAa=\u0001\t\u0003\u0012Y\u0006C\u0004\u0003v\u0002!\tFa\u0017\t\u000f\t]\b\u0001\"\u0001\u0003\u0012!9!\u0011 \u0001\u0005B\tm(AI\"mkN$XM\u001d'j].4U\r^2iKJ<\u0016\u000e\u001e5TQ\u0006\u0014X\r\u001a+ie\u0016\fGM\u0003\u0002={\u0005!A.\u001b8l\u0015\tqt(\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0001\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001D!\t!U)D\u0001<\u0013\t15H\u0001\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAA\\1nKV\t\u0011\n\u0005\u0002K':\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0006\u000ba\u0001\u0010:p_Rt$\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{\u0015A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!AU(\u0002\u000b9\fW.\u001a\u0011\u0002\r1Lgn[%e!\tI\u0016-D\u0001[\u0015\tYF,\u0001\u0004d_6lwN\u001c\u0006\u0003\u0001vS!AX0\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0017aA8sO&\u0011!M\u0017\u0002\u0005+VLG-A\u0005gKR\u001c\u0007.\u001a:JIB\u0011QMZ\u0007\u0002\u001f&\u0011qm\u0014\u0002\u0004\u0013:$\u0018a\u00034fi\u000eDWM\u001d)p_2\u0004\"A[6\u000e\u0003uJ!\u0001\\\u001f\u0003\u0017\u0019+Go\u00195feB{w\u000e\\\u0001\tG2LWM\u001c;JI\u0006a1o\\;sG\u0016\u0014%o\\6feB\u0011\u0001o]\u0007\u0002c*\u0011!oP\u0001\bG2,8\u000f^3s\u0013\t!\u0018O\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u0019MD\u0017M]3e)\"\u0014X-\u00193\u0011\u0005\u0011;\u0018B\u0001=<\u0005y\u0019E.^:uKJd\u0015N\\6TQ\u0006\u0014X\r\u001a$fi\u000eDWM\u001d+ie\u0016\fG-A\u0006bgft7mU3oI\u0016\u0014\bC\u00016|\u0013\taXHA\u0005Bgft7mU3oI\u0006Y\u0011m]=oG2+\u0017\rZ3s!\t!u0C\u0002\u0002\u0002m\u0012ad\u00117vgR,'\u000fT5oW\u0006\u001b\u0018P\\2MK\u0006$WM]#oIB{\u0017N\u001c;\n\t\u0005\u0015\u0011qA\u0001\u0007Y\u0016\fG-\u001a:\n\u0007\u0005%QHA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0007)\fy!C\u0002\u0002\u0012u\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0011\u0007\u0011\u000b9\"C\u0002\u0002\u001am\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003M\u0019G.^:uKJd\u0015N\\6NKR\fG-\u0019;b!\r!\u0015qD\u0005\u0004\u0003CY$aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0017A\u00044fi\u000eDWM]'b]\u0006<WM\u001d\t\u0004\t\u0006\u001d\u0012bAA\u0015w\tI2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002k\u0003_I1!!\r>\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\tqCV\u001cX\r\u001a)beRLG/[8ogB\u0019!.a\u000e\n\u0007\u0005eRH\u0001\tQCV\u001cX\r\u001a)beRLG/[8og\u0006\u0011R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"5\u0006)Q\u000f^5mg&!\u0011qIA!\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u0002k\u0003\u001bJ1!a\u0014>\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u00042A[A+\u0013\r\t9&\u0010\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0013G2,8\u000f^3s\u0019&t7.T3ue&\u001c7\u000fE\u0002E\u0003;J1!a\u0018<\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\tQLW.\u001a\t\u0005\u0003\u007f\t)'\u0003\u0003\u0002h\u0005\u0005#\u0001\u0002+j[\u0016\f\u0001\u0003Z=oC6L7MR3uG\"\u001c\u0016N_3\u0011\u000b\u0015\fi'!\u001d\n\u0007\u0005=tJA\u0005Gk:\u001cG/[8oaA\u0019A)a\u001d\n\u0007\u0005U4HA\tGKR\u001c\u0007NU3ta>t7/Z*ju\u0016\f\u0011c\u00197vgR,'\u000fT5oW\u000ec\u0017.\u001a8u+\t\tY\bE\u0002E\u0003{J1!a <\u0005a\u0019E.^:uKJd\u0015N\\6OKR<xN]6DY&,g\u000e^\u0001\u0013G2,8\u000f^3s\u0019&t7n\u00117jK:$\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!a\u0010\u0002\b&!\u0011\u0011RA!\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0007i\u0016t\u0017M\u001c;\u0011\t\u0015\fy)S\u0005\u0004\u0003#{%AB(qi&|g.\u0001\u0004=S:LGO\u0010\u000b3\u0003/\u000bI*a'\u0002\u001e\u0006}\u0015\u0011UAR\u0003K\u000b9+!+\u0002,\u00065\u0016qVAY\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0002HB\u0011A\t\u0001\u0005\u0006\u000fn\u0001\r!\u0013\u0005\u0006/n\u0001\r\u0001\u0017\u0005\u0006Gn\u0001\r\u0001\u001a\u0005\u0006Qn\u0001\r!\u001b\u0005\u0006[n\u0001\r!\u0013\u0005\u0006]n\u0001\ra\u001c\u0005\u0006kn\u0001\rA\u001e\u0005\u0006sn\u0001\rA\u001f\u0005\u0006{n\u0001\rA \u0005\b\u0003\u0017Y\u0002\u0019AA\u0007\u0011\u001d\t\u0019b\u0007a\u0001\u0003+Aq!a\u0007\u001c\u0001\u0004\ti\u0002C\u0004\u0002$m\u0001\r!!\n\t\u000f\u0005-2\u00041\u0001\u0002.!9\u00111G\u000eA\u0002\u0005U\u0002bBA\u001e7\u0001\u0007\u0011Q\b\u0005\b\u0003\u0013Z\u0002\u0019AA&\u0011\u001d\t\tf\u0007a\u0001\u0003'Bq!!\u0017\u001c\u0001\u0004\tY\u0006C\u0004\u0002bm\u0001\r!a\u0019\t\u000f\u0005%4\u00041\u0001\u0002l!9\u0011qO\u000eA\u0002\u0005m\u0004bBAB7\u0001\u0007\u0011Q\u0011\u0005\b\u0003\u0017[\u0002\u0019AAG\u0003U1W\r^2i)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016,\"!!4\u0011\u0007)\fy-C\u0002\u0002Rv\u0012\u0001\u0003V5feN#\u0018\r^3NC\u000eD\u0017N\\3\u0002-\u0019,Go\u00195US\u0016\u00148\u000b^1uK6\u000b7\r[5oK\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0005\u0005e\u0007c\u00016\u0002\\&\u0019\u0011Q\\\u001f\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u0005yA-\u001a3jG\u0006$X\r\u001a+ie\u0016\fG-\u0006\u0002\u0002fB)Q-a$\u0002hB!\u0011\u0011^Ay\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018\u0001B;uS2T!A\u0010/\n\t\u0005M\u00181\u001e\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\teK\u0012L7-\u0019;fIRC'/Z1eA\u0005i1\u000f[;uI><h\u000eT1uG\",\"!a?\u0011\t\u0005u(\u0011B\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055(Q\u0001\u0006\u0003\u0005\u000f\tAA[1wC&!!1BA\u0000\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\fab\u001d5vi\u0012|wO\u001c'bi\u000eD\u0007%A\ttQV$Hm\\<o\u0013:LG/[1uK\u0012,\"Aa\u0005\u0011\u0007\u0015\u0014)\"C\u0002\u0003\u0018=\u0013qAQ8pY\u0016\fg.A\u000btQV$Hm\\<o\u0013:LG/[1uK\u0012|F%Z9\u0015\t\tu!1\u0005\t\u0004K\n}\u0011b\u0001B\u0011\u001f\n!QK\\5u\u0011%\u0011)#JA\u0001\u0002\u0004\u0011\u0019\"A\u0002yIE\n!c\u001d5vi\u0012|wO\\%oSRL\u0017\r^3eA!\u001aaEa\u000b\u0011\u0007\u0015\u0014i#C\u0002\u00030=\u0013\u0001B^8mCRLG.Z\u0001\rM\u0016$8\r[3s'R\fG/Z\u000b\u0003\u0005k\u0001BAa\u000e\u0003J9!!\u0011\bB#\u001d\u0011\u0011YDa\u0011\u000f\t\tu\"\u0011\t\b\u0004\u0019\n}\u0012\"\u0001!\n\u0005yz\u0014B\u0001\u001f>\u0013\r\u00119eO\u0001\u0019\u00072,8\u000f^3s\u0019&t7NR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002\u0002B&\u0005\u001b\u0012ABR3uG\",'o\u0015;bi\u0016T1Aa\u0012<\u0003A1W\r^2iKJ\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0003\u001e\tM\u0003\"\u0003B\u0013Q\u0005\u0005\t\u0019\u0001B\u001b\u000351W\r^2iKJ\u001cF/\u0019;fA!\u001a\u0011Fa\u000b\u0002\r\u0011|wk\u001c:l)\t\u0011i\"A\u0007nCf\u0014W\r\u0016:v]\u000e\fG/\u001a\u000b\u0003\u0005C\u0002bAa\u0019\u0003n\tETB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\u000f5,H/\u00192mK*\u0019!1N(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003p\t\u0015$aC!se\u0006L()\u001e4gKJ\u00042!\u0017B:\u0013\r\u0011)H\u0017\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003e\u0019\u0007.Z2la>Lg\u000e\u001e*fG>4XM]=PM\u001a\u001cX\r^:\u0015\t\tu!1\u0010\u0005\b\u0005{b\u0003\u0019\u0001B1\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\u0018AC7bs\n,g)\u001a;dQ\u0006IR.Y=cKR\u0013\u0018M\\:ji&|g\u000eV5feN#\u0018\r^3t\u0003e!(/\u001e8dCR,Gk\\#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\tu!q\u0011\u0005\b\u0005\u0013{\u0003\u0019\u0001BF\u0003ea\u0017\r^3ti\u0016\u0003xn\u00195t\r>\u0014\b+\u0019:uSRLwN\\:\u0011\u0011\t5%q\u0012B9\u0005'k!A!\u001b\n\t\tE%\u0011\u000e\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002BK\u0005/k\u0011\u0001A\u0005\u0005\u00053\u000b9AA\u0005Fa>\u001c\u0007\u000eR1uC\u0006\u0019\u0002O]8dKN\u001ch)\u001a;dQJ+\u0017/^3tiR1!Q\u0004BP\u0005{CqA!)1\u0001\u0004\u0011\u0019+A\ttKN\u001c\u0018n\u001c8QCJ$\u0018\u000e^5p]N\u0004\u0002B!*\u0003(\nE$\u0011V\u0007\u0003\u0005\u0007IAA!%\u0003\u0004A!!1\u0016B\\\u001d\u0011\u0011iKa-\u000e\u0005\t=&b\u0001BY5\u0006A!/Z9vKN$8/\u0003\u0003\u00036\n=\u0016\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002\u0002B]\u0005w\u0013Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002\u0002B[\u0005_CqAa01\u0001\u0004\u0011\t-\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0003,\n\r\u0017\u0002\u0002Bc\u0005w\u0013qAQ;jY\u0012,'/A\bp]\u0006\u001b\u0018P\\2SKN\u0004xN\\:f)\u0011\u0011iBa3\t\u000f\t5\u0017\u00071\u0001\u0003\u0014\u0005\t\"/Z9vKN$8+^2dKN\u001ch-\u001e7\u0002%U\u0004H-\u0019;f\r\u0016$8\r[3s'R\fG/\u001a\u000b\u0005\u0005'\u0011\u0019\u000eC\u0004\u0003VJ\u0002\rAa6\u0002!M$\u0018\r^3Ue\u0006t7OZ8s[\u0016\u0014\bcB3\u0003Z\nU\"Q\\\u0005\u0004\u00057|%!\u0003$v]\u000e$\u0018n\u001c82!\u0015)\u0017q\u0012B\u001b\u0003%\u0019\u0018n\u001a8bY\u0006cG.\u0001\fxC&$hi\u001c:SK\u0006$\u0017\u0010U1si&$\u0018n\u001c8t)\u0011\u0011iB!:\t\u000f\t\u001dH\u00071\u0001\u0003j\u0006I!-Y2l_\u001a4Wj\u001d\t\u0004K\n-\u0018b\u0001Bw\u001f\n!Aj\u001c8h\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0003\u0014\u0005i\u0011m^1jiNCW\u000f\u001e3po:\f!b\u001c8TQV$Hm\\<o\u0003%I7O\u00117pG.,G-\u0001\u0005u_N#(/\u001b8h)\u0005I\u0005")
public class ClusterLinkFetcherWithSharedThread
extends ClusterLinkFetcherThread {
    private final String name;
    private final int fetcherId;
    private final FetcherPool fetcherPool;
    private final BrokerEndPoint sourceBroker;
    private final ClusterLinkSharedFetcherThread sharedThread;
    private final AsyncSend asyncSender;
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final Time time;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final TierStateMachine fetchTierStateMachine;
    private final BrokerTopicStats brokerTopicStats;
    private final Option<ShutdownableThread> dedicatedThread;
    private final CountDownLatch shutdownLatch;
    private volatile boolean shutdownInitiated;
    private volatile ClusterLinkFetcherThread.FetcherState fetcherState;

    public String name() {
        return this.name;
    }

    @Override
    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    @Override
    public TierStateMachine fetchTierStateMachine() {
        return this.fetchTierStateMachine;
    }

    @Override
    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    @Override
    public Option<ShutdownableThread> dedicatedThread() {
        return this.dedicatedThread;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public boolean shutdownInitiated() {
        return this.shutdownInitiated;
    }

    public void shutdownInitiated_$eq(boolean x$1) {
        this.shutdownInitiated = x$1;
    }

    public ClusterLinkFetcherThread.FetcherState fetcherState() {
        return this.fetcherState;
    }

    public void fetcherState_$eq(ClusterLinkFetcherThread.FetcherState x$1) {
        this.fetcherState = x$1;
    }

    @Override
    public void doWork() {
        this.asyncSender.maybeSendPendingRequest();
        long now = this.time.milliseconds();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions && ((ClusterLinkFetcherThread.AwaitingPartitions)x0$1).deadlineMs() <= now) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        if (this.shutdownInitiated()) {
            if (this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)state -> {
                ClusterLinkFetcherThread.FetcherState fetcherState = state;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState == null || !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$)) {
                    return new Some((Object)ClusterLinkFetcherThread$FetcherShutdown$.MODULE$);
                }
                return None$.MODULE$;
            })) {
                this.onShutdown();
                return;
            }
            return;
        }
        if (!this.isBlocked()) {
            try {
                ClusterLinkFetcherThread.FetcherState fetcherState;
                ClusterLinkFetcherThread.FetcherState fetcherState2 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTruncate$ clusterLinkFetcherThread$MaybeTruncate$ = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
                if (fetcherState2 != null && fetcherState2.equals(clusterLinkFetcherThread$MaybeTruncate$)) {
                    this.maybeTruncate();
                }
                if ((fetcherState = this.fetcherState()) instanceof ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets) {
                    ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets maybeCheckpointRecoveryOffsets = (ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets)fetcherState;
                    this.checkpointRecoveryOffsets(maybeCheckpointRecoveryOffsets.partitions());
                }
                ClusterLinkFetcherThread.FetcherState fetcherState3 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeFetch$ clusterLinkFetcherThread$MaybeFetch$ = ClusterLinkFetcherThread$MaybeFetch$.MODULE$;
                if (fetcherState3 != null && fetcherState3.equals(clusterLinkFetcherThread$MaybeFetch$)) {
                    this.updateDynamicFetchSize();
                    this.maybeFetch();
                }
                ClusterLinkFetcherThread.FetcherState fetcherState4 = this.fetcherState();
                ClusterLinkFetcherThread$MaybeTransitionTierStates$ clusterLinkFetcherThread$MaybeTransitionTierStates$ = ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$;
                if (fetcherState4 != null && fetcherState4.equals(clusterLinkFetcherThread$MaybeTransitionTierStates$)) {
                    this.maybeTransitionTierStates();
                }
                this.completeDelayedFetchRequests();
                return;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in fetcher thread", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$8 -> new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$));
                return;
            }
        }
    }

    @Override
    public ArrayBuffer<TopicPartition> maybeTruncate() {
        ArrayBuffer<TopicPartition> truncatingPartitions = super.maybeTruncate();
        if (this.asyncSender.hasPendingRequest()) {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$9 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse(truncatingPartitions)));
        } else {
            this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$10 -> new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(truncatingPartitions)));
        }
        return ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
        super.checkpointRecoveryOffsets(topicPartitions);
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$11 -> new Some((Object)ClusterLinkFetcherThread$MaybeFetch$.MODULE$));
    }

    @Override
    public void maybeFetch() {
        super.maybeFetch();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return None$.MODULE$;
            }
            if ($this.asyncSender.hasPendingRequest()) {
                return new Some((Object)ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$);
            }
            return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
        });
    }

    @Override
    public void maybeTransitionTierStates() {
        super.maybeTransitionTierStates();
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$12 -> new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$));
    }

    @Override
    public void truncateToEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> latestEpochsForPartitions) {
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetchEpochEndOffsets(latestEpochsForPartitions, (Function1<Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>, BoxedUnit>)(Function1 & Serializable)endOffsets -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$1(this, latestEpochsForPartitions, endOffsets);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$truncateToEpochEndOffsets$2(this, latestEpochsForPartitions, t);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void processFetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchRequest.Builder fetchRequest) {
        ((ClusterLinkAsyncLeaderEndPoint)super.leader()).asyncFetch(fetchRequest, (Function1<Map<TopicPartition, FetchResponseData.PartitionData>, BoxedUnit>)(Function1 & Serializable)responseData -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$1(this, sessionPartitions, responseData);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
            ClusterLinkFetcherWithSharedThread.$anonfun$processFetchRequest$2(this, fetchRequest, t);
            return BoxedUnit.UNIT;
        });
    }

    private void onAsyncResponse(boolean requestSuccessful) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse) {
                ArrayBuffer<TopicPartition> partitions = ((ClusterLinkFetcherThread.AwaitingTruncateOffsetResponse)x0$1).partitions();
                if (requestSuccessful) {
                    return new Some((Object)new ClusterLinkFetcherThread.MaybeCheckpointRecoveryOffsets(partitions));
                }
            }
            if (ClusterLinkFetcherThread$AwaitingFetchResponse$.MODULE$.equals(x0$1) && requestSuccessful) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTransitionTierStates$.MODULE$);
            }
            if (x0$1.isAwaitingResponse()) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            if (!this.shutdownInitiated()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Ignoring unexpected response in state ").append(this.fetcherState()).append(", requestSuccessful=").append(requestSuccessful).toString());
            }
            return None$.MODULE$;
        });
    }

    public boolean updateFetcherState(Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>> stateTransformer) {
        boolean bl;
        this.partitionMapLock().lockInterruptibly();
        try {
            bl = ((Option)stateTransformer.apply((Object)this.fetcherState())).exists((Function1 & Serializable)newState -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherWithSharedThread.$anonfun$updateFetcherState$1(this, newState)));
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return bl;
    }

    @Override
    public void signalAll() {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)state -> {
            if (state instanceof ClusterLinkFetcherThread.AwaitingPartitions) {
                return new Some((Object)ClusterLinkFetcherThread$MaybeTruncate$.MODULE$);
            }
            return None$.MODULE$;
        });
        this.clusterLinkClient().networkClient().wakeup();
        super.signalAll();
    }

    @Override
    public void waitForReadyPartitions(long backoffMs) {
        this.updateFetcherState((Function1<ClusterLinkFetcherThread.FetcherState, Option<ClusterLinkFetcherThread.FetcherState>>)(Function1 & Serializable)x$13 -> new Some((Object)new ClusterLinkFetcherThread.AwaitingPartitions($this.time.milliseconds() + backoffMs)));
    }

    @Override
    public boolean initiateShutdown() {
        this.shutdownInitiated_$eq(true);
        return super.initiateShutdown();
    }

    @Override
    public void awaitShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Awaiting shared fetcher thread shutdown.");
        this.clusterLinkClient().networkClient().wakeup();
        this.shutdownLatch().await();
        this.sharedThread.threadPool().removeFetcher(this.sourceBroker.id(), this, this.sharedThread);
        super.awaitShutdown();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed shared fetcher thread shutdown.");
    }

    @Override
    public void onShutdown() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Shared fetcher thread is shutting down.");
        this.shutdownLatch().countDown();
    }

    public boolean isBlocked() {
        return this.fetcherState().isBlocked();
    }

    public String toString() {
        return new StringBuilder(77).append("ClusterLinkFetcherWithSharedThread(fetcherId=").append(this.fetcherId).append(", sourceBrokerId=").append(this.sourceBroker.id()).append(", fetcherPool=").append(this.fetcherPool.name()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$1(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Map endOffsets) {
        $this.onAsyncResponse(true);
        $this.truncateToEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)latestEpochsForPartitions$1, (Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset>)endOffsets);
    }

    public static final /* synthetic */ void $anonfun$truncateToEpochEndOffsets$2(ClusterLinkFetcherWithSharedThread $this, Map latestEpochsForPartitions$1, Throwable t) {
        $this.onAsyncResponse(false);
        if (t instanceof IOException ? true : t instanceof NetworkException) {
            $this.clusterLinkMetadata.requestUpdate();
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).append(", request for metadata").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Failed to fetch epoch end offsets for ").append(latestEpochsForPartitions$1.keySet()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$1(ClusterLinkFetcherWithSharedThread $this, java.util.Map sessionPartitions$1, Map responseData) {
        $this.onAsyncResponse(true);
        $this.processFetchResponse(sessionPartitions$1, (Map<TopicPartition, FetchResponseData.PartitionData>)responseData);
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$2(ClusterLinkFetcherWithSharedThread $this, FetchRequest.Builder fetchRequest$1, Throwable t) {
        $this.onAsyncResponse(false);
        $this.processFetchFailure(fetchRequest$1, t);
    }

    public static final /* synthetic */ boolean $anonfun$updateFetcherState$1(ClusterLinkFetcherWithSharedThread $this, ClusterLinkFetcherThread.FetcherState newState) {
        block5: {
            block4: {
                if (!$this.shutdownInitiated()) break block4;
                ClusterLinkFetcherThread.FetcherState fetcherState = newState;
                ClusterLinkFetcherThread$FetcherShutdown$ clusterLinkFetcherThread$FetcherShutdown$ = ClusterLinkFetcherThread$FetcherShutdown$.MODULE$;
                if (fetcherState == null || !fetcherState.equals(clusterLinkFetcherThread$FetcherShutdown$)) break block5;
            }
            ClusterLinkFetcherThread.FetcherState fetcherState = newState;
            ClusterLinkFetcherThread.FetcherState fetcherState2 = $this.fetcherState();
            if (fetcherState == null ? fetcherState2 != null : !fetcherState.equals(fetcherState2)) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating fetcher state from old=").append($this.fetcherState()).append(" to new=").append(newState).toString());
                $this.fetcherState_$eq(newState);
                return true;
            }
        }
        return false;
    }

    public ClusterLinkFetcherWithSharedThread(String name, Uuid linkId, int fetcherId, FetcherPool fetcherPool, String clientId, BrokerEndPoint sourceBroker, ClusterLinkSharedFetcherThread sharedThread, AsyncSend asyncSender, ClusterLinkAsyncLeaderEndPoint asyncLeader, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, LogContext logContext, Option<String> tenant) {
        this.name = name;
        this.fetcherId = fetcherId;
        this.fetcherPool = fetcherPool;
        this.sourceBroker = sourceBroker;
        this.sharedThread = sharedThread;
        this.asyncSender = asyncSender;
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.time = time;
        this.clusterLinkClient = clusterLinkClient;
        super(name, fetcherId, fetcherPool, asyncLeader, brokerConfig, clusterLinkConfig, clusterLinkMetadata, fetcherManager, failedPartitions, pausedPartitions, exponentialBackoff, replicaMgr, quota, clusterLinkMetrics, time, dynamicFetchSize, clusterLinkClient, (Option<LogContext>)new Some((Object)logContext), tenant);
        this.fetchTierStateMachine = new ConfluentReplicaFetcherTierStateMachine(this.leader(), replicaMgr, exponentialBackoff);
        this.brokerTopicStats = replicaMgr.brokerTopicStats();
        this.dedicatedThread = None$.MODULE$;
        this.shutdownLatch = new CountDownLatch(1);
        this.shutdownInitiated = false;
        this.fetcherState = ClusterLinkFetcherThread$MaybeTruncate$.MODULE$;
    }
}

