/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierOffsetInfo;
import kafka.server.link.ClusterLinkAsyncLeaderEndPoint;
import kafka.server.link.ClusterLinkAsyncSender;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetchThrottleListener;
import kafka.server.link.ClusterLinkLeaderEndPoint$;
import kafka.server.link.ClusterLinkLeaderRequestBuilder;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t%r!\u0002\u0011\"\u0011\u0003Ac!\u0002\u0016\"\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002*\u0002\t\u0003\u0019\u0006b\u0002B\u0002\u0003\u0011\u0005!Q\u0001\u0004\u0005U\u0005\u0002Q\u000b\u0003\u0005[\r\t\u0005\t\u0015!\u0003\\\u0011!1gA!A!\u0002\u00139\u0007\u0002\u00036\u0007\u0005\u0003\u0005\u000b\u0011B6\t\u001394!Q1A\u0005B\rz\u0007\u0002C>\u0007\u0005\u0003\u0005\u000b\u0011\u00029\t\u0013q4!Q1A\u0005B\rj\b\"CA\u0002\r\t\u0005\t\u0015!\u0003\u007f\u0011)\t)A\u0002B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001b1!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\r\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0004\u0004\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015bA!A!\u0002\u0013\t9\u0003\u0003\u0005C\r\t\u0005\t\u0015!\u0003D\u0011\u0019\u0011d\u0001\"\u0001\u0002.!9\u0011Q\t\u0004\u0005\u0002\u0005\u001d\u0003bBA)\r\u0011\u0005\u0011\u0011\f\u0005\b\u000372A\u0011AA/\u0011\u001d\t\tG\u0002C\u0001\u0003SBq!a\u001b\u0007\t\u0003\ti\u0007C\u0005\u0002t\u0019\u0011\r\u0011\"\u0011\u0002v!9\u0011q\u000f\u0004!\u0002\u00131\u0004bBA=\r\u0011\u0005\u00131\u0010\u0005\b\u0003/3A\u0011IAM\u0011\u001d\tyJ\u0002C!\u0003CCq!a)\u0007\t\u0003\t)+A\rDYV\u001cH/\u001a:MS:\\G*Z1eKJ,e\u000e\u001a)pS:$(B\u0001\u0012$\u0003\u0011a\u0017N\\6\u000b\u0005\u0011*\u0013AB:feZ,'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!K\u0001\u000e\u0003\u0005\u0012\u0011d\u00117vgR,'\u000fT5oW2+\u0017\rZ3s\u000b:$\u0007k\\5oiN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013aG5t%\u0016\fG-\u001f$pe\u001a+Go\u00195G_J\u0004\u0016M\u001d;ji&|g\u000eF\u00037s\u00053\u0005\u000b\u0005\u0002.o%\u0011\u0001H\f\u0002\b\u0005>|G.Z1o\u0011\u0015Q4\u00011\u0001<\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?K\u000591\r\\;ti\u0016\u0014\u0018B\u0001!>\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003C\u0007\u0001\u00071)\u0001\ndYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\bCA\u0015E\u0013\t)\u0015E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\b\"B$\u0004\u0001\u0004A\u0015A\u00067j].4U\r^2iKJ4En\\<D_:$(o\u001c7\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001\u00027b]\u001eT\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n9\u0011J\u001c;fO\u0016\u0014\b\"B)\u0004\u0001\u00041\u0014aD;qI\u0006$X\rT1h'\u0016t7o\u001c:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015+Q\u000b\t.!9\u0002l\u00065\u0018q^Ay\u0003g\fi0a@\u0003\u0002A\u0011\u0011FB\n\u0003\rY\u0003\"a\u0016-\u000e\u0003\rJ!!W\u0012\u0003)I+Wn\u001c;f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0003%awn\u001a)sK\u001aL\u0007\u0010\u0005\u0002]G:\u0011Q,\u0019\t\u0003=:j\u0011a\u0018\u0006\u0003A\u001e\na\u0001\u0010:p_Rt\u0014B\u00012/\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tt\u0013A\u00042m_\u000e\\\u0017N\\4TK:$WM\u001d\t\u0003/\"L!![\u0012\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002#\rdWo\u001d;fe2Kgn[\"mS\u0016tG\u000f\u0005\u0002*Y&\u0011Q.\t\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\u0018a\u00054fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014X#\u00019\u0011\u0005ELX\"\u0001:\u000b\u0005M$\u0018aB2mS\u0016tGo\u001d\u0006\u0003MUT!A^<\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0018aA8sO&\u0011!P\u001d\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u0001\u0015M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0011\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feV\ta\u0010\u0005\u0002*\u007f&\u0019\u0011\u0011A\u0011\u0003?\rcWo\u001d;fe2Kgn\u001b'fC\u0012,'OU3rk\u0016\u001cHOQ;jY\u0012,'/A\bsKF,Xm\u001d;Ck&dG-\u001a:!\u0003%!\bN]8ui2,'\u000fE\u0002X\u0003\u0013I1!a\u0003$\u0005E1u\u000e\u001c7po\u0016\u0014H\u000b\u001b:piRdWM]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0004/\u0006E\u0011bAA\nG\tY1*\u00194lC\u000e{gNZ5h\u0003E\u0019G.^:uKJd\u0015N\\6D_:4\u0017n\u001a\t\u0004S\u0005e\u0011bAA\u000eC\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019q+!\t\n\u0007\u0005\r2E\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0007]\u000bI#C\u0002\u0002,\r\u0012ABU3qY&\u001c\u0017-U;pi\u0006$r\u0003VA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\t\u000bi#\u0002\u0019A.\t\u000b\u0019$\u0002\u0019A4\t\u000b)$\u0002\u0019A6\t\u000b9$\u0002\u0019\u00019\t\u000bq$\u0002\u0019\u0001@\t\u000f\u0005\u0015A\u00031\u0001\u0002\b!9\u0011Q\u0002\u000bA\u0002\u0005=\u0001bBA\u000b)\u0001\u0007\u0011q\u0003\u0005\b\u0003;!\u0002\u0019AA\u0010\u0011\u001d\t)\u0003\u0006a\u0001\u0003OAQA\u0011\u000bA\u0002\r\u000bq#\u001e9eCR,g)\u001a;dQJ+7\u000f]8og\u0016\u001c\u0016N_3\u0015\t\u0005%\u0013q\n\t\u0004[\u0005-\u0013bAA']\t!QK\\5u\u0011\u001d\t\t&\u0006a\u0001\u0003'\n\u0011CZ3uG\"\u0014Vm\u001d9p]N,7+\u001b>f!\ri\u0013QK\u0005\u0004\u0003/r#aA%oiR\t\u0001*A\u000bva\u0012\fG/\u001a'bgR4U\r^2i)&lW-T:\u0015\t\u0005%\u0013q\f\u0005\b\u0003C:\u0002\u0019AA2\u0003=a\u0017m\u001d;GKR\u001c\u0007\u000eV5nK6\u001b\bcA\u0017\u0002f%\u0019\u0011q\r\u0018\u0003\t1{gn\u001a\u000b\u0003\u0003G\nAb]3u\r\u0016$8\r[*ju\u0016$B!!\u0013\u0002p!9\u0011\u0011O\rA\u0002\u0005M\u0013A\u00044fi\u000eD7+\u001b>f\u0005f$Xm]\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e+\u00051\u0014!H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\r\u001a\u0011\u0002=\u0019,Go\u00195US\u0016\u0014X*\u0019;fe&\fG.\u001b>bi&|g\u000eV1sO\u0016$HCBA?\u0003\u0007\u000b\u0019\nE\u0002X\u0003\u007fJ1!!!$\u00059!\u0016.\u001a:PM\u001a\u001cX\r^%oM>Dq!!\"\u001d\u0001\u0004\t9)\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$u\u0003\u0019\u0019w.\\7p]&!\u0011\u0011SAF\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!&\u001d\u0001\u0004\t\u0019&A\u0006mK\u0006$WM]#q_\u000eD\u0017aD5t%\u0016\fG-\u001f$pe\u001a+Go\u00195\u0015\u0007Y\nY\nC\u0004\u0002\u001ev\u0001\r!a\"\u0002\u0005Q\u0004\u0018!B2m_N,GCAA%\u0003I1W\r^2i)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\t\u0005\u001d\u0016Q\u001a\t\u0005\u0003S\u000b9M\u0004\u0003\u0002,\u0006\u0005g\u0002BAW\u0003{sA!a,\u0002<:!\u0011\u0011WA]\u001d\u0011\t\u0019,a.\u000f\u0007y\u000b),C\u0001y\u0013\t1x/\u0003\u0002'k&\u0019\u0011Q\u0012;\n\t\u0005}\u00161R\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\u0019-!2\u0002)5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,G)\u0019;b\u0015\u0011\ty,a#\n\t\u0005%\u00171\u001a\u0002\u0016\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$v\u000e]5d\u0015\u0011\t\u0019-!2\t\r\u0005=w\u00041\u0001\\\u0003\u0015!x\u000e]5d\u0011\u001d\t\u0019\u000e\u0002a\u0001\u0003+\f!\u0002\\8h\u0007>tG/\u001a=u!\u0011\t9.!8\u000e\u0005\u0005e'\u0002BAn\u0003\u0017\u000bQ!\u001e;jYNLA!a8\u0002Z\nQAj\\4D_:$X\r\u001f;\t\u000f\u0005\rH\u00011\u0001\u0002f\u0006!A/[7f!\u0011\t9.a:\n\t\u0005%\u0018\u0011\u001c\u0002\u0005)&lW\rC\u0003g\t\u0001\u0007q\rC\u0003k\t\u0001\u00071\u000eC\u0004\u0002\u000e\u0011\u0001\r!a\u0004\t\u000f\u0005UA\u00011\u0001\u0002\u0018!9\u0011Q\u001f\u0003A\u0002\u0005]\u0018!\u00064fi\u000eDG\u000b\u001b:piRdW\rT5ti\u0016tWM\u001d\t\u0004S\u0005e\u0018bAA~C\t\u00013\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r\u001b+ie>$H\u000f\\3MSN$XM\\3s\u0011\u001d\ti\u0002\u0002a\u0001\u0003?Aq!!\n\u0005\u0001\u0004\t9\u0003C\u0003C\t\u0001\u00071)A\rde\u0016\fG/Z!ts:\u001cG*Z1eKJ,e\u000e\u001a9pS:$HC\u0006B\u0004\u0005\u001b\u0011yA!\u0005\u0003\u001c\tu!q\u0004B\u0011\u0005G\u0011)Ca\n\u0011\u0007%\u0012I!C\u0002\u0003\f\u0005\u0012ad\u00117vgR,'\u000fT5oW\u0006\u001b\u0018P\\2MK\u0006$WM]#oIB{\u0017N\u001c;\t\u000f\u0005MW\u00011\u0001\u0002V\"9\u00111]\u0003A\u0002\u0005\u0015\bb\u0002B\n\u000b\u0001\u0007!QC\u0001\fCNLhnY*f]\u0012,'\u000fE\u0002*\u0005/I1A!\u0007\"\u0005Y\u0019E.^:uKJd\u0015N\\6Bgft7mU3oI\u0016\u0014\b\"\u00026\u0006\u0001\u0004Y\u0007bBA\u0007\u000b\u0001\u0007\u0011q\u0002\u0005\b\u0003+)\u0001\u0019AA\f\u0011\u001d\t)0\u0002a\u0001\u0003oDq!!\b\u0006\u0001\u0004\ty\u0002C\u0004\u0002&\u0015\u0001\r!a\n\t\u000b\t+\u0001\u0019A\"")
public class ClusterLinkLeaderEndPoint
extends RemoteLeaderEndPoint {
    private final BlockingSend blockingSender;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final FetchSessionHandler fetchSessionHandler;
    private final ClusterLinkLeaderRequestBuilder requestBuilder;
    private final ClusterLinkConfig clusterLinkConfig;
    private final ReplicaManager replicaManager;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final boolean isTruncationOnFetchSupported;

    public static ClusterLinkAsyncLeaderEndPoint createAsyncLeaderEndpoint(LogContext logContext, Time time, ClusterLinkAsyncSender asyncSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkFetchThrottleListener fetchThrottleListener, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        return ClusterLinkLeaderEndPoint$.MODULE$.createAsyncLeaderEndpoint(logContext, time, asyncSender, clusterLinkClient, brokerConfig, clusterLinkConfig, fetchThrottleListener, replicaManager, quota, clusterLinkMetrics);
    }

    public static ClusterLinkLeaderEndPoint apply(LogContext logContext, Time time, BlockingSend blockingSender, ClusterLinkNetworkClient clusterLinkClient, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkFetchThrottleListener fetchThrottleListener, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        return ClusterLinkLeaderEndPoint$.MODULE$.apply(logContext, time, blockingSender, clusterLinkClient, brokerConfig, clusterLinkConfig, fetchThrottleListener, replicaManager, quota, clusterLinkMetrics);
    }

    public static boolean isReadyForFetchForPartition(Partition partition, ClusterLinkMetrics clusterLinkMetrics, Integer linkFetcherFlowControl, boolean updateLagSensor) {
        return ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, clusterLinkMetrics, linkFetcherFlowControl, updateLagSensor);
    }

    @Override
    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public ClusterLinkLeaderRequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public void updateFetchResponseSize(int fetchResponseSize) {
        this.requestBuilder().fetchResponseSize_$eq(Predef$.MODULE$.int2Integer(fetchResponseSize));
    }

    public Integer fetchResponseSize() {
        return this.requestBuilder().fetchResponseSize();
    }

    public void updateLastFetchTimeMs(long lastFetchTimeMs) {
        this.requestBuilder().lastFetchTimeMs_$eq(lastFetchTimeMs);
    }

    public long lastFetchTimeMs() {
        return this.requestBuilder().lastFetchTimeMs();
    }

    public void setFetchSize(int fetchSizeBytes) {
        this.fetchSize_$eq(Predef$.MODULE$.int2Integer(fetchSizeBytes));
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int leaderEpoch) {
        throw new UnsupportedOperationException("Cluster link leader endpoint does not support tiered partitions");
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return this.replicaManager.onlinePartition(tp).exists((Function1 & Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkLeaderEndPoint$.MODULE$.isReadyForFetchForPartition(partition, this.clusterLinkMetrics, this.clusterLinkConfig.linkFetcherFlowControl(), true)));
    }

    @Override
    public void close() {
        super.close();
        this.clusterLinkClient.removeMetrics();
    }

    public MetadataResponseData.MetadataResponseTopic fetchTopicMetadata(String topic) {
        MetadataRequest.Builder metadataRequest = this.requestBuilder().buildMetadataRequest(topic);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Sending metadata request for topic ").append(topic).append(": ").append(metadataRequest).toString());
        ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)metadataRequest);
        MetadataResponse responseBody = (MetadataResponse)response.responseBody();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Received metadata response ").append(response).toString());
        return responseBody.data().topics().find(topic);
    }

    public ClusterLinkLeaderEndPoint(String logPrefix, BlockingSend blockingSender, ClusterLinkNetworkClient clusterLinkClient, FetchSessionHandler fetchSessionHandler, ClusterLinkLeaderRequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ReplicaManager replicaManager, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics) {
        this.blockingSender = blockingSender;
        this.clusterLinkClient = clusterLinkClient;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.clusterLinkConfig = clusterLinkConfig;
        this.replicaManager = replicaManager;
        this.clusterLinkMetrics = clusterLinkMetrics;
        Serializable x$9 = new Serializable(brokerConfig){
            private static final long serialVersionUID = 0L;
            private final KafkaConfig brokerConfig$1;

            public final MetadataVersion apply() {
                return this.brokerConfig$1.interBrokerProtocolVersion();
            }
            {
                this.brokerConfig$1 = brokerConfig$1;
            }
        };
        super(logPrefix, blockingSender, fetchSessionHandler, requestBuilder, throttler, brokerConfig, replicaManager, quota, (Function0<MetadataVersion>)x$9);
        this.isTruncationOnFetchSupported = false;
    }
}

