/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rg\u0001B\u0015+\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Iq\b\u0001B\u0001B\u0003%\u0001I\u0012\u0005\n\u000f\u0002\u0011\t\u0011)A\u0005\u0011JC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tE\u0002\u0011\t\u0011)A\u0005G\")\u0011\u000e\u0001C\u0001U\")!\u000f\u0001C!g\"9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\n\u0001\u0011%\u0011Q\u0007\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\ty\u0005\u0001C!\u0003#Bq!a\u0014\u0001\t\u0003\n)\u0006C\u0004\u0002P\u0001!\t%!\u0017\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u00111\f\u0001\u0005B\u0005\u0005\u0004bBA.\u0001\u0011\u0005\u0013\u0011\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0011\u0001\u0005\u0002\u0005m\u0005bBAQ\u0001\u0011\u0005\u00131\u0015\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!a5\u0001\t\u0003\n)\u000eC\u0004\u0002d\u0002!\t%!:\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u0011Q\u001f\u0001\u0005B\u0005]\b\"\u0003B\f\u0001E\u0005I\u0011\u0001B\r\u0011%\u0011y\u0003AI\u0001\n\u0003\u0011I\u0002C\u0005\u00032\u0001\t\n\u0011\"\u0001\u00034!I!q\u0007\u0001\u0012\u0002\u0013\u0005!\u0011\b\u0005\b\u0005{\u0001A\u0011\tB \u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003 \u0002!\tE!)\t\u000f\tU\u0006\u0001\"\u0011\u00038\"i!\u0011\u0018\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003<\u001a\u0013!f\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ<\u0016\u000e\u001e5L%\u00064GoU;qa>\u0014HO\u0003\u0002,Y\u0005!A.\u001b8l\u0015\tic&\u0001\u0004tKJ4XM\u001d\u0006\u0002_\u0005)1.\u00194lC\u000e\u00011C\u0001\u00013!\t\u0019D'D\u0001+\u0013\t)$F\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u00029s5\tA&\u0003\u0002;Y\tY1*\u00194lC\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u00024{%\u0011aH\u000b\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\t\tE)D\u0001C\u0015\t\u0019E&\u0001\u0005nKR\fG-\u0019;b\u0013\t)%I\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017BA 5\u0003a\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003[-S!a\f'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#*\u0013aDT8eKR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\n\u0005\u001d#\u0014!\u00057pG\u0006d\u0017\tZ7j]\u001a\u000b7\r^8ssB\u0019Q\u000b\u0017.\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016!B1e[&t'BA0L\u0003\u001d\u0019G.[3oiNL!!\u0019/\u0003\u000b\u0005#W.\u001b8\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0002eO6\tQM\u0003\u0002g\u0015\u0006Q\u0011-\u001e;i_JL'0\u001a:\n\u0005!,'\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.\u0001\u0004=S:LGO\u0010\u000b\bW2lgn\u001c9r!\t\u0019\u0004\u0001C\u00037\u000f\u0001\u0007q\u0007C\u0003<\u000f\u0001\u0007A\bC\u0003@\u000f\u0001\u0007\u0001\tC\u0003H\u000f\u0001\u0007\u0001\nC\u0003T\u000f\u0001\u0007A\u000bC\u0003c\u000f\u0001\u00071-A\u0006nSJ\u0014xN\u001d+pa&\u001cGC\u0001;}!\r)Vo^\u0005\u0003mZ\u0013aa\u00149uS>t\u0007C\u0001={\u001b\u0005I(BA\"L\u0013\tY\u0018PA\u0006NSJ\u0014xN\u001d+pa&\u001c\u0007\"B?\t\u0001\u0004q\u0018!\u0002;pa&\u001c\u0007cA@\u0002\u000e9!\u0011\u0011AA\u0005!\r\t\u0019AV\u0007\u0003\u0003\u000bQ1!a\u00021\u0003\u0019a$o\\8u}%\u0019\u00111\u0002,\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tYAV\u0001\u0012[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001cH\u0003BA\f\u0003S\u0001r!!\u0007\u0002 y\f\u0019#\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004,\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005m!aA'baB\u00191'!\n\n\u0007\u0005\u001d\"FA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\t\u000f\u0005-\u0012\u00021\u0001\u0002.\u0005IAo\u001c9jGN|\u0005\u000f\u001e\t\u0005+V\fy\u0003\u0005\u0003\u0000\u0003cq\u0018\u0002BA\u001a\u0003#\u00111aU3u)\u0011\t9\"a\u000e\t\u000f\u0005e\"\u00021\u0001\u0002<\u00051A.\u001b8l\u0013\u0012\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003Z\u0015AB2p[6|g.\u0003\u0003\u0002F\u0005}\"\u0001B+vS\u0012\f!%\\5se>\u0014Hk\u001c9jGN#\u0018\r^3t\rJ|W.T3uC\u0012\fG/Y*u_J,G\u0003BA\f\u0003\u0017Bq!!\u0014\f\u0001\u0004\ty#\u0001\u0004u_BL7m]\u0001#[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0015\t\u0005]\u00111\u000b\u0005\b\u0003sa\u0001\u0019AA\u001e)\u0011\t9\"a\u0016\t\u000f\u00055S\u00021\u0001\u00020Q\u0011\u0011qC\u0001'[&\u0014(o\u001c:U_BL7m\u0015;bi\u0016\u001chI]8n\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$H\u0003BA\f\u0003?Bq!!\u000f\u0010\u0001\u0004\tY\u0004\u0006\u0003\u0002\u0018\u0005\r\u0004bBA'!\u0001\u0007\u0011qF\u0001\u0016O\u0016$\u0018\t\u001c7U_BL7m]%o\u00072,8\u000f^3s)\t\ty#\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002n\u0005M\u0004cA+\u0002p%\u0019\u0011\u0011\u000f,\u0003\u000f\t{w\u000e\\3b]\")Qp\u0005a\u0001}\u00069RM\\:ve\u0016\u001cE.^:uKJd\u0015N\\6Fq&\u001cHo\u001d\u000b\u0005\u0003s\ny\bE\u0002V\u0003wJ1!! W\u0005\u0011)f.\u001b;\t\u000f\u0005eB\u00031\u0001\u0002<\u0005\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\t\u00055\u0014Q\u0011\u0005\b\u0003s)\u0002\u0019AA\u001e\u0003I9W\r^\"mkN$XM\u001d'j].$\u0015\r^1\u0015\t\u0005-\u0015\u0011\u0014\t\u0005+V\fi\t\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019JL\u0001\u0003u.LA!a&\u0002\u0012\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018\rC\u0004\u0002:Y\u0001\r!a\u000f\u0015\t\u0005-\u0015Q\u0014\u0005\u0007\u0003?;\u0002\u0019\u0001@\u0002\u00111Lgn\u001b(b[\u0016\f\u0011dZ3u\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0007K]8qgR!\u0011QUA[!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bA!\u001e;jY*\u0011\u0011qV\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0006%&A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\b\rA\u0002\u0005m\u0012AD4fiR{\u0007/[2D_:4\u0017n\u001a\u000b\u0005\u0003K\u000bY\fC\u0003~3\u0001\u0007a0A\u000ebYR,'o\u00117vgR,'\u000fT5oW\u000e{gNZ5h5:{G-\u001a\u000b\u000b\u0003s\n\t-a1\u0002F\u0006%\u0007bBA\u001d5\u0001\u0007\u00111\b\u0005\u0007\u0003?S\u0002\u0019\u0001@\t\u000f\u0005\u001d'\u00041\u0001\u0002&\u0006y\u0001/\u001a:tSN$XM\u001c;Qe>\u00048\u000fC\u0004\u0002Lj\u0001\r!!4\u0002\u00151Lgn[\"p]\u001aLw\rE\u00024\u0003\u001fL1!!5+\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001![\u0006L(-\u001a*fK:\u001c'/\u001f9u\u00072,8\u000f^3s\u0019&t7nQ8oM&<7\u000f\u0006\u0003\u0002z\u0005]\u0007bBAm7\u0001\u0007\u00111\\\u0001\u0012G>tg-[4Ue\u0006t7OZ8s[\u0016\u0014\bcB+\u0002^\u0006\u0015\u0016\u0011]\u0005\u0004\u0003?4&!\u0003$v]\u000e$\u0018n\u001c82!\u0011)V/!*\u0002-\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$b!!\u001f\u0002h\u0006-\bbBAu9\u0001\u0007\u0011QR\u0001\u0010G2,8\u000f^3s\u0019&t7\u000eR1uC\"9\u0011Q\u001e\u000fA\u0002\u0005\u0015\u0016!\u00029s_B\u001c\u0018aE:fi\u000ecWo\u001d;fe2Kgn\u001b.O_\u0012,G\u0003BA=\u0003gDq!!;\u001e\u0001\u0004\ti)A\u000bbYR,'/T5se>\u0014Hk\u001c9jGN#\u0018\r^3\u0015!\u0005e\u0014\u0011`A~\u0005\u0007\u00119Aa\u0003\u0003\u0010\tM\u0001\"B?\u001f\u0001\u0004q\bbBA\u007f=\u0001\u0007\u0011q`\u0001\rgR\fG/Z+qI\u0006$XM\u001d\t\b+\u0006u\u00171\u0005B\u0001!\u0011)V/a\t\t\u000f\t\u0015a\u00041\u0001\u0002n\u0005aa/\u00197jI\u0006$Xm\u00148ms\"I!\u0011\u0002\u0010\u0011\u0002\u0003\u0007\u0011QN\u0001\u0010M\u0006LG.\u00134O_Rl\u0015N\u001d:pe\"I!Q\u0002\u0010\u0011\u0002\u0003\u0007\u0011QN\u0001\u0019SN\u001cuN\u001c<feR$v\u000eU3oI&tw-T5se>\u0014\b\u0002\u0003B\t=A\u0005\t\u0019\u0001@\u0002\u001fM|WO]2f)>\u0004\u0018n\u0019(b[\u0016D\u0011B!\u0006\u001f!\u0003\u0005\r!a\u000f\u0002)\u0015D\b/Z2uK\u0012dunY1m)>\u0004\u0018nY%e\u0003}\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u00057QC!!\u001c\u0003\u001e-\u0012!q\u0004\t\u0005\u0005C\u0011Y#\u0004\u0002\u0003$)!!Q\u0005B\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0003*Y\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iCa\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0010bYR,'/T5se>\u0014Hk\u001c9jGN#\u0018\r^3%I\u00164\u0017-\u001e7uIU\nq$\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011)DK\u0002\u007f\u0005;\tq$\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011YD\u000b\u0003\u0002<\tu\u0011A\u00063fY\u0016$Xm\u00117vgR,'\u000fT5oWjsu\u000eZ3\u0015\t\u0005e$\u0011\t\u0005\b\u0003s\u0019\u0003\u0019AA\u001e\u0003A\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0006\u0003H\te#1\fB0\u0005C\u0002b!!\u0010\u0003J\t5\u0013\u0002\u0002B&\u0003\u007f\u00111bS1gW\u00064U\u000f^;sKB!!q\nB+\u001b\t\u0011\tF\u0003\u0003\u0003T\u00055\u0016\u0001\u00027b]\u001eLAAa\u0016\u0003R\t!ak\\5e\u0011\u0015iH\u00051\u0001\u007f\u0011\u001d\u0011i\u0006\na\u0001\u0003G\t\u0001#\\5se>\u0014Hk\u001c9jGN#\u0018\r^3\t\r\tEA\u00051\u0001\u007f\u0011\u001d\u0011)\u0002\na\u0001\u0003w\t1d]3oI\u0006cG/\u001a:NSJ\u0014xN\u001d+pa&\u001c'+Z9vKN$HCBA=\u0005O\u0012y\tC\u0004\u0003D\u0015\u0002\rA!\u001b\u0011\t\t-$\u0011\u0012\b\u0005\u0005[\u0012\u0019I\u0004\u0003\u0003p\t}d\u0002\u0002B9\u0005{rAAa\u001d\u0003|9!!Q\u000fB=\u001d\u0011\t\u0019Aa\u001e\n\u0003=K!!\u0014(\n\u0005=b\u0015bAA!\u0017&!!\u0011QA \u0003\u001diWm]:bO\u0016LAA!\"\u0003\b\u0006a\u0012\t\u001c;fe6K'O]8s)>\u0004\u0018nY:SKF,Xm\u001d;ECR\f'\u0002\u0002BA\u0003\u007fIAAa#\u0003\u000e\n\u0001\u0012\t\u001c;fe6K'O]8s)>\u0004\u0018n\u0019\u0006\u0005\u0005\u000b\u00139\tC\u0004\u0003\u0012\u0016\u0002\rAa%\u0002\rI,7/\u001e7u!\u0019\u0011)Ja'\u0003N5\u0011!q\u0013\u0006\u0005\u00053\u000by$A\u0005j]R,'O\\1mg&!!Q\u0014BL\u0005=Y\u0015MZ6b\rV$XO]3J[Bd\u0017aF4fi\u0006cG\u000eT5oWN4%o\\7NKR\fG-\u0019;b)\t\u0011\u0019\u000b\u0005\u0004\u0003&\n=\u0016Q\u0012\b\u0005\u0005O\u0013YK\u0004\u0003\u0002\u0004\t%\u0016\"A,\n\u0007\t5f+A\u0004qC\u000e\\\u0017mZ3\n\t\tE&1\u0017\u0002\u0004'\u0016\f(b\u0001BW-\u0006A\u0012n\u001d'j].\u001cun\u001c:eS:\fGo\u001c:F]\u0006\u0014G.\u001a3\u0016\u0005\u00055\u0014aE:va\u0016\u0014H%\\3uC\u0012\fG/Y\"bG\",WC\u0001B_!\rA$qX\u0005\u0004\u0005\u0003d#!D'fi\u0006$\u0017\r^1DC\u000eDW\r")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        if (topicsOpt instanceof Some) {
            set = (Set)((Set)((Some)topicsOpt).value()).map((Function1 & Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic()))));
        } else if (None$.MODULE$.equals(topicsOpt)) {
            set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)image.topics().topicsByName()).asScala().values().map((Function1 & Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic())))).toSet();
        } else {
            throw new MatchError(topicsOpt);
        }
        return ((IterableOnceOps)((IterableOps)set.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        ImmutableMap mirrorTopics = ((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByLinkId(linkId);
        return ((MapOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)mirrorTopics).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1 & Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2((Object)((TopicImage)entry._2()).name(), (Object)state);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return CollectionConverters$.MODULE$.SetHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala().toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, String linkName, Properties persistentProps, ClusterLinkConfig linkConfig) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Uuid linkId = (Uuid)x0$1._1();
                ClusterLink clusterLink = (ClusterLink)x0$1._2();
                ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
                Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
                if (newEncodedProps instanceof Some) {
                    Properties props = (Properties)((Some)newEncodedProps).value();
                    HashSet newConfigs = new HashSet();
                    CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                    ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                    return alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                }
                if (None$.MODULE$.equals(newEncodedProps)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)newEncodedProps);
            }
            throw new MatchError(null);
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.destAdmin() == null) {
                this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.destAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
            return;
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror, boolean isConvertToPendingMirror, String sourceTopicName, Uuid expectedLocalTopicId) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (currentState.isEmpty() && failIfNotMirror && !isConvertToPendingMirror) {
            throw new InvalidRequestException(new StringBuilder(28).append("Topic ").append(topic).append(" is not a mirror topic").toString());
        }
        if (currentState.isEmpty() && isConvertToPendingMirror && !validateOnly) {
            ((Option)stateUpdater.apply(null)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
                if (!validateOnly) {
                    try {
                        return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            });
        }
        currentState.foreach((Function1 & Serializable)state -> {
            this.applyState$1(state, stateUpdater, validateOnly, topic, sourceTopicName, expectedLocalTopicId);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState, String sourceTopicName, Uuid expectedLocalTopicId) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        if (mirrorTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)stoppedMirror.logEndOffsets().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1))).asJava());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingMirror) {
            ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_MIRROR.stateName()).setLinkId(pendingMirror.linkId()).setSourceTopicId(pendingMirror.sourceTopicId()).setSourceTopicName(sourceTopicName).setExpectedLocalTopicId(expectedLocalTopicId).setNextState(pendingMirror.nextState());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
            ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirror = (ClusterLinkTopicState.PendingSynchronizeMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_SYNCHRONIZE.stateName()).setNextState(pendingSynchronizeMirror.remoteMirrorNextState().name());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingRepairMirror) {
            ClusterLinkTopicState.PendingRepairMirror pendingRepairMirror = (ClusterLinkTopicState.PendingRepairMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_REPAIR.stateName()).setMirrorTopicError(pendingRepairMirror.mirrorTopicError().code());
        } else {
            throw new MatchError((Object)mirrorTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1 & Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$2(BoxesRunTime.unboxToLong((Object)x)))).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    @Override
    public boolean alterMirrorTopicState$default$5() {
        return false;
    }

    @Override
    public String alterMirrorTopicState$default$6() {
        return "";
    }

    @Override
    public Uuid alterMirrorTopicState$default$7() {
        return Uuid.ZERO_UUID;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("Received response for alterMirrorTopicRequest"));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent("alterMirrorTopic request failed with exception"), ex);
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder)builder, (ControllerRequestCompletionHandler)requestHandler);
    }

    @Override
    public scala.collection.immutable.Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala().values().map((Function1 & Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false))).toSeq();
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    private final void applyState$1(ClusterLinkTopicState state, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, String sourceTopicName$1, Uuid expectedLocalTopicId$1) {
        ((Option)stateUpdater$1.apply((Object)state)).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable)newState -> {
            if (!validateOnly) {
                try {
                    return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState, sourceTopicName, expectedLocalTopicId).get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$2(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, NodeToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

