/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClientType$OutboundConnectionAdmin$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSelectorMetricsRegistry;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.LazyResource;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001B!C\u0001%C\u0011\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!W0\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0011\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a:\t\u0011M\u0004!\u0011!Q\u0001\nQD!\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0003\u0005\u000b\u0003/\u0001!\u0011!Q\u0001\n\u0005e\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013B!\"a\u0014\u0001\u0005\u0003\u0005\u000b\u0011BA)\u0011)\t\t\u0007\u0001B\u0001B\u0003%\u00111\r\u0005\b\u0003S\u0002A\u0011AA6\u0011%\tI\t\u0001b\u0001\n\u0013\tY\t\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAG\u0011%\ty\n\u0001b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BAR\u0011%\t)\r\u0001b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BAR\u0011%\tI\r\u0001b\u0001\n\u0013\tY\r\u0003\u0005\u0002Z\u0002\u0001\u000b\u0011BAg\u0011-\tY\u000e\u0001a\u0001\u0002\u0004%I!!8\t\u0017\u0005\u001d\b\u00011AA\u0002\u0013%\u0011\u0011\u001e\u0005\f\u0003k\u0004\u0001\u0019!A!B\u0013\ty\u000eC\u0006\u0002\u0000\u0002\u0001\r\u00111A\u0005\n\t\u0005\u0001b\u0003B\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0017A1Ba\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0004!Y!1\u0003\u0001A\u0002\u0003\u0007I\u0011\u0002B\u000b\u0011-\u0011\u0019\u0003\u0001a\u0001\u0002\u0004%IA!\n\t\u0017\t%\u0002\u00011A\u0001B\u0003&!q\u0003\u0005\n\u0005[\u0001\u0001\u0019!C\u0005\u0005_A\u0011B!\u000f\u0001\u0001\u0004%IAa\u000f\t\u0011\t}\u0002\u0001)Q\u0005\u0005cAqAa\u0011\u0001\t\u0003\u0012)\u0005\u0003\u0005\u0003H\u0001!\tE\u0011B%\u0011\u001d\u0011I\u0006\u0001C!\u0005\u000bBqAa\u0017\u0001\t\u0003\u0012i\u0006C\u0004\u0003z\u0001!\tEa\u001f\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u001a\u0001\u0005\n\t=\u0007b\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011\u001d\u0019y\u0001\u0001C!\u0007#Aqa!\b\u0001\t\u0003\u001ay\u0002C\u0004\u0004&\u0001!\tE!\u0012\t\u000f\r\u001d\u0002\u0001\"\u0003\u0003F!91\u0011\u0006\u0001\u0005R\t\u0015\u0003bBB\u0016\u0001\u0011E#Q\t\u0005\t\u0007[\u0001A\u0011\u0001\"\u00040!A1\u0011\u0007\u0001\u0005\u0002\t\u001b\u0019\u0004C\u0004\u00046\u0001!Iaa\u000e\t\u000f\ru\u0002\u0001\"\u0003\u0004@!91q\t\u0001\u0005\n\t\u0015\u0003bBB$\u0001\u0011%1\u0011\n\u0005\b\u0007\u001b\u0002A\u0011\u0002B#\u0011\u001d\u0019y\u0005\u0001C\u0005\u0005\u000bBqa!\u0015\u0001\t\u0013\u0011)\u0005C\u0004\u0004T\u0001!Ia!\u0016\t\u000f\r-\u0004\u0001\"\u0005\u0004n!A11\u000f\u0001\u0005\u0002\t\u001b)\bC\u0004\u0004\u0000\u0001!\te!!\t\u000f\r\r\u0005\u0001\"\u0011\u0004\u0002\"91Q\u0011\u0001\u0005B\r\u001d%\u0001J\"mkN$XM\u001d'j].|U\u000f\u001e2pk:$7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\r#\u0015\u0001\u00027j].T!!\u0012$\u0002\rM,'O^3s\u0015\u00059\u0015!B6bM.\f7\u0001A\n\u0005\u0001)sU\u000b\u0005\u0002L\u00196\t!)\u0003\u0002N\u0005\na2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014\bCA(S\u001d\tY\u0005+\u0003\u0002R\u0005\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\u0019FKA\rPkR\u0014w.\u001e8e\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014(BA)C!\tYe+\u0003\u0002X\u0005\n\u00192i\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8fe\u0006AA.\u001b8l\t\u0006$\u0018\r\u0005\u0002[;6\t1L\u0003\u0002]\r\u0006\u0011!p[\u0005\u0003=n\u0013qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0005\u000312\u000bQ\"\u001b8ji&\fGnQ8oM&<\u0007CA&c\u0013\t\u0019'IA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\f1\u0003\\8dC2dunZ5dC2\u001cE.^:uKJ\u0004\"AZ8\u000f\u0005\u001dl\u0007C\u00015l\u001b\u0005I'B\u00016I\u0003\u0019a$o\\8u})\tA.A\u0003tG\u0006d\u0017-\u0003\u0002oW\u00061\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tq7.\u0003\u0002e\u0019\u0006\t2\r\\5f]RLe\u000e^3sG\u0016\u0004Ho\u001c:\u0011\u0007U4\b0D\u0001l\u0013\t98N\u0001\u0004PaRLwN\u001c\t\u0004s\u0006\rQ\"\u0001>\u000b\u0005md\u0018aB2mS\u0016tGo\u001d\u0006\u0003\u000fvT!A`@\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t!A\u0002pe\u001eL1!!\u0002{\u0005E\u0019E.[3oi&sG/\u001a:dKB$xN]\u0001\b[\u0016$(/[2t!\rY\u00151B\u0005\u0004\u0003\u001b\u0011%AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\fqc]3mK\u000e$xN]'fiJL7m\u001d*fO&\u001cHO]=\u0011\u0007-\u000b\u0019\"C\u0002\u0002\u0016\t\u0013!e\u00117vgR,'\u000fT5oWN+G.Z2u_JlU\r\u001e:jGN\u0014VmZ5tiJL\u0018aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0011\u0007-\u000bY\"C\u0002\u0002\u001e\t\u0013!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\fAb]8dW\u0016$8+\u001a:wKJ\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0015a\u00028fi^|'o[\u0005\u0005\u0003W\t)C\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0003\u00022\u0005MR\"\u0001#\n\u0007\u0005UBIA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AC:feZ,'/\u00138g_B!\u00111HA\"\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AC1vi\"|'/\u001b>fe*\u0011Q\t`\u0005\u0005\u0003\u000b\niD\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\u0006cV|G/\u0019\t\u0005\u0003c\tY%C\u0002\u0002N\u0011\u0013qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\u0002\tQLW.\u001a\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0015)H/\u001b7t\u0015\r\tY\u0006`\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0005)&lW-\u0001\rf]\u0006\u0014G.\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u00042!^A3\u0013\r\t9g\u001b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Qa\u0012QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0005CA&\u0001\u0011\u0015Af\u00021\u0001Z\u0011\u0015\u0001g\u00021\u0001b\u0011\u0015!g\u00021\u0001f\u0011\u0015\u0019h\u00021\u0001u\u0011\u001d\t9A\u0004a\u0001\u0003\u0013Aq!a\u0004\u000f\u0001\u0004\t\t\u0002C\u0004\u0002\u00189\u0001\r!!\u0007\t\u000f\u0005}a\u00021\u0001\u0002\"!9\u0011Q\u0006\bA\u0002\u0005=\u0002bBA\u001c\u001d\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u000fr\u0001\u0019AA%\u0011\u001d\tyE\u0004a\u0001\u0003#Bq!!\u0019\u000f\u0001\u0004\t\u0019'\u0001\u000bd_:tWm\u0019;j_:,\u0006\u000fZ1uK2{7m[\u000b\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0003mC:<'BAAL\u0003\u0011Q\u0017M^1\n\t\u0005m\u0015\u0011\u0013\u0002\u0007\u001f\nTWm\u0019;\u0002+\r|gN\\3di&|g.\u00169eCR,Gj\\2lA\u0005)\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001cXCAAR!!\t)+a,\u00024\u0006eVBAAT\u0015\u0011\tI+a+\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002.\u0006U\u0015\u0001B;uS2LA!!-\u0002(\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007U\f),C\u0002\u00028.\u00141!\u00138u!\u0011\tY,a0\u000e\u0005\u0005u&\u0002BA\u0014\u00033JA!!1\u0002>\nq!+\u001a<feN,7\t[1o]\u0016d\u0017A\u00069feNL7\u000f^3oi\u000e{gN\\3di&|gn\u001d\u0011\u00021\u0005\u001cG/\u001b<f%\u00164XM]:f\u0007>tg.Z2uS>t7/A\rbGRLg/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0004\u0013!\t7pG\u0006d'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8MSN$XM\\3s\u001b\u0006\u0004XCAAg!\u0019\ty-!6fK6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\\\u0017AC2pY2,7\r^5p]&!\u0011q[Ai\u0005\ri\u0015\r]\u0001#Y>\u001c\u0017\r\u001c*fm\u0016\u00148/Z\"p]:,7\r^5p]2K7\u000f^3oKJl\u0015\r\u001d\u0011\u0002)1Lgn\u001b'jgR,g.\u001a:F]\u0012\u0004x.\u001b8u+\t\ty\u000e\u0005\u0003\u0002b\u0006\rXBAA-\u0013\u0011\t)/!\u0017\u0003\u0011\u0015sG\r]8j]R\f\u0001\u0004\\5oW2K7\u000f^3oKJ,e\u000e\u001a9pS:$x\fJ3r)\u0011\tY/!=\u0011\u0007U\fi/C\u0002\u0002p.\u0014A!\u00168ji\"I\u00111\u001f\r\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0014!\u00067j].d\u0015n\u001d;f]\u0016\u0014XI\u001c3q_&tG\u000f\t\u0015\u00043\u0005e\bcA;\u0002|&\u0019\u0011Q`6\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001\u0003\\5oW2K7\u000f^3oKJt\u0015-\\3\u0016\u0005\t\r\u0001\u0003BA^\u0005\u000bIAAa\u0002\u0002>\naA*[:uK:,'OT1nK\u0006!B.\u001b8l\u0019&\u001cH/\u001a8fe:\u000bW.Z0%KF$B!a;\u0003\u000e!I\u00111_\u000e\u0002\u0002\u0003\u0007!1A\u0001\u0012Y&t7\u000eT5ti\u0016tWM\u001d(b[\u0016\u0004\u0003f\u0001\u000f\u0002z\u0006QAn\\2bY\u0006#W.\u001b8\u0016\u0005\t]\u0001\u0003\u0002B\r\u0005?i!Aa\u0007\u000b\u0007\tu!0A\u0003bI6Lg.\u0003\u0003\u0003\"\tm!AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u000fY>\u001c\u0017\r\\!e[&tw\fJ3r)\u0011\tYOa\n\t\u0013\u0005Mh$!AA\u0002\t]\u0011a\u00037pG\u0006d\u0017\tZ7j]\u0002B3aHA}\u0003M\u0011X-\\8uK:+Go^8sW\u000ec\u0017.\u001a8u+\t\u0011\t\u0004\u0005\u0003vm\nM\u0002cA&\u00036%\u0019!q\u0007\"\u0003'I+Wn\u001c;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002/I,Wn\u001c;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;`I\u0015\fH\u0003BAv\u0005{A\u0011\"a=\"\u0003\u0003\u0005\rA!\r\u0002)I,Wn\u001c;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;!Q\r\u0011\u0013\u0011`\u0001\bgR\f'\u000f^;q)\t\tY/A\u0006sK\u000e|gNZ5hkJ,GCBAv\u0005\u0017\u0012y\u0005\u0003\u0004\u0003N\u0011\u0002\r!Y\u0001\n]\u0016<8i\u001c8gS\u001eDqA!\u0015%\u0001\u0004\u0011\u0019&A\u0006va\u0012\fG/\u001a3LKf\u001c\b#BAh\u0005+*\u0017\u0002\u0002B,\u0003#\u00141aU3u\u00031\u0019Gn\\:f\u00072LWM\u001c;t\u0003E)g.\u00192mK\u000ecWo\u001d;fe2Kgn\u001b\u000b\u0007\u0003W\u0014yF!\u001b\t\u000f\t\u0005d\u00051\u0001\u0003d\u0005ia.\u001a;x_J\\7\t\\5f]R\u00042a\u0013B3\u0013\r\u00119G\u0011\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$\bbBA\fM\u0001\u0007!1\u000e\t\u0005kZ\u0014i\u0007\u0005\u0003\u0003p\tUTB\u0001B9\u0015\u0011\u0011\u0019Ha\u0007\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002\u0002B<\u0005c\u0012A#\u00113nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AG5oSRL\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001cHC\u0002B?\u00057\u0013Y\u000b\u0005\u0004\u0003\u0000\t%%q\u0012\b\u0005\u0005\u0003\u0013)ID\u0002i\u0005\u0007K\u0011\u0001\\\u0005\u0004\u0005\u000f[\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u0017\u0013iIA\u0002TKFT1Aa\"l!\u0019\t)K!%\u0003\u0016&!!1SAT\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0005\u0003\u001f\u00139*\u0003\u0003\u0003\u001a\u0006E%\u0001\u0002,pS\u0012DqA!((\u0001\u0004\u0011y*A\rj]&$\u0018.\u0019;f\u0007>tg.Z2uS>t'+Z9vKN$\b\u0003\u0002BQ\u0005Ok!Aa)\u000b\t\t\u0015\u0016\u0011L\u0001\te\u0016\fX/Z:ug&!!\u0011\u0016BR\u0005\u0005Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001d\u0011ik\na\u0001\u0005_\u000baB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0003\"\nE\u0016\u0002\u0002BZ\u0005G\u0013aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\np]J+g/\u001a:tK\u000e{gN\\3di&|g\u000e\u0006\u0004\u0002l\ne&1\u0019\u0005\b\u0005wC\u0003\u0019\u0001B_\u0003\u001d\u0019\u0007.\u00198oK2\u0004B!a/\u0003@&!!\u0011YA_\u00051Y\u0015MZ6b\u0007\"\fgN\\3m\u0011\u001d\u0011)\r\u000ba\u0001\u0005\u000f\f1B]3wKJ\u001cXMT8eKB!\u00111\u0018Be\u0013\u0011\u0011Y-!0\u0003\u0017I+g/\u001a:tK:{G-Z\u0001\u0012_:\u001cuN\u001c8fGRLwN\\\"m_N,GCCAv\u0005#\u0014\u0019N!:\u0003j\"9!1X\u0015A\u0002\tu\u0006b\u0002BkS\u0001\u0007!q[\u0001\ne\u0016\fX/Z:u\u0013\u0012\u0004bA!7\u0003\\\n}WBAAV\u0013\u0011\u0011i.a+\u0003\u0011=\u0003H/[8oC2\u0004B!a$\u0003b&!!1]AI\u0005\u001dIe\u000e^3hKJDqAa:*\u0001\u0004\t\u0019,\u0001\bsK6|G/\u001a\"s_.,'/\u00133\t\u000f\t-\u0018\u00061\u0001\u0002d\u0005QR\u000f\u001d3bi\u0016lU\r^1eCR\f\u0017J\u001a)feNL7\u000f^3oi\u00061bm\u001c:xCJ$Gk\\*pkJ\u001cWM\u0011:pW\u0016\u00148\u000f\u0006\u0004\u0002l\nE8\u0011\u0001\u0005\b\u0005gT\u0003\u0019\u0001B{\u0003-\u0011X-];fgR$\u0015\r^1\u0011\t\t](Q`\u0007\u0003\u0005sTAAa?\u0002Z\u00059Q.Z:tC\u001e,\u0017\u0002\u0002B\u0000\u0005s\u0014Q%\u00138ji&\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0014V-];fgR$\u0015\r^1\t\u000f\r\r!\u00061\u0001\u0003~\u00059a-\u001e;ve\u0016\u001c\u0018\u0001G2sK\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogRA\u00111^B\u0005\u0007\u0017\u0019i\u0001C\u0004\u0003t.\u0002\rA!>\t\u000f\t56\u00061\u0001\u00030\"911A\u0016A\u0002\tu\u0014AG8o\u001d\u0016<(+Z7pi\u0016d\u0015N\\6D_>\u0014H-\u001b8bi>\u0014H\u0003BAv\u0007'Aqa!\u0006-\u0001\u0004\u00199\"A\u0006d_>\u0014H-\u001b8bi>\u0014\b\u0003BAq\u00073IAaa\u0007\u0002Z\t!aj\u001c3f\u0003IygnQ8oiJ|G\u000e\\3s\u0007\"\fgnZ3\u0015\t\u0005-8\u0011\u0005\u0005\b\u0007Gi\u0003\u0019AA2\u0003!I7/Q2uSZ,\u0017aI8o\u0019&t7.T3uC\u0012\fG/\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:DQ\u0006tw-Z\u0001\u001e[\u0006L(-\u001a)s_\u000e,7o]\"p_J$\u0017N\\1u_J\u001c\u0005.\u00198hK\u0006Y2\r\\8tKJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\fAd\u0019:fCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.A\tde\u0016\fG/\u001a*f[>$X-\u00113nS:$\"Aa\r\u0002!\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\\!e[&tGC\u0001B\f\u0003I)\b\u000fZ1uK2Kgn\u001b'jgR,g.\u001a:\u0015\t\u0005-8\u0011\b\u0005\u0007\u0007w!\u0004\u0019A1\u0002\r\r|gNZ5h\u00031\u0011XM^3sg\u0006dG)\u0019;b+\t\u0019\t\u0005\u0005\u0003\u0003x\u000e\r\u0013\u0002BB#\u0005s\u0014ADU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o%\u0016\fX/Z:u\t\u0006$\u0018-A\u0010nCf\u0014Wm\u0011:fCR,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:$B!a;\u0004L!91QC\u001cA\u0002\r]\u0011!\u0006:fcV,7\u000f^'fi\u0006$\u0017\r^1Va\u0012\fG/Z\u0001\u001bG2|7/\u001a)feNL7\u000f^3oi\u000e{gN\\3di&|gn]\u0001\u001eG2|7/Z!di&4XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8og\u0006\u00012o\\2lKR\u001c\u0005.\u00198oK2\\U-\u001f\u000b\u0005\u0003g\u001b9\u0006C\u0004\u0004Zm\u0002\raa\u0017\u0002\u001bM|7m[3u\u0007\"\fgN\\3m!\u0011\u0019ifa\u001a\u000e\u0005\r}#\u0002BB1\u0007G\n\u0001b\u00195b]:,Gn\u001d\u0006\u0005\u0007K\n)*A\u0002oS>LAa!\u001b\u0004`\ti1k\\2lKR\u001c\u0005.\u00198oK2\f1c\u00197pg\u0016\u0014VM^3sg\u0016\u001c\u0005.\u00198oK2$B!a\u0019\u0004p!91\u0011\u000f\u001fA\u0002\u0005e\u0016A\u0004:fm\u0016\u00148/Z\"iC:tW\r\\\u0001\u000f[\u0016$\u0018\rZ1uCRC'/Z1e+\t\u00199\b\u0005\u0003vm\u000ee\u0004cA&\u0004|%\u00191Q\u0010\"\u00033\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u0001\u001aa\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8D_VtG/\u0006\u0002\u00024\u00061\"/\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8D_VtG/A\u0007mCjL(+Z:pkJ\u001cWm]\u000b\u0003\u0007\u0013\u0003bAa \u0003\n\u000e-\u0005\u0007BBG\u0007/\u0003RaSBH\u0007'K1a!%C\u00051a\u0015M_=SKN|WO]2f!\u0011\u0019)ja&\r\u0001\u0011Y1\u0011\u0014!\u0002\u0002\u0003\u0005)\u0011ABN\u0005\ryF%M\t\u0005\u0007;\u001b\u0019\u000bE\u0002v\u0007?K1a!)l\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!^BS\u0013\r\u00199k\u001b\u0002\u0004\u0003:L\b")
public class ClusterLinkOutboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.OutboundConnectionManager,
CoordinatorListener {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final boolean enableReverseConnections;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, ReverseChannel> persistentConnections;
    private final ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections;
    private final Map<String, String> localReverseConnectionListenerMap;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, ReverseChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Map<String, String> localReverseConnectionListenerMap() {
        return this.localReverseConnectionListenerMap;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$)) {
            throw new IllegalStateException("Outbound connection manager created in inbound connection mode");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
            return;
        }
    }

    @Override
    public void closeClients() {
        super.closeClients();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            ((NetworkClient)kafkaClient).enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            return;
        }
    }

    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0 & Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            futures.foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = new StringBuilder(88).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the link coordinator").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.onConnectionClose((KafkaChannel)channel, reverseNode.requestId(), reverseNode.remoteBrokerId(), true));
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel)), reverseChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$onReverseConnection$4(x$5)))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), reverseChannel);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        this.metrics.deprecatedReverseConnectionCreatedSensor().record();
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void onConnectionClose(KafkaChannel channel, Optional<Integer> requestId, int remoteBrokerId, boolean updateMetadataIfPersistent) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)System.identityHashCode(channel.socketChannel()))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
                this.metrics.deprecatedReverseConnectionClosedSensor().record();
            }
            if (!requestId.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId)) != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (updateMetadataIfPersistent && bl) {
            this.requestMetadataUpdate();
            return;
        }
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Forward initiate reverse connection request from source link coordinator to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sourceBrokerId())).foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object object;
                block5: {
                    InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                    CompletableFuture future = (CompletableFuture)x0$1._2();
                    try {
                        if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)entry.targetBrokerId()))).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$createReverseConnections$4(x$7)))) {
                            object = BoxesRunTime.boxToBoolean((boolean)future.complete(null));
                            break block5;
                        }
                        if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Create reverse connection from source broker to destination broker: ").append(entry).toString());
                            ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                            object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                                if (x1$1 != null) {
                                    $this.metrics.outboundReverseConnectionFailedSensor().record();
                                    $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                                    networkClient.requestClusterLinkMetadataUpdate();
                                    future.completeExceptionally((Throwable)x1$1);
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                                    return;
                                }
                                future.complete(x0$2);
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                            });
                            break block5;
                        }
                        return BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                    catch (Throwable e) {
                        future.completeExceptionally(e);
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }
            throw new MatchError(null);
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Process remote metadata: isLocalCoordinator=").append(this.isLinkCoordinator()).append(" remoteCoordinator=").append(coordinator).toString());
        if (!this.enableReverseConnections) {
            return;
        }
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Process link coordinator change isLocalCoordinator=").append(isCoordinator).toString());
            if (this.enableReverseConnections) {
                if (!isCoordinator) {
                    this.closePersistentConnections();
                } else {
                    this.maybeCreatePersistentConnection();
                }
                return;
            }
            return;
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
            return;
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        if (!this.enableReverseConnections) {
            return;
        }
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, (Option<ClusterLinkConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), this.selectorMetricsRegistry, ClusterLinkClientType$OutboundConnectionAdmin$.MODULE$, this.quota, this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableClusterLinkReverseConnectionAdmin(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        java.util.Map<String, Object> adminConfigs = config.localLinkClientConfigs(this.brokerConfig, this.linkListenerEndpoint(), super.linkData().tenantPrefix().nonEmpty());
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        return (ConfluentAdmin)Admin.create(adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        String localListenerName = super.linkData().tenantPrefix().isEmpty() ? config.localListenerName() : ClusterLinkUtils$.MODULE$.mapRequestListenerToLocalAdminListener(config.localListenerName(), this.localReverseConnectionListenerMap());
        this.linkListenerEndpoint_$eq(this.serverInfo.endpoints().stream().filter(x$9 -> {
            Optional optional = x$9.listenerName();
            Optional<String> optional2 = Optional.of(localListenerName);
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(localListenerName).append(" not found").toString())));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable)client -> {
                ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)coordinator.id()))).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$3(x$10)))) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating persistent connection to remote link coordinator ").append(coordinator).toString());
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)new .colon.colon(future, (List)Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                if (x1$1 != null) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                    this.requestMetadataUpdate();
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully created persistent connection to ").append(coordinator).append("  for ").append(requestData).toString());
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(coordinator).append(", persistentConnections=").append(this.persistentConnections()).toString());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ClusterLinkOutboundConnectionManager.$anonfun$requestMetadataUpdate$1(x$11)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing persistent connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.persistentConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing active reverse connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.activeReverseConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public boolean closeReverseChannel(ReverseChannel reverseChannel) {
        if (!reverseChannel.maybeClose()) {
            SocketChannel socketChannel = reverseChannel.socketChannel();
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("Runnable to close reverse channel '").append(reverseChannel).append("' not set. Channel may not have been added to SocketServer yet, closing socket channel.").toString());
                reverseChannel.socketChannel().close();
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("Close initiated for reverse channel '").append(reverseChannel).append("', the channel will be closed by SocketServer.").toString());
        return false;
    }

    public Option<ClusterLinkMetadataThread> metadataThread() {
        return this.remoteNetworkClient().map((Function1 & Serializable)x$12 -> x$12.metadataRefreshThread());
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    public Seq<LazyResource<?>> lazyResources() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$onReverseConnection$4(ReverseChannel x$5) {
        return x$5.socketChannel().isConnected();
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkOutboundConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries(CollectionConverters$.MODULE$.BufferHasAsJava(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> x1$1.whenComplete((x0$4, x1$2) -> {
                    if (x1$2 != null) {
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).completeExceptionally((Throwable)x1$2);
                        $this.metrics.outboundReverseConnectionFailedSensor().record();
                        $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(x0$3).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$2);
                        return;
                    }
                    ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).complete(x0$4);
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(x0$3).toString());
                }));
                return;
            }
            entries.foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createReverseConnections$4(ReverseChannel x$7) {
        return x$7.socketChannel().isConnected();
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkOutboundConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$maybeCreatePersistentConnection$3(ReverseChannel x$10) {
        return x$10.socketChannel().isConnected();
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$11) {
        return x$11.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public static final /* synthetic */ boolean $anonfun$closePersistentConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closePersistentConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeActiveReverseConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closeActiveReverseConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public ClusterLinkOutboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkSelectorMetricsRegistry selectorMetricsRegistry, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, ClusterLinkRequestQuota quota, Time time, boolean enableReverseConnections) {
        this.initialConfig = initialConfig;
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.selectorMetricsRegistry = selectorMetricsRegistry;
        this.metadataManager = metadataManager;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.quota = quota;
        this.time = time;
        this.enableReverseConnections = enableReverseConnections;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.localReverseConnectionListenerMap = brokerConfig.clusterLinkLocalReverseConnectionListenerMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(48).append("[ClusterLinkOutboundConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        if (enableReverseConnections) {
            this.updateLinkListener(initialConfig);
        }
    }
}

