/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrorTopicTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r-e\u0001\u0002\"D\u0001)C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003g\u0011%Q\u0007A!A!\u0002\u0013Y\u0007\u0010C\u0005z\u0001\t\u0005\t\u0015!\u0003{}\"Yq\u0010\u0001B\u0001B\u0003%\u0011\u0011AA\u0005\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fA\u0011\"!\t\u0001\u0001\u0004%I!a\t\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0002\u0002CA\u001d\u0001\u0001\u0006K!!\n\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005\r\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011!\t\u0019\u0005\u0001Q!\n\u0005\u0015\u0002\"CA#\u0001\u0001\u0007I\u0011BA\u0012\u0011%\t9\u0005\u0001a\u0001\n\u0013\tI\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA\u0013\u0011%\ty\u0005\u0001a\u0001\n\u0013\t\u0019\u0003C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!A\u0011q\u000b\u0001!B\u0013\t)\u0003C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0004bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"! \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002j!Y\u0011q\u0010\u0001A\u0002\u0003\u0007I\u0011BAA\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005U\u0005\u00011A\u0001B\u0003&\u00111\u0011\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n\u0013\tI\nC\u0006\u00024\u0002\u0001\r\u00111A\u0005\n\u0005U\u0006bCA]\u0001\u0001\u0007\t\u0011)Q\u0005\u00037C\u0011\"a/\u0001\u0005\u0004%I!!0\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003\u007fC\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0013\u0005]\u0007\u00011A\u0005\n\u0005e\u0007\u0002CAo\u0001\u0001\u0006K!a3\t\u000f\u0005\u001d\b\u0001\"\u0015\u0002j\"9\u0011q \u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WCqA!.\u0001\t\u0013\u00119\fC\u0004\u0003>\u0002!IAa0\t\u000f\tu\u0007\u0001\"\u0003\u0003`\"9!1\u001e\u0001\u0005\n\t5\bb\u0002B|\u0001\u0011%!\u0011 \u0005\b\u0007#\u0001A\u0011BA\u0012\u0011\u001d\u0019\u0019\u0002\u0001C\u0005\u0007+Aqa!\u0007\u0001\t\u0013\u0019Y\u0002C\u0004\u0004&\u0001!Iaa\n\t\u000f\r\u0015\u0002\u0001\"\u0015\u0004,!91Q\u0007\u0001\u0005B\r]\u0002bBB\u001d\u0001\u0011%11\b\u0005\u000f\u0007C\u0002\u0001\u0013aA\u0001\u0002\u0013%11MA\u0005\u000f%\u0019)gQA\u0001\u0012\u0003\u00199G\u0002\u0005C\u0007\u0006\u0005\t\u0012AB5\u0011\u001d\tia\u0010C\u0001\u0007cB\u0011ba\u001d@#\u0003%\ta!\u001e\u0003+\rcWo\u001d;fe2Kgn[*u_Bl\u0015N\u001d:pe*\u0011A)R\u0001\u0005Y&t7N\u0003\u0002G\u000f\u000611/\u001a:wKJT\u0011\u0001S\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\n\u0005\u0002M!:\u0011QJT\u0007\u0002\u0007&\u0011qjQ\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005E\u0013&\u0001\u0004)fe&|G-[2UCN\\'BA(D\u0003\u0015!x\u000e]5d!\t)fL\u0004\u0002W9B\u0011qKW\u0007\u00021*\u0011\u0011,S\u0001\u0007yI|w\u000e\u001e \u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;j\u000bQb\u00197jK:$X*\u00198bO\u0016\u0014\bCA'd\u0013\t!7I\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\t\u0003\u001b\u001eL!\u0001[\"\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006QAn\\2bY\u0006#W.\u001b8\u0002\tQLW.\u001a\t\u0003YZl\u0011!\u001c\u0006\u0003]>\fQ!\u001e;jYNT!\u0001]9\u0002\r\r|W.\\8o\u0015\tA%O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<n\u0005\u0011!\u0016.\\3\n\u0005)\u0004\u0016!B9v_R\f\u0007CA>}\u001b\u0005)\u0015BA?F\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0002z!\u0006Q\u0011N\u001c;feZ\fG.T:\u0011\t\u0005\r\u0011QA\u0007\u00025&\u0019\u0011q\u0001.\u0003\u0007%sG/C\u0002\u0002\fA\u000b\u0011C]3tG\",G-\u001e7f\t\u0016d\u0017-_'t\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003\u001b\u0002AQa\u0015\u0005A\u0002QCQ!\u0019\u0005A\u0002\tDQ!\u001a\u0005A\u0002\u0019DQ!\u001b\u0005A\u0002\u0019DQA\u001b\u0005A\u0002-DQ!\u001f\u0005A\u0002iD\u0001b \u0005\u0011\u0002\u0003\u0007\u0011\u0011A\u0001\fgft7\r\u001b:p]&TX-\u0006\u0002\u0002&A!\u00111AA\u0014\u0013\r\tIC\u0017\u0002\b\u0005>|G.Z1o\u0003=\u0019\u0018P\\2ie>t\u0017N_3`I\u0015\fH\u0003BA\u0018\u0003k\u0001B!a\u0001\u00022%\u0019\u00111\u0007.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003oQ\u0011\u0011!a\u0001\u0003K\t1\u0001\u001f\u00132\u00031\u0019\u0018P\\2ie>t\u0017N_3!\u0003I)\b\u000fZ1uK\u0012$v\u000e]5d\u0007>tg-[4\u0002-U\u0004H-\u0019;fIR{\u0007/[2D_:4\u0017nZ0%KF$B!a\f\u0002B!I\u0011qG\u0007\u0002\u0002\u0003\u0007\u0011QE\u0001\u0014kB$\u0017\r^3e)>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0014kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]\u0001\u0018kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go]0%KF$B!a\f\u0002L!I\u0011q\u0007\t\u0002\u0002\u0003\u0007\u0011QE\u0001\u0015kB$\u0017\r^3e\u000fJ|W\u000f](gMN,Go\u001d\u0011\u0002)U\u0004H-\u0019;fIJ+\u0007\u000f\\5dCN#\u0018\r^;t\u0003a)\b\u000fZ1uK\u0012\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003_\t)\u0006C\u0005\u00028M\t\t\u00111\u0001\u0002&\u0005)R\u000f\u001d3bi\u0016$'+\u001a9mS\u000e\f7\u000b^1ukN\u0004\u0013aF3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3s+\t\ti\u0006E\u0002N\u0003?J1!!\u0019D\u0005])\u0005pY3tg&4X\rT8hO&tw\rS1oI2,'/\u0001\rfq\u000e,7o]5wK2{wmZ5oO\"\u000bg\u000e\u001a7fe\u0002\n!\u0002]1si&$\u0018n\u001c8t+\t\tI\u0007E\u0003V\u0003W\ny'C\u0002\u0002n\u0001\u00141aU3u!\u0011\t\t(a\u001d\u000e\u0003=L1!!\u001ep\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002]1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u00020\u0005m\u0004\"CA\u001c1\u0005\u0005\t\u0019AA5\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002-A\f'\u000f^5uS>tGj\\4F]\u0012|eMZ:fiN,\"!a!\u0011\u000fU\u000b))a\u001c\u0002\n&\u0019\u0011q\u00111\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005-\u0015bAAG5\n!Aj\u001c8h\u0003i\u0001\u0018M\u001d;ji&|g\u000eT8h\u000b:$wJ\u001a4tKR\u001cx\fJ3r)\u0011\ty#a%\t\u0013\u0005]2$!AA\u0002\u0005\r\u0015a\u00069beRLG/[8o\u0019><WI\u001c3PM\u001a\u001cX\r^:!\u000319'o\\;q\r&dG/\u001a:t+\t\tY\n\u0005\u0004\u0002\u001e\u0006\u001d\u0016Q\u0016\b\u0005\u0003?\u000b\u0019KD\u0002X\u0003CK\u0011aW\u0005\u0004\u0003KS\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003S\u000bYKA\u0002TKFT1!!*[!\ri\u0015qV\u0005\u0004\u0003c\u001b%AG$s_V\u00048\t\\;ti\u0016\u0014H*\u001b8l\r&dG/\u001a:J]\u001a|\u0017\u0001E4s_V\u0004h)\u001b7uKJ\u001cx\fJ3r)\u0011\ty#a.\t\u0013\u0005]b$!AA\u0002\u0005m\u0015!D4s_V\u0004h)\u001b7uKJ\u001c\b%A\bnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s+\t\ty\fE\u0002N\u0003\u0003L1!a1D\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\u0005uCN\\G)Z:d+\t\tY\r\u0005\u0004\u0002\u0004\u00055\u0017\u0011[\u0005\u0004\u0003\u001fT&AB(qi&|g\u000eE\u0002N\u0003'L1!!6D\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0017\u0001\u0004;bg.$Um]2`I\u0015\fH\u0003BA\u0018\u00037D\u0011\"a\u000e$\u0003\u0003\u0005\r!a3\u0002\u0013Q\f7o\u001b#fg\u000e\u0004\u0003f\u0001\u0013\u0002bB!\u00111AAr\u0013\r\t)O\u0017\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005-\b\u0003BAw\u0003wt1!a<O\u001d\u0011\t\t0!?\u000f\t\u0005M\u0018q\u001f\b\u0004/\u0006U\u0018\"\u0001%\n\u0005\u0019;\u0015B\u0001#F\u0013\r\tiP\u0015\u0002\u000b)\u0006\u001c8NU3tk2$\u0018A\u0003;sC:\u001c\u0018\u000e^5p]R!\u00111\u001eB\u0002\u0011\u001d\u0011)A\na\u0001\u0005\u000f\t1\u0002^1tW\u000e{g\u000e^3yiB!\u0011Q\u001eB\u0005\u0013\r\u0011YA\u0015\u0002\f)\u0006\u001c8nQ8oi\u0016DH/\u0001\u0007qe>\u001cWm]:U_BL7\r\u0006\u0003\u0002l\nE\u0001b\u0002B\u0003O\u0001\u0007!qA\u0001\u0014Q\u0006tG\r\\3SKBd\u0017nY1Ti\u0006$Xo\u001d\u000b\u0007\u0003W\u00149B!\u0007\t\u000f\t\u0015\u0001\u00061\u0001\u0003\b!9!1\u0004\u0015A\u0002\tu\u0011A\u0002:fgVdG\u000fE\u0004V\u0003\u000b\u000byGa\b\u0011\r\u0005E$\u0011\u0005B\u0013\u0013\r\u0011\u0019c\u001c\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0004\u0003(\tE\"QG\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005!Q\u000f^5m\u0015\t\u0011y#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u001a\u0005S\u0011A\u0001T5tiB!!q\u0007B\u001f\u001b\t\u0011IDC\u0002\u0003<=\fqA]3qY&\u001c\u0017-\u0003\u0003\u0003@\te\"!\u0004*fa2L7-Y*uCR,8/\u0001\u000bqe>\u001cWm]:SKBd\u0017nY1Ti\u0006$Xo\u001d\u000b\u0007\u0003W\u0014)Ea\u0012\t\u000f\t\u0015\u0011\u00061\u0001\u0003\b!9!1D\u0015A\u0002\t%\u0003cB+\u0002\u0006\u0006=$1\n\t\u0007\u0003;\u0013iE!\u000e\n\t\tM\u00121V\u0001\u0010gft7\rV8qS\u000e\u001cuN\u001c4jOR!\u00111\u001eB*\u0011\u001d\u0011)A\u000ba\u0001\u0005\u000f\tQ\u0003[1oI2,7+\u001f8d)>\u0004\u0018nY\"p]\u001aLw\r\u0006\u0004\u0002l\ne#1\f\u0005\b\u0005\u000bY\u0003\u0019\u0001B\u0004\u0011\u001d\u0011if\u000ba\u0001\u0005?\naAZ;ukJ,\u0007CBA9\u0005C\u0011\t\u0007\u0005\u0003\u0003d\t5TB\u0001B3\u0015\u0011\u00119G!\u001b\u0002\u000b\u0005$W.\u001b8\u000b\u0007\t-\u0014/A\u0004dY&,g\u000e^:\n\t\t=$Q\r\u0002\u0007\u0007>tg-[4\u0002-A\u0014xnY3tgNKhn\u0019+pa&\u001c7i\u001c8gS\u001e$b!a;\u0003v\t]\u0004b\u0002B\u0003Y\u0001\u0007!q\u0001\u0005\b\u0005sb\u0003\u0019\u0001B1\u0003-!x\u000e]5d\u0007>tg-[4\u0002-!\fg\u000e\u001a7f\u00032$XM\u001d+pa&\u001c7i\u001c8gS\u001e$b!a;\u0003\u0000\t\u0005\u0005b\u0002B\u0003[\u0001\u0007!q\u0001\u0005\b\u00057i\u0003\u0019\u0001BB!\u0011\u0011\u0019G!\"\n\t\t\u001d%Q\r\u0002\u0013\u00032$XM]\"p]\u001aLwm\u001d*fgVdG/\u0001\u0006mSN$xI]8vaN$B!a;\u0003\u000e\"9!Q\u0001\u0018A\u0002\t\u001d\u0011\u0001\u00055b]\u0012dW\rT5ti\u001e\u0013x.\u001e9t)!\tYOa%\u0003\u0016\n\u0015\u0006b\u0002B\u0003_\u0001\u0007!q\u0001\u0005\b\u0005;z\u0003\u0019\u0001BL!\u0019\t\tH!\t\u0003\u001aB1!q\u0005BN\u0005?KAA!(\u0003*\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\t\t\r$\u0011U\u0005\u0005\u0005G\u0013)G\u0001\u000bD_:\u001cX/\\3s\u000fJ|W\u000f\u001d'jgRLgn\u001a\u0005\b\u0005O{\u0003\u0019AA\u0013\u00039awnY1m\u0003\u0012l\u0017N\\+tK\u0012\f\u0011\u0003\u001d:pG\u0016\u001c8\u000fT5ti\u001e\u0013x.\u001e9t)\u0019\tYO!,\u00030\"9!Q\u0001\u0019A\u0002\t\u001d\u0001b\u0002BYa\u0001\u0007!1W\u0001\u0007OJ|W\u000f]:\u0011\tU\u000bY\u0007V\u0001\u0011Y&\u001cHo\u0012:pkB|eMZ:fiN$b!a;\u0003:\nm\u0006b\u0002B\u0003c\u0001\u0007!q\u0001\u0005\b\u0005c\u000b\u0004\u0019\u0001BZ\u0003YA\u0017M\u001c3mK2K7\u000f^$s_V\u0004xJ\u001a4tKR\u001cH\u0003CAv\u0005\u0003\u0014\u0019Ma7\t\u000f\t\u0015!\u00071\u0001\u0003\b!9!Q\u0019\u001aA\u0002\t\u001d\u0017a\u00024viV\u0014Xm\u001d\t\u0007+\u0006\u0015EK!3\u0011\r\u0005E$\u0011\u0005Bf!!\u00119C!4\u0002p\t=\u0017\u0002BAD\u0005S\u0001BA!5\u0003X6\u0011!1\u001b\u0006\u0005\u0005+\u0014I'\u0001\u0005d_:\u001cX/\\3s\u0013\u0011\u0011INa5\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003(J\u0002\r!!\n\u0002-\u0019LG\u000e^3s\u0019&\u001cHo\u0012:pkB|eMZ:fiN$bA!9\u0003d\n\u001d\bcB+\u0002\u0006\u0006=$q\u001a\u0005\u0007\u0005K\u001c\u0004\u0019\u0001+\u0002\u000b\u001d\u0014x.\u001e9\t\u000f\t%8\u00071\u0001\u0003b\u00069qN\u001a4tKR\u001c\u0018!E1mi\u0016\u0014xI]8va>3gm]3ugR1\u00111\u001eBx\u0005cDqA!\u00025\u0001\u0004\u00119\u0001C\u0004\u0003tR\u0002\rA!>\u0002\u0019\u001d\u0014x.\u001e9PM\u001a\u001cX\r^:\u0011\rU\u000b)\t\u0016Bq\u0003]A\u0017M\u001c3mK\u0006cG/\u001a:He>,\bo\u00144gg\u0016$8\u000f\u0006\u0004\u0002l\nm(Q \u0005\b\u0005\u000b)\u0004\u0019\u0001B\u0004\u0011\u001d\u0011y0\u000ea\u0001\u0007\u0003\tqA]3tk2$8\u000f\u0005\u0004V\u0003\u000b#61\u0001\t\u0007\u0003c\u0012\tc!\u0002\u0011\t\r\u001d1QB\u0007\u0003\u0007\u0013QAaa\u0003\u0003.\u0005!A.\u00198h\u0013\u0011\u0019ya!\u0003\u0003\tY{\u0017\u000eZ\u0001\u001bSN$v\u000e]5d'R\fG/\u001a)f]\u0012LgnZ*u_B\u0004X\rZ\u0001\u0010gR|\u0007/T5se>\u0014Hk\u001c9jGR!\u00111^B\f\u0011\u001d\u0011)a\u000ea\u0001\u0005\u000f\t\u0001\u0003[1oI2,7\u000b^8q\u001b&\u0014(o\u001c:\u0015\u0011\u0005-8QDB\u0010\u0007CAqA!\u00029\u0001\u0004\u00119\u0001C\u0004\u0003\u001ca\u0002\raa\u0001\t\u000f\r\r\u0002\b1\u0001\u0002\n\u0006Y\u0002/\u001a8eS:<7\u000b^8qa\u0016$W\u000b\u001d3bi\u0016$G+[7f\u001bN\fAb\u001c8D_6\u0004H.\u001a;j_:$B!a;\u0004*!9!QA\u001dA\u0002\t\u001dA\u0003BA\u0018\u0007[AqAa\u0007;\u0001\u0004\u0019y\u0003E\u0002M\u0007cI1aa\rS\u0005M\u0019u.\u001c9mKR,G\rV1tWJ+7/\u001e7u\u0003=!\u0018m]6EKN\u001c'/\u001b9uS>tGCAAf\u0003M!\u0018m]6FeJ|'oQ8eK\u0006sG-T:h)!\u0019ida\u0011\u0004H\r%\u0003cA'\u0004@%\u00191\u0011I\"\u0003'Q\u000b7o[#se>\u00148i\u001c3f\u0003:$Wj]4\t\r\r\u0015C\b1\u0001U\u00031)'O]'tOB\u0013XMZ5y\u0011\u001d\u00119\u000b\u0010a\u0001\u0003KAqaa\u0013=\u0001\u0004\u0019i%\u0001\u0002fqB!1qJB.\u001d\u0011\u0019\tfa\u0016\u000f\t\u0005}51K\u0005\u0004\u0007+R\u0016AC2p]\u000e,(O]3oi&!\u0011QUB-\u0015\r\u0019)FW\u0005\u0005\u0007;\u001ayF\u0001\nFq\u0016\u001cW\u000f^5p]\u0016C8-\u001a9uS>t'\u0002BAS\u00073\nqc];qKJ$#/Z:dQ\u0016$W\u000f\\3EK2\f\u00170T:\u0016\u0005\u0005\u0005\u0011!F\"mkN$XM\u001d'j].\u001cFo\u001c9NSJ\u0014xN\u001d\t\u0003\u001b~\u001a2aPB6!\u0011\t\u0019a!\u001c\n\u0007\r=$L\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007O\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TCAB<U\u0011\t\ta!\u001f,\u0005\rm\u0004\u0003BB?\u0007\u000fk!aa \u000b\t\r\u000551Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\"[\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0013\u001byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ClusterLinkStopMirror
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private boolean synchronize;
    private boolean updatedTopicConfig;
    private boolean updatedGroupOffsets;
    private boolean updatedReplicaStatus;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private scala.collection.immutable.Set<TopicPartition> partitions;
    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets;
    private scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> groupFilters;
    private final ClusterLinkMetadataManager metadataManager;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return 500;
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean synchronize() {
        return this.synchronize;
    }

    private void synchronize_$eq(boolean x$1) {
        this.synchronize = x$1;
    }

    private boolean updatedTopicConfig() {
        return this.updatedTopicConfig;
    }

    private void updatedTopicConfig_$eq(boolean x$1) {
        this.updatedTopicConfig = x$1;
    }

    private boolean updatedGroupOffsets() {
        return this.updatedGroupOffsets;
    }

    private void updatedGroupOffsets_$eq(boolean x$1) {
        this.updatedGroupOffsets = x$1;
    }

    private boolean updatedReplicaStatus() {
        return this.updatedReplicaStatus;
    }

    private void updatedReplicaStatus_$eq(boolean x$1) {
        this.updatedReplicaStatus = x$1;
    }

    private ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private scala.collection.immutable.Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(scala.collection.immutable.Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionLogEndOffsets() {
        return this.partitionLogEndOffsets;
    }

    private void partitionLogEndOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.partitionLogEndOffsets = x$1;
    }

    private scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> groupFilters() {
        return this.groupFilters;
    }

    private void groupFilters_$eq(scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> x$1) {
        this.groupFilters = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()));
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("Cannot stop mirror topic for deleted topic '").append($this.topic).append("'. Shutting down stop mirror topic task.").toString());
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        boolean bl = false;
        Some some = null;
        if (mirrorState instanceof Some) {
            bl = true;
            some = (Some)mirrorState;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (state instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)state;
                this.synchronize_$eq(pendingStoppedMirror.synchronize());
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Attempting to stop mirror topic ").append($this.topic).append(" with synchronize=").append(this.synchronize()).toString());
                if (this.updatedReplicaStatus()) {
                    return this.transition(taskContext);
                }
                return this.processTopic(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("See mirror '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(mirrorState)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("No mirror state for mirror topic '").append($this.topic).append("', not performing stop mirror topic task").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)mirrorState);
    }

    public ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.synchronize() && !this.updatedTopicConfig()) {
            return this.syncTopicConfig(taskContext);
        }
        if (!this.updatedGroupOffsets() && this.clientManager.currentConfig().consumerOffsetSyncEnable()) {
            return this.listGroups(taskContext);
        }
        return this.stopMirrorTopic(taskContext);
    }

    private ClusterLinkScheduler.TaskResult processTopic(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Invoking replica status on mirror topic ").append($this.topic).toString());
        ReplicaStatusResult result = this.localAdmin.replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleReplicaStatus((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>>)CollectionConverters$.MODULE$.MapHasAsScala(result.result()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<TopicPartition, KafkaFuture<java.util.List<ReplicaStatus>>> result) {
        void var5_5;
        Tuple2 tuple2 = this.liftedTree1$1(result);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option resOpt = (Option)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        if (var5_5 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_5).value();
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var5_5)) {
            void var4_4;
            return this.processReplicaStatus(taskContext, (scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>>)((scala.collection.immutable.Map)var4_4.get()));
        }
        throw new MatchError((Object)var5_5);
    }

    private ClusterLinkScheduler.TaskResult processReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<TopicPartition, List<ReplicaStatus>> result) {
        this.partitionLogEndOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)result.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                List rsList = (List)x0$1._2();
                ReplicaStatus leader = (ReplicaStatus)rsList.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isLeader())).head();
                if (Option$.MODULE$.apply(leader.mirrorInfo().orElse(null)).exists((Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirror.$anonfun$processReplicaStatus$3(this, info))) && rsList.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isInIsr())).forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirror.$anonfun$processReplicaStatus$5(leader, x$7)))) {
                    return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)BoxesRunTime.boxToLong((long)leader.logEndOffset())));
                }
                return None$.MODULE$;
            }
            throw new MatchError(null);
        })));
        if (this.partitionLogEndOffsets().size() == result.size()) {
            this.updatedReplicaStatus_$eq(true);
            return this.transition(taskContext);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(111).append("Not all mirror partitions are ready to be stopped for mirror topic '").append($this.topic).append("', ").append("awaiting state change. Will retry in ").append(this.super$rescheduleDelayMs()).append(" ms").toString());
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult syncTopicConfig(ClusterLinkScheduler.TaskContext taskContext) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, this.topic);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Syncing topic configs for mirror topic ").append($this.topic).toString());
        DescribeConfigsResult result = this.remoteAdmin.describeConfigs(Collections.singleton(resource));
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleSyncTopicConfig((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Config>)((KafkaFuture)result.values().get(resource))), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleSyncTopicConfig(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Config> future) {
        void var5_5;
        Tuple2 tuple2 = this.liftedTree2$1(future);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option configOpt = (Option)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        if (var5_5 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var5_5).value();
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var5_5)) {
            void var4_4;
            return this.processSyncTopicConfig(taskContext, (Config)var4_4.get());
        }
        throw new MatchError((Object)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult processSyncTopicConfig(ClusterLinkScheduler.TaskContext taskContext, Config topicConfig) {
        void var7_7;
        Properties curProps = this.metadataManager().getTopicConfig(this.topic);
        MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate = new MirrorTopicConfigsDelegate(curProps, topicConfig, this.clientManager.topicConfigSyncRules());
        Tuple2 tuple2 = this.liftedTree3$1(mirrorTopicConfigsDelegate);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option newPropsOpt = (Option)tuple2._1();
        Option policyErrOpt = (Option)tuple2._2();
        if (var7_7 instanceof Some) {
            TaskErrorCodeAndMsg policyErr = (TaskErrorCodeAndMsg)((Some)var7_7).value();
            return this.transition(new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)policyErr, (List)Nil$.MODULE$)))));
        }
        if (None$.MODULE$.equals(var7_7)) {
            void var6_6;
            Properties newProps;
            Properties properties = newProps = (Properties)var6_6.get();
            if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                if (!this.isTopicStatePendingStopped()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(127).append("Detected stopped topic '").append($this.topic).append("' unexpectedly right before topic config was going to be changed. Shutting down stop mirror topic task.").toString());
                    return this.onCompletion(taskContext);
                }
                HashSet newConfigs = new HashSet();
                CollectionConverters$.MODULE$.PropertiesHasAsScala(newProps).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                AlterConfigsResult result = this.localAdmin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.TOPIC, this.topic), newConfigs));
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterTopicConfig((ClusterLinkScheduler.TaskContext)tc, result), taskContext));
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
            this.updatedTopicConfig_$eq(true);
            return this.transition(taskContext);
        }
        throw new MatchError((Object)var7_7);
    }

    private ClusterLinkScheduler.TaskResult handleAlterTopicConfig(ClusterLinkScheduler.TaskContext taskContext, AlterConfigsResult result) {
        Set errs = (Set)CollectionConverters$.MODULE$.SetHasAsScala(result.values().entrySet()).asScala().flatMap((Function1 & Serializable)entry -> {
            String topic = ((ConfigResource)entry.getKey()).name();
            try {
                ((KafkaFuture)entry.getValue()).get();
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully updated configuration for mirror topic ").append(topic).toString());
                return None$.MODULE$;
            }
            catch (ExecutionException e) {
                if (this.synchronize()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error during promote, will retry in ").append(this.super$rescheduleDelayMs()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return new Some((Object)this.taskErrorCodeAndMsg("Failed to alter the topic config", true, e));
                }
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Error encountered while altering configuration on mirror topic ").append(topic).append(".").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return None$.MODULE$;
            }
        });
        if (errs.isEmpty()) {
            this.updatedTopicConfig_$eq(true);
            return this.transition(taskContext);
        }
        scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)errs.toSeq());
        return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult listGroups(ClusterLinkScheduler.TaskContext taskContext) {
        boolean bl;
        ListConsumerGroupsResult listConsumerGroupsResult;
        Option<String> clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.clientManager.currentConfig().clusterLinkPrefixConsumerGroupEnable()) ? this.clientManager.currentConfig().clusterLinkPrefix() : None$.MODULE$;
        this.groupFilters_$eq(ClusterLinkUtils$.MODULE$.clusterLinkGroupFilters(this.clientManager.currentConfig().consumerGroupFilters(), this.clientManager.linkData().tenantPrefix(), clusterLinkPrefix, this.clientManager.currentConfig().linkMode()));
        if (this.groupFilters().isEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Found empty group filters, no consumer group offsets to sync.");
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Syncing consumer group offsets for mirror topic ").append($this.topic).toString());
        if (this.synchronize()) {
            listConsumerGroupsResult = this.remoteAdmin.listConsumerGroups();
            bl = false;
        } else {
            listConsumerGroupsResult = this.localAdmin.listConsumerGroups();
            bl = true;
        }
        boolean bl2 = bl;
        ListConsumerGroupsResult listConsumerGroupsResult2 = listConsumerGroupsResult;
        this.scheduleWhenComplete(listConsumerGroupsResult2.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListGroups((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ConsumerGroupListing>>)listConsumerGroupsResult2.all(), bl2), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListGroups(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ConsumerGroupListing>> future, boolean localAdminUsed) {
        void var6_6;
        Tuple2 tuple2 = this.liftedTree4$1(future, localAdminUsed);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option resultOpt = (Option)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        if (var6_6 instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var6_6).value();
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(110).append("Unable to process list consumer groups request. Skipping over syncing").append(" consumer group offsets for mirror topic ").append($this.topic).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition(new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$)))));
            }
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(var6_6)) {
            void var5_5;
            return this.processListGroups(taskContext, (scala.collection.immutable.Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)var5_5.get()).asScala().map((Function1 & Serializable)x$12 -> x$12.groupId())).toSet());
        }
        throw new MatchError((Object)var6_6);
    }

    private ClusterLinkScheduler.TaskResult processListGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        scala.collection.immutable.Set matchedGroups = (scala.collection.immutable.Set)((IterableOps)ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.groupFilters())._1()).map((Function1 & Serializable)x$13 -> x$13.name());
        if (matchedGroups.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        return this.listGroupOffsets(taskContext, (scala.collection.immutable.Set<String>)matchedGroups);
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult listGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<String> groups) {
        void var4_5;
        boolean bl;
        ClusterLinkBatchAdmin clusterLinkBatchAdmin;
        ListConsumerGroupOffsetsSpec spec = new ListConsumerGroupOffsetsSpec().topicPartitions((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.partitions().toList()).asJava());
        if (this.synchronize()) {
            clusterLinkBatchAdmin = this.remoteAdmin;
            bl = false;
        } else {
            clusterLinkBatchAdmin = this.localAdmin;
            bl = true;
        }
        boolean bl2 = bl;
        ClusterLinkBatchAdmin admin = clusterLinkBatchAdmin;
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        groups.foreach(arg_0 -> ClusterLinkStopMirror.$anonfun$listGroupOffsets$1$adapted((ClusterLinkBatchAdmin)var4_5, spec, futures, arg_0));
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>>)((scala.collection.immutable.Map)futures$1.elem), bl2), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleListGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> futures, boolean localAdminUsed) {
        ClusterLinkScheduler.TaskContext newTaskContext;
        ClusterLinkScheduler.TaskContext taskContext2;
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Map groupOffsets = (scala.collection.immutable.Map)futures.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                scala.collection.immutable.Map map;
                String group = (String)x0$1._1();
                try {
                    java.util.Map result = (java.util.Map)((KafkaFuture)x0$1._2()).get();
                    map = this.filterListGroupOffsets(group, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)CollectionConverters$.MODULE$.MapHasAsScala(result).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Encountered error when trying to handle list consumer offsets request for ").append("group ").append(group).append(".").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    unSyncedGroups.put((Object)group, (Object)this.taskErrorCodeAndMsg(new StringBuilder(33).append("Failed to list group offsets for ").append(group).toString(), localAdminUsed, e));
                    map = Predef$.MODULE$.Map().empty();
                }
                scala.collection.immutable.Map res = map;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), res);
            }
            throw new MatchError(null);
        }).filterNot((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirror.$anonfun$handleListGroupOffsets$4(x$15)));
        if (unSyncedGroups.nonEmpty() && this.synchronize()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(146).append("Got errors when trying to sync the following consumer groups' offsets").append(" ").append(unSyncedGroups.keySet().mkString(",")).append(" when handling the list consumer group offset request. Will retry again in").append(" ").append(this.super$rescheduleDelayMs()).append(".").toString());
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)unSyncedGroups.values().toSeq());
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (unSyncedGroups.nonEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(163).append("Got errors when trying to sync the following consumer groups' offsets when handling the list consumer group offset request. These consumer ").append("groups will be skipped: ").append(unSyncedGroups.keySet().mkString(",")).toString());
            taskContext2 = new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)unSyncedGroups.values().toSeq())));
        } else {
            taskContext2 = newTaskContext = taskContext;
        }
        if (groupOffsets.isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(newTaskContext);
        }
        if (!this.isTopicStatePendingStopped()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(129).append("Detected stopped topic '").append($this.topic).append("' unexpectedly right before group offsets were going to be altered. Shutting down stop mirror topic task.").toString());
            return this.onCompletion(newTaskContext);
        }
        return this.alterGroupOffsets(newTaskContext, (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)groupOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> filterListGroupOffsets(String group, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return (scala.collection.immutable.Map)offsets.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition partition = (TopicPartition)x0$1._1();
                OffsetAndMetadata offsetMeta = (OffsetAndMetadata)x0$1._2();
                Option option = this.partitionLogEndOffsets().get((Object)partition);
                if (option instanceof Some) {
                    Object object;
                    long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    if (offsetMeta == null) {
                        object = None$.MODULE$;
                    } else if (logEndOffset < offsetMeta.offset()) {
                        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Rolling back offset for group '").append(group).append("' and topic '").append($this.topic).append("' from '").append(offsetMeta.offset()).append(" to '").append(logEndOffset).append("'").toString());
                        object = new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
                    } else {
                        object = this.synchronize() ? new Some((Object)BoxesRunTime.boxToLong((long)offsetMeta.offset())) : None$.MODULE$;
                    }
                    return object.map((Function1 & Serializable)off -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)new OffsetAndMetadata(BoxesRunTime.unboxToLong((Object)off), offsetMeta.leaderEpoch(), offsetMeta.metadata())));
                }
                if (None$.MODULE$.equals(option)) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Unexpected partition '").append(partition).append("', skipping").toString());
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError(null);
        });
    }

    private ClusterLinkScheduler.TaskResult alterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> groupOffsets) {
        ObjectRef futures = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        groupOffsets.foreach((Function1 & Serializable)x0$1 -> {
            ClusterLinkStopMirror.$anonfun$alterGroupOffsets$1(this, futures, x0$1);
            return BoxedUnit.UNIT;
        });
        if (((scala.collection.immutable.Map)futures.elem).isEmpty()) {
            this.updatedGroupOffsets_$eq(true);
            return this.transition(taskContext);
        }
        KafkaFuture all = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((scala.collection.immutable.Map)futures.elem).values().toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(all, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterGroupOffsets((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map<String, KafkaFuture<Void>>)((scala.collection.immutable.Map)futures$2.elem)), taskContext));
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleAlterGroupOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, KafkaFuture<Void>> results) {
        HashMap unSyncedGroups = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String group = (String)x0$1._1();
                try {
                    return ((KafkaFuture)x0$1._2()).get();
                }
                catch (ExecutionException e) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Encountered error when trying to handle alter consumer offsets request for ").append("group ").append(group).append(".").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return unSyncedGroups.put((Object)group, (Object)this.taskErrorCodeAndMsg(new StringBuilder(43).append("Failed to alter consumer offsets for group ").append(group).toString(), true, e));
                }
            }
            throw new MatchError(null);
        });
        if (unSyncedGroups.nonEmpty()) {
            if (!this.synchronize()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(164).append("Got errors when trying to sync the following consumer groups' offsets when handling the alter consumer group offset request. These consumer groups will be ").append("skipped: ").append(unSyncedGroups.keySet().mkString(",")).toString());
                this.updatedGroupOffsets_$eq(true);
                return this.transition(new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)unSyncedGroups.values()))));
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(147).append("Got errors when trying to sync the following consumer groups' ").append(unSyncedGroups.keySet().mkString(",")).append(" offsets when ").append("handling the alter consumer group offset request. Will retry again in ").append(this.super$rescheduleDelayMs()).append(".").toString());
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)unSyncedGroups.values());
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        this.updatedGroupOffsets_$eq(true);
        return this.transition(new ClusterLinkScheduler.TaskContext(taskContext.errs()));
    }

    private boolean isTopicStatePendingStopped() {
        return this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic).exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkStopMirror.$anonfun$isTopicStatePendingStopped$1(x$16)));
    }

    private ClusterLinkScheduler.TaskResult stopMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.metadataManager().topicPartitions(this.topic).size() != this.partitions().size()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Detected change in partitions while stopping mirror topic. Retrying consumer group offset sync.");
            this.updatedGroupOffsets_$eq(false);
            return this.transition(taskContext);
        }
        boolean bl = false;
        Some some = null;
        Option option = this.metadataManager().mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ClusterLinkTopicState currentState = (ClusterLinkTopicState)some.value();
            if (currentState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
                ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)currentState;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Setting the mirror topic ").append($this.topic).append(" state to STOPPED").toString());
                List logEndOffsets = ((List)this.partitionLogEndOffsets().toList().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ClusterLinkStopMirror.$anonfun$stopMirrorTopic$3(x0$1)), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToLong((long)ClusterLinkStopMirror.$anonfun$stopMirrorTopic$4(x0$2)));
                AlterMirrorsResult result = this.localAdmin.stopMirror(this.topic, (scala.collection.immutable.Seq<Object>)logEndOffsets);
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleStopMirror((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Void>)result.all(), pendingStoppedMirror.timeMs()), taskContext));
                scala.collection.immutable.Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(84).append("See cluster link state '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing stop ").append("mirror topic task").toString());
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("No cluster link state for mirror topic '").append($this.topic).append("', not performing stop mirror ").append("topic task").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)option);
    }

    private ClusterLinkScheduler.TaskResult handleStopMirror(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Void> result, long pendingStoppedUpdatedTimeMs) {
        None$ errOpt;
        None$ none$;
        try {
            result.get();
            none$ = None$.MODULE$;
        }
        catch (ExecutionException ex) {
            String errorString = new StringBuilder(90).append("Failed to update the stopped state for mirror topic ").append(this.topic).append(". Retrying the ").append("task to stop the mirror").toString();
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, errorString);
            this.warn((Function0<String>)(Function0 & Serializable)() -> errorString, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            none$ = errOpt = new Some((Object)this.taskErrorCodeAndMsg(new StringBuilder(51).append("Failed to update the mirror topic ").append(this.topic).append(" state to stopped").toString(), true, ex));
        }
        if (errOpt instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)errOpt).value();
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (None$.MODULE$.equals(errOpt)) {
            long timeToStopMirrorTopicMs = Time.SYSTEM.milliseconds() - pendingStoppedUpdatedTimeMs;
            if (this.synchronize()) {
                this.clientManager.metrics().timeToStopMirrorTopicPromoteSensor().record((double)timeToStopMirrorTopicMs);
            } else {
                this.clientManager.metrics().timeToStopMirrorTopicFailoverSensor().record((double)timeToStopMirrorTopicMs);
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Mirror topic ").append($this.topic).append(" took ").append(timeToStopMirrorTopicMs).append(" ms to transition to STOPPED state with synchronize=").append(this.synchronize()).append(".").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)errOpt);
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Shutting down stop mirror topic task for ").append($this.topic).append(".").toString());
        this.shutdown();
        scala.collection.immutable.Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkStopMirrorTopicTaskType$.MODULE$, "stop the mirror"));
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private TaskErrorCodeAndMsg taskErrorCodeAndMsg(String errMsgPrefix, boolean localAdminUsed, ExecutionException ex) {
        if (ex.getCause() instanceof UnknownTopicOrPartitionException && !localAdminUsed) {
            return new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, new StringBuilder(35).append(errMsgPrefix).append(" due to unknown topic or partition.").toString());
        }
        return ClusterLinkUtils$.MODULE$.taskErrorCodeAndMsg(errMsgPrefix, localAdminUsed, ex);
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(scala.collection.immutable.Map result$2) {
        try {
            scala.collection.immutable.Map res = (scala.collection.immutable.Map)result$2.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    KafkaFuture future = (KafkaFuture)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)future.get()).asScala().toList());
                }
                throw new MatchError(null);
            });
            return new Tuple2((Object)new Some((Object)res), (Object)None$.MODULE$);
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, new StringBuilder(77).append("Encountered exception when trying to handle replica status for mirror topic ").append(this.topic).append(".").toString());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)this.taskErrorCodeAndMsg("Failed to get the replicas statuses", true, e)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$3(ClusterLinkStopMirror $this, ReplicaStatus.MirrorInfo info) {
        block3: {
            block2: {
                ReplicaStatus.MirrorInfo.State state = info.state();
                ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
                if (!(state == null ? state2 != null : !state.equals(state2))) break block2;
                if ($this.synchronize()) break block3;
                ReplicaStatus.MirrorInfo.State state3 = info.state();
                ReplicaStatus.MirrorInfo.State state4 = ReplicaStatus.MirrorInfo.State.LINK_FAILED;
                if (state3 != null ? !state3.equals(state4) : state4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processReplicaStatus$5(ReplicaStatus leader$1, ReplicaStatus x$7) {
        return x$7.logEndOffset() == leader$1.logEndOffset();
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(KafkaFuture future$1) {
        try {
            Config config = (Config)future$1.get();
            return new Tuple2((Object)new Some((Object)config), (Object)None$.MODULE$);
        }
        catch (ExecutionException e) {
            this.excessiveLoggingHandler().handle(e, this, new StringBuilder(77).append("Encountered exception when trying to process topic configs for mirror topic ").append(this.topic).append(".").toString());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)this.taskErrorCodeAndMsg("Failed to describe topic configs", false, e)));
        }
    }

    private final /* synthetic */ Tuple2 liftedTree3$1(MirrorTopicConfigsDelegate mirrorTopicConfigsDelegate$1) {
        try {
            Properties props = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(this.topic, mirrorTopicConfigsDelegate$1.updateMirrorProps(this.topic), this.clientManager.alterConfigPolicy());
            return new Tuple2((Object)new Some((Object)props), (Object)None$.MODULE$);
        }
        catch (PolicyViolationException e) {
            String errMsg = new StringBuilder(101).append("Encountered policy violation when finalizing topic configuration for '").append(this.topic).append("', skipping topic config update").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.updatedTopicConfig_$eq(true);
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
        }
    }

    private final /* synthetic */ Tuple2 liftedTree4$1(KafkaFuture future$2, boolean localAdminUsed$2) {
        try {
            Collection result = (Collection)future$2.get();
            return new Tuple2((Object)new Some((Object)result), (Object)None$.MODULE$);
        }
        catch (ExecutionException e) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)this.taskErrorCodeAndMsg("Failed to list the consumer groups", localAdminUsed$2, e)));
        }
    }

    public static final /* synthetic */ void $anonfun$listGroupOffsets$1(ClusterLinkBatchAdmin admin$1, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, String group) {
        ListConsumerGroupOffsetsResult result = admin$1.listConsumerGroupOffsets(Collections.singletonMap(group, spec$1));
        futures$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.partitionsToOffsetAndMetadata()));
    }

    public static final /* synthetic */ boolean $anonfun$handleListGroupOffsets$4(Tuple2 x$15) {
        return ((IterableOnceOps)x$15._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterGroupOffsets$1(ClusterLinkStopMirror $this, ObjectRef futures$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String group = (String)x0$1._1();
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)x0$1._2();
            AlterConsumerGroupOffsetsResult result = $this.localAdmin.alterConsumerGroupOffsets(group, CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava());
            futures$2.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)futures$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)result.all()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$isTopicStatePendingStopped$1(ClusterLinkTopicState x$16) {
        TopicLinkState topicLinkState = x$16.state();
        TopicLinkPendingStoppedMirror$ topicLinkPendingStoppedMirror$ = TopicLinkPendingStoppedMirror$.MODULE$;
        return topicLinkState != null && topicLinkState.equals(topicLinkPendingStoppedMirror$);
    }

    public static final /* synthetic */ int $anonfun$stopMirrorTopic$3(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((TopicPartition)x0$1._1()).partition();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$stopMirrorTopic$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcJ$sp();
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkStopMirror(String topic, ClusterLinkDestClientManager clientManager, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        void apply_now;
        void apply_ttlMs;
        this.topic = topic;
        this.clientManager = clientManager;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        super(clientManager.scheduler(), new StringBuilder(28).append("ClusterLinkStopMirror-topic-").append(topic).toString(), intervalMs, time, quota);
        this.synchronize = true;
        this.updatedTopicConfig = false;
        this.updatedGroupOffsets = false;
        this.updatedReplicaStatus = false;
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var12_8 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        function0 = null;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
        this.metadataManager = clientManager.metadataManager();
        this.taskDesc = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$listGroupOffsets$1$adapted(ClusterLinkBatchAdmin admin$1, ListConsumerGroupOffsetsSpec spec$1, ObjectRef futures$1, String group) {
        ClusterLinkStopMirror.$anonfun$listGroupOffsets$1(admin$1, spec$1, futures$1, group);
        return BoxedUnit.UNIT;
    }
}

